/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCompoundExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpression;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.BasicExpressionPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.CompoundExpressionTreeNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionTree;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionTreeNode;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;

final class ExpressionTreePanel
extends AbstractPanel {
    private MWCompoundExpression expression;
    private PropertyValueModel selectedExpressionHolder;
    private PropertyValueModel selectedCompoundExpressionHolder;
    private ExpressionTree expressionTree;
    private DefaultTreeModel expressionTreeModel;
    private TreeSelectionModel expressionTreeSelectionModel;
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String NAND = "NAND";
    public static final String NOR = "NOR";
    private JButton addButton;
    private JButton addNestedButton;
    private JButton removeButton;
    private JComboBox logicalOperatorComboBox;
    private BasicExpressionPanel basicExpressionPanel;
    private String baseTopicId;

    ExpressionTreePanel(WorkbenchContextHolder workbenchContextHolder, String string) {
        super(workbenchContextHolder);
        this.baseTopicId = string;
        this.initialize();
    }

    private void addBasicExpresion() {
        MWCompoundExpression mWCompoundExpression;
        ExpressionTreeNode expressionTreeNode = this.getSelectedCompoundExpressionNode();
        if (expressionTreeNode == null) {
            mWCompoundExpression = this.expression;
            expressionTreeNode = (ExpressionTreeNode)this.expressionTreeModel.getRoot();
        } else {
            mWCompoundExpression = (MWCompoundExpression)expressionTreeNode.getUserObject();
        }
        MWBasicExpression mWBasicExpression = mWCompoundExpression.addBasicExpression();
        Enumeration<TreeNode> enumeration = expressionTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ExpressionTreeNode expressionTreeNode2 = (ExpressionTreeNode)enumeration.nextElement();
            if (expressionTreeNode2.getUserObject() != mWBasicExpression) continue;
            this.expressionTreeSelectionModel.setSelectionPath(new TreePath(expressionTreeNode2.getPath()));
        }
    }

    private void addNestedExpresion() {
        ExpressionTreeNode expressionTreeNode = this.getSelectedCompoundExpressionNode();
        MWCompoundExpression mWCompoundExpression = this.getSelectedCompoundExpression();
        if (mWCompoundExpression == null) {
            mWCompoundExpression = this.expression;
            expressionTreeNode = (ExpressionTreeNode)this.expressionTreeModel.getRoot();
        }
        MWCompoundExpression mWCompoundExpression2 = mWCompoundExpression.addSubCompoundExpression();
        Enumeration<TreeNode> enumeration = expressionTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ExpressionTreeNode expressionTreeNode2 = (ExpressionTreeNode)enumeration.nextElement();
            if (expressionTreeNode2.getUserObject() != mWCompoundExpression2) continue;
            this.expressionTreeSelectionModel.setSelectionPath(new TreePath(((ExpressionTreeNode)expressionTreeNode2.getChildAt(0)).getPath()));
        }
    }

    private ActionListener buildAddBasicExpresionAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionTreePanel.this.addBasicExpresion();
            }
        };
    }

    private ActionListener buildAddNestedExpressionAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionTreePanel.this.addNestedExpresion();
            }
        };
    }

    private ActionListener buildRemoveExpressionAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionTreePanel.this.removeSelectedExpressions();
            }
        };
    }

    private Iterator allowableOperatorTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(AND);
        arrayList.add(OR);
        arrayList.add(NAND);
        arrayList.add(NOR);
        return arrayList.iterator();
    }

    private MWCompoundExpression getSelectedCompoundExpression() {
        MWExpression mWExpression = this.getSelectedExpression();
        if (mWExpression == null) {
            return null;
        }
        if (MWCompoundExpression.class.isAssignableFrom(mWExpression.getClass())) {
            return (MWCompoundExpression)mWExpression;
        }
        return ((MWBasicExpression)mWExpression).getParentCompoundExpression();
    }

    private ExpressionTreeNode getSelectedCompoundExpressionNode() {
        TreePath treePath = this.expressionTreeSelectionModel.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        while (treePath.getPathCount() > 0) {
            ExpressionTreeNode expressionTreeNode = (ExpressionTreeNode)treePath.getLastPathComponent();
            if (MWCompoundExpression.class.isAssignableFrom(expressionTreeNode.getUserObject().getClass())) {
                return expressionTreeNode;
            }
            treePath = treePath.getParentPath();
        }
        return null;
    }

    private ExpressionTreeNode getSelectedExpressionNode() {
        if (this.expressionTreeSelectionModel.getSelectionPath() == null || this.expressionTreeSelectionModel.getSelectionCount() > 1) {
            return null;
        }
        return (ExpressionTreeNode)this.expressionTreeSelectionModel.getSelectionPath().getLastPathComponent();
    }

    private MWExpression getSelectedExpression() {
        ExpressionTreeNode expressionTreeNode = this.getSelectedExpressionNode();
        if (expressionTreeNode == null) {
            return null;
        }
        return (MWExpression)expressionTreeNode.getUserObject();
    }

    private PropertyValueModel buildSelectedCompoundExpressionHolder(PropertyValueModel propertyValueModel) {
        return new FilteringPropertyValueModel(propertyValueModel){

            protected boolean accept(Object object) {
                return object instanceof MWCompoundExpression;
            }
        };
    }

    private void initialize() {
        this.selectedExpressionHolder = new SimplePropertyValueModel();
        this.selectedCompoundExpressionHolder = this.buildSelectedCompoundExpressionHolder(this.selectedExpressionHolder);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.expressionTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("RootNode"), true);
        this.expressionTree = new ExpressionTree(this.expressionTreeModel);
        this.addHelpTopicId(this.expressionTree, this.baseTopicId);
        this.expressionTreeSelectionModel = this.expressionTree.getSelectionModel();
        this.expressionTreeSelectionModel.setSelectionMode(1);
        JScrollPane jScrollPane = new JScrollPane(this.expressionTree);
        jScrollPane.setPreferredSize(new Dimension(10, 10));
        this.expressionTree.addTreeSelectionListener(new ExpressionTreeSelectionListener());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.addButton = new JButton(this.resourceRepository().getString("ADD_EXPRESSION_BUTTON"));
        this.addButton.setMnemonic(this.resourceRepository().getMnemonic("ADD_EXPRESSION_BUTTON"));
        this.addButton.addActionListener(this.buildAddBasicExpresionAction());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.addButton, gridBagConstraints);
        this.addNestedButton = new JButton(this.resourceRepository().getString("ADD_NESTED_EXPRESSION_BUTTON"));
        this.addNestedButton.addActionListener(this.buildAddNestedExpressionAction());
        this.addNestedButton.setMnemonic(this.resourceRepository().getMnemonic("ADD_NESTED_EXPRESSION_BUTTON"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        jPanel.add((Component)this.addNestedButton, gridBagConstraints);
        this.removeButton = new JButton(this.resourceRepository().getString("REMOVE_EXPRESSION_BUTTON"));
        this.removeButton.setMnemonic(this.resourceRepository().getMnemonic("REMOVE_EXPRESSION_BUTTON"));
        this.removeButton.addActionListener(this.buildRemoveExpressionAction());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        jPanel.add((Component)this.removeButton, gridBagConstraints);
        JLabel jLabel = new JLabel(this.resourceRepository().getString("OPERATOR_TYPE_COMBO_BOX_LABEL"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("OPERATOR_TYPE_COMBO_BOX_LABEL"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.logicalOperatorComboBox = new JComboBox();
        this.logicalOperatorComboBox.setModel(this.buildLogicalOperatorComboBoxModel());
        jLabel.setLabelFor(this.logicalOperatorComboBox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        jPanel.add((Component)this.logicalOperatorComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jPanel, gridBagConstraints);
        this.basicExpressionPanel = new BasicExpressionPanel(this.selectedExpressionHolder, this.getWorkbenchContextHolder());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.basicExpressionPanel, gridBagConstraints);
        this.updateButtons();
    }

    private ComboBoxModel buildLogicalOperatorComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildOperatorTypeCollectionHolder(), this.buildOperatorAdapter());
    }

    private CollectionValueModel buildOperatorTypeCollectionHolder() {
        return new AbstractReadOnlyCollectionValueModel(){

            public Object getValue() {
                return ExpressionTreePanel.this.allowableOperatorTypes();
            }
        };
    }

    private PropertyValueModel buildOperatorAdapter() {
        return new PropertyAspectAdapter(this.selectedCompoundExpressionHolder, "operatorType"){

            protected Object getValueFromSubject() {
                if (((MWCompoundExpression)this.subject).getOperatorType() == ExpressionTreePanel.AND) {
                    return ExpressionTreePanel.AND;
                }
                if (((MWCompoundExpression)this.subject).getOperatorType() == ExpressionTreePanel.OR) {
                    return ExpressionTreePanel.OR;
                }
                if (((MWCompoundExpression)this.subject).getOperatorType() == ExpressionTreePanel.NAND) {
                    return ExpressionTreePanel.NAND;
                }
                return ExpressionTreePanel.NOR;
            }

            protected void setValueOnSubject(Object object) {
                if (object == ExpressionTreePanel.AND) {
                    ExpressionTreePanel.this.getSelectedCompoundExpression().setOperatorType(ExpressionTreePanel.AND);
                } else if (object == ExpressionTreePanel.OR) {
                    ExpressionTreePanel.this.getSelectedCompoundExpression().setOperatorType(ExpressionTreePanel.OR);
                } else if (object == ExpressionTreePanel.NAND) {
                    ExpressionTreePanel.this.getSelectedCompoundExpression().setOperatorType(ExpressionTreePanel.NAND);
                } else if (object == ExpressionTreePanel.NOR) {
                    ExpressionTreePanel.this.getSelectedCompoundExpression().setOperatorType(ExpressionTreePanel.NOR);
                }
            }
        };
    }

    protected void disengageListeners() {
        CompoundExpressionTreeNode compoundExpressionTreeNode = (CompoundExpressionTreeNode)this.expressionTreeModel.getRoot();
        compoundExpressionTreeNode.disengageListeners();
        this.expression = null;
    }

    private void removeSelectedExpressions() {
        TreePath[] treePathArray = this.expressionTreeSelectionModel.getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath = treePathArray[i];
            ExpressionTreeNode expressionTreeNode = (ExpressionTreeNode)treePath.getLastPathComponent();
            MWExpression mWExpression = (MWExpression)expressionTreeNode.getUserObject();
            MWCompoundExpression mWCompoundExpression = mWExpression.getParentCompoundExpression();
            if (mWCompoundExpression != null) {
                mWCompoundExpression.removeExpression(mWExpression);
                continue;
            }
            ((MWCompoundExpression)mWExpression).clearExpressions();
        }
    }

    void setExpression(MWCompoundExpression mWCompoundExpression, int n) {
        this.expression = mWCompoundExpression;
        CompoundExpressionTreeNode compoundExpressionTreeNode = new CompoundExpressionTreeNode(mWCompoundExpression);
        this.expressionTreeModel.setRoot(compoundExpressionTreeNode);
        compoundExpressionTreeNode.setModel(this.expressionTreeModel);
        ((ExpressionTreeNode)compoundExpressionTreeNode).initializeChildren();
        for (int i = 0; i < n; ++i) {
            this.expressionTree.expandRow(i);
        }
        this.expressionTree.setSelectionRow(n);
        this.expressionTree.scrollRowToVisible(n);
    }

    private void updateButtons() {
        this.addButton.setEnabled(this.expressionTreeSelectionModel.getSelectionCount() <= 1);
        this.addNestedButton.setEnabled(this.expressionTreeSelectionModel.getSelectionCount() <= 1);
        this.removeButton.setEnabled(this.expressionTreeSelectionModel.getSelectionCount() >= 1);
        this.logicalOperatorComboBox.setEnabled(this.expressionTreeSelectionModel.getSelectionCount() >= 1 && this.getSelectedExpression() != null && MWCompoundExpression.class.isAssignableFrom(this.getSelectedExpression().getClass()));
    }

    protected class ExpressionTreeSelectionListener
    implements TreeSelectionListener {
        protected ExpressionTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (ExpressionTreePanel.this.expressionTreeSelectionModel.getSelectionPath() == null || ExpressionTreePanel.this.expressionTreeSelectionModel.getSelectionCount() > 1) {
                ExpressionTreePanel.this.selectedExpressionHolder.setValue(null);
            } else {
                ExpressionTreeNode expressionTreeNode = (ExpressionTreeNode)ExpressionTreePanel.this.expressionTreeSelectionModel.getSelectionPath().getLastPathComponent();
                ExpressionTreePanel.this.selectedExpressionHolder.setValue(expressionTreeNode.getUserObject());
            }
            ExpressionTreePanel.this.updateButtons();
        }
    }
}

