/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAbstractRelationalReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.RelationalQueryAdvancedOptionsDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.RelationalQueryComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;

final class RelationalQueryOptionsPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;

    RelationalQueryOptionsPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.initialize(propertyValueModel);
        this.initializeLayout();
    }

    private void initialize(PropertyValueModel propertyValueModel) {
        this.queryHolder = this.buildRelationalQueryHolder(propertyValueModel);
    }

    private PropertyValueModel buildRelationalQueryHolder(PropertyValueModel propertyValueModel) {
        return new FilteringPropertyValueModel(propertyValueModel){

            protected boolean accept(Object object) {
                return object instanceof MWAbstractRelationalReadQuery;
            }
        };
    }

    protected String helpTopicId() {
        return "descriptor.queries.options";
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JCheckBox jCheckBox = this.buildRefreshIdentityMapCheckBox();
        this.addHelpTopicId(jCheckBox, this.helpTopicId() + ".refresh");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jPanel, gridBagConstraints);
        this.addHelpTopicId(jPanel, this.helpTopicId() + ".refresh");
        JLabel jLabel = this.buildLabel("CACHE_STATMENT_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel, gridBagConstraints);
        JComboBox jComboBox = this.buildCacheStatementComboBox();
        this.addHelpTopicId(jComboBox, this.helpTopicId() + ".cacheState");
        jLabel.setLabelFor(jComboBox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)jComboBox, gridBagConstraints);
        JLabel jLabel2 = this.buildLabel("BIND_PARAMETERS_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel2, gridBagConstraints);
        JComboBox jComboBox2 = this.buildBindParametersComboBox();
        this.addHelpTopicId(jComboBox2, this.helpTopicId() + ".bind");
        jLabel2.setLabelFor(jComboBox2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)jComboBox2, gridBagConstraints);
        JLabel jLabel3 = this.buildLabel("CACHE_USAGE_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel3, gridBagConstraints);
        JComboBox jComboBox3 = this.buildCachingOptionsComboBox();
        this.addHelpTopicId(jComboBox3, this.helpTopicId() + ".cacheUse");
        jLabel3.setLabelFor(jComboBox3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jComboBox3, gridBagConstraints);
        JLabel jLabel4 = this.buildLabel("IN_MEMORY_QUERY_INDIRECTION_LABEL");
        jLabel4.setDisplayedMnemonic(this.resourceRepository().getMnemonic("IN_MEMORY_QUERY_INDIRECTION_LABEL"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel4, gridBagConstraints);
        JComboBox jComboBox4 = this.buildInMemoryQueryIndirectionComboBox();
        this.addHelpTopicId(jComboBox4, this.helpTopicId() + ".memory");
        jLabel4.setLabelFor(jComboBox4);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jComboBox4, gridBagConstraints);
        JButton jButton = this.buildAdvancedOptionsButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)jButton, gridBagConstraints);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private JCheckBox buildRefreshIdentityMapCheckBox() {
        return QueryComponentFactory.buildRefreshIdentityMapCheckBox(this.queryHolder, this.resourceRepository());
    }

    private JComboBox buildCacheStatementComboBox() {
        return RelationalQueryComponentFactory.buildCacheStatementComboBox(this.queryHolder, this.resourceRepository());
    }

    private JComboBox buildBindParametersComboBox() {
        return RelationalQueryComponentFactory.buildBindParametersComboBox(this.queryHolder, this.resourceRepository());
    }

    private JComboBox buildCachingOptionsComboBox() {
        JComboBox jComboBox = new JComboBox(new ComboBoxModelAdapter(this.buildCacheUsageValueModel(), this.buildCacheUsagePropertyAdapter()));
        jComboBox.setRenderer(this.buildCacheUsageRenderer());
        return jComboBox;
    }

    private ListCellRenderer buildCacheUsageRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                if (object == null) {
                    return "";
                }
                MWAbstractRelationalReadQuery.CacheUsageModel cacheUsageModel = (MWAbstractRelationalReadQuery.CacheUsageModel)object;
                return RelationalQueryOptionsPanel.this.resourceRepository().getString(cacheUsageModel.resourceKey());
            }
        };
    }

    private ListValueModel buildCacheUsageValueModel() {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWAbstractRelationalReadQuery.cacheUsageOptions().toplinkOptions();
            }
        };
    }

    private PropertyValueModel buildCacheUsagePropertyAdapter() {
        return new PropertyAspectAdapter(this.queryHolder, "cacheUsage"){

            protected Object getValueFromSubject() {
                return ((MWAbstractRelationalReadQuery)this.subject).getCacheUsage();
            }

            protected void setValueOnSubject(Object object) {
                ((MWAbstractRelationalReadQuery)this.subject).setCacheUsage((MWAbstractRelationalReadQuery.CacheUsageModel)object);
            }
        };
    }

    private JComboBox buildInMemoryQueryIndirectionComboBox() {
        JComboBox jComboBox = new JComboBox(new ComboBoxModelAdapter(this.buildInMemoryQueryIndirectionValueModel(), this.buildInMemoryQueryIndirectionPolicyPropertyAdapter()));
        jComboBox.setRenderer(this.buildInMemoryQueryIndirectionPolicyRenderer());
        return jComboBox;
    }

    private ListValueModel buildInMemoryQueryIndirectionValueModel() {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWAbstractRelationalReadQuery.inMemoryQueryIndirectionPolicyOptions().toplinkOptions();
            }
        };
    }

    private PropertyValueModel buildInMemoryQueryIndirectionPolicyPropertyAdapter() {
        return new PropertyAspectAdapter(this.queryHolder, "inMemoryQueryIndirectionPolicy"){

            protected Object getValueFromSubject() {
                return ((MWAbstractRelationalReadQuery)this.subject).getInMemoryQueryIndirectionPolicy();
            }

            protected void setValueOnSubject(Object object) {
                ((MWAbstractRelationalReadQuery)this.subject).setInMemoryQueryIndirectionPolicy((MWAbstractRelationalReadQuery.InMemoryQueryIndirectionPolicyModel)object);
            }
        };
    }

    private ListCellRenderer buildInMemoryQueryIndirectionPolicyRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return object == null ? "" : RelationalQueryOptionsPanel.this.resourceRepository().getString(((MWAbstractRelationalReadQuery.InMemoryQueryIndirectionPolicyModel)object).resourceKey());
            }
        };
    }

    private JButton buildAdvancedOptionsButton() {
        JButton jButton = this.buildButton("ADVANCED_BUTTON_TEXT");
        jButton.addActionListener(this.buildAdvancedOptionsAction());
        return jButton;
    }

    private ActionListener buildAdvancedOptionsAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RelationalQueryOptionsPanel.this.showAdvancedOptionsDialog();
            }
        };
    }

    private void showAdvancedOptionsDialog() {
        RelationalQueryAdvancedOptionsDialog relationalQueryAdvancedOptionsDialog = new RelationalQueryAdvancedOptionsDialog((MWAbstractReadQuery)this.getQuery(), this.getWorkbenchContext());
        relationalQueryAdvancedOptionsDialog.show();
        if (relationalQueryAdvancedOptionsDialog.wasConfirmed()) {
            MWAbstractRelationalReadQuery mWAbstractRelationalReadQuery = this.getQuery();
            mWAbstractRelationalReadQuery.setMaintainCache(relationalQueryAdvancedOptionsDialog.getMaintainCache());
            mWAbstractRelationalReadQuery.setLocking(relationalQueryAdvancedOptionsDialog.getLocking());
            mWAbstractRelationalReadQuery.setPrepare(relationalQueryAdvancedOptionsDialog.getPrepare());
            mWAbstractRelationalReadQuery.setUseWrapperPolicy(relationalQueryAdvancedOptionsDialog.getUseWrapperPolicy());
            mWAbstractRelationalReadQuery.setCacheQueryResults(relationalQueryAdvancedOptionsDialog.getCacheQueryResults());
            mWAbstractRelationalReadQuery.setOuterJoinAllSubclasses(relationalQueryAdvancedOptionsDialog.getOuterJoinAllSubclasses());
            mWAbstractRelationalReadQuery.setRefreshIdentityMapResult(relationalQueryAdvancedOptionsDialog.getRefreshIdentityMapResult());
            mWAbstractRelationalReadQuery.setRefreshRemoteIdentityMapResult(relationalQueryAdvancedOptionsDialog.getRefreshRemoteIdentityMapResult());
            mWAbstractRelationalReadQuery.setDistinctState(relationalQueryAdvancedOptionsDialog.getDistinctState());
            mWAbstractRelationalReadQuery.setQueryTimeout(relationalQueryAdvancedOptionsDialog.getQueryTimeout());
            mWAbstractRelationalReadQuery.setMaximumRows(relationalQueryAdvancedOptionsDialog.getMaximumRows());
            mWAbstractRelationalReadQuery.setFirstResult(relationalQueryAdvancedOptionsDialog.getFirstResult());
            mWAbstractRelationalReadQuery.setExclusiveConnection(relationalQueryAdvancedOptionsDialog.getExclusiveConnection());
        }
    }

    private MWAbstractRelationalReadQuery getQuery() {
        return (MWAbstractRelationalReadQuery)this.queryHolder.getValue();
    }
}

