/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWLiteralArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWNullArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryParameterArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ArgumentPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.LiteralArgumentPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ParameterArgumentPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableArgumentPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

final class SecondArgumentPanel
extends AbstractPanel {
    private PropertyValueModel argumentHolder;
    private PropertyValueModel basicExpressionHolder;
    private PropertyValueModel argumentTypeHolder;
    private JRadioButton literalRadioButton;
    private JRadioButton queryKeyRadioButton;
    private JRadioButton parameterRadioButton;
    private JPanel emptyPanel;
    private ArgumentPanel activeArgumentPanel;
    private ParameterArgumentPanel parameterArgumentPanel;
    private QueryableArgumentPanel queryKeyArgumentPanel;
    private LiteralArgumentPanel literalArgumentPanel;
    private Map argumentTypeRadioButtonMap;
    private Map argumentTypeArgumentPanelMap;

    SecondArgumentPanel(PropertyValueModel propertyValueModel, PropertyValueModel propertyValueModel2, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.argumentHolder = propertyValueModel;
        this.basicExpressionHolder = propertyValueModel2;
        this.argumentTypeHolder = this.buildArgumentTypeHolder();
        this.initializeLayout();
        this.initializeMaps();
    }

    private void initializeMaps() {
        this.argumentTypeRadioButtonMap = new Hashtable();
        this.argumentTypeRadioButtonMap.put(MWQueryableArgument.class, this.queryKeyRadioButton);
        this.argumentTypeRadioButtonMap.put(MWLiteralArgument.class, this.literalRadioButton);
        this.argumentTypeRadioButtonMap.put(MWQueryParameterArgument.class, this.parameterRadioButton);
        this.argumentTypeArgumentPanelMap = new Hashtable();
        this.argumentTypeArgumentPanelMap.put(MWQueryableArgument.class, this.queryKeyArgumentPanel);
        this.argumentTypeArgumentPanelMap.put(MWLiteralArgument.class, this.literalArgumentPanel);
        this.argumentTypeArgumentPanelMap.put(MWNullArgument.class, this.literalArgumentPanel);
        this.argumentTypeArgumentPanelMap.put(MWQueryParameterArgument.class, this.parameterArgumentPanel);
    }

    private MWArgument getArgument() {
        return (MWArgument)this.argumentHolder.getValue();
    }

    private ValueModel buildNullArgumentBooleanHolder() {
        return new PropertyAspectAdapter(this.argumentHolder){

            protected Object getValueFromSubject() {
                return !(this.subject instanceof MWNullArgument);
            }
        };
    }

    private void initializeLayout() {
        this.argumentHolder.addPropertyChangeListener("value", this.buildArgumentListener());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ArrayList<JRadioButton> arrayList = new ArrayList<JRadioButton>();
        AccessibleTitledPanel accessibleTitledPanel = new AccessibleTitledPanel(new GridBagLayout());
        int n = 0;
        this.literalRadioButton = this.buildRadioButton("LITERAL_RADIO_BUTTON_ON_SECOND_ARGUMENT_PANEL", this.buildRadioButtonModelAdapter("literal", true));
        arrayList.add(this.literalRadioButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        accessibleTitledPanel.add((Component)this.literalRadioButton, gridBagConstraints);
        this.queryKeyRadioButton = this.buildRadioButton("QUERY_KEY_RADIO_BUTTON_ON_SECOND_ARGUMENT_PANEL", this.buildRadioButtonModelAdapter("queryKey", false));
        arrayList.add(this.queryKeyRadioButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        accessibleTitledPanel.add((Component)this.queryKeyRadioButton, gridBagConstraints);
        this.parameterRadioButton = this.buildRadioButton("PARAMETER_RADIO_BUTTON_ON_SECOND_ARGUMENT_PANEL", this.buildRadioButtonModelAdapter("parameter", false));
        arrayList.add(this.parameterRadioButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        accessibleTitledPanel.add((Component)this.parameterRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)accessibleTitledPanel, gridBagConstraints);
        this.emptyPanel = new JPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.emptyPanel, gridBagConstraints);
        this.parameterArgumentPanel = new ParameterArgumentPanel(this.argumentHolder, this.getWorkbenchContextHolder(), arrayList);
        this.literalArgumentPanel = new LiteralArgumentPanel(this.argumentHolder, this.getWorkbenchContextHolder(), arrayList);
        this.queryKeyArgumentPanel = new QueryableArgumentPanel(this.argumentHolder, this.getWorkbenchContextHolder(), arrayList);
        this.setActiveArgumentPanel(this.literalArgumentPanel);
        new ComponentEnabler(this.buildNullArgumentBooleanHolder(), arrayList);
    }

    private void setActiveArgumentPanel(ArgumentPanel argumentPanel) {
        ArgumentPanel argumentPanel2 = this.activeArgumentPanel;
        if (argumentPanel == argumentPanel2) {
            return;
        }
        this.activeArgumentPanel = argumentPanel;
        if (argumentPanel2 != null) {
            this.emptyPanel.remove(argumentPanel2);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.emptyPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.emptyPanel.add((Component)this.activeArgumentPanel, gridBagConstraints);
        this.revalidate();
        this.repaint();
    }

    private PropertyChangeListener buildArgumentListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SecondArgumentPanel.this.updateActiveArgumentPanel();
            }
        };
    }

    private void updateActiveArgumentPanel() {
        MWArgument mWArgument = this.getArgument();
        if (mWArgument != null) {
            this.setActiveArgumentPanel((ArgumentPanel)this.argumentTypeArgumentPanelMap.get(mWArgument.getClass()));
        } else {
            this.setActiveArgumentPanel(this.literalArgumentPanel);
        }
    }

    private ButtonModel buildRadioButtonModelAdapter(String string, boolean bl) {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, string, bl);
    }

    private PropertyValueModel buildArgumentTypeHolder() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.basicExpressionHolder, "secondArgument"){

            protected Object getValueFromSubject() {
                return ((MWBasicExpression)this.subject).getSecondArgument();
            }

            protected void setValueOnSubject(Object object) {
                if (object == "literal") {
                    ((MWBasicExpression)this.subject).setSecondArgumentToLiteral();
                } else if (object == "queryKey") {
                    ((MWBasicExpression)this.subject).setSecondArgumentToQueryable();
                } else if (object == "parameter") {
                    ((MWBasicExpression)this.subject).setSecondArgumentToParameter();
                }
            }
        };
        return new TransformationPropertyValueModel(propertyAspectAdapter){

            protected Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return ((MWArgument)object).getType();
            }
        };
    }
}

