/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaNamespacesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.XmlSchemaNode;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.LabelPanel;

final class SchemaDocumentInfoPanel
extends ScrollablePropertiesPage {
    public SchemaDocumentInfoPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected Component buildPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = this.buildSchemaSourcePanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.addHelpTopicId(jPanel2, "schema.docInfo.source");
        JCheckBox jCheckBox = this.buildCheckBox("DEFAULT_NAMESPACE_CHECK_BOX", this.buildDefaultNamespaceCheckBoxAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        this.addAlignLeft(jCheckBox);
        JTextField jTextField = new JTextField();
        jTextField.setDocument(this.buildDefaultNamspaceUrlDocument(this.buildDefaultNamespaceUrlHolder()));
        jTextField.setEnabled(jCheckBox.isSelected());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jTextField, gridBagConstraints);
        this.addAlignRight(jTextField);
        jCheckBox.addItemListener(this.buildDefaultNamspaceUrlEnabler(jTextField));
        JPanel jPanel3 = this.buildSchemaNamespacesPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.addHelpTopicId(jPanel3, "schema.docInfo.namespaces");
        this.addHelpTopicId(jPanel, "schema.docInfo");
        return jPanel;
    }

    private JPanel buildSchemaSourcePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("SCHEMA_SOURCE_LABEL")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)this.buildSchemaSourceLabelPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.buildEditSchemaSourceButton(), gridBagConstraints);
        return jPanel;
    }

    private JPanel buildSchemaSourceLabelPanel() {
        LabelPanel labelPanel = new LabelPanel(this.buildSchemaSourceLabelAdapter());
        Insets insets = UIManager.getInsets("TextField.margin");
        labelPanel.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right)));
        return labelPanel;
    }

    private PropertyValueModel buildSchemaSourceLabelAdapter() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "schemaSource"){

            protected Object getValueFromSubject() {
                ResourceSpecification resourceSpecification = ((MWXmlSchema)this.subject).getSchemaSource();
                if (resourceSpecification == null) {
                    return null;
                }
                String string = resourceSpecification.getSourceKey() + "_LABEL";
                return SchemaDocumentInfoPanel.this.resourceRepository().getString(string, resourceSpecification.getLocation());
            }
        };
    }

    private JButton buildEditSchemaSourceButton() {
        JButton jButton = new JButton(this.buildEditSchemaSourceAction());
        jButton.setText(this.resourceRepository().getString("EDIT_SCHEMA_SOURCE_BUTTON_TEXT"));
        return jButton;
    }

    private Action buildEditSchemaSourceAction() {
        return ((XmlSchemaNode)this.getNode()).getSchemaPropertiesAction(this.getWorkbenchContext());
    }

    private JPanel buildSchemaNamespacesPanel() {
        SchemaNamespacesPanel schemaNamespacesPanel = new SchemaNamespacesPanel(this.getNodeHolder(), this.getWorkbenchContextHolder());
        schemaNamespacesPanel.setBorder(this.buildTitledBorder("NAMESPACES_PANEL_TITLE"));
        return schemaNamespacesPanel;
    }

    private ButtonModel buildDefaultNamespaceCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildDefaultNamespaceHolder());
    }

    private PropertyValueModel buildDefaultNamespaceHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "shouldUseDefaultNamespace"){

            protected Object getValueFromSubject() {
                return ((MWXmlSchema)this.subject).shouldUseDefaultNamespace();
            }

            protected void setValueOnSubject(Object object) {
                ((MWXmlSchema)this.subject).setShouldUseDefaultNamespace(((Boolean)object).booleanValue());
            }
        };
    }

    private ItemListener buildDefaultNamspaceUrlEnabler(final JTextField jTextField) {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                jTextField.setEnabled(itemEvent.getStateChange() == 1);
            }
        };
    }

    private Document buildDefaultNamspaceUrlDocument(PropertyValueModel propertyValueModel) {
        return new DocumentAdapter(propertyValueModel, new RegexpDocument());
    }

    private PropertyValueModel buildDefaultNamespaceUrlHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "defaultNamespaceUrl"){

            protected Object getValueFromSubject() {
                return ((MWXmlSchema)this.subject).getDefaultNamespaceUrl();
            }

            protected void setValueOnSubject(Object object) {
                ((MWXmlSchema)this.subject).setDefaultNamespaceUrl((String)object);
            }
        };
    }
}

