/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.XpathChooserDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public final class XpathChooser
extends AbstractPanel {
    private ValueModel xmlFieldHolder;
    private PropertyValueModel xpathHolder;
    private Accessible labeler;

    public XpathChooser(WorkbenchContextHolder workbenchContextHolder, ValueModel valueModel) {
        super(workbenchContextHolder);
        this.initialize(valueModel);
    }

    public XpathChooser(WorkbenchContextHolder workbenchContextHolder, ValueModel valueModel, PropertyValueModel propertyValueModel) {
        super(workbenchContextHolder);
        this.initialize(valueModel, propertyValueModel);
    }

    private void initialize(ValueModel valueModel) {
        this.initialize(valueModel, this.buildXpathHolder(valueModel));
    }

    private void initialize(ValueModel valueModel, PropertyValueModel propertyValueModel) {
        this.xmlFieldHolder = valueModel;
        this.xpathHolder = propertyValueModel;
        this.initializeLayout();
    }

    private PropertyValueModel buildXpathHolder(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "xpath"){

            protected Object getValueFromSubject() {
                return ((MWXmlField)this.subject).getXpath();
            }

            protected void setValueOnSubject(Object object) {
                ((MWXmlField)this.subject).setXpath((String)object);
            }
        };
    }

    private void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTextField jTextField = this.buildTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jTextField, gridBagConstraints);
        JButton jButton = this.buildButton();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)jButton, gridBagConstraints);
        this.addAlignRight(jButton);
    }

    private JTextField buildTextField() {
        JTextField jTextField = new JTextField();
        jTextField.setDocument(this.buildXpathDocument());
        return jTextField;
    }

    private DocumentAdapter buildXpathDocument() {
        return new DocumentAdapter(this.xpathHolder);
    }

    private JButton buildButton() {
        JButton jButton = this.buildBrowseButton("BROWSE_BUTTON_1", this.buildLabeler());
        jButton.addActionListener(this.buildBrowseAction());
        return jButton;
    }

    private Accessible buildLabeler() {
        return new Accessible(){

            public AccessibleContext getAccessibleContext() {
                if (XpathChooser.this.labeler != null) {
                    return XpathChooser.this.labeler.getAccessibleContext();
                }
                return null;
            }
        };
    }

    private ActionListener buildBrowseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XpathChooser.this.promptToSelectXpath();
            }
        };
    }

    public void setAccessibleLabeler(Accessible accessible) {
        this.labeler = accessible;
        for (int i = this.getComponentCount(); i > 0; --i) {
            JComponent jComponent = (JComponent)this.getComponent(i - 1);
            jComponent.putClientProperty("labeledBy", accessible);
        }
    }

    private void promptToSelectXpath() {
        XpathChooserDialog.promptToSelectXpath(this.xmlFieldHolder, this.xpathHolder, this.getWorkbenchContext());
    }

    private MWXmlField xmlField() {
        return (MWXmlField)this.xmlFieldHolder.getValue();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            this.getComponent(i).setEnabled(bl);
        }
    }
}

