/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository;

import java.io.File;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformsApplicationNode;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformsPlugin;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.DatabasePlatformNode;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository.AddDatabasePlatformAction;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository.DatabasePlatformRepositoryTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository.RenameDatabasePlatformRepositoryAction;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.node.NodeModel;

public final class DatabasePlatformRepositoryNode
extends PlatformsApplicationNode {
    private ListValueModel childrenModel;
    protected static final String[] DATABASE_PLATFORM_REPOSITORY_DISPLAY_STRING_PROPERTY_NAMES = new String[]{"name"};

    public DatabasePlatformRepositoryNode(DatabasePlatformRepository databasePlatformRepository, ApplicationContext applicationContext, PlatformsPlugin platformsPlugin) {
        super((NodeModel)databasePlatformRepository, applicationContext.getNodeManager().getRootNode(), platformsPlugin, applicationContext);
    }

    protected void initialize() {
        super.initialize();
        this.childrenModel = this.buildChildrenModel();
    }

    private ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildDisplayStringAdapter());
    }

    private ListValueModel buildDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildPlatformNodeAdapter(), "displayString");
    }

    private ListValueModel buildPlatformNodeAdapter() {
        return new TransformationListValueModelAdapter(this.buildPlatformsAdapter()){

            protected Object transformItem(Object object) {
                return DatabasePlatformRepositoryNode.this.buildDatabasePlatformNode((DatabasePlatform)object);
            }
        };
    }

    DatabasePlatformNode buildDatabasePlatformNode(DatabasePlatform databasePlatform) {
        return new DatabasePlatformNode(databasePlatform, this, this.getPlatformsPlugin(), this.getApplicationContext());
    }

    private CollectionValueModel buildPlatformsAdapter() {
        return new CollectionAspectAdapter(this, "platforms"){

            protected Iterator getValueFromSubject() {
                return ((DatabasePlatformRepository)this.subject).platforms();
            }

            protected int sizeFromSubject() {
                return ((DatabasePlatformRepository)this.subject).platformsSize();
            }
        };
    }

    protected Class propertiesPageClass() {
        return DatabasePlatformRepositoryTabbedPropertiesPage.class;
    }

    protected AbstractPropertiesPage buildPropertiesPage(WorkbenchContext workbenchContext) {
        return new DatabasePlatformRepositoryTabbedPropertiesPage(workbenchContext);
    }

    public String helpTopicID() {
        return "database.platform.repository";
    }

    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    protected String[] displayStringPropertyNames() {
        return DATABASE_PLATFORM_REPOSITORY_DISPLAY_STRING_PROPERTY_NAMES;
    }

    protected String buildIconKey() {
        return "DATABASE_PLATFORM_REPOSITORY";
    }

    public boolean save(File file, WorkbenchContext workbenchContext) {
        workbenchContext = this.buildLocalWorkbenchContext(workbenchContext);
        if (this.getDatabasePlatformRepository().getFile() == null) {
            File file2 = this.promptForSaveFile(file, workbenchContext);
            if (file2 == null) {
                return false;
            }
            this.getDatabasePlatformRepository().setFile(file2);
        }
        this.getDatabasePlatformRepository().write();
        return true;
    }

    public boolean saveAs(File file, WorkbenchContext workbenchContext) {
        File file2 = this.promptForSaveFile(file, workbenchContext = this.buildLocalWorkbenchContext(workbenchContext));
        if (file2 == null) {
            return false;
        }
        this.getDatabasePlatformRepository().setFile(file2);
        this.getDatabasePlatformRepository().write();
        return true;
    }

    public File saveFile() {
        return this.getDatabasePlatformRepository().getFile();
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        workbenchContext = this.buildLocalWorkbenchContext(workbenchContext);
        RootMenuDescription rootMenuDescription = new RootMenuDescription();
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.buildRenameAction(workbenchContext));
        menuGroupDescription.add(this.buildAddPlatformAction(workbenchContext));
        rootMenuDescription.add(menuGroupDescription);
        MenuGroupDescription menuGroupDescription2 = new MenuGroupDescription();
        menuGroupDescription2.add(this.getPlatformsPlugin().getHelpAction(workbenchContext));
        rootMenuDescription.add(menuGroupDescription2);
        return rootMenuDescription;
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        workbenchContext = this.buildLocalWorkbenchContext(workbenchContext);
        ToolBarDescription toolBarDescription = new ToolBarDescription();
        ToolBarButtonGroupDescription toolBarButtonGroupDescription = new ToolBarButtonGroupDescription();
        toolBarButtonGroupDescription.add(this.buildRenameAction(workbenchContext));
        toolBarButtonGroupDescription.add(this.buildAddPlatformAction(workbenchContext));
        toolBarDescription.add(toolBarButtonGroupDescription);
        return toolBarDescription;
    }

    DatabasePlatformRepository getDatabasePlatformRepository() {
        return (DatabasePlatformRepository)this.getValue();
    }

    private FrameworkAction buildRenameAction(WorkbenchContext workbenchContext) {
        return new RenameDatabasePlatformRepositoryAction(workbenchContext);
    }

    private FrameworkAction buildAddPlatformAction(WorkbenchContext workbenchContext) {
        return new AddDatabasePlatformAction(workbenchContext);
    }

    private File promptForSaveFile(File file, WorkbenchContext workbenchContext) {
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle(workbenchContext.getApplicationContext().getResourceRepository().getString("REPOSITORY_SAVE_FILE_TITLE", this.getDatabasePlatformRepository().getName()));
        int n;
        while ((n = jFileChooser.showSaveDialog(workbenchContext.getCurrentWindow())) == 0) {
            File file2 = jFileChooser.getSelectedFile();
            if (this.getPlatformsPlugin().fileIsSupported(file2)) {
                return file2;
            }
            JOptionPane.showMessageDialog(workbenchContext.getCurrentWindow(), workbenchContext.getApplicationContext().getResourceRepository().getString("UNSUPPORTED_FILE_TYPE"));
        }
        return null;
    }
}

