/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.List;
import org.eclipse.persistence.internal.sessions.factories.model.platform.CustomServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.ServerPlatformConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class CustomServerPlatformAdapter
extends ServerPlatformAdapter {
    public static final String SERVER_CLASS_NAME_PROPERTY = "serverClassName";
    public static final String EXTERNAL_TRANSACTION_CONTROLLER_CLASS_PROPERTY = "externalTransactionControllerClass";

    CustomServerPlatformAdapter() {
    }

    CustomServerPlatformAdapter(SCAdapter sCAdapter, CustomServerPlatformConfig customServerPlatformConfig) {
        super(sCAdapter, (ServerPlatformConfig)customServerPlatformConfig);
    }

    protected CustomServerPlatformAdapter(SCAdapter sCAdapter) {
        super(sCAdapter);
    }

    private final CustomServerPlatformConfig platformConfig() {
        return (CustomServerPlatformConfig)this.getModel();
    }

    protected Object buildModel() {
        return new CustomServerPlatformConfig();
    }

    public boolean isCustom() {
        return true;
    }

    public String getServerClassName() {
        return this.platformConfig().getServerClassName();
    }

    public void setServerClassName(String string) {
        String string2 = this.platformConfig().getServerClassName();
        this.platformConfig().setServerClassName(string);
        this.firePropertyChanged(SERVER_CLASS_NAME_PROPERTY, string2, string);
    }

    public String getExternalTransactionControllerClass() {
        return this.platformConfig().getExternalTransactionControllerClass();
    }

    public void setExternalTransactionControllerClass(String string) {
        String string2 = this.platformConfig().getExternalTransactionControllerClass();
        this.platformConfig().setExternalTransactionControllerClass(string);
        this.firePropertyChanged(EXTERNAL_TRANSACTION_CONTROLLER_CLASS_PROPERTY, string2, string);
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.verifyExternalTransactionControllerClass(list);
        this.verifyServerClassName(list);
    }

    private void verifyExternalTransactionControllerClass(List list) {
        String string = this.getExternalTransactionControllerClass();
        if (StringTools.stringIsEmpty((String)string)) {
            list.add(this.buildProblem("0811", this.getParent().displayString()));
        }
    }

    private void verifyServerClassName(List list) {
        String string = this.getServerClassName();
        if (StringTools.stringIsEmpty((String)string)) {
            list.add(this.buildProblem("0812", this.getParent().displayString()));
        }
    }
}

