/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.scplugin.model.SCModel;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.ClassRepository;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public abstract class SCAdapter
extends SCModel {
    private static final String adapterPackageName = ClassTools.packageNameFor(SCAdapter.class) + ".";
    private static final String adapterClassSuffix = "Adapter";
    public static final String modelClassSuffix = "Config";
    private volatile Object config;
    private volatile boolean configClean;
    private volatile boolean configRequired;

    SCAdapter() {
    }

    protected SCAdapter(SCAdapter sCAdapter) {
        super(sCAdapter);
        this.initialize(this.buildModel());
        this.initializeDefaults();
        this.setConfigClean(true);
    }

    SCAdapter(SCAdapter sCAdapter, Object object) {
        super(sCAdapter);
        this.initializeFromModel(object);
        this.setConfigClean(false);
    }

    protected abstract Object buildModel();

    Preferences preferences() {
        return ((SCAdapter)this.getParent()).preferences();
    }

    public ClassRepository getClassRepository() {
        return ((SCAdapter)this.getParent()).getClassRepository();
    }

    protected Object getModel() {
        return this.config;
    }

    protected final String getConfigFileVersion() {
        if (this.getParent() == null) {
            return ((TopLinkSessionsAdapter)this).getVersion();
        }
        return ((SCAdapter)this.getParent()).getConfigFileVersion();
    }

    protected final boolean configVersionIsPre10g() {
        char c;
        String string = this.getConfigFileVersion();
        int n = 0;
        for (int i = 0; i < string.length() && Character.isDigit(c = string.charAt(i)); ++i) {
            n *= 10;
            n += Character.digit(c, 10);
        }
        return n > 3 && n < 10;
    }

    public boolean hasNoConfigToSave() {
        return this.isACleanConfig() && !this.isARequiredConfig();
    }

    protected boolean isACleanConfig() {
        return this.configClean;
    }

    public boolean isARequiredConfig() {
        return this.configRequired;
    }

    private final void setModel(Object object) {
        this.config = object;
    }

    protected final void setConfigClean(boolean bl) {
        this.configClean = bl;
    }

    protected final void setConfigRequired(boolean bl) {
        this.configRequired = bl;
    }

    protected void markEntireConfigurationClean() {
        this.setConfigClean(true);
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            ((SCAdapter)((Object)iterator.next())).setConfigClean(true);
        }
    }

    public void markBranchDirty() {
        super.markBranchDirty();
        this.setConfigClean(false);
    }

    protected void preSaving() {
    }

    protected void postSaving() {
    }

    protected Collection adaptAll(Collection collection) {
        ArrayList<SCAdapter> arrayList = new ArrayList<SCAdapter>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.adapt(iterator.next()));
        }
        return arrayList;
    }

    protected SCAdapter adapt(Object object) {
        if (object == null) {
            return null;
        }
        Constructor constructor = this.adapterConstructorFor(object);
        return SCAdapter.buildsAdapterWith(constructor, new Object[]{this, object});
    }

    protected Collection modelObjectsFrom(Collection collection) {
        TransformationIterator transformationIterator = new TransformationIterator(collection.iterator()){

            protected Object transform(Object object) {
                return ((SCAdapter)((Object)object)).getModel();
            }
        };
        return CollectionTools.collection((Iterator)transformationIterator);
    }

    protected SCAdapter findAdapterFor(Object object, Iterator iterator) {
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            SCAdapter sCAdapter = (SCAdapter)((Object)iterator2.next());
            if (sCAdapter.getModel() != object) continue;
            return sCAdapter;
        }
        return null;
    }

    private final Constructor adapterConstructorFor(Object object) {
        Class clazz = this.adapterClassFor(object);
        Class<?> clazz2 = object.getClass();
        return SCAdapter.adapterConstructorFor(clazz2, clazz, 2);
    }

    static final Constructor adapterConstructor(Class clazz) {
        Object object = null;
        try {
            object = ((SCAdapter)((Object)clazz.newInstance())).buildModel();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Instantiation Exception When Instantiating " + clazz.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Illegal Access Exception When Instantiating " + clazz.getName(), illegalAccessException);
        }
        return SCAdapter.adapterConstructorFor(object.getClass(), clazz, 1);
    }

    private static final Constructor adapterConstructorFor(Class clazz, Class clazz2, int n) {
        ArrayIterator arrayIterator = new ArrayIterator((Object[])clazz2.getDeclaredConstructors());
        while (arrayIterator.hasNext()) {
            Constructor constructor = (Constructor)arrayIterator.next();
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length != n) continue;
            if (classArray.length == 2 && classArray[0].isAssignableFrom(SCAdapter.class) && classArray[1].isAssignableFrom(clazz)) {
                return constructor;
            }
            if (classArray.length == 1 && classArray[0].isAssignableFrom(SCAdapter.class)) {
                return constructor;
            }
            if (classArray.length != 0) continue;
            return constructor;
        }
        throw new NoSuchElementException("No Valid Constructor Found for: " + clazz2.getName());
    }

    private final Class adapterClassFor(Object object) {
        String string = ClassTools.shortNameFor(object.getClass());
        return SCAdapter.adapterClassNamed(string);
    }

    static final Class adapterClassNamed(String string) {
        String string2 = adapterPackageName + string.substring(0, string.lastIndexOf(modelClassSuffix)) + adapterClassSuffix;
        Class clazz = null;
        try {
            clazz = ClassTools.classForName((String)string2);
        }
        catch (RuntimeException runtimeException) {
            throw new NoSuchElementException("Adapter Class Not Known For SC Model Class: " + string);
        }
        return clazz;
    }

    static final SCAdapter buildsAdapterWith(Constructor constructor, Object[] objectArray) {
        SCAdapter sCAdapter = null;
        try {
            sCAdapter = (SCAdapter)((Object)constructor.newInstance(objectArray));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("InvocationTarget Exception When Instantiating " + constructor.getName(), invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Instantiation Exception When Instantiating " + constructor.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Illegal Access Exception When Instantiating " + constructor.getName(), illegalAccessException);
        }
        return sCAdapter;
    }

    protected void initializeFromModel(Object object) {
        this.setModel(object);
    }

    protected void postInitializationFromModel() {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            ((SCAdapter)((Object)iterator.next())).postInitializationFromModel();
        }
    }

    protected void initialize() {
        super.initialize();
        this.setConfigRequired(false);
    }

    protected void initialize(Object object) {
        this.setModel(object);
    }

    protected void initializeDefaults() {
    }
}

