/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool;

import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;

public class DeletePoolAction
extends AbstractEnablableFrameworkAction {
    public DeletePoolAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.initializeText("DELETE_CONNECTION_POOL");
        this.initializeMnemonic("DELETE_CONNECTION_POOL");
        this.initializeIcon("DELETE");
        this.initializeToolTipText("DELETE_CONNECTION_POOL.TOOL_TIP");
    }

    protected void execute(ApplicationNode applicationNode) {
        ConnectionPoolAdapter connectionPoolAdapter = (ConnectionPoolAdapter)applicationNode.getValue();
        String string = connectionPoolAdapter.getName();
        if (this.confirmDeletion(string)) {
            ServerSessionAdapter serverSessionAdapter = (ServerSessionAdapter)applicationNode.getParent().getValue();
            if (connectionPoolAdapter.isWriteConnectionPool()) {
                serverSessionAdapter.removeWriteConnectionPool();
            } else if (connectionPoolAdapter.isReadConnectionPool()) {
                serverSessionAdapter.removeReadConnectionPool();
            } else if (connectionPoolAdapter.isSequenceConnectionPool()) {
                serverSessionAdapter.removeSequenceConnectionPool();
            } else {
                serverSessionAdapter.removeConnectionPoolNamed(string);
            }
        }
        this.navigatorSelectionModel().setSelectedNode((ApplicationNode)applicationNode.getParent());
    }

    private boolean confirmDeletion(String string) {
        int n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("DELETE_CONNECTION_POOL_WARNING", string), this.resourceRepository().getString("DELETE_CONNECTION_POOL_WARNING_TITLE"), 0, 2);
        return n == 0;
    }

    protected boolean shouldBeEnabled(ApplicationNode applicationNode) {
        return true;
    }
}

