/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.TitledPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.ClasspathPanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.ClassRepository;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.SessionsListPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.ProjectDisplayableTranslatorAdapter;
import org.eclipse.persistence.tools.workbench.uitools.DisplayableAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

public final class ProjectPropertiesPage
extends TitledPropertiesPage {
    public ProjectPropertiesPage(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    private ActionListener buildChangeLocationAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectNode projectNode = (ProjectNode)ProjectPropertiesPage.this.getNode();
                projectNode.saveAs(null, ProjectPropertiesPage.this.getWorkbenchContext());
            }
        };
    }

    private PropertyValueModel buildClasspathHolder() {
        return new TransformationPropertyValueModel(this.getSelectionHolder()){

            protected Object transform(Object object) {
                SCAdapter sCAdapter = (SCAdapter)((Object)object);
                return object == null ? null : sCAdapter.getClassRepository();
            }
        };
    }

    private ListValueModel buildClasspathListAdapter() {
        return new ClasspathListAdapter();
    }

    protected TopLinkSessionsAdapter getProject() {
        return (TopLinkSessionsAdapter)this.getSelectionHolder().getValue();
    }

    private ClasspathPanel.DefaultClasspathDirectoryHolder buildCurrentDirectoryHolder() {
        return new ClasspathPanel.DefaultClasspathDirectoryHolder(){

            public File getDefaultClasspathDirectory() {
                File file = ProjectPropertiesPage.this.getProject().getSaveDirectory();
                if (file != null) {
                    return file;
                }
                String string = ProjectPropertiesPage.this.preferences().get("recent classpath directory", null);
                if (string != null) {
                    return new File(string);
                }
                return FileTools.userHomeDirectory();
            }

            public void setDefaultClasspathDirectory(File file) {
                File file2 = ProjectPropertiesPage.this.getProject().getSaveDirectory();
                if (file.equals(FileTools.userHomeDirectory())) {
                    file = null;
                } else if (file2 != null && file2.equals(file)) {
                    file = null;
                }
                if (file != null) {
                    ProjectPropertiesPage.this.preferences().put("recent classpath directory", file.getPath());
                } else {
                    ProjectPropertiesPage.this.preferences().remove("recent classpath directory");
                }
            }
        };
    }

    protected DisplayableAdapter buildDisplayableAdapter() {
        return new ProjectDisplayableTranslatorAdapter(this.resourceRepository());
    }

    private Document buildLocationDocumentAdapter() {
        TransformationPropertyValueModel transformationPropertyValueModel = new TransformationPropertyValueModel(this.buildLocationHolder()){

            protected Object transform(Object object) {
                File file = (File)object;
                if (file == null) {
                    return null;
                }
                File file2 = file.getParentFile();
                if (file2 == null) {
                    return null;
                }
                return FileTools.canonicalFile((File)file2).getPath();
            }
        };
        return new DocumentAdapter(transformationPropertyValueModel);
    }

    private PropertyValueModel buildLocationHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "configSavePath"){

            protected Object getValueFromSubject() {
                TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)this.subject;
                return topLinkSessionsAdapter.getPath();
            }
        };
    }

    protected Component buildPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = BorderFactory.createTitledBorder("m").getBorderInsets(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = this.buildLabel("PROJECT_LOCATION_FIELD");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, insets.left + 5, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.addHelpTopicId(jLabel, "scproject.location");
        JTextField jTextField = new JTextField(this.buildLocationDocumentAdapter(), null, 1);
        jTextField.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, insets.left + 5, 0, 0);
        jPanel.add((Component)jTextField, gridBagConstraints);
        this.addHelpTopicId(jTextField, "scproject.location");
        jLabel.setLabelFor(jTextField);
        JButton jButton = this.buildButton("PROJECT_LOCATION_BROWSE_BUTTON");
        jButton.addActionListener(this.buildChangeLocationAction());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 5, 0, insets.right + 5);
        jPanel.add((Component)jButton, gridBagConstraints);
        this.addHelpTopicId(jButton, "scproject.location");
        this.addAlignRight(jButton);
        ClasspathPanel classpathPanel = new ClasspathPanel(this.getApplicationContext(), this.buildClasspathListAdapter(), this.buildRootFileHolder(), true);
        classpathPanel.setDefaultClasspathDirectoryHolder(this.buildCurrentDirectoryHolder());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)classpathPanel, gridBagConstraints);
        this.addPaneForAlignment(classpathPanel);
        this.addHelpTopicId(classpathPanel, "scproject.classpath");
        SessionsListPane sessionsListPane = new SessionsListPane(this.getSelectionHolder(), this.getWorkbenchContextHolder());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)sessionsListPane, gridBagConstraints);
        this.addPaneForAlignment(sessionsListPane);
        this.addHelpTopicId(sessionsListPane, "scproject.sessions");
        this.addHelpTopicId(jPanel, "scproject");
        return jPanel;
    }

    private ValueModel buildRootFileHolder() {
        return new SimplePropertyValueModel(this.getSelectionHolder()){

            public Object getValue() {
                ValueModel valueModel = (ValueModel)super.getValue();
                TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)valueModel.getValue();
                return null;
            }
        };
    }

    private class ClasspathListAdapter
    extends ListAspectAdapter {
        private ClasspathListAdapter() {
            super(ProjectPropertiesPage.this.buildClasspathHolder(), "classpathEntries");
        }

        public void addItem(int n, Object object) {
            ClassRepository classRepository = (ClassRepository)this.subject;
            classRepository.addClasspathEntry(n, (String)object);
        }

        public Object getItem(int n) {
            ClassRepository classRepository = (ClassRepository)this.subject;
            return classRepository.getClasspathEntry(n);
        }

        protected ListIterator getValueFromSubject() {
            ClassRepository classRepository = (ClassRepository)this.subject;
            return classRepository.classpathEntries();
        }

        public Object removeItem(int n) {
            ClassRepository classRepository = (ClassRepository)this.subject;
            return classRepository.removeClasspathEntry(n);
        }

        public Object replaceItem(int n, Object object) {
            ClassRepository classRepository = (ClassRepository)this.subject;
            return classRepository.replaceClasspathEntry(n, (String)object);
        }
    }
}

