/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.ComponentAligner;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

final class ProjectTypeEditDialog
extends AbstractDialog {
    private DatabaseSessionAdapter databaseSession;
    private JComponent projectClassWidgets;
    private ProjectTypeEditor projectType;
    private String helpTopicId;
    private JComponent projectXmlWidgets;

    ProjectTypeEditDialog(WorkbenchContext workbenchContext, String string, DatabaseSessionAdapter databaseSessionAdapter, ProjectTypeUpdater projectTypeUpdater, String string2) {
        super(workbenchContext, string);
        this.initialize(databaseSessionAdapter, projectTypeUpdater, string2);
    }

    private void addProjectXML() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new XmlFileFilter());
        jFileChooser.setCurrentDirectory(this.retrieveLastDirectory());
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.preferences().put("location", file.getParent());
            this.projectType.setProjectXml(file.getAbsolutePath());
        }
    }

    private ActionListener buildClassBrowseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassChooserTools.promptForType(ProjectTypeEditDialog.this.getWorkbenchContext(), ProjectTypeEditDialog.this.databaseSession.getClassRepository(), ProjectTypeEditDialog.this.buildProjectClassHolder());
            }
        };
    }

    private void buildClassComponentEnabler(JComponent jComponent) {
        new ComponentEnabler((ValueModel)this.buildProjectTypeClassHolder(), jComponent.getComponents());
    }

    private JComponent buildLabeledComponent(String string, JComponent jComponent, JComponent jComponent2, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        Pane pane = new Pane(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = SwingComponentFactory.buildLabel(string, this.resourceRepository());
        pane.add((Component)jLabel, gridBagConstraints);
        componentAligner.add(jLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        pane.add((Component)jComponent, gridBagConstraints);
        jComponent.setName(string);
        jLabel.setLabelFor(jComponent);
        if (jComponent2 != null) {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            pane.add((Component)jComponent2, gridBagConstraints);
            jComponent2.setName(string);
            componentAligner2.add(jComponent2);
        }
        return pane;
    }

    private JComponent buildLabeledTextField(String string, Document document, JComponent jComponent, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        JTextField jTextField = new JTextField(document, null, 40);
        return this.buildLabeledComponent(string, jTextField, jComponent, componentAligner, componentAligner2);
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ComponentAligner componentAligner = new ComponentAligner();
        ComponentAligner componentAligner2 = new ComponentAligner();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(SwingComponentFactory.buildStandardEmptyBorder());
        JRadioButton jRadioButton = SwingComponentFactory.buildRadioButton("PROJECT_TYPE_EDIT_DIALOG_XML_RADIO_BUTTON", this.buildProjectTypeButtonModel(Boolean.TRUE), this.resourceRepository());
        JButton jButton = SwingComponentFactory.buildButton("PROJECT_TYPE_EDIT_DIALOG_XML_BROWSE_BUTTON", this.resourceRepository());
        jButton.addActionListener(this.buildXMLBrowseAction());
        this.projectXmlWidgets = this.buildLabeledTextField("PROJECT_TYPE_EDIT_DIALOG_XML_FIELD", this.buildProjectXmlDocumentAdapter(), jButton, componentAligner, componentAligner2);
        GroupBox groupBox = new GroupBox(jRadioButton, this.projectXmlWidgets);
        this.buildXmlFileComponentEnabler(this.projectXmlWidgets);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)groupBox, gridBagConstraints);
        JRadioButton jRadioButton2 = SwingComponentFactory.buildRadioButton("PROJECT_TYPE_EDIT_DIALOG_CLASS_RADIO_BUTTON", this.buildProjectTypeButtonModel(Boolean.FALSE), this.resourceRepository());
        JButton jButton2 = SwingComponentFactory.buildButton("PROJECT_TYPE_EDIT_DIALOG_CLASS_BROWSE_BUTTON", this.resourceRepository());
        jButton2.addActionListener(this.buildClassBrowseAction());
        this.projectClassWidgets = this.buildLabeledTextField("PROJECT_TYPE_EDIT_DIALOG_CLASS_FIELD", this.buildProjectClassDocumentAdapter(), jButton2, componentAligner, componentAligner2);
        groupBox = new GroupBox(jRadioButton2, this.projectClassWidgets);
        this.buildClassComponentEnabler(this.projectClassWidgets);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)groupBox, gridBagConstraints);
        return jPanel;
    }

    private Document buildProjectClassDocumentAdapter() {
        return new DocumentAdapter(this.buildProjectClassHolder(), RegexpDocument.buildDocument(3));
    }

    private PropertyValueModel buildProjectClassHolder() {
        return new PropertyAspectAdapter("ProjectClass", (Model)this.projectType){

            protected Object getValueFromSubject() {
                ProjectTypeEditor projectTypeEditor = (ProjectTypeEditor)((Object)this.subject);
                return projectTypeEditor.getProjectClass();
            }

            protected void setValueOnSubject(Object object) {
                ProjectTypeEditor projectTypeEditor = (ProjectTypeEditor)((Object)this.subject);
                projectTypeEditor.setProjectClass((String)object);
            }
        };
    }

    private ButtonModel buildProjectTypeButtonModel(Object object) {
        return new RadioButtonModelAdapter(this.buildProjectTypeHolder(), object);
    }

    private PropertyValueModel buildProjectTypeClassHolder() {
        return new TransformationPropertyValueModel(this.buildProjectTypeHolder()){

            protected Object transform(Object object) {
                return !Boolean.TRUE.equals(object);
            }
        };
    }

    private PropertyValueModel buildProjectTypeHolder() {
        return new PropertyAspectAdapter("projectTypeXml", (Model)this.projectType){

            protected Object getValueFromSubject() {
                ProjectTypeEditor projectTypeEditor = (ProjectTypeEditor)((Object)this.subject);
                return projectTypeEditor.isProjectTypeXml();
            }

            protected void setValueOnSubject(Object object) {
                ProjectTypeEditor projectTypeEditor = (ProjectTypeEditor)((Object)this.subject);
                projectTypeEditor.setProjectTypeXml(Boolean.TRUE.equals(object));
            }
        };
    }

    private Document buildProjectXmlDocumentAdapter() {
        return new DocumentAdapter(this.buildProjectXmlHolder());
    }

    private PropertyValueModel buildProjectXmlHolder() {
        return new PropertyAspectAdapter("ProjectXml", (Model)this.projectType){

            protected Object getValueFromSubject() {
                ProjectTypeEditor projectTypeEditor = (ProjectTypeEditor)((Object)this.subject);
                return projectTypeEditor.getProjectXml();
            }

            protected void setValueOnSubject(Object object) {
                ProjectTypeEditor projectTypeEditor = (ProjectTypeEditor)((Object)this.subject);
                projectTypeEditor.setProjectXml((String)object);
            }
        };
    }

    private ActionListener buildXMLBrowseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectTypeEditDialog.this.addProjectXML();
            }
        };
    }

    private void buildXmlFileComponentEnabler(JComponent jComponent) {
        new ComponentEnabler((ValueModel)this.buildProjectTypeHolder(), jComponent.getComponents());
    }

    protected String helpTopicId() {
        return this.helpTopicId;
    }

    protected Component initialFocusComponent() {
        if (this.databaseSession.isPrimaryProjectXml()) {
            return this.projectXmlWidgets.getComponent(1);
        }
        return this.projectClassWidgets.getComponent(1);
    }

    private void initialize(DatabaseSessionAdapter databaseSessionAdapter, ProjectTypeUpdater projectTypeUpdater, String string) {
        this.databaseSession = databaseSessionAdapter;
        this.helpTopicId = string;
        this.projectType = new ProjectTypeEditor(projectTypeUpdater);
    }

    public void okConfirmed() {
        super.okConfirmed();
        this.projectType.apply();
    }

    private File retrieveLastDirectory() {
        TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)this.databaseSession.getParent();
        File file = topLinkSessionsAdapter.getSaveDirectory();
        if (file == null) {
            file = FileTools.userHomeDirectory();
        }
        return new File(this.preferences().get("location", file.getPath()));
    }

    private class XmlFileFilter
    extends FileFilter {
        private XmlFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || ".xml".equalsIgnoreCase(FileTools.extension((File)file));
        }

        public String getDescription() {
            return ProjectTypeEditDialog.this.resourceRepository().getString("SESSION_PROJECT_ADVANCED_FILE_CHOOSER_DESCRIPTION");
        }
    }

    public static interface ProjectTypeUpdater {
        public void apply(boolean var1, String var2);

        public String getProjectName();

        public boolean isProjectXml();
    }

    private static class ProjectTypeEditor
    extends AbstractModel {
        private String projectClass;
        private boolean projectTypeXml;
        private String projectXml;
        private ProjectTypeUpdater updater;
        public static final String PROJECT_CLASS_PROPERTY = "ProjectClass";
        public static final String PROJECT_TYPE_XML_PROPERTY = "projectTypeXml";
        public static final String PROJECT_XML_PROPERTY = "ProjectXml";

        public ProjectTypeEditor(ProjectTypeUpdater projectTypeUpdater) {
            this.initialize(projectTypeUpdater);
        }

        public void apply() {
            this.updater.apply(this.projectTypeXml, this.projectTypeXml ? this.projectXml : this.projectClass);
        }

        public String getProjectClass() {
            return this.projectClass;
        }

        public String getProjectXml() {
            return this.projectXml;
        }

        private void initialize(ProjectTypeUpdater projectTypeUpdater) {
            this.updater = projectTypeUpdater;
            this.setProjectTypeXml(projectTypeUpdater.isProjectXml());
            if (this.projectTypeXml) {
                this.setProjectXml(projectTypeUpdater.getProjectName());
            } else {
                this.setProjectClass(projectTypeUpdater.getProjectName());
            }
        }

        public boolean isProjectTypeXml() {
            return this.projectTypeXml;
        }

        public void setProjectClass(String string) {
            String string2 = this.getProjectClass();
            this.projectClass = string;
            this.firePropertyChanged(PROJECT_CLASS_PROPERTY, string2, string);
        }

        public void setProjectTypeXml(boolean bl) {
            boolean bl2 = this.isProjectTypeXml();
            this.projectTypeXml = bl;
            this.firePropertyChanged(PROJECT_TYPE_XML_PROPERTY, bl2, bl);
        }

        public void setProjectXml(String string) {
            String string2 = this.getProjectXml();
            this.projectXml = string;
            this.firePropertyChanged(PROJECT_XML_PROPERTY, string2, string);
        }
    }
}

