/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyIterator;

public class ListCollectionValueModelAdapter
extends AbstractModel
implements CollectionValueModel {
    protected ListValueModel listHolder;
    protected ListChangeListener listChangeListener;
    protected ArrayList collection;

    public ListCollectionValueModelAdapter(ListValueModel listValueModel) {
        if (listValueModel == null) {
            throw new NullPointerException();
        }
        this.listHolder = listValueModel;
    }

    protected void initialize() {
        super.initialize();
        this.listChangeListener = this.buildListChangeListener();
        this.collection = new ArrayList();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent listChangeEvent) {
                ListCollectionValueModelAdapter.this.itemsAdded(listChangeEvent);
            }

            public void itemsRemoved(ListChangeEvent listChangeEvent) {
                ListCollectionValueModelAdapter.this.itemsRemoved(listChangeEvent);
            }

            public void itemsReplaced(ListChangeEvent listChangeEvent) {
                ListCollectionValueModelAdapter.this.itemsReplaced(listChangeEvent);
            }

            public void listChanged(ListChangeEvent listChangeEvent) {
                ListCollectionValueModelAdapter.this.listChanged(listChangeEvent);
            }

            public String toString() {
                return "list change listener";
            }
        };
    }

    public Object getValue() {
        return new ReadOnlyIterator((Collection)this.collection);
    }

    public void addItem(Object object) {
        throw new UnsupportedOperationException();
    }

    public void addItems(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void removeItem(Object object) {
        throw new UnsupportedOperationException();
    }

    public void removeItems(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.collection.size();
    }

    public void addCollectionChangeListener(CollectionChangeListener collectionChangeListener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(collectionChangeListener);
    }

    public void addCollectionChangeListener(String string, CollectionChangeListener collectionChangeListener) {
        if (string == "value" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(string, collectionChangeListener);
    }

    public void removeCollectionChangeListener(CollectionChangeListener collectionChangeListener) {
        super.removeCollectionChangeListener(collectionChangeListener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public void removeCollectionChangeListener(String string, CollectionChangeListener collectionChangeListener) {
        super.removeCollectionChangeListener(string, collectionChangeListener);
        if (string == "value" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("value");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected int lastIdentityIndexOf(Object object) {
        return this.lastIdentityIndexOf(object, this.collection.size());
    }

    protected int lastIdentityIndexOf(Object object, int n) {
        int n2 = n;
        while (n2-- > 0) {
            if (this.collection.get(n2) != object) continue;
            return n2;
        }
        return -1;
    }

    protected void buildCollection() {
        Iterator iterator = (Iterator)this.listHolder.getValue();
        if (iterator.hasNext()) {
            this.collection.ensureCapacity(this.listHolder.size());
            while (iterator.hasNext()) {
                this.collection.add(iterator.next());
            }
        }
    }

    protected void engageModel() {
        this.listHolder.addListChangeListener("value", this.listChangeListener);
        this.buildCollection();
    }

    protected void disengageModel() {
        this.listHolder.removeListChangeListener("value", this.listChangeListener);
        this.collection.clear();
    }

    protected void addInternalItems(Iterator iterator) {
        Collection collection = CollectionTools.collection((Iterator)iterator);
        this.collection.addAll(collection);
        this.fireItemsAdded("value", collection);
    }

    protected void itemsAdded(ListChangeEvent listChangeEvent) {
        this.addInternalItems(listChangeEvent.items());
    }

    protected void removeInternalItems(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = this.lastIdentityIndexOf(e);
            this.collection.remove(n);
            this.fireItemRemoved("value", e);
        }
    }

    protected void itemsRemoved(ListChangeEvent listChangeEvent) {
        this.removeInternalItems(listChangeEvent.items());
    }

    protected void itemsReplaced(ListChangeEvent listChangeEvent) {
        this.removeInternalItems(listChangeEvent.replacedItems());
        this.addInternalItems(listChangeEvent.items());
    }

    protected void listChanged(ListChangeEvent listChangeEvent) {
        if (!this.collection.isEmpty()) {
            ArrayList arrayList = this.collection;
            this.collection = new ArrayList();
            this.fireItemsRemoved("value", arrayList);
        }
        this.buildCollection();
        if (!this.collection.isEmpty()) {
            this.fireItemsAdded("value", this.collection);
        }
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.listHolder);
    }
}

