/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class ObjectListSelectionModel
extends DefaultListSelectionModel {
    private ListModel listModel;
    private ListDataListener listDataListener;

    private ObjectListSelectionModel() {
    }

    public ObjectListSelectionModel(ListModel listModel) {
        this();
        this.listModel = listModel;
        this.listDataListener = this.buildListDataListener();
    }

    private ListDataListener buildListDataListener() {
        return new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                ObjectListSelectionModel.this.listModelContentsChanged(listDataEvent);
            }

            public String toString() {
                return "list data listener";
            }
        };
    }

    protected void listModelContentsChanged(ListDataEvent listDataEvent) {
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.hasNoListSelectionListeners()) {
            this.listModel.addListDataListener(this.listDataListener);
        }
        super.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        super.removeListSelectionListener(listSelectionListener);
        if (this.hasNoListSelectionListeners()) {
            this.listModel.removeListDataListener(this.listDataListener);
        }
    }

    protected boolean hasNoListSelectionListeners() {
        return this.getListSelectionListeners().length == 0;
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public int getSelectedValuesSize() {
        int n = this.getMinSelectionIndex();
        int n2 = this.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = this.getListModel().getSize();
        for (int i = n; i <= n2; ++i) {
            if (!this.isSelectedIndex(i) || i >= n4) continue;
            ++n3;
        }
        return n3;
    }

    public Object getSelectedValue() {
        int n = this.getMinSelectionIndex();
        if (n == -1) {
            return null;
        }
        if (this.getListModel().getSize() <= n) {
            return null;
        }
        return this.getListModel().getElementAt(n);
    }

    public Object[] getSelectedValues() {
        int n = this.getMinSelectionIndex();
        int n2 = this.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new Object[0];
        }
        int n3 = n2 - n + 1;
        Object[] objectArray = new Object[n3];
        int n4 = 0;
        int n5 = this.getListModel().getSize();
        for (int i = n; i <= n2; ++i) {
            if (!this.isSelectedIndex(i) || i >= n5) continue;
            objectArray[n4++] = this.getListModel().getElementAt(i);
        }
        if (n4 == n3) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n4];
        System.arraycopy(objectArray, 0, objectArray2, 0, n4);
        return objectArray2;
    }

    public void setSelectedValue(Object object) {
        this.setSelectedValues(CollectionTools.singletonIterator((Object)object));
    }

    public void setSelectedValues(Iterator iterator) {
        this.setValueIsAdjusting(true);
        this.clearSelection();
        this.addSelectedValuesInternal(iterator);
        this.setValueIsAdjusting(false);
    }

    public void setSelectedValues(Collection collection) {
        this.setSelectedValues(collection.iterator());
    }

    public void setSelectedValues(Object[] objectArray) {
        this.setSelectedValues(CollectionTools.iterator((Object[])objectArray));
    }

    public void addSelectedValue(Object object) {
        this.addSelectedValues(CollectionTools.singletonIterator((Object)object));
    }

    public void addSelectedValues(Iterator iterator) {
        this.setValueIsAdjusting(true);
        this.addSelectedValuesInternal(iterator);
        this.setValueIsAdjusting(false);
    }

    public void addSelectedValues(Collection collection) {
        this.addSelectedValues(collection.iterator());
    }

    public void addSelectedValues(Object[] objectArray) {
        this.addSelectedValues(CollectionTools.iterator((Object[])objectArray));
    }

    public void removeSelectedValue(Object object) {
        this.removeSelectedValues(CollectionTools.singletonIterator((Object)object));
    }

    public void removeSelectedValues(Iterator iterator) {
        this.setValueIsAdjusting(true);
        ListModel listModel = this.getListModel();
        int n = listModel.getSize();
        while (iterator.hasNext()) {
            int n2 = this.indexOf(iterator.next(), listModel, n);
            this.removeSelectionInterval(n2, n2);
        }
        this.setValueIsAdjusting(false);
    }

    public void removeSelectedValues(Collection collection) {
        this.removeSelectedValues(collection.iterator());
    }

    public void removeSelectedValues(Object[] objectArray) {
        this.removeSelectedValues(CollectionTools.iterator((Object[])objectArray));
    }

    public Object getAnchorSelectedValue() {
        int n = this.getAnchorSelectionIndex();
        if (n == -1) {
            return null;
        }
        return this.getListModel().getElementAt(n);
    }

    public void setAnchorSelectedValue(Object object) {
        this.setAnchorSelectionIndex(this.indexOf(object));
    }

    public Object getLeadSelectedValue() {
        int n = this.getLeadSelectionIndex();
        if (n == -1) {
            return null;
        }
        return this.getListModel().getElementAt(n);
    }

    public void setLeadSelectedValue(Object object) {
        this.setLeadSelectionIndex(this.indexOf(object));
    }

    public Object getMaxSelectedValue() {
        int n = this.getMaxSelectionIndex();
        if (n == -1) {
            return null;
        }
        return this.getListModel().getElementAt(n);
    }

    public Object getMinSelectedValue() {
        int n = this.getMinSelectionIndex();
        if (n == -1) {
            return null;
        }
        return this.getListModel().getElementAt(n);
    }

    public boolean valueIsSelected(Object object) {
        return this.isSelectedIndex(this.indexOf(object));
    }

    private void addSelectedValuesInternal(Iterator iterator) {
        ListModel listModel = this.getListModel();
        int n = listModel.getSize();
        while (iterator.hasNext()) {
            int n2 = this.indexOf(iterator.next(), listModel, n);
            this.addSelectionInterval(n2, n2);
        }
    }

    private int indexOf(Object object) {
        ListModel listModel = this.getListModel();
        return this.indexOf(object, listModel, listModel.getSize());
    }

    private int indexOf(Object object, ListModel listModel, int n) {
        int n2 = n;
        while (n2-- > 0) {
            if (listModel.getElementAt(n2) != object) continue;
            return n2;
        }
        return -1;
    }
}

