/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;

public abstract class LabeledTreeCellRenderer
implements TreeCellRenderer {
    private JPanel panel;
    private JLabel label;
    protected JComponent component;
    protected boolean editing = false;
    private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

    public LabeledTreeCellRenderer(String string, Icon icon) {
        this.initialize(string, icon);
    }

    public LabeledTreeCellRenderer(String string) {
        this(string, null);
    }

    public LabeledTreeCellRenderer(Icon icon) {
        this(null, icon);
    }

    public LabeledTreeCellRenderer() {
        this(null, null);
    }

    protected void initialize(String string, Icon icon) {
        this.panel = this.buildPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.label = this.buildLabel(string, icon);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panel.add((Component)this.label, gridBagConstraints);
        this.component = this.buildComponent();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.panel.add((Component)this.component, gridBagConstraints);
    }

    protected JPanel buildPanel(LayoutManager layoutManager) {
        return new JPanel(layoutManager);
    }

    protected JLabel buildLabel(String string, Icon icon) {
        return new JLabel(string, icon, 10);
    }

    protected abstract JComponent buildComponent();

    protected void setEditing(boolean bl) {
        this.editing = bl;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.setComponentOrientation(jTree.getComponentOrientation());
        this.setFont(jTree.getFont());
        this.setEnabled(jTree.isEnabled());
        this.setForeground(this.foregroundColor(jTree, object, bl, bl2, bl3, n, bl4));
        this.setBackground(this.backgroundColor(jTree, object, bl, bl2, bl3, n, bl4));
        this.panel.setBorder(this.border(jTree, object, bl, bl2, bl3, n, bl4));
        this.setOpaque(this.cellIsOpaqueIn(jTree, object, bl, bl2, bl3, n, bl4));
        this.setValue(object);
        return this.panel;
    }

    protected void setComponentOrientation(ComponentOrientation componentOrientation) {
        this.panel.setComponentOrientation(componentOrientation);
        this.label.setComponentOrientation(componentOrientation);
        this.component.setComponentOrientation(componentOrientation);
    }

    protected void setFont(Font font) {
        this.panel.setFont(font);
        this.label.setFont(font);
        this.component.setFont(font);
    }

    protected void setEnabled(boolean bl) {
        this.panel.setEnabled(bl);
        this.label.setEnabled(bl);
        this.component.setEnabled(bl);
    }

    protected Color foregroundColor(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (bl) {
            if (this.editing) {
                return UIManager.getColor("Tree.textForeground");
            }
            return UIManager.getColor("Tree.selectionForeground");
        }
        return UIManager.getColor("Tree.textForeground");
    }

    protected Color backgroundColor(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (bl) {
            if (this.editing) {
                return UIManager.getColor("Tree.textBackground");
            }
            return UIManager.getColor("Tree.selectionBackground");
        }
        return UIManager.getColor("Tree.textBackground");
    }

    protected void setForeground(Color color) {
        this.panel.setForeground(color);
        this.label.setForeground(color);
        this.component.setForeground(color);
    }

    protected void setBackground(Color color) {
        this.panel.setBackground(color);
        this.label.setBackground(color);
        this.component.setBackground(color);
    }

    protected Border border(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (bl4) {
            if (this.editing) {
                return UIManager.getBorder("Tree.editorBorder");
            }
            return BorderFactory.createLineBorder(UIManager.getColor("Tree.selectionBorderColor"), 1);
        }
        return NO_FOCUS_BORDER;
    }

    protected boolean cellIsOpaqueIn(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Color color = this.panel.getBackground();
        Color color2 = jTree.getBackground();
        return !jTree.isOpaque() || !color.equals(color2);
    }

    protected void setOpaque(boolean bl) {
        this.panel.setOpaque(bl);
    }

    protected abstract void setValue(Object var1);

    public void setLabelText(String string) {
        this.label.setText(string);
    }

    public void setLabelIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public int getPreferredHeight() {
        return (int)this.panel.getPreferredSize().getHeight() + 2;
    }

    public void setPreferredWidth(int n) {
        this.panel.setPreferredSize(new Dimension(n, this.panel.getPreferredSize().height));
    }
}

