/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.InheritanceNodeValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaClassPathReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.helper.SDOClassLoader;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;

public class SDOType
implements Type,
Serializable {
    private QName qName;
    private boolean open;
    private boolean isAbstract;
    protected boolean isDataType;
    private List baseTypes;
    private List declaredProperties;
    private transient Map declaredPropertiesMap;
    private List aliasNames;
    private boolean xsd;
    private boolean xsdList;
    private String xsdLocalName;
    private QName xsdType;
    protected transient XMLDescriptor xmlDescriptor = new XMLDescriptor();
    private Map propertyValues;
    private SDOProperty changeSummaryProperty;
    private List allProperties;
    private SDOProperty[] allPropertiesArr;
    private List subTypes;
    private boolean finalized;
    private Class javaClass;
    private String javaClassName;
    private String javaImplClassName;
    private Class javaImplClass;
    private List nonFinalizedReferencingProps;
    private List nonFinalizedMappingURIs;
    private Object pseudoDefault;
    protected HelperContext aHelperContext;
    private List appInfoElements;
    private Map appInfoMap;
    private static final String ANY_MAPPING_ATTRIBUTE_NAME = "openContentProperties";
    private static final String ANY_MAPPING_GET_METHOD_NAME = "_getOpenContentPropertiesWithXMLRoots";
    private static final String ANY_MAPPING_SET_METHOD_NAME = "_setOpenContentPropertiesWithXMLRoots";
    private static final String SDO_REF_MAPPING_ATTRIBUTE_NAME = "sdoRef";

    public SDOType(HelperContext helperContext) {
        this((SDOTypeHelper)helperContext.getTypeHelper());
    }

    public SDOType(SDOTypeHelper sDOTypeHelper) {
        if (null != sDOTypeHelper) {
            this.aHelperContext = sDOTypeHelper.getHelperContext();
            this.xmlDescriptor.setNamespaceResolver(sDOTypeHelper.getNamespaceResolver());
        }
    }

    public SDOType(String string, String string2) {
        this(string, string2, (SDOTypeHelper)HelperProvider.getDefaultContext().getTypeHelper());
    }

    public SDOType(String string, String string2, SDOTypeHelper sDOTypeHelper) {
        this(sDOTypeHelper);
        this.qName = new QName(string, string2);
    }

    public QName getQName() {
        return this.qName;
    }

    public void setQName(QName qName) {
        this.qName = qName;
    }

    public String getName() {
        return this.qName.getLocalPart();
    }

    public String getURI() {
        String string = this.qName.getNamespaceURI();
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    public Class getInstanceClass() {
        if (this.javaClass == null && this.javaClassName != null) {
            try {
                SDOClassLoader sDOClassLoader = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader();
                if (!this.isDataType() && this.javaImplClass == null) {
                    this.javaImplClass = sDOClassLoader.loadClass(this.getImplClassName(), this);
                    this.getXmlDescriptor().setJavaClass(this.javaImplClass);
                }
                this.javaClass = sDOClassLoader.loadClass(this.javaClassName, this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw SDOException.classNotFound((Exception)classNotFoundException, (String)this.getURI(), (String)this.getName());
            }
            catch (SecurityException securityException) {
                throw SDOException.classNotFound((Exception)securityException, (String)this.getURI(), (String)this.getName());
            }
        }
        return this.javaClass;
    }

    public boolean isInstance(Object object) {
        Class clazz;
        if (!this.isDataType() && object instanceof DataObject && (clazz = ((DataObject)object).getType()) != null) {
            return clazz.equals(this);
        }
        clazz = this.getInstanceClass();
        if (clazz != null) {
            return clazz.isInstance(object);
        }
        return false;
    }

    public List getProperties() {
        if (this.allProperties == null) {
            this.allProperties = new ArrayList();
        }
        return this.allProperties;
    }

    public SDOProperty getProperty(String string) {
        SDOProperty sDOProperty = (SDOProperty)this.getDeclaredPropertiesMap().get(string);
        if (null == sDOProperty && this.isSubType()) {
            for (int i = 0; i < this.getBaseTypes().size() && (sDOProperty = ((SDOType)this.getBaseTypes().get(i)).getProperty(string)) == null; ++i) {
            }
        }
        return sDOProperty;
    }

    public boolean isDataType() {
        return this.isDataType;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isSequenced() {
        return this.xmlDescriptor.isSequencedObject();
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public List getBaseTypes() {
        if (this.baseTypes == null) {
            this.baseTypes = new ArrayList();
        }
        return this.baseTypes;
    }

    public boolean isSubType() {
        return null != this.baseTypes && !this.baseTypes.isEmpty();
    }

    public List getDeclaredProperties() {
        if (this.declaredProperties == null) {
            this.declaredProperties = new ArrayList();
        }
        return this.declaredProperties;
    }

    public List getAliasNames() {
        if (this.aliasNames == null) {
            this.aliasNames = new ArrayList();
        }
        return this.aliasNames;
    }

    public void addAliasName(String string) {
        this.getAliasNames().add(string);
        QName qName = new QName(this.getURI(), string);
        ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypesHashMap().put(qName, this);
    }

    public void setAliasNames(List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addAliasName((String)list.get(i));
        }
    }

    public void setOpen(boolean bl) {
        if (this.isDataType() && bl) {
            throw SDOException.typeCannotBeOpenAndDataType((String)this.getURI(), (String)this.getName());
        }
        if (this.open != bl) {
            this.open = bl;
            if (this.open) {
                if (this.isSubType()) {
                    Type type = (Type)this.getBaseTypes().get(0);
                    if (!type.isOpen()) {
                        this.addOpenMappings();
                    }
                } else {
                    this.addOpenMappings();
                }
                for (int i = 0; i < this.getSubTypes().size(); ++i) {
                    SDOType sDOType = (SDOType)this.getSubTypes().get(i);
                    sDOType.setOpen(bl);
                }
            }
        }
    }

    private void addOpenMappings() {
        XMLAnyCollectionMapping xMLAnyCollectionMapping = new XMLAnyCollectionMapping();
        xMLAnyCollectionMapping.setAttributeName(ANY_MAPPING_ATTRIBUTE_NAME);
        xMLAnyCollectionMapping.setGetMethodName(ANY_MAPPING_GET_METHOD_NAME);
        xMLAnyCollectionMapping.setSetMethodName(ANY_MAPPING_SET_METHOD_NAME);
        xMLAnyCollectionMapping.setUseXMLRoot(true);
        this.getXmlDescriptor().addMapping((DatabaseMapping)xMLAnyCollectionMapping);
        XMLAnyAttributeMapping xMLAnyAttributeMapping = new XMLAnyAttributeMapping();
        xMLAnyAttributeMapping.setAttributeName("openContentPropertiesAttributes");
        xMLAnyAttributeMapping.setGetMethodName("_getOpenContentPropertiesAttributesMap");
        xMLAnyAttributeMapping.setSetMethodName("_setOpenContentPropertiesAttributesMap");
        this.getXmlDescriptor().addMapping((DatabaseMapping)xMLAnyAttributeMapping);
    }

    public void setAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    public void setSequenced(boolean bl) {
        this.xmlDescriptor.setSequencedObject(bl);
    }

    public void setMixed(boolean bl) {
        String string = "text";
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)this.xmlDescriptor.getMappingForAttributeName(string);
        if (bl) {
            if (null == xMLDirectMapping) {
                xMLDirectMapping = new XMLDirectMapping();
                xMLDirectMapping.setAttributeName(string);
                xMLDirectMapping.setXPath("text()");
                this.xmlDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
            }
        } else {
            this.xmlDescriptor.removeMappingForAttributeName(string);
        }
    }

    public void setDataType(boolean bl) {
        if (bl && this.isOpen()) {
            throw SDOException.typeCannotBeOpenAndDataType((String)this.getURI(), (String)this.getName());
        }
        this.isDataType = bl;
        if (bl) {
            this.setFinalized(true);
        }
    }

    public void setBaseTypes(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.addBaseType((SDOType)list.get(i));
            }
        } else {
            this.baseTypes = null;
        }
    }

    public void addBaseType(SDOType sDOType) {
        if (!this.getBaseTypes().contains(sDOType)) {
            this.getBaseTypes().add(sDOType);
            this.updateSubtypes(sDOType);
            sDOType.getSubTypes().add(this);
            if (sDOType.isOpen() && this.isOpen()) {
                DatabaseMapping databaseMapping = this.getXmlDescriptor().getMappingForAttributeName(ANY_MAPPING_ATTRIBUTE_NAME);
                this.getXmlDescriptor().getMappings().remove(databaseMapping);
                DatabaseMapping databaseMapping2 = this.getXmlDescriptor().getMappingForAttributeName("openContentPropertiesAttributes");
                this.getXmlDescriptor().getMappings().remove(databaseMapping2);
            }
        }
    }

    private void updateSubtypes(Type type) {
        this.getProperties().addAll(0, type.getProperties());
        for (int i = 0; i < this.getSubTypes().size(); ++i) {
            SDOType sDOType = (SDOType)this.getSubTypes().get(i);
            sDOType.updateSubtypes(type);
        }
    }

    public void setInstanceClass(Class clazz) {
        this.javaClass = clazz;
        if (this.javaClass != null) {
            this.javaClassName = this.javaClass.getName();
        }
        if (this.getXmlDescriptor() != null) {
            this.getXmlDescriptor().setJavaClass(clazz);
        }
    }

    public void setXsd(boolean bl) {
        this.xsd = bl;
    }

    public boolean isXsd() {
        return this.xsd;
    }

    public void setXsdLocalName(String string) {
        this.xsdLocalName = string;
    }

    public String getXsdLocalName() {
        return this.xsdLocalName;
    }

    public void addDeclaredProperty(Property property) {
        this.addDeclaredProperty((SDOProperty)property);
    }

    public void addDeclaredProperty(SDOProperty sDOProperty) {
        int n = this.getDeclaredProperties().size();
        this.addDeclaredProperty(sDOProperty, n);
    }

    public void addDeclaredProperty(Property property, int n) {
        this.addDeclaredProperty((SDOProperty)property, n);
    }

    public void addDeclaredProperty(SDOProperty sDOProperty, int n) {
        if (!this.getDeclaredPropertiesMap().containsKey(sDOProperty.getName())) {
            int n2;
            int n3 = this.getDeclaredProperties().size();
            int n4 = this.getProperties().size();
            int n5 = n4 - n3 + n;
            for (n2 = 0; n2 < this.getSubTypes().size(); ++n2) {
                SDOType sDOType = (SDOType)this.getSubTypes().get(n2);
                sDOType.updateIndices(n5, sDOProperty);
            }
            this.getDeclaredProperties().add(n, sDOProperty);
            this.getProperties().add(n5, sDOProperty);
            sDOProperty.setContainingType(this);
            this.getDeclaredPropertiesMap().put(sDOProperty.getName(), sDOProperty);
            for (n2 = 0; n2 < sDOProperty.getAliasNames().size(); ++n2) {
                this.getDeclaredPropertiesMap().put(sDOProperty.getAliasNames().get(n2), sDOProperty);
            }
            if (sDOProperty.getType() != null && sDOProperty.getType().isChangeSummaryType()) {
                this.changeSummaryProperty = sDOProperty;
            }
        }
    }

    public void removeDeclaredProperties(Property property) {
        this.getDeclaredProperties().remove(property);
        this.getDeclaredPropertiesMap().remove(property.getName());
        this.getProperties().remove(property);
    }

    public Map getDeclaredPropertiesMap() {
        if (null == this.declaredPropertiesMap) {
            this.declaredPropertiesMap = new HashMap();
        }
        return this.declaredPropertiesMap;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    public void setInstanceClassName(String string) {
        this.javaClassName = string;
        this.javaClass = null;
    }

    public String getInstanceClassName() {
        if (this.javaClassName == null && this.javaClass != null) {
            this.javaClassName = this.javaClass.getName();
        }
        return this.javaClassName;
    }

    public void setXsdList(boolean bl) {
        this.xsdList = bl;
    }

    public boolean isXsdList() {
        return this.xsdList;
    }

    public void setXmlDescriptor(XMLDescriptor xMLDescriptor) {
        this.xmlDescriptor = xMLDescriptor;
    }

    public XMLDescriptor getXmlDescriptor() {
        return this.xmlDescriptor;
    }

    public void initializeNamespaces(List list) {
        if (!this.isDataType()) {
            NamespaceResolver namespaceResolver = new NamespaceResolver();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    NamespaceResolver namespaceResolver2 = (NamespaceResolver)list.get(i);
                    if (namespaceResolver2 == null) continue;
                    int n = namespaceResolver2.getNamespaces().size();
                    for (int j = 0; j < n; ++j) {
                        Namespace namespace = (Namespace)namespaceResolver2.getNamespaces().get(j);
                        if (namespace.getPrefix().equals("xmlns") || namespace.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || namespace.getNamespaceURI().equals("commonj.sdo/java") || namespace.getNamespaceURI().equals("commonj.sdo/xml") || namespace.getNamespaceURI().equals("commonj.sdo")) continue;
                        String string = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).addNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                        namespaceResolver.put(string, namespace.getNamespaceURI());
                    }
                }
            }
            this.xmlDescriptor.setNamespaceResolver(namespaceResolver);
            if (this.getURI() != null) {
                String string = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getPrefix(this.getURI());
                this.xmlDescriptor.getNamespaceResolver().put(string, this.getURI());
            }
            this.xmlDescriptor.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    private void addClassIndicator(XMLDescriptor xMLDescriptor, Class clazz, boolean bl) {
        Object object;
        XMLField xMLField = (XMLField)this.getXmlDescriptor().buildField("@xsi:type");
        xMLDescriptor.getInheritancePolicy().setClassIndicatorField((DatabaseField)xMLField);
        String string = this.getName();
        String string2 = xMLDescriptor.getNamespaceResolver().resolveNamespaceURI(this.getURI());
        if (string2 != null) {
            string = string2 + ":" + string;
        }
        xMLDescriptor.getInheritancePolicy().addClassIndicator(clazz, (Object)string);
        if (bl) {
            object = new InheritanceNodeValue();
            object.setInheritancePolicy(xMLDescriptor.getInheritancePolicy());
            ((TreeObjectBuilder)this.xmlDescriptor.getObjectBuilder()).addChild(xMLField.getXPathFragment(), (NodeValue)object, this.xmlDescriptor.getNamespaceResolver());
        }
        if (xMLDescriptor.getMappingForAttributeName(SDO_REF_MAPPING_ATTRIBUTE_NAME) == null) {
            object = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getPrefix("commonj.sdo");
            XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
            xMLDirectMapping.setAttributeName(SDO_REF_MAPPING_ATTRIBUTE_NAME);
            XMLField xMLField2 = new XMLField("@" + (String)object + ":" + "ref");
            xMLField2.getXPathFragment().setNamespaceURI("commonj.sdo");
            xMLField2.getLastXPathFragment().setNamespaceURI("commonj.sdo");
            xMLDirectMapping.setField((DatabaseField)xMLField2);
            xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        }
    }

    public void setupInheritance(SDOType sDOType) {
        SDOType sDOType2;
        if (sDOType == null) {
            this.addClassIndicator(this.getXmlDescriptor(), this.getImplClass(), true);
        } else if (sDOType.getURI() != null && !sDOType.getURI().equals("commonj.sdo")) {
            String string;
            XMLDescriptor xMLDescriptor;
            if (!sDOType.getXmlDescriptor().hasInheritance()) {
                this.addClassIndicator(sDOType.getXmlDescriptor(), sDOType.getImplClass(), false);
            }
            if ((sDOType2 = (xMLDescriptor = (XMLDescriptor)sDOType.getXmlDescriptor().getInheritancePolicy().getRootParentDescriptor()).getNonNullNamespaceResolver()) != null) {
                for (int i = 0; i < sDOType2.getNamespaces().size(); ++i) {
                    string = (Namespace)sDOType2.getNamespaces().get(i);
                    if (string.getPrefix().equals("xmlns") || string.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || string.getNamespaceURI().equals("commonj.sdo/java") || string.getNamespaceURI().equals("commonj.sdo/xml") || string.getNamespaceURI().equals("commonj.sdo")) continue;
                    this.getXmlDescriptor().getNonNullNamespaceResolver().put(string.getPrefix(), string.getNamespaceURI());
                }
            }
            if (this.getInstanceClassName() != null) {
                String string2 = this.getName();
                string = xMLDescriptor.getNamespaceResolver().resolveNamespaceURI(this.getURI());
                if (string == null && (string = this.getXmlDescriptor().getNamespaceResolver().resolveNamespaceURI(this.getURI())) != null) {
                    xMLDescriptor.getNamespaceResolver().put(string, this.getURI());
                }
                if (string != null) {
                    string2 = string + ":" + string2;
                }
                Class clazz = this.getImplClass();
                xMLDescriptor.getInheritancePolicy().addClassIndicator(clazz, (Object)string2);
                xMLDescriptor.getInheritancePolicy().setShouldReadSubclasses(true);
                Class clazz2 = sDOType.getImplClass();
                this.getXmlDescriptor().getInheritancePolicy().setParentClass(clazz2);
                this.getXmlDescriptor().getInheritancePolicy().setParentDescriptor((ClassDescriptor)sDOType.getXmlDescriptor());
                sDOType.getXmlDescriptor().getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this.getXmlDescriptor().getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        for (int i = 0; i < this.subTypes.size(); ++i) {
            sDOType2 = (SDOType)this.subTypes.get(i);
            if (sDOType2.isDataType() || !sDOType2.isSubType()) continue;
            sDOType2.setupInheritance(this);
        }
    }

    public void preInitialize(String string, List list) {
        CharSequence charSequence;
        String string2;
        String string3 = this.getInstanceClassName();
        if (null == string3) {
            if (null == string) {
                string2 = this.getURI();
                string = null == string2 ? SDOUtil.getDefaultPackageName() + "." : SDOUtil.getPackageNameFromURI(string2) + ".";
            }
            string2 = SDOUtil.className(this.getName(), true);
            charSequence = new StringBuffer(string);
            ((StringBuffer)charSequence).append(string2);
            this.setInstanceClassName(((StringBuffer)charSequence).toString());
        }
        AbstractSessionLog.getLog().log(2, "sdo_type_generation_processing_type", new Object[]{Helper.getShortClassName(this.getClass()), this.getInstanceClassName()});
        this.initializeNamespaces(list);
        this.getXmlDescriptor().setJavaClassName(this.getImplClassName());
        this.getInstanceClass();
        string2 = this.getName();
        if (this.getXmlDescriptor().getNamespaceResolver() != null && (charSequence = this.getXmlDescriptor().getNamespaceResolver().resolveNamespaceURI(this.getURI())) != null && !((String)charSequence).equals("")) {
            string2 = (String)charSequence + ":" + string2;
        }
        charSequence = "/" + string2;
        XMLSchemaClassPathReference xMLSchemaClassPathReference = new XMLSchemaClassPathReference();
        xMLSchemaClassPathReference.setSchemaContext((String)charSequence);
        xMLSchemaClassPathReference.setType(1);
        this.getXmlDescriptor().setSchemaReference((XMLSchemaReference)xMLSchemaClassPathReference);
    }

    public void postInitialize() {
        String string;
        Object object;
        SDOProperty sDOProperty;
        String string2 = (String)this.get(SDOConstants.ID_PROPERTY);
        if (string2 != null && (sDOProperty = this.getProperty(string2)) != null) {
            object = sDOProperty.getQualifiedXPath(this.getURI(), true);
            this.getXmlDescriptor().addPrimaryKeyFieldName((String)object);
        }
        this.setFinalized(true);
        for (int i = 0; i < this.getNonFinalizedReferencingProps().size(); ++i) {
            object = (SDOProperty)this.getNonFinalizedReferencingProps().get(i);
            string = (String)this.getNonFinalizedMappingURIs().get(i);
            ((SDOProperty)object).buildMapping(string, ((SDOProperty)object).getIndexInType());
        }
        if (!this.isDataType() && !this.isSubType() && this.getSubTypes().size() == 0) {
            String string3 = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getPrefix("commonj.sdo");
            object = new XMLDirectMapping();
            object.setAttributeName(SDO_REF_MAPPING_ATTRIBUTE_NAME);
            string = new XMLField("@" + string3 + ":" + "ref");
            string.getXPathFragment().setNamespaceURI("commonj.sdo");
            string.getLastXPathFragment().setNamespaceURI("commonj.sdo");
            object.setField((DatabaseField)string);
            this.xmlDescriptor.addMapping((DatabaseMapping)object);
        }
    }

    public void setImplClassName(String string) {
        this.javaImplClassName = string;
        this.javaImplClass = null;
    }

    public String getImplClassName() {
        if (this.javaImplClassName == null && this.javaClassName != null) {
            this.javaImplClassName = this.javaClassName + "Impl";
        }
        return this.javaImplClassName;
    }

    public Class getImplClass() {
        if (this.javaImplClass == null && this.getImplClassName() != null) {
            try {
                SDOClassLoader sDOClassLoader = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader();
                this.javaImplClass = sDOClassLoader.loadClass(this.getImplClassName(), this);
                this.xmlDescriptor.setJavaClass(this.javaImplClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw SDOException.classNotFound((Exception)classNotFoundException, (String)this.getURI(), (String)this.getName());
            }
            catch (SecurityException securityException) {
                throw SDOException.classNotFound((Exception)securityException, (String)this.getURI(), (String)this.getName());
            }
        }
        return this.javaImplClass;
    }

    public Object get(Property property) {
        return this.getPropertyValues().get(property);
    }

    public List getInstanceProperties() {
        return new ArrayList(this.getPropertyValues().keySet());
    }

    public void setPropertyValues(Map map) {
        this.propertyValues = map;
    }

    public Map getPropertyValues() {
        if (this.propertyValues == null) {
            this.propertyValues = new HashMap();
        }
        return this.propertyValues;
    }

    public void setInstanceProperty(Property property, Object object) {
        if (property.equals(SDOConstants.JAVA_CLASS_PROPERTY) && object instanceof String) {
            this.setInstanceClassName((String)object);
        }
        this.getPropertyValues().put(property, object);
    }

    public SDOProperty getChangeSummaryProperty() {
        return this.changeSummaryProperty;
    }

    public SDOProperty[] getPropertiesArray() {
        if (this.allPropertiesArr == null || this.allPropertiesArr.length != this.getProperties().size()) {
            List list = this.getProperties();
            int n = list == null ? 0 : list.size();
            this.allPropertiesArr = n > 0 ? list.toArray(new SDOProperty[n]) : new SDOProperty[0];
        }
        return this.allPropertiesArr;
    }

    public void setSubTypes(List list) {
        this.subTypes = list;
    }

    public List getSubTypes() {
        if (this.subTypes == null) {
            this.subTypes = new ArrayList();
        }
        return this.subTypes;
    }

    private void updateIndices(int n, Property property) {
        int n2;
        int n3 = this.getDeclaredProperties().size();
        SDOProperty sDOProperty = null;
        for (n2 = 0; n2 < n3; ++n2) {
            sDOProperty = (SDOProperty)this.getDeclaredProperties().get(n2);
            sDOProperty.setIndexInType(sDOProperty.getIndexInType() + 1);
        }
        this.getProperties().add(n, property);
        n2 = this.getSubTypes().size();
        SDOType sDOType = null;
        for (int i = 0; i < n2; ++i) {
            sDOType = (SDOType)this.getSubTypes().get(i);
            sDOType.updateIndices(n, property);
        }
    }

    public void setXsdType(QName qName) {
        this.xsdType = qName;
    }

    public QName getXsdType() {
        return this.xsdType;
    }

    public void setFinalized(boolean bl) {
        this.finalized = bl;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public void setNonFinalizedReferencingProps(List list) {
        this.nonFinalizedReferencingProps = list;
    }

    public List getNonFinalizedReferencingProps() {
        if (this.nonFinalizedReferencingProps == null) {
            this.nonFinalizedReferencingProps = new ArrayList();
        }
        return this.nonFinalizedReferencingProps;
    }

    public void setNonFinalizedMappingURIs(List list) {
        this.nonFinalizedMappingURIs = list;
    }

    public List getNonFinalizedMappingURIs() {
        if (this.nonFinalizedMappingURIs == null) {
            this.nonFinalizedMappingURIs = new ArrayList();
        }
        return this.nonFinalizedMappingURIs;
    }

    public void setAppInfoElements(List list) {
        this.appInfoElements = list;
    }

    public List getAppInfoElements() {
        return this.appInfoElements;
    }

    public Map getAppInfoMap() {
        if (this.appInfoMap == null) {
            this.appInfoMap = ((SDOXSDHelper)this.aHelperContext.getXSDHelper()).buildAppInfoMap(this.appInfoElements);
        }
        return this.appInfoMap;
    }

    public Object getPseudoDefault() {
        return this.pseudoDefault;
    }

    public void setPseudoDefault(Object object) {
        this.pseudoDefault = object;
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public boolean isChangeSummaryType() {
        return false;
    }

    public boolean isDataObjectType() {
        return false;
    }

    public boolean isTypeType() {
        return false;
    }

    public boolean isOpenSequencedType() {
        return false;
    }
}

