/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.FormattedWriterRecord;
import org.eclipse.persistence.oxm.record.WriterRecord;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.DefaultSchemaResolver;
import org.eclipse.persistence.sdo.helper.SDOSchemaGenerator;
import org.eclipse.persistence.sdo.helper.SDOTypesGenerator;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.SchemaLocationResolver;
import org.eclipse.persistence.sdo.helper.SchemaResolver;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SDOXSDHelperDelegate
implements SDOXSDHelper {
    private Map globalAttributes;
    private Map globalElements;
    private HelperContext aHelperContext;

    public SDOXSDHelperDelegate(HelperContext helperContext) {
        this.aHelperContext = helperContext;
        this.globalAttributes = new HashMap();
        this.initOpenProps();
        this.globalElements = new HashMap();
    }

    public String getLocalName(Type type) {
        if (type == null) {
            return null;
        }
        return ((SDOType)type).getXsdLocalName();
    }

    public String getLocalName(Property property) {
        if (property == null) {
            return null;
        }
        return ((SDOProperty)property).getXsdLocalName();
    }

    public String getNamespaceURI(Type type) {
        if (type == null) {
            return null;
        }
        return type.getURI();
    }

    public String getNamespaceURI(Property property) {
        if (property == null) {
            return null;
        }
        String string = null;
        if (property.isOpenContent()) {
            string = ((SDOProperty)property).getUri();
        } else {
            XMLField xMLField;
            DatabaseMapping databaseMapping = ((SDOProperty)property).getXmlMapping();
            if (databaseMapping != null && (xMLField = (XMLField)databaseMapping.getField()) != null && xMLField.getXPathFragment() != null) {
                string = xMLField.getXPathFragment().getNamespaceURI();
            }
        }
        return string == null ? "" : string;
    }

    public boolean isAttribute(Property property) {
        boolean bl;
        if (property == null) {
            return false;
        }
        Object object = property.get((Property)SDOConstants.XMLELEMENT_PROPERTY);
        if (object != null && object instanceof Boolean && (bl = ((Boolean)object).booleanValue())) {
            return false;
        }
        if (property.getOpposite() != null && property.getOpposite().isContainment()) {
            return false;
        }
        return !property.isMany() && !property.isContainment() && !property.isNullable();
    }

    public boolean isElement(Property property) {
        if (property == null) {
            return false;
        }
        Object object = property.get((Property)SDOConstants.XMLELEMENT_PROPERTY);
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        if (property.getOpposite() != null && property.getOpposite().isContainment()) {
            return false;
        }
        return property.isMany() || property.isContainment() || property.isNullable();
    }

    public boolean isMixed(Type type) {
        if (type == null) {
            return false;
        }
        return type.isSequenced();
    }

    public boolean isXSD(Type type) {
        if (type == null) {
            return false;
        }
        return ((SDOType)type).isXsd();
    }

    public Property getGlobalProperty(String string, String string2, boolean bl) {
        QName qName = new QName(string, string2);
        return this.getGlobalProperty(qName, bl);
    }

    public Property getGlobalProperty(QName qName, boolean bl) {
        if (bl) {
            return (Property)this.getGlobalElements().get(qName);
        }
        return (Property)this.getGlobalAttributes().get(qName);
    }

    public String getAppinfo(Type type, String string) {
        if (type == null) {
            throw SDOException.noAppInfoForNull();
        }
        if (string == null) {
            string = "";
        }
        return (String)((SDOType)type).getAppInfoMap().get(string);
    }

    public String getAppinfo(Property property, String string) {
        if (property == null) {
            throw SDOException.noAppInfoForNull();
        }
        if (string == null) {
            string = "";
        }
        return (String)((SDOProperty)property).getAppInfoMap().get(string);
    }

    public synchronized List define(String string) {
        StringReader stringReader = new StringReader(string);
        DefaultSchemaResolver defaultSchemaResolver = new DefaultSchemaResolver();
        return this.define((Reader)stringReader, (SchemaResolver)defaultSchemaResolver);
    }

    public synchronized List define(Reader reader, String string) {
        DefaultSchemaResolver defaultSchemaResolver = new DefaultSchemaResolver();
        defaultSchemaResolver.setBaseSchemaLocation(string);
        return this.define(new StreamSource(reader), (SchemaResolver)defaultSchemaResolver);
    }

    public synchronized List define(Reader reader, SchemaResolver schemaResolver) {
        return this.define(new StreamSource(reader), schemaResolver);
    }

    public synchronized List define(Source source, SchemaResolver schemaResolver) {
        return new SDOTypesGenerator(this.aHelperContext).define(source, schemaResolver);
    }

    public synchronized List define(InputStream inputStream, String string) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return this.define((Reader)inputStreamReader, string);
    }

    public String generate(List list) {
        Map map = null;
        return this.generate(list, map);
    }

    public String generate(List list, Map map) {
        return new SDOSchemaGenerator(this.aHelperContext).generate(list, map);
    }

    public String generate(List list, SchemaLocationResolver schemaLocationResolver) {
        return new SDOSchemaGenerator(this.aHelperContext).generate(list, schemaLocationResolver);
    }

    public void setGlobalAttributes(Map map) {
        this.globalAttributes = map;
    }

    private Map getGlobalAttributes() {
        return this.globalAttributes;
    }

    private void initOpenProps() {
        this.getGlobalAttributes().put(SDOConstants.MIME_TYPE_QNAME, SDOConstants.MIME_TYPE_PROPERTY);
        this.getGlobalAttributes().put(SDOConstants.MIME_TYPE_PROPERTY_QNAME, SDOConstants.MIME_TYPE_PROPERTY_PROPERTY);
        Property property = this.aHelperContext.getTypeHelper().getOpenContentProperty("commonj.sdo", "xmlSchemaType");
        this.getGlobalAttributes().put(SDOConstants.SCHEMA_TYPE_QNAME, property);
        this.getGlobalAttributes().put(SDOConstants.JAVA_CLASS_QNAME, SDOConstants.JAVA_CLASS_PROPERTY);
        this.getGlobalAttributes().put(SDOConstants.XML_ELEMENT_QNAME, SDOConstants.XMLELEMENT_PROPERTY);
        Property property2 = this.aHelperContext.getTypeHelper().getOpenContentProperty("commonj.sdo/xml", "dataType");
        this.getGlobalAttributes().put(SDOConstants.XML_DATATYPE_QNAME, property2);
        this.getGlobalAttributes().put(SDOConstants.XML_ID_PROPERTY_QNAME, SDOConstants.ID_PROPERTY);
        this.getGlobalAttributes().put(SDOConstants.DOCUMENTATION_PROPERTY_QNAME, SDOConstants.DOCUMENTATION_PROPERTY);
    }

    public void setGlobalElements(Map map) {
        this.globalElements = map;
    }

    private Map getGlobalElements() {
        return this.globalElements;
    }

    public Map buildAppInfoMap(List list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element = (Element)list.get(i);
                if (!element.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || !element.getLocalName().equals("appinfo")) continue;
                String string = element.getAttribute("source");
                String string2 = (String)hashMap.get(string);
                StringWriter stringWriter = new StringWriter();
                WriterRecord writerRecord = new WriterRecord();
                writerRecord.setWriter((Writer)stringWriter);
                writerRecord.node((Node)element, new NamespaceResolver());
                hashMap.put(string, string2 == null ? stringWriter.toString() : string2 + stringWriter.toString());
            }
        }
        return hashMap;
    }

    public void reset() {
        this.globalAttributes = new HashMap();
        this.initOpenProps();
        this.globalElements = new HashMap();
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public String getStringFromAppInfoElement(Element element) {
        FormattedWriterRecord formattedWriterRecord = new FormattedWriterRecord();
        formattedWriterRecord.setWriter((Writer)new StringWriter());
        formattedWriterRecord.node((Node)element, new NamespaceResolver());
        return formattedWriterRecord.getWriter().toString();
    }

    public void addGlobalProperty(QName qName, Property property, boolean bl) {
        ((SDOProperty)property).setUri(qName.getNamespaceURI());
        if (bl) {
            this.getGlobalElements().put(qName, property);
        } else {
            this.getGlobalAttributes().put(qName, property);
        }
    }
}

