/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.sql.Timestamp;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;

public class VersionAccessor
extends BasicAccessor {
    public VersionAccessor() {
        super("<version>");
    }

    public VersionAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
    }

    protected boolean isValidTimestampVersionLockingType(Class clazz) {
        return clazz.equals(Timestamp.class);
    }

    protected boolean isValidVersionLockingType(Class clazz) {
        return clazz.equals(Integer.TYPE) || clazz.equals(Integer.class) || clazz.equals(Short.TYPE) || clazz.equals(Short.class) || clazz.equals(Long.TYPE) || clazz.equals(Long.class);
    }

    public void process() {
        super.process();
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_version_locking", this);
        } else {
            Class clazz = this.getRawClass();
            this.getField().setType(clazz);
            if (this.isValidVersionLockingType(clazz) || this.isValidTimestampVersionLockingType(clazz)) {
                VersionLockingPolicy versionLockingPolicy = this.isValidVersionLockingType(clazz) ? new VersionLockingPolicy(this.getField()) : new TimestampLockingPolicy(this.getField());
                versionLockingPolicy.storeInObject();
                versionLockingPolicy.setIsCascaded(this.getDescriptor().usesCascadedOptimisticLocking());
                this.getOwningDescriptor().setOptimisticLockingPolicy((OptimisticLockingPolicy)versionLockingPolicy);
            } else {
                throw ValidationException.invalidTypeForVersionAttribute((String)this.getAttributeName(), (Class)clazz, (Class)this.getJavaClass());
            }
        }
    }
}

