/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.bind.Binder;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBBinder;
import org.eclipse.persistence.jaxb.JAXBIntrospector;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.JAXBValidator;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.oxm.XMLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBContext
extends javax.xml.bind.JAXBContext {
    private XMLContext xmlContext;
    private Generator generator;
    private HashMap<Class, QName> generatedClassesToQName;
    private HashMap<QName, Class> qNameToGeneratedClasses;

    public JAXBContext(XMLContext xMLContext) {
        this.xmlContext = xMLContext;
    }

    public JAXBContext(XMLContext xMLContext, Generator generator) {
        this.xmlContext = xMLContext;
        this.generator = generator;
        this.generatedClassesToQName = generator.getMappingsGenerator().getGeneratedClassesToQName();
        this.qNameToGeneratedClasses = generator.getMappingsGenerator().getQNamesToGeneratedClasses();
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }

    public void generateSchema(SchemaOutputResolver schemaOutputResolver) {
        if (this.generator == null) {
            return;
        }
        this.generator.generateSchemaFiles(schemaOutputResolver, null);
    }

    public Marshaller createMarshaller() {
        JAXBMarshaller jAXBMarshaller = new JAXBMarshaller(this.xmlContext.createMarshaller(), new JAXBIntrospector(this.xmlContext));
        if (this.generator != null && this.generator.hasMarshalCallbacks()) {
            Iterator iterator = this.generator.getMarshalCallbacks().keySet().iterator();
            while (iterator.hasNext()) {
                MarshalCallback marshalCallback = (MarshalCallback)this.generator.getMarshalCallbacks().get(iterator.next());
                marshalCallback.initialize(this.generator.getClass().getClassLoader());
            }
            jAXBMarshaller.setMarshalCallbacks(this.generator.getMarshalCallbacks());
        }
        jAXBMarshaller.setQNameToGeneratedClasses(this.qNameToGeneratedClasses);
        return jAXBMarshaller;
    }

    public Unmarshaller createUnmarshaller() {
        JAXBUnmarshaller jAXBUnmarshaller = new JAXBUnmarshaller(this.xmlContext.createUnmarshaller());
        if (this.generator != null && this.generator.hasUnmarshalCallbacks()) {
            Iterator iterator = this.generator.getUnmarshalCallbacks().keySet().iterator();
            while (iterator.hasNext()) {
                UnmarshalCallback unmarshalCallback = (UnmarshalCallback)this.generator.getUnmarshalCallbacks().get(iterator.next());
                unmarshalCallback.initialize(this.generator.getClass().getClassLoader());
            }
            jAXBUnmarshaller.setUnmarshalCallbacks(this.generator.getUnmarshalCallbacks());
        }
        jAXBUnmarshaller.setGeneratedClassesToQName(this.generatedClassesToQName);
        return jAXBUnmarshaller;
    }

    public Validator createValidator() {
        return new JAXBValidator(this.xmlContext.createValidator());
    }

    public Binder createBinder() {
        return new JAXBBinder(this.xmlContext);
    }

    public JAXBIntrospector createJAXBIntrospector() {
        return new JAXBIntrospector(this.xmlContext);
    }

    public void setGeneratedClassesToQName(HashMap<Class, QName> hashMap) {
        this.generatedClassesToQName = hashMap;
    }

    public void setQNameToGeneratedClasses(HashMap<QName, Class> hashMap) {
        this.qNameToGeneratedClasses = hashMap;
    }

    public void applyORMMetadata(AbstractSession abstractSession) {
        this.xmlContext.applyORMMetadata(abstractSession);
    }
}

