/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.lang.reflect.Method;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.sessions.Session;

public class JAXBTypesafeEnumConverter
implements Converter {
    String enumClassName;
    Class enumClass;
    Method fromStringMethod;

    public Object convertObjectValueToDataValue(Object object, Session session) {
        return object;
    }

    public Object convertDataValueToObjectValue(Object object, Session session) {
        Object object2 = null;
        try {
            object2 = this.fromStringMethod.invoke((Object)this.enumClass, object);
        }
        catch (Exception exception) {
            throw XMLMarshalException.errorInvokingFromStringMethod((Exception)exception, (String)this.enumClass.getName());
        }
        return object2;
    }

    public boolean isMutable() {
        return true;
    }

    public void initialize(DatabaseMapping databaseMapping, Session session) {
        if (this.getEnumClass() == null) {
            if (this.getEnumClassName() == null) {
                throw XMLMarshalException.enumClassNotSpecified();
            }
            try {
                this.enumClass = session.getDatasourcePlatform().getConversionManager().getLoader().loadClass(this.enumClassName);
            }
            catch (Exception exception) {
                throw XMLMarshalException.invalidEnumClassSpecified((Exception)exception, (String)this.enumClassName);
            }
        }
        try {
            this.fromStringMethod = this.enumClass.getMethod("fromString", String.class);
        }
        catch (Exception exception) {
            throw XMLMarshalException.errorInvokingFromStringMethod((Exception)exception, (String)this.enumClass.getName());
        }
    }

    public String getEnumClassName() {
        return this.enumClassName;
    }

    public void setEnumClassName(String string) {
        this.enumClassName = string;
    }

    public void setEnumClass(Class clazz) {
        this.enumClass = clazz;
    }

    public Class getEnumClass() {
        return this.enumClass;
    }
}

