/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class FieldExpression
extends DataExpression {
    protected DatabaseField field;
    protected transient DatabaseField aliasedField;

    public FieldExpression() {
    }

    public FieldExpression(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public FieldExpression(DatabaseField databaseField, Expression expression) {
        this.field = databaseField;
        this.baseExpression = expression;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FieldExpression fieldExpression = (FieldExpression)object;
        return this.getField() == fieldExpression.getField() || this.getField() != null && this.getField().equals(fieldExpression.getField());
    }

    public int computeHashCode() {
        int n = super.computeHashCode();
        if (this.getField() != null) {
            n += this.getField().hashCode();
        }
        return n;
    }

    public void clearAliases() {
        super.clearAliases();
        this.aliasedField = null;
    }

    public String descriptionOfNodeType() {
        return "Field";
    }

    public DatabaseField getAliasedField() {
        if (this.aliasedField == null) {
            this.initializeAliasedField();
        }
        return this.aliasedField;
    }

    private DatabaseTable getAliasedTable() {
        DatabaseTable databaseTable;
        DataExpression dataExpression = (DataExpression)this.getBaseExpression();
        DatabaseField databaseField = this.getField();
        if (!databaseField.hasTableName() && dataExpression.getDescriptor() != null) {
            databaseField = dataExpression.getDescriptor().buildField(databaseField);
        }
        if ((databaseTable = dataExpression.aliasForTable(databaseField.getTable())) == null) {
            return databaseField.getTable();
        }
        return databaseTable;
    }

    public DatabaseField getClonedField() {
        return (DatabaseField)this.getField().clone();
    }

    public Vector getClonedFields() {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(this.getField().clone());
        return vector;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public Vector getFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        vector.addElement(this.getField());
        return vector;
    }

    private void initializeAliasedField() {
        DatabaseField databaseField = (DatabaseField)this.getField().clone();
        DatabaseTable databaseTable = this.getAliasedTable();
        this.aliasedField = databaseField;
        this.aliasedField.setTable(databaseTable);
    }

    public boolean isAttribute() {
        return true;
    }

    public boolean isFieldExpression() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        Expression expression = super.normalize(expressionNormalizer);
        if (this.getBaseExpression() != null && this.getBaseExpression().isFieldExpression() || this.getBaseExpression().isTableExpression() || this.getBaseExpression().isQueryKeyExpression() && ((QueryKeyExpression)this.getBaseExpression()).isAttribute()) {
            this.getBuilder().getStatement().setRequiresAliases(true);
        }
        return expression;
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        if (this.getBaseExpression() != null && this.getBaseExpression().isFieldExpression() || this.getBaseExpression().isQueryKeyExpression() && ((QueryKeyExpression)this.getBaseExpression()).isAttribute()) {
            this.getBaseExpression().printSQL(expressionSQLPrinter);
            expressionSQLPrinter.printString(".");
        }
        expressionSQLPrinter.printField(this.getAliasedField());
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        this.getBaseExpression().printJava(expressionJavaPrinter);
        expressionJavaPrinter.printString(".getField(\"" + this.getField().getQualifiedName() + "\")");
    }

    public Expression rebuildOn(Expression expression) {
        FieldExpression fieldExpression = new FieldExpression(this.getField(), this.getBaseExpression().rebuildOn(expression));
        fieldExpression.setSelectIfOrderedBy(this.selectIfOrderedBy());
        return fieldExpression;
    }

    public void setField(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        Expression expression3 = this.getBaseExpression().twistedForBaseAndContext(expression, expression2);
        return expression3.getField(this.getField());
    }

    public void validateNode() {
        Vector vector;
        DataExpression dataExpression = (DataExpression)this.getBaseExpression();
        if (this.getField().getTable().hasName() && (vector = dataExpression.getOwnedTables()) != null && !vector.contains(this.getField().getTable())) {
            throw QueryException.invalidTableForFieldInExpression(this.getField());
        }
    }

    public Object valueFromObject(Object object, AbstractSession abstractSession, AbstractRecord abstractRecord, int n, boolean bl) {
        if (!this.getBaseExpression().isExpressionBuilder()) {
            throw QueryException.cannotConformExpression();
        }
        DatabaseMapping databaseMapping = abstractSession.getDescriptor(object.getClass()).getObjectBuilder().getMappingForField(this.getField());
        if (databaseMapping == null) {
            throw QueryException.cannotConformExpression();
        }
        return databaseMapping.valueFromObject(object, this.getField(), abstractSession);
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.getField().toString());
    }

    public void writeFields(ExpressionSQLPrinter expressionSQLPrinter, Vector vector, SQLSelectStatement sQLSelectStatement) {
        DatabaseField databaseField = this.getField();
        if (databaseField != null) {
            vector.addElement(databaseField);
            this.writeField(expressionSQLPrinter, databaseField, sQLSelectStatement);
        }
    }

    protected void writeField(ExpressionSQLPrinter expressionSQLPrinter, DatabaseField databaseField, SQLSelectStatement sQLSelectStatement) {
        if (this.field == databaseField) {
            if (expressionSQLPrinter.isFirstElementPrinted()) {
                expressionSQLPrinter.printString(", ");
            } else {
                expressionSQLPrinter.setIsFirstElementPrinted(true);
            }
            this.printSQL(expressionSQLPrinter);
        } else {
            super.writeField(expressionSQLPrinter, databaseField, sQLSelectStatement);
        }
    }
}

