/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.ArithmeticFunctionNode;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class SizeNode
extends ArithmeticFunctionNode {
    public void validate(ParseTreeContext parseTreeContext) {
        if (this.left != null) {
            this.left.validate(parseTreeContext);
        }
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        this.setType(typeHelper.getIntType());
    }

    public Expression generateExpression(GenerationContext generationContext) {
        DotNode dotNode = (DotNode)this.getLeft();
        Node node = dotNode.getLeft();
        String string = ((AttributeNode)dotNode.getRight()).getAttributeName();
        if (!dotNode.endsWithCollectionField(generationContext)) {
            throw JPQLException.invalidSizeArgument(generationContext.getParseTreeContext().getQueryInfo(), this.getLine(), this.getColumn(), string);
        }
        Expression expression = node.generateExpression(generationContext);
        expression = expression.size(string);
        return expression;
    }
}

