/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.ForUpdateOfClause;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.NonSynchronizedSubVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinedAttributeManager
implements Cloneable,
Serializable {
    protected List<Expression> joinedAttributeExpressions;
    protected List<Expression> joinedMappingExpressions;
    protected List<String> joinedAttributes;
    protected boolean isToManyJoin = false;
    protected boolean hasOuterJoinedAttribute = true;
    protected transient Map<DatabaseMapping, Object> joinedMappingIndexes;
    protected transient Map<DatabaseMapping, ObjectLevelReadQuery> joinedMappingQueries;
    protected transient Map<DatabaseMapping, ObjectLevelReadQuery> joinedMappingQueryClones;
    protected transient List<AbstractRecord> dataResults;
    protected transient Map<CacheKey, List> dataResultsByPrimaryKey;
    protected transient ClassDescriptor descriptor;
    protected ExpressionBuilder baseExpressionBuilder;
    protected ObjectBuildingQuery baseQuery;
    protected int parentResultIndex;
    protected boolean shouldFilterDuplicates = true;

    public JoinedAttributeManager() {
    }

    public JoinedAttributeManager(ClassDescriptor classDescriptor, ExpressionBuilder expressionBuilder, ObjectBuildingQuery objectBuildingQuery) {
        this.descriptor = classDescriptor;
        this.baseQuery = objectBuildingQuery;
        this.baseExpressionBuilder = expressionBuilder;
        this.parentResultIndex = 0;
    }

    public boolean shouldFilterDuplicates() {
        return this.shouldFilterDuplicates;
    }

    public void setShouldFilterDuplicates(boolean bl) {
        this.shouldFilterDuplicates = bl;
    }

    public void addJoinedAttribute(String string) {
        this.getJoinedAttributes().add(string);
    }

    public void addJoinedAttributeExpression(Expression expression) {
        this.getJoinedAttributeExpressions().add(expression);
    }

    public void addJoinedMappingExpression(Expression expression) {
        this.getJoinedMappingExpressions().add(expression);
    }

    public void addJoinedMapping(String string) {
        this.addJoinedMappingExpression(this.baseExpressionBuilder.get(string));
    }

    public Object clone() {
        JoinedAttributeManager joinedAttributeManager = null;
        try {
            joinedAttributeManager = (JoinedAttributeManager)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        if (this.joinedAttributeExpressions != null) {
            joinedAttributeManager.joinedAttributeExpressions = new ArrayList<Expression>(this.joinedAttributeExpressions);
        }
        if (this.joinedMappingExpressions != null) {
            joinedAttributeManager.joinedMappingExpressions = new ArrayList<Expression>(this.joinedMappingExpressions);
        }
        if (this.joinedAttributes != null) {
            joinedAttributeManager.joinedAttributes = new ArrayList<String>(this.joinedAttributes);
        }
        if (this.joinedMappingIndexes != null) {
            joinedAttributeManager.joinedMappingIndexes = new HashMap<DatabaseMapping, Object>(this.joinedMappingIndexes);
        }
        if (this.joinedMappingQueries != null) {
            joinedAttributeManager.joinedMappingQueries = new HashMap<DatabaseMapping, ObjectLevelReadQuery>(this.joinedMappingQueries);
        }
        return joinedAttributeManager;
    }

    public void clear() {
        this.joinedAttributeExpressions = null;
        this.joinedMappingExpressions = null;
        this.joinedAttributes = null;
        this.joinedMappingIndexes = null;
        this.isToManyJoin = false;
        this.hasOuterJoinedAttribute = false;
        this.joinedMappingQueries = null;
        this.joinedMappingQueryClones = null;
    }

    public int computeJoiningMappingIndexes(boolean bl, AbstractSession abstractSession, int n) {
        if (!this.hasJoinedExpressions()) {
            return n;
        }
        this.setJoinedMappingIndexes_(new HashMap(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size()));
        int n2 = 0;
        if (this.getBaseQuery().hasPartialAttributeExpressions()) {
            n2 = this.getDescriptor().getPrimaryKeyFields().size();
            for (Expression expression : ((ObjectLevelReadQuery)this.getBaseQuery()).getPartialAttributeExpressions()) {
                if (!expression.isQueryKeyExpression() || this.getJoinedMappingExpressions().contains(expression) || this.getJoinedAttributeExpressions().contains(expression)) continue;
                n2 += ((QueryKeyExpression)expression).getFields().size();
            }
        } else {
            n2 = bl ? this.getDescriptor().getAllFields().size() : this.getDescriptor().getFields().size();
        }
        n2 += n;
        n2 = this.computeIndexesForJoinedExpressions(this.getJoinedAttributeExpressions(), n2, abstractSession);
        n2 = this.computeIndexesForJoinedExpressions(this.getJoinedMappingExpressions(), n2, abstractSession);
        return n2;
    }

    protected void computeNestedQueriesForJoinedExpressions(List list, AbstractSession abstractSession, ObjectLevelReadQuery objectLevelReadQuery) {
        for (int i = 0; i < list.size(); ++i) {
            ObjectExpression objectExpression = (ObjectExpression)list.get(i);
            objectExpression.getBuilder().setSession(abstractSession.getRootSession(null));
            if (objectExpression.getBuilder().getQueryClass() == null) {
                objectExpression.getBuilder().setQueryClass(this.descriptor.getJavaClass());
            }
            ObjectExpression objectExpression2 = objectExpression;
            while (!objectExpression2.getBaseExpression().isExpressionBuilder()) {
                objectExpression2 = (ObjectExpression)objectExpression2.getBaseExpression();
            }
            this.addJoinedAttribute(objectExpression2.getName());
            if (objectExpression.getBaseExpression() != objectExpression.getBuilder() || !objectExpression.getMapping().isForeignReferenceMapping()) continue;
            ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)objectExpression.getMapping();
            ObjectLevelReadQuery objectLevelReadQuery2 = foreignReferenceMapping.prepareNestedJoins(this, objectLevelReadQuery, abstractSession);
            if (objectLevelReadQuery2 != null) {
                this.getJoinedMappingQueries_().put(foreignReferenceMapping, objectLevelReadQuery2);
            }
            if (!foreignReferenceMapping.isCollectionMapping()) continue;
            ((CollectionMapping)foreignReferenceMapping).getContainerPolicy().addNestedJoinsQueriesForMapKey(this, objectLevelReadQuery, abstractSession);
        }
    }

    public void computeJoiningMappingQueries(AbstractSession abstractSession) {
        if (this.hasJoinedExpressions()) {
            this.joinedAttributes = new ArrayList<String>(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size());
            this.setJoinedMappingQueries_(new HashMap(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size()));
            this.computeNestedQueriesForJoinedExpressions(this.getJoinedAttributeExpressions(), abstractSession, (ObjectLevelReadQuery)this.baseQuery);
            this.computeNestedQueriesForJoinedExpressions(this.getJoinedMappingExpressions(), abstractSession, (ObjectLevelReadQuery)this.baseQuery);
        }
    }

    protected int computeIndexesForJoinedExpressions(List list, int n, AbstractSession abstractSession) {
        for (int i = 0; i < list.size(); ++i) {
            ObjectExpression objectExpression = (ObjectExpression)list.get(i);
            DatabaseMapping databaseMapping = objectExpression.getMapping();
            if (objectExpression.getBaseExpression() == objectExpression.getBuilder() && databaseMapping != null && databaseMapping.isForeignReferenceMapping()) {
                this.getJoinedMappingIndexes_().put(databaseMapping, new Integer(n));
            }
            ClassDescriptor classDescriptor = databaseMapping.getReferenceDescriptor();
            int n2 = 0;
            if (classDescriptor == null) {
                if (databaseMapping.isDirectCollectionMapping()) {
                    n2 = 1;
                } else if (databaseMapping.isDirectMapMapping()) {
                    n2 = 2;
                }
            } else {
                n2 = objectExpression.isQueryKeyExpression() && objectExpression.isUsingOuterJoinForMultitableInheritance() ? classDescriptor.getAllFields().size() : classDescriptor.getFields().size();
            }
            n += n2;
        }
        return n;
    }

    public ExpressionBuilder getBaseExpressionBuilder() {
        return this.baseExpressionBuilder;
    }

    public ObjectBuildingQuery getBaseQuery() {
        return this.baseQuery;
    }

    public List<AbstractRecord> getDataResults_() {
        return this.dataResults;
    }

    public ClassDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = this.baseQuery.getDescriptor();
        }
        return this.descriptor;
    }

    public List<String> getJoinedAttributes() {
        if (this.joinedAttributes == null) {
            this.joinedAttributes = new ArrayList<String>();
        }
        return this.joinedAttributes;
    }

    public List<Expression> getJoinedAttributeExpressions() {
        if (this.joinedAttributeExpressions == null) {
            this.joinedAttributeExpressions = new ArrayList<Expression>();
        }
        return this.joinedAttributeExpressions;
    }

    public List<Expression> getJoinedMappingExpressions() {
        if (this.joinedMappingExpressions == null) {
            this.joinedMappingExpressions = new ArrayList<Expression>();
        }
        return this.joinedMappingExpressions;
    }

    public boolean hasJoinedAttributeExpressions() {
        return this.joinedAttributeExpressions != null && !this.joinedAttributeExpressions.isEmpty();
    }

    public boolean hasJoinedExpressions() {
        return this.hasJoinedAttributeExpressions() || this.hasJoinedMappingExpressions();
    }

    public boolean hasJoinedMappingExpressions() {
        return this.joinedMappingExpressions != null && !this.joinedMappingExpressions.isEmpty();
    }

    public boolean hasJoinedAttributes() {
        return this.joinedAttributes != null && !this.joinedAttributes.isEmpty();
    }

    public boolean hasOuterJoinedAttributeQuery() {
        return this.hasOuterJoinedAttribute;
    }

    public boolean isToManyJoin() {
        return this.isToManyJoin;
    }

    public boolean isAttributeJoined(ClassDescriptor classDescriptor, String string) {
        if (classDescriptor.isAggregateDescriptor() && classDescriptor != this.getDescriptor()) {
            return false;
        }
        if (this.hasJoinedAttributes()) {
            return this.joinedAttributes.contains(string);
        }
        return this.isAttributeExpressionJoined(string) || this.isAttributeMappingJoined(string);
    }

    protected boolean isAttributeNameInJoinedExpressionList(String string, List list) {
        for (QueryKeyExpression queryKeyExpression : list) {
            while (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) {
                queryKeyExpression = (QueryKeyExpression)queryKeyExpression.getBaseExpression();
            }
            if (!queryKeyExpression.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAttributeExpressionJoined(String string) {
        return this.isAttributeNameInJoinedExpressionList(string, this.getJoinedAttributeExpressions());
    }

    protected boolean isAttributeMappingJoined(String string) {
        return this.isAttributeNameInJoinedExpressionList(string, this.getJoinedMappingExpressions());
    }

    public void setJoinedAttributeExpressions_(List list) {
        this.joinedAttributeExpressions = list;
    }

    public void setJoinedMappingExpressions_(List list) {
        this.joinedMappingExpressions = list;
    }

    public Map<DatabaseMapping, Object> getJoinedMappingIndexes_() {
        return this.joinedMappingIndexes;
    }

    public Map<DatabaseMapping, ObjectLevelReadQuery> getJoinedMappingQueries_() {
        return this.joinedMappingQueries;
    }

    public void setJoinedMappingQueries_(Map map) {
        this.joinedMappingQueries = map;
    }

    public void setJoinedMappingIndexes_(Map map) {
        this.joinedMappingIndexes = map;
    }

    protected void setIsOuterJoinedAttributeQuery(boolean bl) {
        this.hasOuterJoinedAttribute = bl;
    }

    public void setIsToManyJoinQuery(boolean bl) {
        this.isToManyJoin = bl;
    }

    public void prepareJoinExpressions(AbstractSession abstractSession) {
        Expression expression;
        int n;
        this.setIsOuterJoinedAttributeQuery(false);
        for (n = 0; n < this.getJoinedAttributeExpressions().size(); ++n) {
            expression = this.getJoinedAttributeExpressions().get(n);
            if (expression.isObjectExpression()) {
                ((ObjectExpression)expression).setShouldUseOuterJoinForMultitableInheritance(true);
            }
            this.prepareJoinExpression(expression, abstractSession);
        }
        for (n = 0; n < this.getJoinedMappingExpressions().size(); ++n) {
            expression = this.getJoinedMappingExpressions().get(n);
            if (expression.isObjectExpression()) {
                ((ObjectExpression)expression).setShouldUseOuterJoinForMultitableInheritance(true);
            }
            this.prepareJoinExpression(expression, abstractSession);
        }
    }

    protected void prepareJoinExpression(Expression expression, AbstractSession abstractSession) {
        if (!expression.isQueryKeyExpression()) {
            throw QueryException.mappingForExpressionDoesNotSupportJoining(expression);
        }
        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)expression;
        queryKeyExpression.getBuilder().setSession(abstractSession.getRootSession(null));
        if (queryKeyExpression.getBuilder().getQueryClass() == null) {
            queryKeyExpression.getBuilder().setQueryClass(this.descriptor.getJavaClass());
        }
        if (queryKeyExpression.getMapping() == null || !queryKeyExpression.getMapping().isJoiningSupported()) {
            throw QueryException.mappingForExpressionDoesNotSupportJoining(queryKeyExpression);
        }
        ObjectExpression objectExpression = queryKeyExpression;
        while (!objectExpression.isExpressionBuilder()) {
            if (objectExpression.shouldQueryToManyRelationship()) {
                this.setIsToManyJoinQuery(true);
            }
            if (objectExpression.shouldUseOuterJoin()) {
                this.setIsOuterJoinedAttributeQuery(true);
            }
            objectExpression = (ObjectExpression)objectExpression.getBaseExpression();
        }
    }

    public void processJoinedMappings() {
        block4: {
            ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
            if (!objectBuilder.hasJoinedAttributes()) break block4;
            List<DatabaseMapping> list = objectBuilder.getJoinedAttributes();
            if (!this.hasJoinedAttributeExpressions()) {
                for (int i = 0; i < list.size(); ++i) {
                    this.addJoinedMapping((ForeignReferenceMapping)list.get(i));
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)list.get(i);
                    if (this.isAttributeExpressionJoined(foreignReferenceMapping.getAttributeName())) continue;
                    this.addJoinedMapping(foreignReferenceMapping);
                }
            }
        }
    }

    public void addJoinedMapping(ForeignReferenceMapping foreignReferenceMapping) {
        if (foreignReferenceMapping.isCollectionMapping()) {
            if (foreignReferenceMapping.isInnerJoinFetched()) {
                this.addJoinedMappingExpression(this.getBaseExpressionBuilder().anyOf(foreignReferenceMapping.getAttributeName()));
            } else if (foreignReferenceMapping.isOuterJoinFetched()) {
                this.addJoinedMappingExpression(this.getBaseExpressionBuilder().anyOfAllowingNone(foreignReferenceMapping.getAttributeName()));
            }
        } else if (foreignReferenceMapping.isInnerJoinFetched()) {
            this.addJoinedMappingExpression(this.getBaseExpressionBuilder().get(foreignReferenceMapping.getAttributeName()));
        } else if (foreignReferenceMapping.isOuterJoinFetched()) {
            this.addJoinedMappingExpression(this.getBaseExpressionBuilder().getAllowingNull(foreignReferenceMapping.getAttributeName()));
        }
    }

    public void reset() {
        this.joinedMappingExpressions = null;
        this.joinedAttributes = null;
        this.isToManyJoin = false;
        this.hasOuterJoinedAttribute = true;
        this.joinedMappingIndexes = null;
        this.joinedMappingQueries = null;
        this.dataResults = null;
    }

    public void setBaseQuery(ObjectLevelReadQuery objectLevelReadQuery) {
        this.baseQuery = objectLevelReadQuery;
    }

    protected void setBaseExpressionBuilder(ExpressionBuilder expressionBuilder) {
        this.baseExpressionBuilder = expressionBuilder;
    }

    public Map<CacheKey, List> getDataResultsByPrimaryKey() {
        return this.dataResultsByPrimaryKey;
    }

    protected void setDataResultsByPrimaryKey(Map<CacheKey, List> map) {
        this.dataResultsByPrimaryKey = map;
    }

    public void setDataResults(List list, AbstractSession abstractSession) {
        this.dataResults = list;
        this.processDataResults(abstractSession);
    }

    protected void processDataResults(AbstractSession abstractSession) {
        this.dataResultsByPrimaryKey = new HashMap<CacheKey, List>();
        int n = this.dataResults.size();
        CacheKey cacheKey = null;
        ArrayList<AbstractRecord> arrayList = null;
        ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
        int n2 = this.getParentResultIndex();
        for (int i = 0; i < n; ++i) {
            Cloneable cloneable;
            Vector vector;
            AbstractRecord abstractRecord;
            AbstractRecord abstractRecord2 = abstractRecord = this.dataResults.get(i);
            if (n2 > 0) {
                vector = new NonSynchronizedSubVector(abstractRecord.getFields(), n2, abstractRecord.size());
                cloneable = new NonSynchronizedSubVector(abstractRecord.getValues(), n2, abstractRecord.size());
                abstractRecord2 = new DatabaseRecord(vector, (Vector)cloneable);
            }
            if ((vector = objectBuilder.extractPrimaryKeyFromRow(abstractRecord2, abstractSession)) == null) continue;
            cloneable = new CacheKey(vector);
            if (cacheKey != null && cacheKey.equals((CacheKey)cloneable)) {
                arrayList.add(abstractRecord);
                if (!this.shouldFilterDuplicates()) continue;
                this.dataResults.set(i, null);
                continue;
            }
            arrayList = this.dataResultsByPrimaryKey.get(cloneable);
            if (arrayList == null) {
                arrayList = new ArrayList<AbstractRecord>();
                this.dataResultsByPrimaryKey.put((CacheKey)cloneable, arrayList);
            } else if (this.shouldFilterDuplicates()) {
                this.dataResults.set(i, null);
            }
            arrayList.add(abstractRecord);
            cacheKey = cloneable;
        }
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public ForUpdateOfClause setupLockingClauseForJoinedExpressions(ForUpdateOfClause forUpdateOfClause, AbstractSession abstractSession) {
        if (this.hasJoinedAttributeExpressions()) {
            return this.setupLockingClauseForJoinedExpressions(this.getJoinedAttributeExpressions(), abstractSession, forUpdateOfClause);
        }
        if (this.hasJoinedMappingExpressions()) {
            return this.setupLockingClauseForJoinedExpressions(this.getJoinedMappingExpressions(), abstractSession, forUpdateOfClause);
        }
        return forUpdateOfClause;
    }

    private ForUpdateOfClause setupLockingClauseForJoinedExpressions(List list, AbstractSession abstractSession, ForUpdateOfClause forUpdateOfClause) {
        for (Expression expression : list) {
            ClassDescriptor classDescriptor;
            if (!expression.isObjectExpression()) continue;
            ObjectExpression objectExpression = (ObjectExpression)expression;
            objectExpression.getBuilder().setSession(abstractSession.getRootSession(null));
            if (objectExpression.getBuilder().getQueryClass() == null) {
                objectExpression.getBuilder().setQueryClass(this.descriptor.getJavaClass());
            }
            if ((classDescriptor = objectExpression.getDescriptor()) == null) {
                return forUpdateOfClause;
            }
            if (!classDescriptor.hasPessimisticLockingPolicy()) continue;
            if (forUpdateOfClause == null) {
                forUpdateOfClause = new ForUpdateOfClause();
                forUpdateOfClause.setLockMode(classDescriptor.getCMPPolicy().getPessimisticLockingPolicy().getLockingMode());
            }
            forUpdateOfClause.addLockedExpression(objectExpression);
        }
        return forUpdateOfClause;
    }

    public void setParentResultIndex(int n) {
        this.parentResultIndex = n;
    }

    public int getParentResultIndex() {
        return this.parentResultIndex;
    }

    public Map<DatabaseMapping, ObjectLevelReadQuery> getJoinedMappingQueryClones() {
        return this.joinedMappingQueryClones;
    }

    public void setJoinedMappingQueryClones(Map map) {
        this.joinedMappingQueryClones = map;
    }
}

