/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.expressions.SQLModifyStatement;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyMapping
extends CollectionMapping
implements RelationalMapping,
MapComponentMapping {
    protected static final String PostInsert = "postInsert";
    protected static final String ObjectRemoved = "objectRemoved";
    protected static final String ObjectAdded = "objectAdded";
    protected transient Vector<DatabaseField> targetForeignKeyFields;
    protected transient Vector<DatabaseField> sourceKeyFields;
    protected transient Map<DatabaseField, DatabaseField> targetForeignKeysToSourceKeys = new HashMap<DatabaseField, DatabaseField>(2);
    protected transient Map<DatabaseField, DatabaseField> sourceKeysToTargetForeignKeys = new HashMap<DatabaseField, DatabaseField>(2);
    protected transient DataModifyQuery addTargetQuery;
    protected transient boolean hasCustomAddTargetQuery;
    protected transient DataModifyQuery removeTargetQuery;
    protected transient boolean hasCustomRemoveTargetQuery;
    protected transient DataModifyQuery removeAllTargetsQuery;
    protected transient boolean hasCustomRemoveAllTargetsQuery;

    public OneToManyMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetForeignKeyFields = NonSynchronizedVector.newInstance(1);
        this.deleteAllQuery = new DeleteAllQuery();
        this.addTargetQuery = new DataModifyQuery();
        this.removeTargetQuery = new DataModifyQuery();
        this.removeAllTargetsQuery = new DataModifyQuery();
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public void addTargetForeignKeyField(DatabaseField databaseField, DatabaseField databaseField2) {
        this.getTargetForeignKeyFields().addElement(databaseField);
        this.getSourceKeyFields().addElement(databaseField2);
    }

    public void addTargetForeignKeyFieldName(String string, String string2) {
        this.addTargetForeignKeyField(new DatabaseField(string), new DatabaseField(string2));
    }

    protected Expression buildDefaultSelectionCriteriaAndAddFieldsToQuery() {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        for (DatabaseField databaseField : this.getTargetForeignKeysToSourceKeys().keySet()) {
            DatabaseField databaseField2 = this.getTargetForeignKeysToSourceKeys().get(databaseField);
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField2));
            expression = expression2.and(expression);
        }
        this.getContainerPolicy().addAdditionalFieldsToQuery(this.getSelectionQuery(), expressionBuilder);
        return expression;
    }

    public Expression buildSelectionCriteria() {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        Enumeration<DatabaseField> enumeration2 = this.getTargetForeignKeyFields().elements();
        while (enumeration2.hasMoreElements()) {
            DatabaseField databaseField = enumeration2.nextElement();
            DatabaseField databaseField2 = enumeration.nextElement();
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField2));
            expression = expression2.and(expression);
        }
        return expression;
    }

    @Override
    public Object clone() {
        OneToManyMapping oneToManyMapping = (OneToManyMapping)super.clone();
        oneToManyMapping.setTargetForeignKeysToSourceKeys(new HashMap<DatabaseField, DatabaseField>(this.getTargetForeignKeysToSourceKeys()));
        return oneToManyMapping;
    }

    @Override
    public Object createMapComponentFromRow(AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        return abstractSession.executeQuery((DatabaseQuery)this.getSelectionQuery(), abstractRecord);
    }

    protected void deleteAll(DeleteObjectQuery deleteObjectQuery) throws DatabaseException {
        Object object = this.getAttributeAccessor().getAttributeValueFromObject(deleteObjectQuery.getObject());
        if (this.usesIndirection() && (object == null || !this.getIndirectionPolicy().objectIsInstantiated(object))) {
            ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(deleteObjectQuery.getSession().getSessionForClass(this.getReferenceClass()), deleteObjectQuery.getTranslationRow(), new Vector(0));
            return;
        }
        Object object2 = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(deleteObjectQuery.getSession().getSessionForClass(this.getReferenceClass()), deleteObjectQuery.getTranslationRow(), this.getContainerPolicy().vectorFor(object2, deleteObjectQuery.getSession()));
    }

    protected void deleteReferenceObjectsLeftOnDatabase(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object = this.readPrivateOwnedForObject(deleteObjectQuery);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            deleteObjectQuery.getSession().deleteObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
        }
    }

    protected Hashtable executeBatchQuery(DatabaseQuery databaseQuery, AbstractSession abstractSession, AbstractRecord abstractRecord) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        ContainerPolicy containerPolicy2 = ((ReadAllQuery)databaseQuery).getContainerPolicy();
        Object object = null;
        object = abstractSession.executeQuery(databaseQuery, abstractRecord);
        Hashtable hashtable = new Hashtable(containerPolicy2.sizeFor(object));
        Object object2 = containerPolicy2.iteratorFor(object);
        while (containerPolicy2.hasNext(object2)) {
            Object object3 = containerPolicy2.next(object2, abstractSession);
            CacheKey cacheKey = new CacheKey(this.extractForeignKeyFromReferenceObject(object3, abstractSession));
            Object object4 = hashtable.get(cacheKey);
            if (object4 == null) {
                object4 = containerPolicy.containerInstance();
                hashtable.put(cacheKey, object4);
            }
            containerPolicy.addInto(object3, object4, abstractSession);
        }
        return hashtable;
    }

    protected Vector extractForeignKeyFromReferenceObject(Object object, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>(this.getTargetForeignKeysToSourceKeys().size());
        for (Map.Entry<DatabaseField, DatabaseField> entry : this.getTargetForeignKeysToSourceKeys().entrySet()) {
            DatabaseField databaseField = entry.getKey();
            DatabaseField databaseField2 = entry.getValue();
            if (object == null) {
                vector.addElement(null);
                continue;
            }
            Object object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, abstractSession);
            try {
                object2 = abstractSession.getDatasourcePlatform().convertObject(object2, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField2));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object2);
        }
        return vector;
    }

    protected Vector extractKeyFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>(this.getTargetForeignKeysToSourceKeys().size());
        for (DatabaseField databaseField : this.getTargetForeignKeysToSourceKeys().values()) {
            Object object = abstractRecord.get(databaseField);
            try {
                object = abstractSession.getDatasourcePlatform().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord, AbstractSession abstractSession, AbstractRecord abstractRecord2) {
        Hashtable hashtable = null;
        DatabaseQuery databaseQuery2 = databaseQuery;
        synchronized (databaseQuery2) {
            hashtable = this.getBatchReadObjects(databaseQuery, abstractSession);
            if (hashtable == null) {
                hashtable = this.executeBatchQuery(databaseQuery, abstractSession, abstractRecord2);
                this.setBatchReadObjects(hashtable, databaseQuery, abstractSession);
            }
        }
        databaseQuery2 = hashtable.get(new CacheKey(this.extractKeyFromRow(abstractRecord, abstractSession)));
        if (databaseQuery2 == null) {
            return this.getContainerPolicy().containerInstance();
        }
        return databaseQuery2;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getSourceKeysToTargetForeignKeys() {
        return this.sourceKeysToTargetForeignKeys;
    }

    public Vector getTargetForeignKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getTargetForeignKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getTargetForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    public Vector<DatabaseField> getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getTargetForeignKeysToSourceKeys() {
        return this.targetForeignKeysToSourceKeys;
    }

    public Map getTargetForeignKeyToSourceKeys() {
        return this.getTargetForeignKeysToSourceKeys();
    }

    @Override
    public boolean hasInverseConstraintDependency() {
        return true;
    }

    @Override
    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        if (!this.isSourceKeySpecified()) {
            this.setSourceKeyFields(NonSynchronizedVector.newInstance(this.getDescriptor().getPrimaryKeyFields()));
        }
        this.initializeTargetForeignKeysToSourceKeys();
        this.getContainerPolicy().initialize(abstractSession, this.getReferenceDescriptor().getDefaultTable());
        if (this.shouldInitializeSelectionCriteria()) {
            this.setSelectionCriteria(this.buildDefaultSelectionCriteriaAndAddFieldsToQuery());
        }
        this.initializeDeleteAllQuery();
        this.initializeAddTargetQuery(abstractSession);
        this.initializeRemoveTargetQuery(abstractSession);
        this.initializeRemoveAllTargetsQuery(abstractSession);
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().hasTablePerClassPolicy()) {
            this.getReferenceDescriptor().getTablePerClassPolicy().prepareChildrenSelectionQuery(this, abstractSession);
        }
    }

    protected void initializeAddTargetQuery(AbstractSession abstractSession) {
        Cloneable cloneable;
        if (!this.addTargetQuery.hasSessionName()) {
            this.addTargetQuery.setSessionName(abstractSession.getName());
        }
        if (this.hasCustomAddTargetQuery) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            cloneable = list.get(i);
            Expression expression2 = ((Expression)expressionBuilder).getField((DatabaseField)cloneable).equal(expressionBuilder.getParameter((DatabaseField)cloneable));
            expression = expression2.and(expression);
        }
        DatabaseRecord databaseRecord = new DatabaseRecord();
        this.containerPolicy.addFieldsForMapKey(databaseRecord);
        cloneable = new SQLUpdateStatement();
        ((SQLModifyStatement)cloneable).setTable(this.getReferenceDescriptor().getDefaultTable());
        ((SQLStatement)cloneable).setWhereClause(expression);
        ((SQLModifyStatement)cloneable).setModifyRow(databaseRecord);
        this.addTargetQuery.setSQLStatement((SQLStatement)cloneable);
    }

    protected void initializeDeleteAllQuery() {
        ((DeleteAllQuery)this.getDeleteAllQuery()).setReferenceClass(this.getReferenceClass());
        if (!this.hasCustomDeleteAllQuery()) {
            if (this.getSelectionCriteria() == null) {
                this.getDeleteAllQuery().setSelectionCriteria(this.buildDefaultSelectionCriteriaAndAddFieldsToQuery());
            } else {
                this.getDeleteAllQuery().setSelectionCriteria(this.getSelectionCriteria());
            }
        }
    }

    protected void initializeRemoveTargetQuery(AbstractSession abstractSession) {
        Cloneable cloneable;
        if (!this.removeTargetQuery.hasSessionName()) {
            this.removeTargetQuery.setSessionName(abstractSession.getName());
        }
        if (this.hasCustomRemoveTargetQuery) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = list.get(i);
            cloneable = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField));
            expression = cloneable.and(expression);
        }
        DatabaseRecord databaseRecord = new DatabaseRecord();
        n = this.targetForeignKeyFields.size();
        for (int i = 0; i < n; ++i) {
            cloneable = this.targetForeignKeyFields.get(i);
            databaseRecord.put((DatabaseField)cloneable, (Object)null);
            Expression expression2 = ((Expression)expressionBuilder).getField((DatabaseField)cloneable).equal(expressionBuilder.getParameter((DatabaseField)cloneable));
            expression = expression2.and(expression);
        }
        SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
        sQLUpdateStatement.setTable(this.getReferenceDescriptor().getDefaultTable());
        sQLUpdateStatement.setWhereClause(expression);
        sQLUpdateStatement.setModifyRow(databaseRecord);
        this.removeTargetQuery.setSQLStatement(sQLUpdateStatement);
    }

    protected void initializeRemoveAllTargetsQuery(AbstractSession abstractSession) {
        if (!this.removeAllTargetsQuery.hasSessionName()) {
            this.removeAllTargetsQuery.setSessionName(abstractSession.getName());
        }
        if (this.hasCustomRemoveAllTargetsQuery) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        DatabaseRecord databaseRecord = new DatabaseRecord();
        int n = this.targetForeignKeyFields.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = this.targetForeignKeyFields.get(i);
            databaseRecord.put(databaseField, (Object)null);
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField));
            expression = expression2.and(expression);
        }
        SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
        sQLUpdateStatement.setTable(this.getReferenceDescriptor().getDefaultTable());
        sQLUpdateStatement.setWhereClause(expression);
        sQLUpdateStatement.setModifyRow(databaseRecord);
        this.removeAllTargetsQuery.setSQLStatement(sQLUpdateStatement);
    }

    protected void initializeTargetForeignKeysToSourceKeys() throws DescriptorException {
        Object object;
        int n;
        if (this.getTargetForeignKeyFields().isEmpty()) {
            if (this.shouldInitializeSelectionCriteria()) {
                throw DescriptorException.noTargetForeignKeysSpecified(this);
            }
            return;
        }
        if (this.getTargetForeignKeyFields().size() != this.getSourceKeyFields().size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (n = 0; n < this.getTargetForeignKeyFields().size(); ++n) {
            object = this.getReferenceDescriptor().buildField(this.getTargetForeignKeyFields().get(n));
            this.getTargetForeignKeyFields().set(n, (DatabaseField)object);
        }
        for (n = 0; n < this.getSourceKeyFields().size(); ++n) {
            object = this.getDescriptor().buildField(this.getSourceKeyFields().get(n));
            this.getSourceKeyFields().set(n, (DatabaseField)object);
        }
        Iterator<DatabaseField> iterator = this.getTargetForeignKeyFields().iterator();
        object = this.getSourceKeyFields().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = iterator.next();
            DatabaseField databaseField2 = (DatabaseField)object.next();
            this.getTargetForeignKeysToSourceKeys().put(databaseField, databaseField2);
            this.getSourceKeysToTargetForeignKeys().put(databaseField2, databaseField);
        }
    }

    @Override
    public boolean isOneToManyMapping() {
        return true;
    }

    protected boolean isSourceKeySpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    @Override
    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object, ObjectChangeSet objectChangeSet, Map map) throws DatabaseException, OptimisticLockException {
        super.objectAddedDuringUpdate(objectLevelModifyQuery, object, objectChangeSet, map);
        if (this.requiresDataModificationEvents() || this.containerPolicy.requiresDataModificationEvents()) {
            if (objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
                Object[] objectArray = new Object[]{ObjectAdded, objectLevelModifyQuery, object};
                objectLevelModifyQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
            } else {
                this.updateTargetForeignKeyPostUpdateSource_ObjectAdded(objectLevelModifyQuery, object);
            }
        }
    }

    @Override
    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object, Map map) throws DatabaseException, OptimisticLockException {
        if (!this.isPrivateOwned() && (this.requiresDataModificationEvents() || this.containerPolicy.requiresDataModificationEvents())) {
            if (objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
                Object[] objectArray = new Object[]{ObjectRemoved, objectLevelModifyQuery, object};
                objectLevelModifyQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
            } else {
                this.updateTargetForeignKeyPostUpdateSource_ObjectRemoved(objectLevelModifyQuery, object);
            }
        }
        super.objectRemovedDuringUpdate(objectLevelModifyQuery, object, map);
    }

    @Override
    public void performDataModificationEvent(Object[] objectArray, AbstractSession abstractSession) throws DatabaseException, DescriptorException {
        if (objectArray[0] == PostInsert) {
            this.updateTargetRowPostInsertSource((WriteObjectQuery)objectArray[1]);
        } else if (objectArray[0] == ObjectRemoved) {
            this.updateTargetForeignKeyPostUpdateSource_ObjectRemoved((WriteObjectQuery)objectArray[1], objectArray[2]);
        } else if (objectArray[0] == ObjectAdded) {
            this.updateTargetForeignKeyPostUpdateSource_ObjectAdded((WriteObjectQuery)objectArray[1], objectArray[2]);
        } else {
            throw DescriptorException.invalidDataModificationEventCode(objectArray[0], this);
        }
    }

    @Override
    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        Object[] objectArray;
        if (this.isReadOnly()) {
            return;
        }
        if (this.shouldObjectModifyCascadeToParts(writeObjectQuery) && !writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            objectArray = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object = containerPolicy.iteratorFor(objectArray);
            while (containerPolicy.hasNext(object)) {
                WriteObjectQuery writeObjectQuery2;
                Object object2 = containerPolicy.nextEntry(object, writeObjectQuery.getSession());
                Object object3 = containerPolicy.unwrapIteratorResult(object2);
                if (this.isPrivateOwned()) {
                    writeObjectQuery2 = new InsertObjectQuery();
                    writeObjectQuery2.setIsExecutionClone(true);
                    writeObjectQuery2.setObject(object3);
                    writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
                    writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
                    continue;
                }
                if (writeObjectQuery.getSession().getCommitManager().isCommitInPreModify(object3)) continue;
                writeObjectQuery2 = new WriteObjectQuery();
                writeObjectQuery2.setIsExecutionClone(true);
                writeObjectQuery2.setObject(object3);
                writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
                writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
            }
        }
        if (this.requiresDataModificationEvents() || this.getContainerPolicy().requiresDataModificationEvents()) {
            if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
                if (!this.isReadOnly() && (this.requiresDataModificationEvents() || this.containerPolicy.shouldUpdateForeignKeysPostInsert())) {
                    objectArray = new Object[]{PostInsert, writeObjectQuery};
                    writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
                }
            } else if (!this.isReadOnly() && (this.requiresDataModificationEvents() || this.containerPolicy.shouldUpdateForeignKeysPostInsert())) {
                this.updateTargetRowPostInsertSource(writeObjectQuery);
            }
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        if (!this.requiresDataModificationEvents() && !this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    @Override
    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Object object2 = containerPolicy.iteratorFor(object);
            while (containerPolicy.hasNext(object2)) {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                deleteObjectQuery2.setObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
            if (!deleteObjectQuery.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(deleteObjectQuery);
            }
        } else {
            this.deleteAll(deleteObjectQuery);
        }
    }

    @Override
    public void prepareCascadeLockingPolicy() {
        CascadeLockingPolicy cascadeLockingPolicy = new CascadeLockingPolicy(this.getDescriptor(), this.getReferenceDescriptor());
        cascadeLockingPolicy.setQueryKeyFields(this.getSourceKeysToTargetForeignKeys());
        this.getReferenceDescriptor().addCascadeLockingPolicy(cascadeLockingPolicy);
    }

    public boolean requiresDataModificationEvents() {
        return false;
    }

    public void setCustomAddTargetQuery(DataModifyQuery dataModifyQuery) {
        this.addTargetQuery = dataModifyQuery;
        this.hasCustomAddTargetQuery = true;
    }

    public void setAddTargetSQLString(String string) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setSQLString(string);
        this.setCustomAddTargetQuery(dataModifyQuery);
    }

    public void setCustomRemoveTargetQuery(DataModifyQuery dataModifyQuery) {
        this.removeTargetQuery = dataModifyQuery;
        this.hasCustomRemoveTargetQuery = true;
    }

    public void setCustomRemoveAllTargetsQuery(DataModifyQuery dataModifyQuery) {
        this.removeAllTargetsQuery = dataModifyQuery;
        this.hasCustomRemoveAllTargetsQuery = true;
    }

    @Override
    public void setDeleteAllSQLString(String string) {
        DeleteAllQuery deleteAllQuery = new DeleteAllQuery();
        deleteAllQuery.setSQLString(string);
        this.setCustomDeleteAllQuery(deleteAllQuery);
    }

    @Override
    public void setSessionName(String string) {
        super.setSessionName(string);
        this.addTargetQuery.setSessionName(string);
        this.removeTargetQuery.setSessionName(string);
        this.removeAllTargetsQuery.setSessionName(string);
    }

    public void setSourceKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setSourceKeyFields(nonSynchronizedVector);
    }

    public void setSourceKeyFields(Vector<DatabaseField> vector) {
        this.sourceKeyFields = vector;
    }

    public void setTargetForeignKeyFieldName(String string) {
        this.getTargetForeignKeyFields().addElement(new DatabaseField(string));
    }

    public void setTargetForeignKeyFieldNames(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addTargetForeignKeyFieldName(stringArray[i], stringArray2[i]);
        }
    }

    public void setTargetForeignKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setTargetForeignKeyFields(nonSynchronizedVector);
    }

    public void setTargetForeignKeyFields(Vector<DatabaseField> vector) {
        this.targetForeignKeyFields = vector;
    }

    protected void setTargetForeignKeysToSourceKeys(Map<DatabaseField, DatabaseField> map) {
        this.targetForeignKeysToSourceKeys = map;
    }

    @Override
    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery objectLevelModifyQuery) {
        if (this.isReadOnly()) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        if (this.containerPolicy.isMappedKeyMapPolicy()) {
            return true;
        }
        return objectLevelModifyQuery.shouldCascadeAllParts();
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    public void updateTargetRowPostInsertSource(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        Object object;
        if (this.isReadOnly()) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.isEmpty(object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession()))) {
            return;
        }
        this.prepareTranslationRow(writeObjectQuery.getTranslationRow(), writeObjectQuery.getObject(), writeObjectQuery.getSession());
        AbstractRecord abstractRecord = this.buildKeyRowForTargetUpdate(writeObjectQuery);
        List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
        int n = list.size();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            DatabaseRecord databaseRecord = new DatabaseRecord();
            databaseRecord.mergeFrom(abstractRecord);
            Object object3 = containerPolicy.nextEntry(object2, writeObjectQuery.getSession());
            Object object4 = containerPolicy.unwrapIteratorResult(object3);
            for (int i = 0; i < n; ++i) {
                DatabaseField databaseField = list.get(i);
                Object object5 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object4, databaseField, writeObjectQuery.getSession());
                databaseRecord.put(databaseField, object5);
            }
            ContainerPolicy.copyMapDataToRow(containerPolicy.getKeyMappingDataForWriteQuery(object3, writeObjectQuery.getSession()), databaseRecord);
            writeObjectQuery.getSession().executeQuery((DatabaseQuery)this.addTargetQuery, databaseRecord);
        }
    }

    protected AbstractRecord buildKeyRowForTargetUpdate(ObjectLevelModifyQuery objectLevelModifyQuery) {
        return new DatabaseRecord();
    }

    public void updateTargetForeignKeyPostUpdateSource_ObjectAdded(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        this.prepareTranslationRow(objectLevelModifyQuery.getTranslationRow(), objectLevelModifyQuery.getObject(), objectLevelModifyQuery.getSession());
        AbstractRecord abstractRecord = this.buildKeyRowForTargetUpdate(objectLevelModifyQuery);
        List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = list.get(i);
            Object object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(containerPolicy.unwrapIteratorResult(object), databaseField, objectLevelModifyQuery.getSession());
            abstractRecord.put(databaseField, object2);
        }
        ContainerPolicy.copyMapDataToRow(containerPolicy.getKeyMappingDataForWriteQuery(object, objectLevelModifyQuery.getSession()), abstractRecord);
        objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)this.addTargetQuery, abstractRecord);
    }

    public void updateTargetForeignKeyPostUpdateSource_ObjectRemoved(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) throws DatabaseException {
        Object object2;
        Object object3;
        if (this.isReadOnly) {
            return;
        }
        AbstractSession abstractSession = objectLevelModifyQuery.getSession();
        this.prepareTranslationRow(objectLevelModifyQuery.getTranslationRow(), objectLevelModifyQuery.getObject(), abstractSession);
        DatabaseRecord databaseRecord = new DatabaseRecord();
        int n = this.sourceKeyFields.size();
        DatabaseRecord databaseRecord2 = new DatabaseRecord(n);
        for (int i = 0; i < n; ++i) {
            object3 = this.sourceKeyFields.get(i);
            DatabaseField databaseField = this.targetForeignKeyFields.get(i);
            object2 = objectLevelModifyQuery.getTranslationRow().get((DatabaseField)object3);
            databaseRecord.add(databaseField, object2);
            databaseRecord2.add(databaseField, null);
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        object3 = this.getReferenceDescriptor().getPrimaryKeyFields();
        n = object3.size();
        for (int i = 0; i < n; ++i) {
            object2 = (DatabaseField)object3.get(i);
            Object object4 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(containerPolicy.unwrapIteratorResult(object), (DatabaseField)object2, abstractSession);
            databaseRecord.add((DatabaseField)object2, object4);
        }
        DataModifyQuery dataModifyQuery = (DataModifyQuery)this.removeTargetQuery.clone();
        dataModifyQuery.setModifyRow(databaseRecord2);
        dataModifyQuery.setHasModifyRow(true);
        dataModifyQuery.setIsExecutionClone(true);
        abstractSession.executeQuery((DatabaseQuery)dataModifyQuery, databaseRecord);
    }

    public void updateTargetRowPreDeleteSource(ObjectLevelModifyQuery objectLevelModifyQuery) throws DatabaseException {
        if (this.isReadOnly) {
            return;
        }
        int n = this.sourceKeyFields.size();
        DatabaseRecord databaseRecord = new DatabaseRecord(n);
        DatabaseRecord databaseRecord2 = new DatabaseRecord(n);
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = this.sourceKeyFields.get(i);
            DatabaseField databaseField2 = this.targetForeignKeyFields.get(i);
            Object object = objectLevelModifyQuery.getTranslationRow().get(databaseField);
            databaseRecord.add(databaseField2, object);
            databaseRecord2.add(databaseField2, null);
        }
        DataModifyQuery dataModifyQuery = (DataModifyQuery)this.removeAllTargetsQuery.clone();
        dataModifyQuery.setModifyRow(databaseRecord2);
        dataModifyQuery.setHasModifyRow(true);
        dataModifyQuery.setIsExecutionClone(true);
        objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)dataModifyQuery, databaseRecord);
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession abstractSession) throws DatabaseException {
        if (this.isPrivateOwned()) {
            Object object2 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object3 = containerPolicy.iteratorFor(object2);
            while (containerPolicy.hasNext(object3)) {
                if (abstractSession.verifyDelete(containerPolicy.next(object3, abstractSession))) continue;
                return false;
            }
        }
        return true;
    }
}

