/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.LockModeType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.ForUpdateOfClause;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.history.UniversalAsOfClause;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.QueryByExampleMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.InMemoryQueryIndirectionPolicy;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectLevelReadQuery
extends ObjectBuildingQuery {
    public static final String NONE = "NONE";
    public static final String PESSIMISTIC = "PESSIMISTIC";
    public static final String PESSIMISTIC_FORCE_INCREMENT = "PESSIMISTIC_FORCE_INCREMENT";
    public static final String READ = "READ";
    public static final String WRITE = "WRITE";
    public static final String OPTIMISTIC = "OPTIMISTIC";
    public static final String OPTIMISTIC_FORCE_INCREMENT = "OPTIMISTIC_FORCE_INCREMENT";
    protected ExpressionBuilder defaultBuilder;
    protected int cacheUsage;
    public static final int UseDescriptorSetting = -1;
    public static final int DoNotCheckCache = 0;
    public static final int CheckCacheByExactPrimaryKey = 1;
    public static final int CheckCacheByPrimaryKey = 2;
    public static final int CheckCacheThenDatabase = 3;
    public static final int CheckCacheOnly = 4;
    public static final int ConformResultsInUnitOfWork = 5;
    protected Vector additionalFields;
    protected boolean shouldIncludeData;
    protected boolean isPrePrepared;
    protected short distinctState;
    public static final short UNCOMPUTED_DISTINCT = 0;
    public static final short USE_DISTINCT = 1;
    public static final short DONT_USE_DISTINCT = 2;
    protected int inMemoryQueryIndirectionPolicy;
    protected long executionTime = 0L;
    protected FetchGroup fetchGroup;
    protected String fetchGroupName;
    protected boolean shouldUseDefaultFetchGroup = true;
    protected Vector nonFetchJoinAttributeExpressions;
    protected Vector partialAttributeExpressions;
    protected JoinedAttributeManager joinedAttributeManager;
    protected Boolean isReferenceClassLocked;
    protected boolean isResultSetOptimizedQuery = false;
    protected boolean isReadOnly = false;
    protected Boolean shouldOuterJoinSubclasses;
    protected Map<Class, DatabaseCall> concreteSubclassCalls;
    protected String lockModeType;
    protected Integer waitTimeout;

    public ObjectLevelReadQuery() {
        this.shouldRefreshIdentityMapResult = false;
        this.distinctState = 0;
        this.cacheUsage = -1;
        this.shouldIncludeData = false;
        this.inMemoryQueryIndirectionPolicy = 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        if (!this.isExpressionQuery() || !this.isDefaultPropertiesQuery()) {
            return super.equals(object);
        }
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)object;
        if (!this.getExpressionBuilder().equals(objectLevelReadQuery.getExpressionBuilder())) {
            return false;
        }
        if (this.hasJoining()) {
            if (!objectLevelReadQuery.hasJoining()) {
                return false;
            }
            List<Expression> list = this.getJoinedAttributeManager().getJoinedAttributeExpressions();
            List<Expression> list2 = objectLevelReadQuery.getJoinedAttributeManager().getJoinedAttributeExpressions();
            int n = list.size();
            if (n != list2.size()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (((Object)list.get(i)).equals(list2.get(i))) continue;
                return false;
            }
        } else if (objectLevelReadQuery.hasJoining()) {
            return false;
        }
        return (this.getReferenceClass() == objectLevelReadQuery.getReferenceClass() || this.getReferenceClass() != null && this.getReferenceClass().equals(objectLevelReadQuery.getReferenceClass())) && (this.getSelectionCriteria() == objectLevelReadQuery.getSelectionCriteria() || this.getSelectionCriteria() != null && this.getSelectionCriteria().equals(objectLevelReadQuery.getSelectionCriteria()));
    }

    public int hashCode() {
        if (!this.isExpressionQuery()) {
            return super.hashCode();
        }
        int n = 32;
        if (this.getReferenceClass() != null) {
            n += this.getReferenceClass().hashCode();
        }
        if (this.getSelectionCriteria() != null) {
            n += this.getSelectionCriteria().hashCode();
        }
        return n;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setIsReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    @Override
    protected boolean wasDefaultLockMode() {
        return this.wasDefaultLockMode;
    }

    public void setWaitTimeout(Integer n) {
        this.waitTimeout = n;
        this.setIsPrePrepared(false);
        this.setIsPrepared(false);
        this.setWasDefaultLockMode(false);
    }

    @Override
    protected void setWasDefaultLockMode(boolean bl) {
        this.wasDefaultLockMode = bl;
    }

    @Override
    public Object clone() {
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)super.clone();
        if (objectLevelReadQuery.hasJoining()) {
            objectLevelReadQuery.joinedAttributeManager = (JoinedAttributeManager)objectLevelReadQuery.getJoinedAttributeManager().clone();
            objectLevelReadQuery.joinedAttributeManager.setBaseQuery(objectLevelReadQuery);
        }
        if (this.hasNonFetchJoinedAttributeExpressions()) {
            objectLevelReadQuery.setNonFetchJoinAttributeExpressions((Vector)this.nonFetchJoinAttributeExpressions.clone());
        }
        return objectLevelReadQuery;
    }

    @Override
    public Object deepClone() {
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.clone();
        if (this.getSelectionCriteria() != null) {
            objectLevelReadQuery.setSelectionCriteria((Expression)this.getSelectionCriteria().clone());
        } else if (this.defaultBuilder != null) {
            objectLevelReadQuery.defaultBuilder = (ExpressionBuilder)this.defaultBuilder.clone();
        }
        return objectLevelReadQuery;
    }

    public void acquireLocks() {
        this.setLockMode((short)1);
        this.setIsPrepared(false);
    }

    public void acquireLocksWithoutWaiting() {
        this.setLockMode((short)2);
        this.setIsPrepared(false);
    }

    public void addAdditionalField(DatabaseField databaseField) {
        this.getAdditionalFields().add(databaseField);
        this.setIsPrepared(false);
    }

    public void addAdditionalField(Expression expression) {
        this.getAdditionalFields().add(expression);
        this.setIsPrepared(false);
    }

    public void addJoinedAttribute(String string) {
        this.addJoinedAttribute(this.getExpressionBuilder().get(string));
    }

    public void addJoinedAttribute(Expression expression) {
        this.getJoinedAttributeManager().addJoinedAttributeExpression(expression);
        this.setIsPrePrepared(false);
    }

    public void addNonFetchJoinedAttribute(String string) {
        this.addNonFetchJoinedAttribute(this.getExpressionBuilder().get(string));
    }

    public void addNonFetchJoinedAttribute(Expression expression) {
        this.getNonFetchJoinAttributeExpressions().add(expression);
        this.setIsPrePrepared(false);
    }

    public void addPartialAttribute(String string) {
        this.addPartialAttribute(this.getExpressionBuilder().get(string));
    }

    protected void addSelectionFieldsForJoinedExpressions(List list, List list2) {
        for (int i = 0; i < list2.size(); ++i) {
            ObjectExpression objectExpression = (ObjectExpression)list2.get(i);
            ExpressionBuilder expressionBuilder = objectExpression.getBuilder();
            expressionBuilder.setSession(this.getSession().getRootSession(null));
            expressionBuilder.setQueryClass(this.getReferenceClass());
            ClassDescriptor classDescriptor = objectExpression.getMapping().getReferenceDescriptor();
            list.addAll(classDescriptor.getAllFields());
        }
    }

    public void setAsOfClause(AsOfClause asOfClause) {
        this.getExpressionBuilder().asOf(new UniversalAsOfClause(asOfClause));
        this.setIsPrepared(false);
    }

    public void addPartialAttribute(Expression expression) {
        this.getPartialAttributeExpressions().addElement(expression);
        this.setIsPrepared(false);
    }

    @Override
    public Object buildObject(AbstractRecord abstractRecord) {
        return this.getDescriptor().getObjectBuilder().buildObject(this, abstractRecord);
    }

    public void checkCacheOnly() {
        this.setCacheUsage(4);
    }

    @Override
    public void checkDescriptor(AbstractSession abstractSession) throws QueryException {
        if (this.getDescriptor() == null) {
            if (this.getReferenceClass() == null) {
                throw QueryException.referenceClassMissing(this);
            }
            ClassDescriptor classDescriptor = abstractSession.getDescriptor(this.getReferenceClass());
            if (classDescriptor == null) {
                throw QueryException.descriptorIsMissing(this.getReferenceClass(), this);
            }
            this.setDescriptor(classDescriptor);
        }
    }

    protected abstract Object checkEarlyReturnImpl(AbstractSession var1, AbstractRecord var2);

    @Override
    public Object checkEarlyReturn(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        this.checkPrePrepare(abstractSession);
        if (!abstractSession.isUnitOfWork()) {
            return this.checkEarlyReturnImpl(abstractSession, abstractRecord);
        }
        UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)abstractSession;
        Object object = this.checkEarlyReturnImpl(unitOfWorkImpl, abstractRecord);
        if (object != null) {
            return object;
        }
        if (this.isReadObjectQuery() && this.isLockQuery()) {
            return null;
        }
        AbstractSession abstractSession2 = unitOfWorkImpl.getParentIdentityMapSession(this);
        object = this.checkEarlyReturn(abstractSession2, abstractRecord);
        if (object != null) {
            if (object == InvalidObject.instance) {
                return object;
            }
            return this.registerResultInUnitOfWork(object, unitOfWorkImpl, abstractRecord, false);
        }
        return null;
    }

    @Override
    public void checkPrepare(AbstractSession abstractSession, AbstractRecord abstractRecord, boolean bl) {
        this.checkPrePrepare(abstractSession);
        super.checkPrepare(abstractSession, abstractRecord, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPrePrepare(AbstractSession abstractSession) {
        if (!this.isPrePrepared()) {
            ObjectLevelReadQuery objectLevelReadQuery = this;
            synchronized (objectLevelReadQuery) {
                if (!this.isPrePrepared()) {
                    AbstractSession abstractSession2 = this.getSession();
                    this.setSession(abstractSession);
                    this.prePrepare();
                    this.setSession(abstractSession2);
                    this.setIsPrePrepared(true);
                }
            }
        } else {
            this.checkDescriptor(abstractSession);
        }
    }

    public void changeDescriptor(AbstractSession abstractSession) {
        this.setDescriptor(null);
        this.checkDescriptor(abstractSession);
    }

    protected Object conformIndividualResult(Object object, UnitOfWorkImpl unitOfWorkImpl, AbstractRecord abstractRecord, Expression expression, Map map, boolean bl) {
        Object object2 = null;
        object2 = bl ? this.buildObject((AbstractRecord)object) : this.registerIndividualResult(object, unitOfWorkImpl, null);
        if (this.getDescriptor().hasWrapperPolicy() && this.getDescriptor().getWrapperPolicy().isWrapped(object2)) {
            return object2;
        }
        if (unitOfWorkImpl.isObjectDeleted(object2)) {
            return null;
        }
        if (!this.isExpressionQuery() || expression == null) {
            if (map != null) {
                map.remove(object2);
            }
            return object2;
        }
        try {
            int n = this.getInMemoryQueryIndirectionPolicyState();
            if (n != 1) {
                n = 2;
            }
            if (expression.doesConform(object2, unitOfWorkImpl, abstractRecord, n)) {
                if (map != null) {
                    map.remove(object2);
                }
                return object2;
            }
        }
        catch (QueryException queryException) {
            if (unitOfWorkImpl.getShouldThrowConformExceptions() == 1 && queryException.getErrorCode() != 6092) {
                throw queryException;
            }
            if (map != null) {
                map.remove(object2);
            }
            return object2;
        }
        return null;
    }

    public void conformResultsInUnitOfWork() {
        this.setCacheUsage(5);
    }

    public void dontAcquireLocks() {
        this.setLockMode((short)0);
        this.setIsPrepared(false);
    }

    public void dontCheckCache() {
        this.setCacheUsage(0);
    }

    @Override
    public void dontRefreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(false);
    }

    @Override
    public void dontRefreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(false);
    }

    public void dontUseDistinct() {
        this.setDistinctState((short)2);
        this.setIsPrepared(false);
    }

    public DatabaseQuery prepareOutsideUnitOfWork(AbstractSession abstractSession) {
        if (this.isLockQuery(abstractSession) && this.getLockingClause().isForUpdateOfClause()) {
            ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.clone();
            objectLevelReadQuery.setIsExecutionClone(true);
            objectLevelReadQuery.dontAcquireLocks();
            objectLevelReadQuery.setIsPrepared(false);
            objectLevelReadQuery.checkPrePrepare(abstractSession);
            return objectLevelReadQuery;
        }
        return this;
    }

    @Override
    public Object execute(AbstractSession abstractSession, AbstractRecord abstractRecord) throws DatabaseException, OptimisticLockException {
        if (this.shouldRefreshIdentityMapResult() && this.shouldCheckCacheOnly()) {
            throw QueryException.refreshNotPossibleWithCheckCacheOnly(this);
        }
        return super.execute(abstractSession, abstractRecord);
    }

    @Override
    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)this.getSession();
            if (this.isLockQuery() && !unitOfWorkImpl.getCommitManager().isActive() && !unitOfWorkImpl.wasTransactionBegunPrematurely()) {
                unitOfWorkImpl.beginTransaction();
                unitOfWorkImpl.setWasTransactionBegunPrematurely(true);
            }
            if (unitOfWorkImpl.isNestedUnitOfWork()) {
                UnitOfWorkImpl unitOfWorkImpl2 = (UnitOfWorkImpl)this.getSession();
                this.setSession(unitOfWorkImpl2.getParent());
                Object object = this.executeDatabaseQuery();
                this.setSession(unitOfWorkImpl2);
                return this.registerResultInUnitOfWork(object, unitOfWorkImpl2, this.getTranslationRow(), false);
            }
        }
        if (this.isResultSetOptimizedQuery()) {
            return this.executeObjectLevelReadQueryFromResultSet();
        }
        this.session.validateQuery(this);
        if (this.getQueryId() == 0L) {
            this.setQueryId(this.getSession().getNextQueryId());
        }
        return this.executeObjectLevelReadQuery();
    }

    protected abstract Object executeObjectLevelReadQuery() throws DatabaseException;

    protected abstract Object executeObjectLevelReadQueryFromResultSet() throws DatabaseException;

    @Override
    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWorkImpl, AbstractRecord abstractRecord) throws DatabaseException, OptimisticLockException {
        Object object = null;
        object = !this.shouldMaintainCache() || this.isReadOnly() ? unitOfWorkImpl.getParent().executeQuery((DatabaseQuery)this, abstractRecord) : this.execute(unitOfWorkImpl, abstractRecord);
        if (this.lockModeType != null && object != null && (this.lockModeType.equals(READ) || this.lockModeType.equals(WRITE) || this.lockModeType.contains(OPTIMISTIC) || this.lockModeType.equals(PESSIMISTIC_FORCE_INCREMENT))) {
            boolean bl;
            boolean bl2 = bl = this.lockModeType.equals(WRITE) || this.lockModeType.equals(OPTIMISTIC_FORCE_INCREMENT) || this.lockModeType.equals(PESSIMISTIC_FORCE_INCREMENT);
            if (object instanceof Collection) {
                for (Object e : (Collection)object) {
                    if (e == null) continue;
                    if (e instanceof Object[]) {
                        for (Object object2 : (Object[])e) {
                            if (object2 == null) continue;
                            unitOfWorkImpl.forceUpdateToVersionField(object2, bl);
                        }
                        continue;
                    }
                    unitOfWorkImpl.forceUpdateToVersionField(e, bl);
                }
            } else {
                unitOfWorkImpl.forceUpdateToVersionField(object, bl);
            }
        }
        return object;
    }

    public Vector getAdditionalFields() {
        if (this.additionalFields == null) {
            this.additionalFields = NonSynchronizedVector.newInstance();
        }
        return this.additionalFields;
    }

    public AsOfClause getAsOfClause() {
        return this.defaultBuilder != null ? this.defaultBuilder.getAsOfClause() : null;
    }

    public int getCacheUsage() {
        return this.cacheUsage;
    }

    public short getDistinctState() {
        return this.distinctState;
    }

    public Object getExampleObject() {
        if (this.getQueryMechanism().isQueryByExampleMechanism()) {
            return ((QueryByExampleMechanism)this.getQueryMechanism()).getExampleObject();
        }
        return null;
    }

    public ExpressionBuilder getExpressionBuilder() {
        if (this.defaultBuilder == null) {
            this.initializeDefaultBuilder();
        }
        return this.defaultBuilder;
    }

    public void setExpressionBuilder(ExpressionBuilder expressionBuilder) {
        this.defaultBuilder = expressionBuilder;
    }

    public int getInMemoryQueryIndirectionPolicyState() {
        return this.inMemoryQueryIndirectionPolicy;
    }

    public InMemoryQueryIndirectionPolicy getInMemoryQueryIndirectionPolicy() {
        return new InMemoryQueryIndirectionPolicy(this.inMemoryQueryIndirectionPolicy, this);
    }

    public JoinedAttributeManager getJoinedAttributeManager() {
        if (this.joinedAttributeManager == null) {
            this.joinedAttributeManager = new JoinedAttributeManager(this.getDescriptor(), this.getExpressionBuilder(), this);
        }
        return this.joinedAttributeManager;
    }

    public void setJoinedAttributeManager(JoinedAttributeManager joinedAttributeManager) {
        this.joinedAttributeManager = joinedAttributeManager;
    }

    public boolean hasJoining() {
        return this.joinedAttributeManager != null;
    }

    public List getJoinedAttributeExpressions() {
        return this.getJoinedAttributeManager().getJoinedAttributeExpressions();
    }

    public void setJoinedAttributeExpressions(List list) {
        if (list != null && !list.isEmpty() || this.hasJoining()) {
            this.getJoinedAttributeManager().setJoinedAttributeExpressions_(list);
        }
    }

    public boolean shouldFilterDuplicates() {
        if (this.hasJoining()) {
            return this.getJoinedAttributeManager().shouldFilterDuplicates();
        }
        return true;
    }

    public void setShouldFilterDuplicates(boolean bl) {
        this.getJoinedAttributeManager().setShouldFilterDuplicates(bl);
    }

    public DatabaseMapping getLeafMappingFor(Expression expression, ClassDescriptor classDescriptor) throws QueryException {
        if (expression == null || expression.isFieldExpression()) {
            return null;
        }
        if (!expression.isQueryKeyExpression()) {
            return null;
        }
        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)expression;
        Expression expression2 = queryKeyExpression.getBaseExpression();
        ClassDescriptor classDescriptor2 = this.getLeafDescriptorFor(expression2, classDescriptor);
        return classDescriptor2.getObjectBuilder().getMappingForAttributeName(queryKeyExpression.getName());
    }

    public ClassDescriptor getLeafDescriptorFor(Expression expression, ClassDescriptor classDescriptor) throws QueryException {
        if (expression.isExpressionBuilder()) {
            Class clazz = ((ExpressionBuilder)expression).getQueryClass();
            if (clazz != null && clazz != this.getReferenceClass()) {
                return this.getSession().getDescriptor(clazz);
            }
            return classDescriptor;
        }
        Expression expression2 = ((QueryKeyExpression)expression).getBaseExpression();
        ClassDescriptor classDescriptor2 = this.getLeafDescriptorFor(expression2, classDescriptor);
        ClassDescriptor classDescriptor3 = null;
        String string = expression.getName();
        DatabaseMapping databaseMapping = classDescriptor2.getObjectBuilder().getMappingForAttributeName(string);
        if (databaseMapping == null) {
            QueryKey queryKey = classDescriptor2.getQueryKeyNamed(string);
            if (queryKey != null) {
                classDescriptor3 = queryKey.isForeignReferenceQueryKey() ? this.getSession().getDescriptor(((ForeignReferenceQueryKey)queryKey).getReferenceClass()) : queryKey.getDescriptor();
            }
            if (classDescriptor3 == null) {
                throw QueryException.invalidExpressionForQueryItem(expression, this);
            }
        } else if (databaseMapping.isAggregateObjectMapping()) {
            classDescriptor3 = ((AggregateObjectMapping)databaseMapping).getReferenceDescriptor();
        } else if (databaseMapping.isForeignReferenceMapping()) {
            classDescriptor3 = ((ForeignReferenceMapping)databaseMapping).getReferenceDescriptor();
        }
        return classDescriptor3;
    }

    @Override
    public short getLockMode() {
        if (this.lockingClause == null) {
            return -1;
        }
        return this.lockingClause.getLockMode();
    }

    public ForUpdateClause getLockingClause() {
        return this.lockingClause;
    }

    public Vector getNonFetchJoinAttributeExpressions() {
        if (this.nonFetchJoinAttributeExpressions == null) {
            this.nonFetchJoinAttributeExpressions = NonSynchronizedVector.newInstance();
        }
        return this.nonFetchJoinAttributeExpressions;
    }

    public Vector getPartialAttributeExpressions() {
        if (this.partialAttributeExpressions == null) {
            this.partialAttributeExpressions = NonSynchronizedVector.newInstance();
        }
        return this.partialAttributeExpressions;
    }

    @Override
    public long getExecutionTime() {
        return this.executionTime;
    }

    public QueryByExamplePolicy getQueryByExamplePolicy() {
        if (this.getQueryMechanism().isQueryByExampleMechanism()) {
            return ((QueryByExampleMechanism)this.getQueryMechanism()).getQueryByExamplePolicy();
        }
        return null;
    }

    @Override
    public Class getReferenceClass() {
        return this.referenceClass;
    }

    @Override
    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public boolean hasAsOfClause() {
        return this.defaultBuilder != null && this.defaultBuilder.hasAsOfClause();
    }

    public boolean hasNonFetchJoinedAttributeExpressions() {
        return this.nonFetchJoinAttributeExpressions != null && !this.nonFetchJoinAttributeExpressions.isEmpty();
    }

    @Override
    public boolean hasPartialAttributeExpressions() {
        return this.partialAttributeExpressions != null && !this.partialAttributeExpressions.isEmpty();
    }

    public boolean hasAdditionalFields() {
        return this.additionalFields != null && !this.additionalFields.isEmpty();
    }

    public Vector getPartialAttributeSelectionFields(boolean bl) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getPartialAttributeExpressions().size());
        NonSynchronizedVector nonSynchronizedVector2 = null;
        ((Vector)nonSynchronizedVector).addAll(this.getDescriptor().getPrimaryKeyFields());
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().getClassIndicatorField() != null) {
            ((Vector)nonSynchronizedVector).addElement(this.getDescriptor().getInheritancePolicy().getClassIndicatorField());
        }
        for (Object object : this.getPartialAttributeExpressions()) {
            if (((Expression)object).isQueryKeyExpression()) {
                ((QueryKeyExpression)object).getBuilder().setSession(this.session.getRootSession(null));
                ((QueryKeyExpression)object).getBuilder().setQueryClass(this.getDescriptor().getJavaClass());
                DatabaseMapping cloneable = ((QueryKeyExpression)object).getMapping();
                if (!((QueryKeyExpression)object).getBaseExpression().isExpressionBuilder()) {
                    if (nonSynchronizedVector2 == null) {
                        nonSynchronizedVector2 = NonSynchronizedVector.newInstance();
                    }
                    if (!bl) {
                        ((Vector)nonSynchronizedVector2).add(object);
                        continue;
                    }
                    ((Vector)nonSynchronizedVector2).addAll(((Expression)object).getFields());
                    continue;
                }
                if (cloneable == null) {
                    throw QueryException.specifiedPartialAttributeDoesNotExist(this, ((Expression)object).getName(), this.descriptor.getJavaClass().getName());
                }
                if (cloneable.isForeignReferenceMapping()) {
                    if (nonSynchronizedVector2 == null) {
                        nonSynchronizedVector2 = NonSynchronizedVector.newInstance();
                    }
                    if (!bl) {
                        ((Vector)nonSynchronizedVector2).add(object);
                        continue;
                    }
                    ((Vector)nonSynchronizedVector2).addAll(((Expression)object).getFields());
                    continue;
                }
                ((Vector)nonSynchronizedVector).addAll(((Expression)object).getFields());
                continue;
            }
            throw QueryException.expressionDoesNotSupportPartialAttributeReading((Expression)object);
        }
        NonSynchronizedVector nonSynchronizedVector3 = NonSynchronizedVector.newInstance();
        for (DatabaseField databaseField : this.getDescriptor().getFields()) {
            if (nonSynchronizedVector.contains(databaseField)) {
                ((Vector)nonSynchronizedVector3).add(databaseField);
                continue;
            }
            ((Vector)nonSynchronizedVector3).add(null);
        }
        if (nonSynchronizedVector2 != null) {
            ((Vector)nonSynchronizedVector3).addAll(nonSynchronizedVector2);
        }
        return nonSynchronizedVector3;
    }

    public Vector getFetchGroupSelectionFields(boolean bl) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>(this.getFetchGroup().getAttributes().size() + 2);
        hashSet.addAll(this.getDescriptor().getPrimaryKeyFields());
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().getClassIndicatorField() != null) {
            hashSet.add(this.getDescriptor().getInheritancePolicy().getClassIndicatorField());
        }
        if (this.shouldMaintainCache() && this.getDescriptor().usesOptimisticLocking() && (object = this.getDescriptor().getOptimisticLockingPolicy().getWriteLockField()) != null) {
            hashSet.add(object);
        }
        for (Object object2 : this.getFetchGroup().getAttributes()) {
            DatabaseMapping cloneable = this.getDescriptor().getObjectBuilder().getMappingForAttributeName((String)object2);
            if (cloneable == null) {
                throw QueryException.fetchGroupAttributeNotMapped((String)object2);
            }
            hashSet.addAll(cloneable.getFields());
        }
        object = NonSynchronizedVector.newInstance(this.getFetchGroup().getAttributes().size() + 2);
        for (DatabaseField databaseField : this.getDescriptor().getFields()) {
            if (hashSet.contains(databaseField)) {
                ((Vector)object).add(databaseField);
                continue;
            }
            ((Vector)object).add(null);
        }
        if (this.hasJoining()) {
            if (bl) {
                this.addSelectionFieldsForJoinedExpressions((List)object, this.getJoinedAttributeManager().getJoinedAttributeExpressions());
                this.addSelectionFieldsForJoinedExpressions((List)object, this.getJoinedAttributeManager().getJoinedMappingExpressions());
            } else {
                Helper.addAllToVector((Vector)object, this.getJoinedAttributeManager().getJoinedAttributeExpressions());
                Helper.addAllToVector((Vector)object, this.getJoinedAttributeManager().getJoinedMappingExpressions());
            }
        }
        if (this.hasAdditionalFields()) {
            Helper.addAllToVector((Vector)object, this.getAdditionalFields());
        }
        return object;
    }

    public Vector getSelectionFields() {
        if (this.hasPartialAttributeExpressions()) {
            return this.getPartialAttributeSelectionFields(true);
        }
        if (this.hasFetchGroup()) {
            return this.getFetchGroupSelectionFields(true);
        }
        if (this.hasJoining()) {
            JoinedAttributeManager joinedAttributeManager = this.getJoinedAttributeManager();
            NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getDescriptor().getAllFields().size() + joinedAttributeManager.getJoinedAttributeExpressions().size() + joinedAttributeManager.getJoinedMappingExpressions().size());
            Helper.addAllToVector((Vector)nonSynchronizedVector, this.getDescriptor().getAllFields());
            this.addSelectionFieldsForJoinedExpressions(nonSynchronizedVector, joinedAttributeManager.getJoinedAttributeExpressions());
            this.addSelectionFieldsForJoinedExpressions(nonSynchronizedVector, joinedAttributeManager.getJoinedMappingExpressions());
            return nonSynchronizedVector;
        }
        return this.getDescriptor().getAllFields();
    }

    public Integer getWaitTimeout() {
        return this.waitTimeout;
    }

    protected void initializeDefaultBuilder() {
        DatabaseQueryMechanism databaseQueryMechanism = this.getQueryMechanism();
        if (databaseQueryMechanism.isExpressionQueryMechanism() && ((ExpressionQueryMechanism)databaseQueryMechanism).getExpressionBuilder() != null) {
            this.defaultBuilder = ((ExpressionQueryMechanism)databaseQueryMechanism).getExpressionBuilder();
            return;
        }
        this.defaultBuilder = new ExpressionBuilder();
    }

    public boolean isDistinctComputed() {
        return this.getDistinctState() != 0;
    }

    @Override
    public boolean isLockQuery() {
        return this.getLockMode() > 0;
    }

    public boolean isLockQuery(Session session) {
        this.checkPrePrepare((AbstractSession)session);
        return this.isLockQuery();
    }

    @Override
    public boolean isObjectLevelReadQuery() {
        return true;
    }

    public boolean isPartialAttribute(String string) {
        if (!this.hasPartialAttributeExpressions()) {
            return false;
        }
        Vector vector = this.getPartialAttributeExpressions();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)vector.get(i);
            while (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) {
                queryKeyExpression = (QueryKeyExpression)queryKeyExpression.getBaseExpression();
            }
            if (!queryKeyExpression.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPrePrepared() {
        return this.isPrePrepared;
    }

    @Override
    protected boolean isRegisteringResults() {
        return this.shouldRegisterResultsInUnitOfWork() && this.getDescriptor().shouldRegisterResultsInUnitOfWork() || this.isLockQuery();
    }

    protected void setIsPrePrepared(boolean bl) {
        if (this.isPrePrepared && !bl) {
            this.setIsPrepared(false);
            if (this.hasJoining()) {
                this.getJoinedAttributeManager().reset();
            }
        }
        this.isPrePrepared = bl;
    }

    @Override
    public void setIsPrepared(boolean bl) {
        super.setIsPrepared(bl);
        this.isReferenceClassLocked = null;
        this.concreteSubclassCalls = null;
    }

    @Override
    protected void prepare() throws QueryException {
        super.prepare();
        this.prepareQuery();
        if (this.hasJoining()) {
            this.getJoinedAttributeManager().computeJoiningMappingQueries(this.session);
        }
    }

    protected boolean prepareFromCachedQuery() {
        boolean bl = this.isExpressionQuery() && !this.getQueryMechanism().isJPQLCallQueryMechanism() && this.isDefaultPropertiesQuery() && !this.getSession().isHistoricalSession();
        DatabaseQuery databaseQuery = null;
        if (!bl) {
            return false;
        }
        databaseQuery = this.getDescriptor().getQueryManager().getCachedExpressionQuery(this);
        if (databaseQuery != null && databaseQuery.isPrepared()) {
            this.prepareFromQuery(databaseQuery);
            this.setIsPrepared(true);
            return true;
        }
        this.getDescriptor().getQueryManager().putCachedExpressionQuery(this);
        return false;
    }

    @Override
    public void copyFromQuery(DatabaseQuery databaseQuery) {
        super.copyFromQuery(databaseQuery);
        if (databaseQuery.isObjectLevelReadQuery()) {
            ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)databaseQuery;
            this.cacheUsage = objectLevelReadQuery.cacheUsage;
            this.isReadOnly = objectLevelReadQuery.isReadOnly;
            this.isResultSetOptimizedQuery = objectLevelReadQuery.isResultSetOptimizedQuery;
            this.shouldIncludeData = objectLevelReadQuery.shouldIncludeData;
            this.inMemoryQueryIndirectionPolicy = objectLevelReadQuery.inMemoryQueryIndirectionPolicy;
        }
    }

    @Override
    public void prepareFromQuery(DatabaseQuery databaseQuery) {
        super.prepareFromQuery(databaseQuery);
        if (databaseQuery.isObjectLevelReadQuery()) {
            ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)databaseQuery;
            this.referenceClass = objectLevelReadQuery.referenceClass;
            this.distinctState = objectLevelReadQuery.distinctState;
            if (objectLevelReadQuery.hasJoining()) {
                JoinedAttributeManager joinedAttributeManager = this.getJoinedAttributeManager();
                JoinedAttributeManager joinedAttributeManager2 = objectLevelReadQuery.getJoinedAttributeManager();
                joinedAttributeManager.setJoinedAttributeExpressions_(joinedAttributeManager2.getJoinedAttributeExpressions());
                joinedAttributeManager.setJoinedMappingExpressions_(joinedAttributeManager2.getJoinedMappingExpressions());
                joinedAttributeManager.setJoinedMappingIndexes_(joinedAttributeManager2.getJoinedMappingIndexes_());
                joinedAttributeManager.setJoinedMappingQueries_(joinedAttributeManager2.getJoinedMappingQueries_());
            }
            this.nonFetchJoinAttributeExpressions = objectLevelReadQuery.nonFetchJoinAttributeExpressions;
            this.defaultBuilder = objectLevelReadQuery.defaultBuilder;
            this.fetchGroup = objectLevelReadQuery.fetchGroup;
            this.fetchGroupName = objectLevelReadQuery.fetchGroupName;
            this.isReferenceClassLocked = objectLevelReadQuery.isReferenceClassLocked;
            this.shouldOuterJoinSubclasses = objectLevelReadQuery.shouldOuterJoinSubclasses;
            this.shouldUseDefaultFetchGroup = objectLevelReadQuery.shouldUseDefaultFetchGroup;
            this.concreteSubclassCalls = objectLevelReadQuery.concreteSubclassCalls;
            this.additionalFields = objectLevelReadQuery.additionalFields;
            this.partialAttributeExpressions = objectLevelReadQuery.partialAttributeExpressions;
        }
    }

    protected void prePrepare() throws QueryException {
        Serializable serializable;
        this.buildSelectionCriteria(this.session);
        this.checkDescriptor(this.session);
        if (this.getQueryMechanism().isExpressionQueryMechanism() && this.getDescriptor().getObjectBuilder().hasJoinedAttributes()) {
            this.getJoinedAttributeManager().processJoinedMappings();
        }
        if (this.lockModeType != null) {
            if (this.lockModeType.equals(NONE)) {
                this.setLockMode((short)0);
            } else if (this.lockModeType.contains(PESSIMISTIC)) {
                Serializable serializable2 = serializable = this.waitTimeout == null ? this.getSession().getPessimisticLockTimeoutDefault() : this.waitTimeout;
                if (serializable == null) {
                    this.setLockMode((short)1);
                } else if ((Integer)serializable == 0) {
                    this.setLockMode((short)2);
                } else {
                    this.lockingClause = ForUpdateClause.newInstance((Integer)serializable);
                }
            }
        }
        if (this.isDefaultLock()) {
            this.setWasDefaultLockMode(true);
            serializable = null;
            if (this.hasJoining()) {
                serializable = this.getJoinedAttributeManager().setupLockingClauseForJoinedExpressions((ForUpdateOfClause)serializable, this.getSession());
            }
            if (this.descriptor.hasPessimisticLockingPolicy()) {
                serializable = new ForUpdateOfClause();
                ((ForUpdateOfClause)serializable).setLockMode(this.descriptor.getCMPPolicy().getPessimisticLockingPolicy().getLockingMode());
                ((ForUpdateOfClause)serializable).addLockedExpression(this.getExpressionBuilder());
            }
            if (serializable == null) {
                this.lockingClause = ForUpdateClause.newInstance((short)0);
            } else {
                this.lockingClause = serializable;
                this.dontUseDistinct();
            }
        } else if (this.getLockMode() == 0 && !this.descriptor.hasPessimisticLockingPolicy()) {
            this.setWasDefaultLockMode(true);
        }
        if (this.hasJoining() && this.hasPartialAttributeExpressions()) {
            this.session.log(6, "query", "query_has_both_join_attributes_and_partial_attributes", new Object[]{this, this.getName()});
        }
    }

    protected void prepareQuery() throws QueryException {
        if (!this.shouldMaintainCache() && this.shouldRefreshIdentityMapResult() && !this.descriptor.isAggregateCollectionDescriptor()) {
            throw QueryException.refreshNotPossibleWithoutCache(this);
        }
        if (this.shouldMaintainCache() && this.hasPartialAttributeExpressions()) {
            throw QueryException.cannotCachePartialObjects(this);
        }
        if (this.descriptor.isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.descriptor, this);
        }
        if (this.hasAsOfClause() && this.getSession().getAsOfClause() == null) {
            if (this.shouldMaintainCache()) {
                throw QueryException.historicalQueriesMustPreserveGlobalCache();
            }
            if (!this.getSession().getPlatform().isOracle() && !this.getSession().getProject().hasGenericHistorySupport()) {
                throw QueryException.historicalQueriesOnlySupportedOnOracle();
            }
        }
        if (!(this.getDescriptor().hasFetchGroupManager() || this.getFetchGroup() == null && this.getFetchGroupName() == null)) {
            throw QueryException.fetchGroupValidOnlyIfFetchGroupManagerInDescriptor(this.getDescriptor().getJavaClassName(), this.getName());
        }
        if (this.getDescriptor().hasFetchGroupManager()) {
            this.getDescriptor().getFetchGroupManager().prepareQueryWithFetchGroup(this);
        }
        if (this.hasJoining()) {
            this.getJoinedAttributeManager().prepareJoinExpressions(this.getSession());
        }
        if (this.hasPartialAttributeExpressions()) {
            for (int i = 0; i < this.getPartialAttributeExpressions().size(); ++i) {
                Expression expression = (Expression)this.getPartialAttributeExpressions().get(i);
                while (expression.isQueryKeyExpression() && !expression.isExpressionBuilder()) {
                    if (((QueryKeyExpression)expression).shouldQueryToManyRelationship()) {
                        this.getJoinedAttributeManager().setIsToManyJoinQuery(true);
                    }
                    expression = ((QueryKeyExpression)expression).getBaseExpression();
                }
            }
        }
        if (!this.shouldOuterJoinSubclasses()) {
            this.setShouldOuterJoinSubclasses(this.getMaxRows() > 0 || this.getFirstResult() > 0 || this.getDescriptor() != null && this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().shouldOuterJoinSubclasses());
        }
        if (!this.shouldOuterJoinSubclasses() && this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead()) {
            this.getConcreteSubclassCalls();
        }
    }

    @Override
    protected void prepareForRemoteExecution() throws QueryException {
        super.prepareForRemoteExecution();
        this.checkPrePrepare(this.getSession());
        this.prepareQuery();
    }

    @Override
    public void refreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(true);
    }

    @Override
    public void refreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(true);
    }

    public abstract Object registerResultInUnitOfWork(Object var1, UnitOfWorkImpl var2, AbstractRecord var3, boolean var4);

    public void resetDistinct() {
        this.setDistinctState((short)0);
        this.setIsPrepared(false);
    }

    public void setAdditionalFields(Vector vector) {
        this.additionalFields = vector;
    }

    public void setCacheUsage(int n) {
        this.cacheUsage = n;
    }

    @Override
    public void setDescriptor(ClassDescriptor classDescriptor) {
        super.setDescriptor(classDescriptor);
        if (this.joinedAttributeManager != null) {
            this.joinedAttributeManager.setDescriptor(classDescriptor);
        }
    }

    public void setDistinctState(short s) {
        this.distinctState = s;
    }

    @Override
    public void setExecutionTime(long l) {
        this.executionTime = l;
    }

    public void setExampleObject(Object object) {
        if (!this.getQueryMechanism().isQueryByExampleMechanism()) {
            this.setQueryMechanism(new QueryByExampleMechanism((DatabaseQuery)this, this.getSelectionCriteria()));
            ((QueryByExampleMechanism)this.getQueryMechanism()).setExampleObject(object);
            this.setIsPrepared(false);
        } else {
            ((QueryByExampleMechanism)this.getQueryMechanism()).setExampleObject(object);
            if (this.isPrepared() || !this.shouldPrepare() && ((QueryByExampleMechanism)this.getQueryMechanism()).isParsed()) {
                ((QueryByExampleMechanism)this.getQueryMechanism()).setIsParsed(false);
                this.setSelectionCriteria(null);
            }
        }
        if (object != null) {
            this.setReferenceClass(object.getClass());
        }
    }

    public void setInMemoryQueryIndirectionPolicy(InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) {
        if (inMemoryQueryIndirectionPolicy != null) {
            this.inMemoryQueryIndirectionPolicy = inMemoryQueryIndirectionPolicy.getPolicy();
            inMemoryQueryIndirectionPolicy.setQuery(this);
        }
    }

    public void setInMemoryQueryIndirectionPolicyState(int n) {
        this.inMemoryQueryIndirectionPolicy = n;
    }

    @Override
    public void setLockMode(short s) {
        if (s == 1 || s == 2) {
            this.lockingClause = ForUpdateClause.newInstance(s);
            this.setShouldRefreshIdentityMapResult(true);
        } else if (s == 0) {
            this.lockingClause = ForUpdateClause.newInstance(s);
        } else {
            this.lockingClause = null;
            this.setIsPrePrepared(false);
        }
        this.setIsPrepared(false);
    }

    public boolean setLockModeType(LockModeType lockModeType, AbstractSession abstractSession) {
        if (lockModeType != null) {
            OptimisticLockingPolicy optimisticLockingPolicy = abstractSession.getDescriptor(this.getReferenceClass()).getOptimisticLockingPolicy();
            if (!(optimisticLockingPolicy != null && optimisticLockingPolicy instanceof VersionLockingPolicy || lockModeType.name().equals(PESSIMISTIC) || lockModeType.name().equals(NONE))) {
                return true;
            }
            this.lockModeType = lockModeType.name();
            this.setIsPrePrepared(false);
            this.setIsPrepared(false);
            this.setWasDefaultLockMode(false);
        }
        return false;
    }

    protected void setNonFetchJoinAttributeExpressions(Vector vector) {
        this.nonFetchJoinAttributeExpressions = vector;
    }

    public void setLockingClause(ForUpdateClause forUpdateClause) {
        if (forUpdateClause.isForUpdateOfClause()) {
            this.lockingClause = forUpdateClause;
            this.setIsPrePrepared(false);
        } else {
            this.setLockMode(forUpdateClause.getLockMode());
        }
    }

    public void setPartialAttributeExpressions(Vector vector) {
        this.partialAttributeExpressions = vector;
    }

    @Override
    public void setEJBQLString(String string) {
        super.setEJBQLString(string);
        this.setIsPrePrepared(false);
    }

    public void setQueryByExamplePolicy(QueryByExamplePolicy queryByExamplePolicy) {
        if (!this.getQueryMechanism().isQueryByExampleMechanism()) {
            this.setQueryMechanism(new QueryByExampleMechanism((DatabaseQuery)this, this.getSelectionCriteria()));
            ((QueryByExampleMechanism)this.getQueryMechanism()).setQueryByExamplePolicy(queryByExamplePolicy);
            this.setIsPrepared(false);
        } else {
            ((QueryByExampleMechanism)this.getQueryMechanism()).setQueryByExamplePolicy(queryByExamplePolicy);
            if (this.isPrepared() || !this.shouldPrepare() && ((QueryByExampleMechanism)this.getQueryMechanism()).isParsed()) {
                ((QueryByExampleMechanism)this.getQueryMechanism()).setIsParsed(false);
                this.setSelectionCriteria(null);
            }
        }
        this.setIsPrePrepared(false);
    }

    @Override
    public void setReferenceClass(Class clazz) {
        if (this.referenceClass != clazz) {
            this.setIsPrepared(false);
        }
        this.referenceClass = clazz;
    }

    @Override
    public void setReferenceClassName(String string) {
        if (this.referenceClassName != string) {
            this.setIsPrepared(false);
        }
        this.referenceClassName = string;
    }

    @Override
    public void setSelectionCriteria(Expression expression) {
        ExpressionBuilder expressionBuilder;
        super.setSelectionCriteria(expression);
        if (expression != null && this.defaultBuilder != null && this.defaultBuilder.getQueryClass() == null && (expressionBuilder = expression.getBuilder()) != this.defaultBuilder) {
            if (this.hasAsOfClause() && this.getAsOfClause().isUniversal()) {
                expressionBuilder.asOf(this.defaultBuilder.getAsOfClause());
            }
            this.defaultBuilder = expressionBuilder;
        }
    }

    public void setShouldIncludeData(boolean bl) {
        this.shouldIncludeData = bl;
    }

    @Override
    public void setShouldRefreshIdentityMapResult(boolean bl) {
        this.shouldRefreshIdentityMapResult = bl;
        if (bl) {
            this.setShouldRefreshRemoteIdentityMapResult(true);
        }
    }

    @Override
    public void setShouldRefreshRemoteIdentityMapResult(boolean bl) {
        this.shouldRefreshRemoteIdentityMapResult = bl;
    }

    @Override
    public void setShouldRegisterResultsInUnitOfWork(boolean bl) {
        this.shouldRegisterResultsInUnitOfWork = bl;
    }

    public boolean shouldCheckCacheOnly() {
        return this.cacheUsage == 4;
    }

    public boolean shouldCheckDescriptorForCacheUsage() {
        return this.cacheUsage == -1;
    }

    public boolean shouldConformResultsInUnitOfWork() {
        return this.cacheUsage == 5;
    }

    public boolean shouldDistinctBeUsed() {
        return this.getDistinctState() == 1;
    }

    public boolean shouldIncludeData() {
        return this.shouldIncludeData;
    }

    public boolean shouldOuterJoinSubclasses() {
        if (this.shouldOuterJoinSubclasses == null) {
            return false;
        }
        return this.shouldOuterJoinSubclasses;
    }

    public void setShouldOuterJoinSubclasses(boolean bl) {
        this.shouldOuterJoinSubclasses = bl;
        this.setIsPrepared(false);
    }

    @Override
    public boolean shouldRegisterResultsInUnitOfWork() {
        return this.shouldRegisterResultsInUnitOfWork;
    }

    @Override
    public boolean shouldReadAllMappings() {
        return !this.hasPartialAttributeExpressions() && !this.hasFetchGroup();
    }

    @Override
    public boolean shouldReadMapping(DatabaseMapping databaseMapping) {
        if (!this.hasPartialAttributeExpressions() && !this.hasFetchGroup()) {
            return true;
        }
        String string = databaseMapping.getAttributeName();
        if (this.hasFetchGroup()) {
            return this.isFetchGroupAttribute(string);
        }
        return this.isPartialAttribute(string);
    }

    @Override
    public boolean shouldRefreshIdentityMapResult() {
        return this.shouldRefreshIdentityMapResult;
    }

    @Override
    public boolean shouldRefreshRemoteIdentityMapResult() {
        return this.shouldRefreshRemoteIdentityMapResult;
    }

    @Override
    public void setShouldProcessResultsInUnitOfWork(boolean bl) {
        this.shouldProcessResultsInUnitOfWork = bl;
    }

    @Override
    public boolean shouldProcessResultsInUnitOfWork() {
        return this.shouldProcessResultsInUnitOfWork;
    }

    public void useDistinct() {
        this.setDistinctState((short)1);
        this.setIsPrepared(false);
    }

    @Override
    public boolean isClonePessimisticLocked(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        return this.getDescriptor().hasPessimisticLockingPolicy() && unitOfWorkImpl.isPessimisticLocked(object);
    }

    protected boolean isReferenceClassLocked() {
        if (this.isReferenceClassLocked == null) {
            this.isReferenceClassLocked = this.isLockQuery() && this.lockingClause.isReferenceClassLocked();
        }
        return this.isReferenceClassLocked;
    }

    @Override
    public void recordCloneForPessimisticLocking(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        if (this.isReferenceClassLocked()) {
            unitOfWorkImpl.addPessimisticLockedClone(object);
        }
    }

    public boolean isResultSetOptimizedQuery() {
        return this.isResultSetOptimizedQuery;
    }

    public void setIsResultSetOptimizedQuery(boolean bl) {
        this.isResultSetOptimizedQuery = bl;
    }

    @Override
    public boolean isDefaultLock() {
        return this.lockingClause == null || this.wasDefaultLockMode();
    }

    @Override
    public boolean isDefaultPropertiesQuery() {
        return super.isDefaultPropertiesQuery() && this.isDefaultLock() && !this.isDistinctComputed() && !this.hasAdditionalFields() && !this.hasPartialAttributeExpressions() && !this.hasNonFetchJoinedAttributeExpressions() && !this.hasFetchGroup() && this.getFetchGroupName() == null && this.shouldUseDefaultFetchGroup();
    }

    public boolean hasFetchGroup() {
        return this.fetchGroup != null;
    }

    @Override
    public FetchGroup getFetchGroup() {
        return this.fetchGroup;
    }

    public void initializeFetchGroup() {
        if (this.fetchGroup != null) {
            return;
        }
        if (this.fetchGroupName != null) {
            this.fetchGroup = this.getDescriptor().getFetchGroupManager().getFetchGroup(this.fetchGroupName);
            if (this.fetchGroup == null) {
                throw QueryException.fetchGroupNotDefinedInDescriptor(this.fetchGroupName);
            }
        } else if (this.shouldUseDefaultFetchGroup()) {
            this.fetchGroup = this.getDescriptor().getDefaultFetchGroup();
        }
    }

    public void setFetchGroup(FetchGroup fetchGroup) {
        this.fetchGroup = fetchGroup;
        this.setIsPrepared(false);
    }

    public void setFetchGroupName(String string) {
        this.fetchGroup = null;
        this.fetchGroupName = string;
        this.setIsPrepared(false);
    }

    public String getFetchGroupName() {
        return this.fetchGroupName;
    }

    public boolean shouldUseDefaultFetchGroup() {
        return this.shouldUseDefaultFetchGroup;
    }

    public void setShouldUseDefaultFetchGroup(boolean bl) {
        this.shouldUseDefaultFetchGroup = bl;
        this.setIsPrepared(false);
    }

    public boolean isFetchGroupAttribute(String string) {
        if (this.getFetchGroup() == null) {
            return true;
        }
        return this.getFetchGroup().getAttributes().contains(string);
    }

    public Map<Class, DatabaseCall> getConcreteSubclassCalls() {
        if (this.concreteSubclassCalls == null) {
            this.concreteSubclassCalls = new ConcurrentHashMap<Class, DatabaseCall>(8);
        }
        return this.concreteSubclassCalls;
    }
}

