/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sequencing.UnaryTableSequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.DefaultTableGenerator;
import org.eclipse.persistence.tools.schemaframework.SequenceDefinition;
import org.eclipse.persistence.tools.schemaframework.SequenceObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureGenerator;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;
import org.eclipse.persistence.tools.schemaframework.TableSequenceDefinition;
import org.eclipse.persistence.tools.schemaframework.UnaryTableSequenceDefinition;

public class SchemaManager {
    protected DatabaseSessionImpl session;
    protected Writer createSchemaWriter;
    protected Writer dropSchemaWriter;
    protected boolean createSQLFiles = true;
    protected TableCreator defaultTableCreator;
    public static boolean FAST_TABLE_CREATOR = false;

    public SchemaManager(DatabaseSessionImpl databaseSessionImpl) {
        this.session = databaseSessionImpl;
    }

    public SchemaManager(DatabaseSession databaseSession) {
        this.session = (DatabaseSessionImpl)databaseSession;
    }

    protected Writer getDropSchemaWriter() {
        if (null == this.dropSchemaWriter) {
            return this.createSchemaWriter;
        }
        return this.dropSchemaWriter;
    }

    public void appendToDDLWriter(String string) {
        this.appendToDDLWriter(this.createSchemaWriter, string);
    }

    public void appendToDDLWriter(Writer writer, String string) {
        if (writer == null) {
            return;
        }
        try {
            writer.write(string);
            writer.flush();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void buildFieldTypes(TableDefinition tableDefinition) {
        tableDefinition.buildFieldTypes(this.getSession());
    }

    public void closeDDLWriter() {
        this.closeDDLWriter(this.createSchemaWriter);
        this.closeDDLWriter(this.dropSchemaWriter);
        this.createSchemaWriter = null;
        this.dropSchemaWriter = null;
    }

    public void closeDDLWriter(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConstraints(TableDefinition tableDefinition) throws EclipseLinkException {
        boolean bl = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            bl = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                tableDefinition.createConstraintsOnDatabase(this.getSession());
            } else {
                tableDefinition.setCreateSQLFiles(this.createSQLFiles);
                tableDefinition.createConstraints(this.getSession(), this.createSchemaWriter);
            }
        }
        finally {
            if (bl) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    void createUniqueConstraints(TableDefinition tableDefinition) throws EclipseLinkException {
        if (this.shouldWriteToDatabase()) {
            tableDefinition.createUniqueConstraintsOnDatabase(this.getSession());
        } else {
            tableDefinition.setCreateSQLFiles(this.createSQLFiles);
            tableDefinition.createUniqueConstraints(this.getSession(), this.createSchemaWriter);
        }
    }

    void createForeignConstraints(TableDefinition tableDefinition) throws EclipseLinkException {
        if (this.shouldWriteToDatabase()) {
            tableDefinition.createForeignConstraintsOnDatabase(this.getSession());
        } else {
            tableDefinition.setCreateSQLFiles(this.createSQLFiles);
            tableDefinition.createForeignConstraints(this.getSession(), this.createSchemaWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObject(DatabaseObjectDefinition databaseObjectDefinition) throws EclipseLinkException {
        boolean bl = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            bl = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                databaseObjectDefinition.createOnDatabase(this.getSession());
            } else {
                databaseObjectDefinition.createObject(this.getSession(), this.createSchemaWriter);
            }
            if (this.createSQLFiles) {
                this.appendToDDLWriter(this.createSchemaWriter, this.getSession().getPlatform().getStoredProcedureTerminationToken());
            }
            this.appendToDDLWriter(this.createSchemaWriter, "\n");
        }
        finally {
            if (bl) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    public void createSequences() throws EclipseLinkException {
        this.createOrReplaceSequences(true);
    }

    public void setCreateSQLFiles(boolean bl) {
        this.createSQLFiles = bl;
    }

    public void replaceSequences() throws EclipseLinkException {
        this.createOrReplaceSequences(false);
    }

    protected void createOrReplaceSequences(boolean bl) throws EclipseLinkException {
        this.createOrReplaceSequences(bl, bl);
    }

    protected void createOrReplaceSequences(boolean bl, boolean bl2) throws EclipseLinkException {
        boolean bl3 = FAST_TABLE_CREATOR;
        if (bl3) {
            return;
        }
        Sequencing sequencing = this.getSession().getSequencing();
        if (sequencing == null || sequencing.whenShouldAcquireValueForAll() == 1) {
            return;
        }
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        this.buildTableAndSequenceDefinitions(hashSet, hashSet2, hashMap);
        this.processTableDefinitions(hashMap, bl);
        this.processSequenceDefinitions(hashSet, bl2);
    }

    private void buildTableAndSequenceDefinitions(HashSet hashSet, HashSet hashSet2, HashMap hashMap) {
        for (ClassDescriptor classDescriptor : this.getSession().getDescriptors().values()) {
            String string;
            TableDefinition tableDefinition;
            if (!classDescriptor.usesSequenceNumbers()) continue;
            String string2 = classDescriptor.getSequenceNumberName();
            if (string2 == null) {
                string2 = this.getSession().getDatasourcePlatform().getDefaultSequence().getName();
            }
            if (hashSet2.contains(string2)) continue;
            hashSet2.add(string2);
            Sequence sequence = this.getSession().getDatasourcePlatform().getSequence(string2);
            SequenceDefinition sequenceDefinition = this.buildSequenceDefinition(sequence);
            if (sequenceDefinition == null) continue;
            hashSet.add(sequenceDefinition);
            TableDefinition tableDefinition2 = sequenceDefinition.buildTableDefinition();
            if (tableDefinition2 == null || (tableDefinition = (TableDefinition)hashMap.get(string = tableDefinition2.getName())) != null) continue;
            hashMap.put(string, tableDefinition2);
        }
    }

    private void processTableDefinitions(HashMap hashMap, boolean bl) throws EclipseLinkException {
        Iterator iterator = hashMap.values().iterator();
        boolean bl2 = this.session.getSessionLog().shouldLogExceptionStackTrace();
        while (iterator.hasNext()) {
            TableDefinition tableDefinition = (TableDefinition)iterator.next();
            this.processDatabaseObjectDefinition(tableDefinition, bl, bl2);
        }
    }

    private void processSequenceDefinitions(HashSet hashSet, boolean bl) throws EclipseLinkException {
        boolean bl2 = this.session.getSessionLog().shouldLogExceptionStackTrace();
        for (SequenceDefinition sequenceDefinition : hashSet) {
            this.processDatabaseObjectDefinition(sequenceDefinition, bl, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDatabaseObjectDefinition(DatabaseObjectDefinition databaseObjectDefinition, boolean bl, boolean bl2) throws EclipseLinkException {
        if (bl2) {
            this.session.getSessionLog().setShouldLogExceptionStackTrace(false);
        }
        if (bl) {
            try {
                this.createObject(databaseObjectDefinition);
            }
            catch (DatabaseException databaseException) {
            }
            finally {
                if (bl2) {
                    this.session.getSessionLog().setShouldLogExceptionStackTrace(true);
                }
            }
        } else {
            try {
                this.dropObject(databaseObjectDefinition);
            }
            catch (DatabaseException databaseException) {
            }
            finally {
                if (bl2) {
                    this.session.getSessionLog().setShouldLogExceptionStackTrace(true);
                }
            }
            this.createObject(databaseObjectDefinition);
        }
    }

    protected SequenceDefinition buildSequenceDefinition(Sequence sequence) {
        if (sequence.shouldAcquireValueAfterInsert()) {
            return null;
        }
        if (sequence instanceof TableSequence || sequence instanceof DefaultSequence && ((DefaultSequence)sequence).getDefaultSequence() instanceof TableSequence) {
            return new TableSequenceDefinition(sequence);
        }
        if (sequence instanceof UnaryTableSequence || sequence instanceof DefaultSequence && ((DefaultSequence)sequence).getDefaultSequence() instanceof UnaryTableSequence) {
            return new UnaryTableSequenceDefinition(sequence);
        }
        if (sequence instanceof NativeSequence || sequence instanceof DefaultSequence && ((DefaultSequence)sequence).getDefaultSequence() instanceof NativeSequence) {
            return new SequenceObjectDefinition(sequence);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropConstraints(TableDefinition tableDefinition) throws EclipseLinkException {
        boolean bl = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            bl = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                tableDefinition.dropConstraintsOnDatabase(this.getSession());
            } else {
                tableDefinition.setCreateSQLFiles(this.createSQLFiles);
                tableDefinition.dropConstraints(this.getSession(), this.getDropSchemaWriter());
            }
        }
        finally {
            if (bl) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropObject(DatabaseObjectDefinition databaseObjectDefinition) throws EclipseLinkException {
        boolean bl = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            bl = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                databaseObjectDefinition.dropFromDatabase(this.getSession());
            } else {
                Writer writer = this.getDropSchemaWriter();
                databaseObjectDefinition.dropObject(this.getSession(), writer);
                if (this.createSQLFiles) {
                    this.appendToDDLWriter(writer, this.getSession().getPlatform().getStoredProcedureTerminationToken());
                }
                this.appendToDDLWriter(writer, "\n");
            }
        }
        finally {
            if (bl) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    public void dropTable(String string) throws EclipseLinkException {
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(string);
        this.dropObject(tableDefinition);
    }

    public void finalize() {
        try {
            this.closeDDLWriter();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void generateStoredProcedures() throws EclipseLinkException {
        new StoredProcedureGenerator(this).generateStoredProcedures();
    }

    public void generateStoredProcedures(Writer writer) throws EclipseLinkException {
        new StoredProcedureGenerator(this).generateStoredProcedures(writer);
    }

    public void generateStoredProceduresAndAmendmentClass(Writer writer, String string) throws EclipseLinkException {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        String string3 = string.substring(0, string.lastIndexOf(46));
        StoredProcedureGenerator storedProcedureGenerator = new StoredProcedureGenerator(this);
        storedProcedureGenerator.generateStoredProcedures();
        storedProcedureGenerator.generateAmendmentClass(writer, string3, string2);
    }

    public void generateStoredProceduresAndAmendmentClass(String string, String string2) throws EclipseLinkException {
        try {
            StoredProcedureGenerator storedProcedureGenerator = new StoredProcedureGenerator(this);
            if (!string.endsWith("\\") && !string.endsWith("/")) {
                string = string + "\\";
            }
            String string3 = string2.substring(string2.lastIndexOf(46) + 1);
            String string4 = string2.substring(0, string2.lastIndexOf(46));
            String string5 = string + string3 + ".java";
            FileWriter fileWriter = new FileWriter(string5);
            storedProcedureGenerator.generateStoredProcedures();
            storedProcedureGenerator.generateAmendmentClass(fileWriter, string4, string3);
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    protected DatabaseAccessor getAccessor() {
        return (DatabaseAccessor)this.getSession().getAccessor();
    }

    public Vector getAllColumnNames(String string) throws DatabaseException {
        return this.getAccessor().getColumnInfo(null, null, string, null, this.getSession());
    }

    public Vector getAllColumnNames(String string, String string2) throws DatabaseException {
        return this.getAccessor().getColumnInfo(null, string, string2, null, this.getSession());
    }

    public Vector getAllTableNames() throws DatabaseException {
        return this.getAccessor().getTableInfo(null, null, null, null, this.getSession());
    }

    public Vector getAllTableNames(String string) throws DatabaseException {
        return this.getAccessor().getTableInfo(null, string, null, null, this.getSession());
    }

    public Vector getColumnInfo(String string, String string2, String string3, String string4) throws DatabaseException {
        return this.getAccessor().getColumnInfo(string, string2, string3, string4, this.getSession());
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public Vector getTableInfo(String string, String string2, String string3, String[] stringArray) throws DatabaseException {
        return this.getAccessor().getTableInfo(string, string2, string3, stringArray, this.getSession());
    }

    public void outputDDLToDatabase() {
        this.createSchemaWriter = null;
        this.dropSchemaWriter = null;
    }

    public void outputDDLToFile(String string) {
        try {
            this.createSchemaWriter = new FileWriter(string);
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void outputCreateDDLToFile(String string) {
        try {
            this.createSchemaWriter = new FileWriter(string);
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void outputDropDDLToFile(String string) {
        try {
            this.dropSchemaWriter = new FileWriter(string);
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void outputDDLToWriter(Writer writer) {
        this.createSchemaWriter = writer;
    }

    public void outputCreateDDLToWriter(Writer writer) {
        this.createSchemaWriter = writer;
    }

    public void outputDropDDLToWriter(Writer writer) {
        this.dropSchemaWriter = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceObject(DatabaseObjectDefinition databaseObjectDefinition) throws EclipseLinkException {
        boolean bl = FAST_TABLE_CREATOR;
        if (bl && databaseObjectDefinition instanceof TableDefinition) {
            this.session.executeNonSelectingSQL("DELETE FROM " + databaseObjectDefinition.getName());
        } else {
            boolean bl2 = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
            if (bl2) {
                this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
            }
            try {
                this.dropObject(databaseObjectDefinition);
            }
            catch (DatabaseException databaseException) {
            }
            finally {
                if (bl2) {
                    this.getSession().getSessionLog().setShouldLogExceptionStackTrace(true);
                }
            }
            this.createObject(databaseObjectDefinition);
        }
    }

    protected TableCreator getDefaultTableCreator(boolean bl) {
        if (this.defaultTableCreator == null) {
            this.defaultTableCreator = new DefaultTableGenerator(this.session.getProject(), bl).generateDefaultTableCreator();
            this.defaultTableCreator.setIgnoreDatabaseException(true);
        }
        return this.defaultTableCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultTables(boolean bl) {
        boolean bl2 = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
        this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
        try {
            TableCreator tableCreator = this.getDefaultTableCreator(bl);
            tableCreator.createTables(this.session, this);
        }
        catch (DatabaseException databaseException) {
        }
        finally {
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDefaultTables() throws EclipseLinkException {
        boolean bl = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
        this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
        try {
            TableCreator tableCreator = this.getDefaultTableCreator(true);
            tableCreator.replaceTables(this.session, this);
        }
        catch (DatabaseException databaseException) {
        }
        finally {
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDefaultTables(boolean bl, boolean bl2) throws EclipseLinkException {
        boolean bl3 = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
        this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
        try {
            TableCreator tableCreator = this.getDefaultTableCreator(bl2);
            tableCreator.replaceTables(this.session, this, bl);
        }
        catch (DatabaseException databaseException) {
        }
        finally {
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(bl3);
        }
    }

    public void setSession(DatabaseSessionImpl databaseSessionImpl) {
        this.session = databaseSessionImpl;
    }

    public boolean shouldWriteToDatabase() {
        return this.createSchemaWriter == null && this.dropSchemaWriter == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterSequence(SequenceDefinition sequenceDefinition) throws EclipseLinkException {
        if (!sequenceDefinition.isAlterSupported(this.getSession())) {
            return;
        }
        boolean bl = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            bl = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                sequenceDefinition.alterOnDatabase(this.getSession());
            } else {
                sequenceDefinition.alter(this.getSession(), this.createSchemaWriter);
            }
        }
        finally {
            if (bl) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }
}

