/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TableCreator {
    protected Vector tableDefinitions;
    protected String name;
    protected boolean ignoreDatabaseException;

    public TableCreator() {
        this(new Vector());
    }

    public TableCreator(Vector vector) {
        this.tableDefinitions = vector;
    }

    public void addTableDefinition(TableDefinition tableDefinition) {
        this.tableDefinitions.addElement(tableDefinition);
    }

    public void addTableDefinitions(Collection collection) {
        this.tableDefinitions.addAll(collection);
    }

    public void createConstraints(DatabaseSession databaseSession) {
        this.createConstraints(databaseSession, new SchemaManager(databaseSession));
    }

    public void createConstraints(DatabaseSession databaseSession, SchemaManager schemaManager) {
        Enumeration enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)enumeration.nextElement());
        }
        enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            try {
                schemaManager.createUniqueConstraints((TableDefinition)enumeration.nextElement());
            }
            catch (DatabaseException databaseException) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw databaseException;
            }
        }
        enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            try {
                schemaManager.createForeignConstraints((TableDefinition)enumeration.nextElement());
            }
            catch (DatabaseException databaseException) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw databaseException;
            }
        }
    }

    public void createTables(DatabaseSession databaseSession) {
        this.createTables(databaseSession, new SchemaManager(databaseSession));
    }

    public void createTables(DatabaseSession databaseSession, SchemaManager schemaManager) {
        Object object = this.getTableDefinitions().elements();
        while (object.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)object.nextElement());
        }
        object = this.getSequenceTableName(databaseSession);
        Enumeration enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            TableDefinition tableDefinition = (TableDefinition)enumeration.nextElement();
            if (tableDefinition.getName().equals(object)) continue;
            try {
                schemaManager.createObject(tableDefinition);
                databaseSession.getSessionLog().log(1, "default_tables_created", tableDefinition.getFullName());
            }
            catch (DatabaseException databaseException) {
                databaseSession.getSessionLog().log(1, "default_tables_already_existed", tableDefinition.getFullName());
                if (this.shouldIgnoreDatabaseException()) continue;
                throw databaseException;
            }
        }
        enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            try {
                schemaManager.createUniqueConstraints((TableDefinition)enumeration.nextElement());
            }
            catch (DatabaseException databaseException) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw databaseException;
            }
        }
        enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            try {
                schemaManager.createForeignConstraints((TableDefinition)enumeration.nextElement());
            }
            catch (DatabaseException databaseException) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw databaseException;
            }
        }
        schemaManager.createSequences();
    }

    public void dropConstraints(DatabaseSession databaseSession) {
        this.dropConstraints(databaseSession, new SchemaManager(databaseSession));
    }

    public void dropConstraints(DatabaseSession databaseSession, SchemaManager schemaManager) {
        Enumeration enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)enumeration.nextElement());
        }
        enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            try {
                schemaManager.dropConstraints((TableDefinition)enumeration.nextElement());
            }
            catch (DatabaseException databaseException) {}
        }
    }

    public void dropTables(DatabaseSession databaseSession) {
        this.dropTables(databaseSession, new SchemaManager(databaseSession));
    }

    public void dropTables(DatabaseSession databaseSession, SchemaManager schemaManager) {
        Object object = this.getTableDefinitions().elements();
        while (object.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)object.nextElement());
        }
        object = this.getTableDefinitions().elements();
        while (object.hasMoreElements()) {
            try {
                schemaManager.dropConstraints((TableDefinition)object.nextElement());
            }
            catch (DatabaseException databaseException) {}
        }
        object = this.getSequenceTableName(databaseSession);
        Enumeration enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            TableDefinition tableDefinition = (TableDefinition)enumeration.nextElement();
            if (tableDefinition.getName().equals(object)) continue;
            try {
                schemaManager.dropObject(tableDefinition);
            }
            catch (DatabaseException databaseException) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw databaseException;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Vector getTableDefinitions() {
        return this.tableDefinitions;
    }

    public void replaceTables(DatabaseSession databaseSession) {
        this.replaceTables(databaseSession, new SchemaManager(databaseSession));
    }

    public void replaceTables(DatabaseSession databaseSession, SchemaManager schemaManager) {
        this.replaceTablesAndConstraints(schemaManager, databaseSession);
        schemaManager.createSequences();
    }

    public void replaceTables(DatabaseSession databaseSession, SchemaManager schemaManager, boolean bl) {
        this.replaceTablesAndConstraints(schemaManager, databaseSession);
        schemaManager.createOrReplaceSequences(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceTablesAndConstraints(SchemaManager schemaManager, DatabaseSession databaseSession) {
        Object object;
        Enumeration enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)enumeration.nextElement());
        }
        boolean bl = databaseSession.getSessionLog().shouldLogExceptionStackTrace();
        if (bl) {
            databaseSession.getSessionLog().setShouldLogExceptionStackTrace(false);
        }
        try {
            object = this.getTableDefinitions().elements();
            while (object.hasMoreElements()) {
                try {
                    schemaManager.dropConstraints((TableDefinition)object.nextElement());
                }
                catch (DatabaseException databaseException) {}
            }
        }
        finally {
            if (bl) {
                databaseSession.getSessionLog().setShouldLogExceptionStackTrace(true);
            }
        }
        object = this.getSequenceTableName(databaseSession);
        Enumeration enumeration2 = this.getTableDefinitions().elements();
        while (enumeration2.hasMoreElements()) {
            TableDefinition tableDefinition = (TableDefinition)enumeration2.nextElement();
            if (tableDefinition.getName().equals(object)) continue;
            try {
                schemaManager.replaceObject(tableDefinition);
            }
            catch (DatabaseException databaseException) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw databaseException;
            }
        }
        enumeration2 = this.getTableDefinitions().elements();
        while (enumeration2.hasMoreElements()) {
            try {
                schemaManager.createUniqueConstraints((TableDefinition)enumeration2.nextElement());
            }
            catch (DatabaseException databaseException) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw databaseException;
            }
        }
        enumeration2 = this.getTableDefinitions().elements();
        while (enumeration2.hasMoreElements()) {
            try {
                schemaManager.createForeignConstraints((TableDefinition)enumeration2.nextElement());
            }
            catch (DatabaseException databaseException) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw databaseException;
            }
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setTableDefinitions(Vector vector) {
        this.tableDefinitions = vector;
    }

    boolean shouldIgnoreDatabaseException() {
        return this.ignoreDatabaseException;
    }

    void setIgnoreDatabaseException(boolean bl) {
        this.ignoreDatabaseException = bl;
    }

    protected String getSequenceTableName(Session session) {
        Sequence sequence;
        String string = null;
        if (session.getProject().usesSequencing() && (sequence = session.getLogin().getDefaultSequence()) instanceof TableSequence) {
            string = ((TableSequence)sequence).getTableName();
        }
        return string;
    }
}

