/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dbws;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.dbws.DBWSAdapter;
import org.eclipse.persistence.internal.dbws.SOAPAttachmentHandler;
import org.eclipse.persistence.internal.dbws.SOAPResponse;
import org.eclipse.persistence.internal.dbws.SOAPResponseClassLoader;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentMarshaller;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.w3c.dom.Node;

public class SOAPResponseWriter {
    protected DBWSAdapter dbwsAdapter;
    protected Map<String, XMLDescriptor> resultDescriptors = new HashMap<String, XMLDescriptor>();
    protected MessageFactory messageFactory;

    public SOAPResponseWriter(DBWSAdapter dBWSAdapter) {
        this.dbwsAdapter = dBWSAdapter;
        try {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            throw new RuntimeException(sOAPException);
        }
    }

    public void initialize() {
        SOAPResponseClassLoader sOAPResponseClassLoader = new SOAPResponseClassLoader(Thread.currentThread().getContextClassLoader());
        NamespaceResolver namespaceResolver = new NamespaceResolver();
        namespaceResolver.put("srvc", this.dbwsAdapter.getExtendedSchema().getTargetNamespace());
        for (Operation operation : this.dbwsAdapter.getOperationsList()) {
            String string = operation.getName() + "_Response";
            Class<?> clazz = sOAPResponseClassLoader.buildClass(string);
            XMLDescriptor xMLDescriptor = new XMLDescriptor();
            xMLDescriptor.setNamespaceResolver(namespaceResolver);
            xMLDescriptor.setJavaClass(clazz);
            xMLDescriptor.setDefaultRootElement("srvc:" + operation.getName() + "Response");
            if (operation instanceof QueryOperation) {
                Object object;
                Object object2;
                QueryOperation queryOperation = (QueryOperation)operation;
                if (queryOperation.isSimpleXMLFormat()) {
                    object2 = new XMLAnyObjectMapping();
                    object2.setUseXMLRoot(true);
                    object2.setAttributeName("result");
                    object2.setXPath("srvc:result");
                    xMLDescriptor.addMapping((DatabaseMapping)object2);
                    object2.initialize((AbstractSession)this.dbwsAdapter.getOXSession());
                } else if (queryOperation.isAttachment()) {
                    object2 = queryOperation.getResult().getAttachment();
                    object = new XMLBinaryDataMapping();
                    object.setAttributeName("result");
                    object.setXPath("srvc:result");
                    object.setSwaRef(true);
                    object.setShouldInlineBinaryData(false);
                    object.setMimeType(((Attachment)object2).getMimeType());
                    xMLDescriptor.addMapping((DatabaseMapping)object);
                } else {
                    Object object3;
                    object2 = queryOperation.getResult().getType();
                    object = null;
                    if (((QName)object2).getPrefix() != null && ((QName)object2).getPrefix().length() > 0) {
                        object = ((QName)object2).getPrefix() + ":";
                    }
                    String string2 = ((QName)object2).getLocalPart();
                    Set set = this.dbwsAdapter.getSchema().getTopLevelComplexTypes().entrySet();
                    XMLDescriptor xMLDescriptor2 = set.iterator();
                    while (xMLDescriptor2.hasNext()) {
                        object3 = xMLDescriptor2.next();
                        if (!((ComplexType)object3.getValue()).getName().equals(((QName)object2).getLocalPart())) continue;
                        string2 = (String)object3.getKey();
                        break;
                    }
                    if ((xMLDescriptor2 = this.dbwsAdapter.getDescriptorsByQName().get(object2)) != null) {
                        if (queryOperation.isCollection()) {
                            object3 = new XMLCompositeCollectionMapping();
                            object3.setAttributeName("result");
                            object3.setReferenceClass(xMLDescriptor2.getJavaClass());
                            object3.useCollectionClass(Vector.class);
                            object3.setXPath("srvc:result/" + (object == null ? string2 : (String)object + string2));
                            xMLDescriptor.addMapping((DatabaseMapping)object3);
                            object3.initialize((AbstractSession)this.dbwsAdapter.getOXSession());
                        } else {
                            object3 = new XMLCompositeObjectMapping();
                            object3.setAttributeName("result");
                            object3.setReferenceClass(xMLDescriptor2.getJavaClass());
                            object3.setXPath("srvc:result/" + (object == null ? string2 : (String)object + string2));
                            xMLDescriptor.addMapping((DatabaseMapping)object3);
                            object3.initialize((AbstractSession)this.dbwsAdapter.getOXSession());
                        }
                        object3 = xMLDescriptor2.getNamespaceResolver().getNamespaces();
                        Iterator iterator = object3.iterator();
                        while (iterator.hasNext()) {
                            Namespace namespace = (Namespace)iterator.next();
                            xMLDescriptor.getNamespaceResolver().put(namespace.getPrefix(), namespace.getNamespaceURI());
                        }
                    } else if (((QName)object2).equals(new QName("http://www.w3.org/2001/XMLSchema", "any"))) {
                        object3 = new XMLAnyObjectMapping();
                        object3.setAttributeName("result");
                        object3.setXPath("srvc:result");
                        xMLDescriptor.addMapping((DatabaseMapping)object3);
                    } else if (((QName)object2).equals(new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"))) {
                        object3 = new XMLBinaryDataMapping();
                        object3.setAttributeName("result");
                        object3.setXPath("srvc:result");
                        object3.setShouldInlineBinaryData(true);
                        ((XMLField)object3.getField()).setSchemaType((QName)object2);
                        xMLDescriptor.addMapping((DatabaseMapping)object3);
                    } else {
                        object3 = new XMLDirectMapping();
                        object3.setAttributeName("result");
                        object3.setXPath("srvc:result/text()");
                        xMLDescriptor.addMapping((DatabaseMapping)object3);
                    }
                }
            }
            this.dbwsAdapter.getOXSession().getProject().addDescriptor((ClassDescriptor)xMLDescriptor);
            ((DatabaseSessionImpl)this.dbwsAdapter.getOXSession()).initializeDescriptorIfSessionAlive((ClassDescriptor)xMLDescriptor);
            this.dbwsAdapter.getXMLContext().storeXMLDescriptorByQName(xMLDescriptor);
            this.resultDescriptors.put(operation.getName(), xMLDescriptor);
        }
    }

    public SOAPMessage generateResponse(Operation operation, EclipseLinkException eclipseLinkException) throws SOAPException {
        SOAPMessage sOAPMessage = this.messageFactory.createMessage();
        SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
        sOAPBody.addFault(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"), operation.getName() + " failed: " + eclipseLinkException.getMessage());
        return sOAPMessage;
    }

    public SOAPMessage generateResponse(Operation operation, Object object) throws SOAPException {
        SOAPMessage sOAPMessage = this.messageFactory.createMessage();
        SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
        XMLDescriptor xMLDescriptor = this.resultDescriptors.get(operation.getName());
        SOAPResponse sOAPResponse = null;
        try {
            sOAPResponse = (SOAPResponse)xMLDescriptor.getJavaClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new SOAPException((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SOAPException((Throwable)illegalAccessException);
        }
        sOAPResponse.setResult(object);
        SOAPAttachmentHandler sOAPAttachmentHandler = new SOAPAttachmentHandler();
        XMLMarshaller xMLMarshaller = this.dbwsAdapter.getXMLContext().createMarshaller();
        xMLMarshaller.setAttachmentMarshaller((XMLAttachmentMarshaller)sOAPAttachmentHandler);
        xMLMarshaller.marshal((Object)sOAPResponse, (Node)sOAPBody);
        if (sOAPAttachmentHandler.hasAttachments()) {
            for (String string : sOAPAttachmentHandler.getAttachments().keySet()) {
                DataHandler dataHandler = sOAPAttachmentHandler.getAttachments().get(string);
                AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart(dataHandler);
                attachmentPart.setContentType(dataHandler.getContentType());
                String string2 = "<" + string.substring(4) + ">";
                attachmentPart.setContentId(string2);
                attachmentPart.setMimeHeader("Content-Transfer-Encoding", "binary");
                sOAPMessage.addAttachmentPart(attachmentPart);
            }
        }
        return sOAPMessage;
    }
}

