/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.Table;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.DiscriminatorColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.inheritance.InheritanceMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityClassListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.SecondaryTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityAccessor
extends MappedSuperclassAccessor {
    private ArrayList<MappedSuperclassAccessor> m_mappedSuperclasses = new ArrayList();
    private DiscriminatorColumnMetadata m_discriminatorColumn;
    private InheritanceMetadata m_inheritance;
    private List<AssociationOverrideMetadata> m_associationOverrides = new ArrayList<AssociationOverrideMetadata>();
    private List<AttributeOverrideMetadata> m_attributeOverrides = new ArrayList<AttributeOverrideMetadata>();
    private List<NamedQueryMetadata> m_namedQueries = new ArrayList<NamedQueryMetadata>();
    private List<NamedNativeQueryMetadata> m_namedNativeQueries = new ArrayList<NamedNativeQueryMetadata>();
    private List<NamedStoredProcedureQueryMetadata> m_namedStoredProcedureQueries = new ArrayList<NamedStoredProcedureQueryMetadata>();
    private List<SQLResultSetMappingMetadata> m_sqlResultSetMappings = new ArrayList<SQLResultSetMappingMetadata>();
    private List<SecondaryTableMetadata> m_secondaryTables = new ArrayList<SecondaryTableMetadata>();
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();
    private SequenceGeneratorMetadata m_sequenceGenerator;
    private String m_discriminatorValue;
    private String m_entityName;
    private TableGeneratorMetadata m_tableGenerator;
    private TableMetadata m_table;

    public EntityAccessor() {
        super("<entity>");
    }

    public EntityAccessor(MetadataAnnotation annotation, MetadataClass cls, MetadataProject project) {
        super(annotation, cls, project);
    }

    protected void addMultipleTableKeyFields(PrimaryKeyJoinColumnsMetadata primaryKeyJoinColumns, DatabaseTable sourceTable, DatabaseTable targetTable, String PK_CTX, String FK_CTX) {
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn : this.processPrimaryKeyJoinColumns(primaryKeyJoinColumns)) {
            String defaultPKFieldName = this.getDescriptor().getPrimaryKeyFieldName();
            DatabaseField pkField = primaryKeyJoinColumn.getPrimaryKeyField();
            this.setFieldName(pkField, defaultPKFieldName, PK_CTX);
            pkField.setTable(sourceTable);
            DatabaseField fkField = primaryKeyJoinColumn.getForeignKeyField();
            this.setFieldName(fkField, pkField.getName(), FK_CTX);
            fkField.setTable(targetTable);
            this.getDescriptor().addForeignKeyFieldForMultipleTable(fkField, pkField);
        }
    }

    protected void addPotentialMappedSuperclass(MetadataClass metadataClass, boolean addMappedSuperclassAccessors) {
        MappedSuperclassAccessor accessor = this.getProject().getMappedSuperclass(metadataClass);
        if (accessor == null) {
            if (addMappedSuperclassAccessors && metadataClass.isAnnotationPresent(MappedSuperclass.class)) {
                this.m_mappedSuperclasses.add(new MappedSuperclassAccessor(metadataClass.getAnnotation(MappedSuperclass.class), metadataClass, this.getDescriptor()));
                MappedSuperclassAccessor msAccessor = new MappedSuperclassAccessor(metadataClass.getAnnotation(MappedSuperclass.class), metadataClass, this.getProject());
                this.getProject().addMetamodelMappedSuperclass(metadataClass, msAccessor);
            }
        } else if (addMappedSuperclassAccessors) {
            MappedSuperclassAccessor msAccessor = this.reloadMappedSuperclass(accessor, this.getDescriptor());
            this.m_mappedSuperclasses.add(msAccessor);
            this.getProject().addMetamodelMappedSuperclass(metadataClass, this.reloadMappedSuperclass(accessor, new MetadataDescriptor(metadataClass)));
        } else {
            this.m_mappedSuperclasses.add(accessor);
        }
    }

    protected void clearMappedSuperclassesAndInheritanceParents() {
        if (!this.m_mappedSuperclasses.isEmpty()) {
            this.m_mappedSuperclasses.clear();
        }
        this.getDescriptor().setInheritanceParentDescriptor(null);
        this.getDescriptor().setInheritanceRootDescriptor(null);
    }

    protected void discoverMappedSuperclassesAndInheritanceParents(boolean addMappedSuperclassAccessors) {
        MetadataClass parent;
        this.clearMappedSuperclassesAndInheritanceParents();
        EntityAccessor currentAccessor = this;
        List<String> genericTypes = this.getJavaClass().getGenericType();
        ArrayList<EntityAccessor> subclassAccessors = new ArrayList<EntityAccessor>();
        subclassAccessors.add(currentAccessor);
        if (parent != null && !parent.isObject()) {
            for (parent = this.getJavaClass().getSuperclass(); parent != null && !parent.isObject(); parent = parent.getSuperclass()) {
                EntityAccessor parentAccessor = this.getProject().getEntityAccessor(parent.getName());
                if (parentAccessor != null) {
                    currentAccessor.getDescriptor().setInheritanceParentDescriptor(parentAccessor.getDescriptor());
                    currentAccessor = parentAccessor;
                    currentAccessor.clearMappedSuperclassesAndInheritanceParents();
                    if (currentAccessor.hasInheritance()) {
                        for (EntityAccessor subclassAccessor : subclassAccessors) {
                            subclassAccessor.getDescriptor().setInheritanceRootDescriptor(currentAccessor.getDescriptor());
                        }
                        subclassAccessors.clear();
                    }
                    subclassAccessors.add(currentAccessor);
                    currentAccessor.resolveGenericTypes(genericTypes, parent);
                } else {
                    currentAccessor.addPotentialMappedSuperclass(parent, addMappedSuperclassAccessors);
                    currentAccessor.resolveGenericTypes(genericTypes, parent);
                }
                genericTypes = parent.getGenericType();
            }
        } else {
            currentAccessor.resolveGenericTypes(genericTypes, parent);
        }
        if (!subclassAccessors.isEmpty()) {
            for (EntityAccessor subclassAccessor : subclassAccessors) {
                if (subclassAccessor == currentAccessor) continue;
                subclassAccessor.getDescriptor().setInheritanceRootDescriptor(currentAccessor.getDescriptor());
            }
        }
    }

    public List<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    public DiscriminatorColumnMetadata getDiscriminatorColumn() {
        return this.m_discriminatorColumn;
    }

    public String getDiscriminatorValue() {
        return this.m_discriminatorValue;
    }

    public String getDiscriminatorValueOrNull() {
        if (!Modifier.isAbstract(this.getJavaClass().getModifiers())) {
            if (this.m_discriminatorValue == null) {
                MetadataAnnotation discriminatorValue = this.getAnnotation(DiscriminatorValue.class);
                if (discriminatorValue == null) {
                    return Helper.getShortClassName(this.getJavaClassName());
                }
                return (String)discriminatorValue.getAttribute("value");
            }
            return this.m_discriminatorValue;
        }
        return null;
    }

    public String getEntityName() {
        return this.m_entityName;
    }

    public InheritanceMetadata getInheritance() {
        return this.m_inheritance;
    }

    public ArrayList<MappedSuperclassAccessor> getMappedSuperclasses() {
        return this.m_mappedSuperclasses;
    }

    public List<NamedNativeQueryMetadata> getNamedNativeQueries() {
        return this.m_namedNativeQueries;
    }

    public List<NamedQueryMetadata> getNamedQueries() {
        return this.m_namedQueries;
    }

    public List<NamedStoredProcedureQueryMetadata> getNamedStoredProcedureQueries() {
        return this.m_namedStoredProcedureQueries;
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    public List<SecondaryTableMetadata> getSecondaryTables() {
        return this.m_secondaryTables;
    }

    public SequenceGeneratorMetadata getSequenceGenerator() {
        return this.m_sequenceGenerator;
    }

    public List<SQLResultSetMappingMetadata> getSqlResultSetMappings() {
        return this.m_sqlResultSetMappings;
    }

    public TableMetadata getTable() {
        return this.m_table;
    }

    public TableGeneratorMetadata getTableGenerator() {
        return this.m_tableGenerator;
    }

    public boolean hasInheritance() {
        if (this.m_inheritance == null) {
            return this.isAnnotationPresent(Inheritance.class);
        }
        return true;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_inheritance, accessibleObject);
        this.initXMLObject(this.m_discriminatorColumn, accessibleObject);
        this.initXMLObject(this.m_sequenceGenerator, accessibleObject);
        this.initXMLObject(this.m_tableGenerator, accessibleObject);
        this.initXMLObject(this.m_table, accessibleObject);
        this.initXMLObjects(this.m_associationOverrides, accessibleObject);
        this.initXMLObjects(this.m_attributeOverrides, accessibleObject);
        this.initXMLObjects(this.m_namedQueries, accessibleObject);
        this.initXMLObjects(this.m_namedNativeQueries, accessibleObject);
        this.initXMLObjects(this.m_namedStoredProcedureQueries, accessibleObject);
        this.initXMLObjects(this.m_sqlResultSetMappings, accessibleObject);
        this.initXMLObjects(this.m_secondaryTables, accessibleObject);
        this.initXMLObjects(this.m_primaryKeyJoinColumns, accessibleObject);
    }

    @Override
    public boolean isEntityAccessor() {
        return true;
    }

    @Override
    public boolean isMappedSuperclass() {
        return false;
    }

    @Override
    public void merge(ORMetadata metadata) {
        super.merge(metadata);
        EntityAccessor accessor = (EntityAccessor)metadata;
        this.m_entityName = (String)this.mergeSimpleObjects(this.m_entityName, accessor.getEntityName(), accessor, "@name");
        this.m_discriminatorValue = (String)this.mergeSimpleObjects(this.m_discriminatorValue, accessor.getDiscriminatorValue(), accessor, "<discriminator-value>");
        this.m_discriminatorColumn = (DiscriminatorColumnMetadata)this.mergeORObjects(this.m_discriminatorColumn, accessor.getDiscriminatorColumn());
        this.m_inheritance = (InheritanceMetadata)this.mergeORObjects(this.m_inheritance, accessor.getInheritance());
        this.m_sequenceGenerator = (SequenceGeneratorMetadata)this.mergeORObjects(this.m_sequenceGenerator, accessor.getSequenceGenerator());
        this.m_tableGenerator = (TableGeneratorMetadata)this.mergeORObjects(this.m_tableGenerator, accessor.getTableGenerator());
        this.m_table = (TableMetadata)this.mergeORObjects(this.m_table, accessor.getTable());
        this.m_namedQueries = this.mergeORObjectLists(this.m_namedQueries, accessor.getNamedQueries());
        this.m_namedNativeQueries = this.mergeORObjectLists(this.m_namedNativeQueries, accessor.getNamedNativeQueries());
        this.m_namedStoredProcedureQueries = this.mergeORObjectLists(this.m_namedStoredProcedureQueries, accessor.getNamedStoredProcedureQueries());
        this.m_sqlResultSetMappings = this.mergeORObjectLists(this.m_sqlResultSetMappings, accessor.getSqlResultSetMappings());
        this.m_associationOverrides = this.mergeORObjectLists(this.m_associationOverrides, accessor.getAssociationOverrides());
        this.m_attributeOverrides = this.mergeORObjectLists(this.m_attributeOverrides, accessor.getAttributeOverrides());
        this.m_secondaryTables = this.mergeORObjectLists(this.m_secondaryTables, accessor.getSecondaryTables());
        this.m_primaryKeyJoinColumns = this.mergeORObjectLists(this.m_primaryKeyJoinColumns, accessor.getPrimaryKeyJoinColumns());
    }

    @Override
    public void preProcess() {
        this.preProcess(true);
    }

    public void preProcess(boolean addMappedSuperclassAccessors) {
        EntityAccessor parentAccessor;
        this.setIsPreProcessed();
        if (!this.getDescriptor().isInheritanceSubclass()) {
            this.discoverMappedSuperclassesAndInheritanceParents(addMappedSuperclassAccessors);
        }
        if (this.getDescriptor().isInheritanceSubclass() && !(parentAccessor = (EntityAccessor)this.getDescriptor().getInheritanceParentDescriptor().getClassAccessor()).isPreProcessed()) {
            parentAccessor.preProcess(addMappedSuperclassAccessors);
        }
        this.processAccessType();
        this.processMetadataComplete();
        this.processExcludeDefaultMappings();
        this.initIdClass();
        this.processCacheable();
        if (addMappedSuperclassAccessors) {
            for (MappedSuperclassAccessor mappedSuperclass : this.m_mappedSuperclasses) {
                mappedSuperclass.preProcess();
            }
        }
        this.addAccessors();
        this.addConverters();
    }

    @Override
    public void preProcessForCanonicalModel() {
        this.preProcess(false);
    }

    @Override
    public void process() {
        ClassAccessor parentAccessor;
        this.setIsProcessed();
        this.processEntity();
        if (this.getDescriptor().isInheritanceSubclass() && !(parentAccessor = this.getDescriptor().getInheritanceParentDescriptor().getClassAccessor()).isProcessed()) {
            parentAccessor.process();
        }
        this.processTableAndInheritance();
        this.processClassMetadata();
        for (MappedSuperclassAccessor mappedSuperclass : this.m_mappedSuperclasses) {
            mappedSuperclass.process();
        }
        this.processAccessors();
    }

    @Override
    protected void processAssociationOverrides() {
        for (AssociationOverrideMetadata associationOverride : this.m_associationOverrides) {
            this.processAssociationOverride(associationOverride);
        }
        super.processAssociationOverrides();
    }

    @Override
    protected void processAttributeOverrides() {
        for (AttributeOverrideMetadata attributeOverride : this.m_attributeOverrides) {
            this.processAttributeOverride(attributeOverride);
        }
        super.processAttributeOverrides();
    }

    @Override
    protected void processCaching() {
        if (this.getProject().isCacheAll()) {
            if (this.getDescriptor().isCacheableFalse()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_cacheable_false", this.getJavaClass());
            }
            this.processCachingMetadata();
        } else if (this.getProject().isCacheNone()) {
            if (this.getDescriptor().isCacheableTrue()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_cacheable_true", this.getJavaClass());
            }
            this.getDescriptor().useNoCache();
        } else if (this.getProject().isCacheEnableSelective()) {
            if (this.getDescriptor().isCacheableTrue()) {
                this.processCachingMetadata();
            } else {
                this.getDescriptor().useNoCache();
            }
        } else if (this.getProject().isCacheDisableSelective()) {
            if (this.getDescriptor().isCacheableFalse()) {
                this.getDescriptor().useNoCache();
            } else {
                this.processCachingMetadata();
            }
        }
    }

    @Override
    public void processDerivedIDs(HashSet<ClassAccessor> processing, HashSet<ClassAccessor> processed) {
        if (this.hasDerivedId() && !processed.contains(this)) {
            super.processDerivedIDs(processing, processed);
            this.validatePrimaryKey();
            this.processSecondaryTables();
        }
    }

    public DatabaseField processDiscriminatorColumn() {
        MetadataAnnotation discriminatorColumn = this.getAnnotation(DiscriminatorColumn.class);
        if (this.m_discriminatorColumn == null) {
            this.m_discriminatorColumn = new DiscriminatorColumnMetadata(discriminatorColumn, this.getAccessibleObject());
        } else if (this.isAnnotationPresent(DiscriminatorColumn.class)) {
            this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", discriminatorColumn, this.getJavaClassName(), this.getLocation());
        }
        return this.m_discriminatorColumn.process(this.getDescriptor(), this.getAnnotatedElementName(), "metadata_default_inheritance_discriminator_column");
    }

    @Override
    public void processAccessors() {
        super.processAccessors();
        this.validateOptimisticLocking();
        if (!this.hasDerivedId()) {
            this.validatePrimaryKey();
            this.processSecondaryTables();
        }
    }

    @Override
    public void processAccessType() {
        String explicitAccessType = this.getAccess();
        String defaultAccessType = null;
        if (this.getDescriptor().isInheritanceSubclass()) {
            for (MetadataDescriptor parent = this.getDescriptor().getInheritanceParentDescriptor(); parent != null; parent = parent.getInheritanceParentDescriptor()) {
                if (parent.getClassAccessor().hasAccess()) continue;
                defaultAccessType = parent.getDefaultAccess();
                break;
            }
        }
        if (defaultAccessType == null) {
            for (MappedSuperclassAccessor mappedSuperclass : this.m_mappedSuperclasses) {
                if (mappedSuperclass.hasAccess()) continue;
                if (this.havePersistenceFieldAnnotationsDefined(mappedSuperclass.getJavaClass().getFields().values())) {
                    defaultAccessType = "FIELD";
                    break;
                }
                if (!this.havePersistenceMethodAnnotationsDefined(mappedSuperclass.getJavaClass().getMethods().values())) break;
                defaultAccessType = "PROPERTY";
                break;
            }
            if (defaultAccessType == null) {
                defaultAccessType = this.havePersistenceFieldAnnotationsDefined(this.getJavaClass().getFields().values()) ? "FIELD" : (this.havePersistenceMethodAnnotationsDefined(this.getJavaClass().getMethods().values()) ? "PROPERTY" : (this.getDescriptor().getDefaultAccess() != null ? this.getDescriptor().getDefaultAccess() : "FIELD"));
            }
        }
        this.getDescriptor().setDefaultAccess(defaultAccessType);
        if (explicitAccessType == null) {
            this.getLogger().logConfigMessage("metadata_access_type", defaultAccessType, (Object)this.getJavaClass());
        }
    }

    protected void processEntity() {
        if (this.m_entityName == null) {
            String string = this.m_entityName = this.getAnnotation(Entity.class) == null ? "" : (String)this.getAnnotation(Entity.class).getAttributeString("name");
        }
        if (this.m_entityName.equals("")) {
            this.m_entityName = Helper.getShortClassName(this.getJavaClassName());
            this.getLogger().logConfigMessage("metadata_default_alias", this.getDescriptor(), (Object)this.m_entityName);
        }
        this.getProject().addAlias(this.m_entityName, this.getDescriptor());
    }

    protected void processExcludeDefaultMappings() {
        if (this.getExcludeDefaultMappings() != null) {
            this.getDescriptor().setIgnoreDefaultMappings(this.excludeDefaultMappings());
        } else {
            for (MappedSuperclassAccessor mappedSuperclass : this.m_mappedSuperclasses) {
                if (mappedSuperclass.getExcludeDefaultMappings() == null) continue;
                this.getDescriptor().setIgnoreDefaultMappings(mappedSuperclass.excludeDefaultMappings());
                break;
            }
        }
    }

    protected void processInheritance() {
        if (this.m_inheritance == null) {
            this.m_inheritance = new InheritanceMetadata(this.getAnnotation(Inheritance.class), this.getAccessibleObject());
        }
        this.m_inheritance.process(this.getDescriptor());
    }

    public void processInheritancePrimaryKeyJoinColumns() {
        PrimaryKeyJoinColumnsMetadata pkJoinColumns;
        if (this.m_primaryKeyJoinColumns.isEmpty()) {
            MetadataAnnotation primaryKeyJoinColumn = this.getAnnotation(PrimaryKeyJoinColumn.class);
            MetadataAnnotation primaryKeyJoinColumns = this.getAnnotation(PrimaryKeyJoinColumns.class);
            pkJoinColumns = new PrimaryKeyJoinColumnsMetadata(primaryKeyJoinColumns, primaryKeyJoinColumn, this.getAccessibleObject());
        } else {
            pkJoinColumns = new PrimaryKeyJoinColumnsMetadata(this.m_primaryKeyJoinColumns);
        }
        this.addMultipleTableKeyFields(pkJoinColumns, this.getDescriptor().getPrimaryKeyTable(), this.getDescriptor().getPrimaryTable(), "metadata_default_inheritance_pk_column", "metadata_default_inheritance_fk_column");
    }

    public void processListeners(ClassLoader loader) {
        for (EntityListenerMetadata defaultListener : this.getProject().getDefaultListeners()) {
            ((EntityListenerMetadata)defaultListener.clone()).process(this.getDescriptor(), loader, true);
        }
        this.discoverMappedSuperclassesAndInheritanceParents(true);
        if (!this.getDescriptor().excludeSuperclassListeners()) {
            int mappedSuperclassesSize = this.m_mappedSuperclasses.size();
            for (int i = mappedSuperclassesSize - 1; i >= 0; --i) {
                this.m_mappedSuperclasses.get(i).processEntityListeners(loader);
            }
        }
        this.processEntityListeners(loader);
        new EntityClassListenerMetadata(this).process(this.m_mappedSuperclasses, loader);
    }

    protected void processMetadataComplete() {
        if (this.getMetadataComplete() != null) {
            this.getDescriptor().setIgnoreAnnotations(this.isMetadataComplete());
        } else {
            for (MappedSuperclassAccessor mappedSuperclass : this.m_mappedSuperclasses) {
                if (mappedSuperclass.getMetadataComplete() == null) continue;
                this.getDescriptor().setIgnoreAnnotations(mappedSuperclass.isMetadataComplete());
                break;
            }
        }
    }

    @Override
    protected void processNamedNativeQueries() {
        for (NamedNativeQueryMetadata namedNativeQuery : this.m_namedNativeQueries) {
            this.getProject().addQuery(namedNativeQuery);
        }
        super.processNamedNativeQueries();
    }

    @Override
    protected void processNamedQueries() {
        for (NamedQueryMetadata namedQuery : this.m_namedQueries) {
            this.getProject().addQuery(namedQuery);
        }
        super.processNamedQueries();
    }

    @Override
    protected void processNamedStoredProcedureQueries() {
        for (NamedStoredProcedureQueryMetadata namedStoredProcedureQuery : this.m_namedStoredProcedureQueries) {
            this.getProject().addQuery(namedStoredProcedureQuery);
        }
        super.processNamedStoredProcedureQueries();
    }

    protected void processSecondaryTable(SecondaryTableMetadata secondaryTable) {
        this.processTable(secondaryTable, secondaryTable.getName());
        this.getDescriptor().addTable(secondaryTable.getDatabaseTable());
        this.addMultipleTableKeyFields(new PrimaryKeyJoinColumnsMetadata(secondaryTable.getPrimaryKeyJoinColumns()), this.getDescriptor().getPrimaryTable(), secondaryTable.getDatabaseTable(), "metadata_default_secondary_table_pk_column", "metadata_default_secondary_table_fk_column");
    }

    protected void processSecondaryTables() {
        block6: {
            MetadataAnnotation secondaryTables;
            MetadataAnnotation secondaryTable;
            block4: {
                block5: {
                    secondaryTable = this.getAnnotation(SecondaryTable.class);
                    secondaryTables = this.getAnnotation(SecondaryTables.class);
                    if (!this.m_secondaryTables.isEmpty()) break block4;
                    if (secondaryTables == null) break block5;
                    for (Object table : (Object[])secondaryTables.getAttributeArray("value")) {
                        this.processSecondaryTable(new SecondaryTableMetadata((MetadataAnnotation)table, this.getAccessibleObject()));
                    }
                    break block6;
                }
                if (secondaryTable == null) break block6;
                this.processSecondaryTable(new SecondaryTableMetadata(secondaryTable, this.getAccessibleObject()));
                break block6;
            }
            if (secondaryTable != null) {
                this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", secondaryTable, this.getJavaClassName(), this.getLocation());
            }
            if (secondaryTables != null) {
                this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", secondaryTables, this.getJavaClassName(), this.getLocation());
            }
            for (SecondaryTableMetadata table : this.m_secondaryTables) {
                this.processSecondaryTable(table);
            }
        }
    }

    @Override
    protected void processSequenceGenerator() {
        if (this.m_sequenceGenerator != null) {
            this.getProject().addSequenceGenerator(this.m_sequenceGenerator, this.getDescriptor().getDefaultCatalog(), this.getDescriptor().getDefaultSchema());
        }
        super.processSequenceGenerator();
    }

    @Override
    protected void processSqlResultSetMappings() {
        for (SQLResultSetMappingMetadata sqlResultSetMapping : this.m_sqlResultSetMappings) {
            this.getProject().addSQLResultSetMapping(sqlResultSetMapping);
        }
        super.processSqlResultSetMappings();
    }

    protected void processTable() {
        MetadataAnnotation table = this.getAnnotation(Table.class);
        if (this.m_table == null) {
            this.processTable(new TableMetadata(table, this.getAccessibleObject()));
        } else {
            if (table != null) {
                this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", table, this.getJavaClassName(), this.getLocation());
            }
            this.processTable(this.m_table);
        }
    }

    protected void processTable(TableMetadata table) {
        this.processTable(table, this.getDescriptor().getDefaultTableName());
        this.getDescriptor().setPrimaryTable(table.getDatabaseTable());
    }

    protected void processTableAndInheritance() {
        if (this.getDescriptor().isInheritanceSubclass()) {
            MetadataDescriptor rootDescriptor = this.getDescriptor().getInheritanceRootDescriptor();
            EntityAccessor rootAccessor = (EntityAccessor)rootDescriptor.getClassAccessor();
            if (!rootAccessor.hasInheritance()) {
                rootAccessor.processInheritance();
            }
            if (this.hasInheritance() || !rootDescriptor.usesSingleTableInheritanceStrategy()) {
                this.processTable();
            }
            if (this.hasInheritance()) {
                this.processInheritance();
            } else {
                rootAccessor.getInheritance().process(this.getDescriptor());
            }
        } else {
            this.processTable();
            if (this.hasInheritance()) {
                this.processInheritance();
            }
        }
    }

    @Override
    protected void processTableGenerator() {
        if (this.m_tableGenerator != null) {
            this.getProject().addTableGenerator(this.m_tableGenerator, this.getDescriptor().getDefaultCatalog(), this.getDescriptor().getDefaultSchema());
        }
        super.processTableGenerator();
    }

    protected void resolveGenericTypes(List<String> genericTypes, MetadataClass parent) {
        this.getMetadataFactory().resolveGenericTypes(this.getJavaClass(), genericTypes, parent, this.getDescriptor());
    }

    public void setAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides) {
        this.m_associationOverrides = associationOverrides;
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides) {
        this.m_attributeOverrides = attributeOverrides;
    }

    public void setDiscriminatorColumn(DiscriminatorColumnMetadata discriminatorColumn) {
        this.m_discriminatorColumn = discriminatorColumn;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.m_discriminatorValue = discriminatorValue;
    }

    public void setEntityName(String entityName) {
        this.m_entityName = entityName;
    }

    public void setInheritance(InheritanceMetadata inheritance) {
        this.m_inheritance = inheritance;
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns) {
        this.m_primaryKeyJoinColumns = primaryKeyJoinColumns;
    }

    public void setNamedNativeQueries(List<NamedNativeQueryMetadata> namedNativeQueries) {
        this.m_namedNativeQueries = namedNativeQueries;
    }

    public void setNamedQueries(List<NamedQueryMetadata> namedQueries) {
        this.m_namedQueries = namedQueries;
    }

    public void setNamedStoredProcedureQueries(List<NamedStoredProcedureQueryMetadata> namedStoredProcedureQueries) {
        this.m_namedStoredProcedureQueries = namedStoredProcedureQueries;
    }

    public void setSecondaryTables(List<SecondaryTableMetadata> secondaryTables) {
        this.m_secondaryTables = secondaryTables;
    }

    public void setSequenceGenerator(SequenceGeneratorMetadata sequenceGenerator) {
        this.m_sequenceGenerator = sequenceGenerator;
    }

    public void setSqlResultSetMappings(List<SQLResultSetMappingMetadata> sqlResultSetMappings) {
        this.m_sqlResultSetMappings = sqlResultSetMappings;
    }

    public void setTable(TableMetadata table) {
        this.m_table = table;
    }

    public void setTableGenerator(TableGeneratorMetadata tableGenerator) {
        this.m_tableGenerator = tableGenerator;
    }

    protected void validateOptimisticLocking() {
        if (this.getDescriptor().usesVersionColumnOptimisticLocking() && !this.getDescriptor().usesOptimisticLocking()) {
            throw ValidationException.optimisticLockingVersionElementNotSpecified(this.getJavaClass());
        }
    }

    protected void validatePrimaryKey() {
        if (this.getDescriptor().hasCompositePrimaryKey()) {
            if (this.getDescriptor().pkClassWasNotValidated()) {
                throw ValidationException.invalidCompositePKSpecification(this.getJavaClass(), this.getDescriptor().getPKClassName());
            }
        } else if (!this.getDescriptor().hasPrimaryKeyFields() && !this.getDescriptor().isInheritanceSubclass()) {
            throw ValidationException.noPrimaryKeyAnnotationsFound(this.getJavaClass());
        }
    }
}

