/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.CollectionAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EmbeddableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EntityTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ListAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MapAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MappedSuperclassTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.SetAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.SingularAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredField;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethod;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManagedTypeImpl<X>
extends TypeImpl<X>
implements ManagedType<X> {
    protected RelationalDescriptor descriptor;
    protected Map<String, Attribute<X, ?>> members;
    protected MetamodelImpl metamodel;

    protected ManagedTypeImpl(MetamodelImpl metamodel, RelationalDescriptor descriptor) {
        super(descriptor.getJavaClass());
        this.descriptor = descriptor;
        this.metamodel = metamodel;
        descriptor.setProperty(this.getClass().getName(), this);
    }

    @Override
    public Attribute<X, ?> getAttribute(String name) {
        if (!this.members.containsKey(name)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return this.members.get(name);
    }

    @Override
    public Set<Attribute<? super X, ?>> getAttributes() {
        return new LinkedHashSet(this.members.values());
    }

    @Override
    public CollectionAttribute<? super X, ?> getCollection(String name) {
        CollectionAttribute anAttribute = (CollectionAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    @Override
    public <E> CollectionAttribute<? super X, E> getCollection(String name, Class<E> elementType) {
        Attribute<X, ?> anAttribute = this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        this.verifyAttributeTypeAndReturnType(anAttribute, elementType, PluralAttribute.CollectionType.COLLECTION);
        return (CollectionAttribute)anAttribute;
    }

    @Override
    public Set<PluralAttribute<? super X, ?, ?>> getPluralAttributes() {
        Set<Attribute<X, ?>> allAttributes = this.getAttributes();
        LinkedHashSet pluralAttributes = new LinkedHashSet();
        for (Attribute<X, ?> anAttribute : allAttributes) {
            if (!anAttribute.isCollection()) continue;
            pluralAttributes.add((PluralAttribute)anAttribute);
        }
        return pluralAttributes;
    }

    protected Attribute<X, ?> getDeclaredAttribute(String name, boolean attributeKnownToExistOnLeafTarget) {
        Attribute<X, ?> anAttribute = this.getAttribute(name);
        ManagedTypeImpl aManagedSuperType = this.getManagedSuperType();
        if (null == aManagedSuperType) {
            return anAttribute;
        }
        boolean isDeclaredAboveLeaf = false;
        isDeclaredAboveLeaf = attributeKnownToExistOnLeafTarget ? aManagedSuperType.isAttributeDeclaredOnlyInLeafType(name, anAttribute) : aManagedSuperType.isAttributeDeclaredOnlyInLeafType(name);
        if (attributeKnownToExistOnLeafTarget && !isDeclaredAboveLeaf || !attributeKnownToExistOnLeafTarget && isDeclaredAboveLeaf) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_declared_attribute_not_present_but_is_on_superclass", new Object[]{name, this}));
        }
        return anAttribute;
    }

    @Override
    public Attribute<X, ?> getDeclaredAttribute(String name) {
        return this.getDeclaredAttribute(name, false);
    }

    @Override
    public Set<Attribute<X, ?>> getDeclaredAttributes() {
        LinkedHashSet allAttributes = new LinkedHashSet(this.members.values());
        LinkedHashSet declaredAttributes = new LinkedHashSet();
        for (Attribute attribute : allAttributes) {
            if (!this.isAttributeDeclaredOnlyInLeafType(attribute.getName())) continue;
            declaredAttributes.add(attribute);
        }
        return declaredAttributes;
    }

    @Override
    public CollectionAttribute<X, ?> getDeclaredCollection(String name) {
        CollectionAttribute<X, ?> anAttribute = this.getCollection(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public <E> CollectionAttribute<X, E> getDeclaredCollection(String name, Class<E> elementType) {
        CollectionAttribute<X, E> anAttribute = this.getCollection(name, elementType);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public Set<PluralAttribute<X, ?, ?>> getDeclaredPluralAttributes() {
        Set<PluralAttribute<X, ?, ?>> pluralAttributes = this.getPluralAttributes();
        LinkedHashSet declaredAttributes = new LinkedHashSet();
        for (PluralAttribute<X, ?, ?> anAttribute : pluralAttributes) {
            if (!((TypeImpl)anAttribute.getElementType()).isManagedType()) continue;
            ManagedTypeImpl potentialSuperType = this.getManagedSuperType();
            if (null == potentialSuperType) {
                declaredAttributes.add(anAttribute);
                continue;
            }
            if (potentialSuperType.isAttributeDeclaredOnlyInLeafType(anAttribute.getName())) continue;
            declaredAttributes.add(anAttribute);
        }
        return declaredAttributes;
    }

    protected static ManagedTypeImpl<?> create(MetamodelImpl metamodel, RelationalDescriptor descriptor) {
        ManagedTypeImpl managedType = (EntityTypeImpl)descriptor.getProperty(ManagedTypeImpl.class.getName());
        if (null == managedType) {
            if (descriptor.isDescriptorForInterface()) {
                managedType = new EntityTypeImpl(metamodel, descriptor);
            } else if (descriptor.isDescriptorTypeAggregate()) {
                if (descriptor.isAggregateDescriptor()) {
                    managedType = new EmbeddableTypeImpl(metamodel, descriptor);
                } else if (descriptor.isAggregateCollectionDescriptor()) {
                    managedType = new EmbeddableTypeImpl(metamodel, descriptor);
                }
            } else if (descriptor.isDescriptorTypeNormal()) {
                managedType = metamodel.hasMappedSuperclass(descriptor.getJavaClassName()) ? MappedSuperclassTypeImpl.create(metamodel, descriptor) : new EntityTypeImpl(metamodel, descriptor);
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_interface_inheritance_not_supported", new Object[]{descriptor, "Unknown"}));
            }
        }
        return managedType;
    }

    @Override
    public <E> ListAttribute<X, E> getDeclaredList(String name, Class<E> elementType) {
        ListAttribute<X, E> anAttribute = this.getList(name, elementType);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public ListAttribute<X, ?> getDeclaredList(String name) {
        ListAttribute<X, ?> anAttribute = this.getList(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public MapAttribute<X, ?, ?> getDeclaredMap(String name) {
        MapAttribute<X, ?, ?> anAttribute = this.getMap(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public <K, V> MapAttribute<X, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        MapAttribute<X, K, V> anAttribute = this.getMap(name, keyType, valueType);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public SetAttribute<X, ?> getDeclaredSet(String name) {
        SetAttribute<X, ?> anAttribute = this.getSet(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public <E> SetAttribute<X, E> getDeclaredSet(String name, Class<E> elementType) {
        SetAttribute<X, E> anAttribute = this.getSet(name, elementType);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public SingularAttribute<X, ?> getDeclaredSingularAttribute(String name) {
        SingularAttribute<X, ?> anAttribute = this.getSingularAttribute(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public <Y> SingularAttribute<X, Y> getDeclaredSingularAttribute(String name, Class<Y> type) {
        SingularAttribute<X, Y> anAttribute = this.getSingularAttribute(name, type);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public Set<SingularAttribute<X, ?>> getDeclaredSingularAttributes() {
        LinkedHashSet allAttributes = new LinkedHashSet(this.members.values());
        LinkedHashSet declaredAttributes = new LinkedHashSet();
        for (Attribute attribute : allAttributes) {
            if (attribute.isCollection()) continue;
            declaredAttributes.add((SingularAttribute)attribute);
        }
        return declaredAttributes;
    }

    public RelationalDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public ListAttribute<? super X, ?> getList(String name) {
        return this.getList(name, true);
    }

    private ListAttribute<? super X, ?> getList(String name, boolean performNullCheck) {
        ListAttribute anAttribute = (ListAttribute)this.members.get(name);
        if (performNullCheck && null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    private void verifyAttributeTypeAndReturnType(Attribute anAttribute, Class attributeElementType, PluralAttribute.CollectionType aReturnCollectionType) {
        if (anAttribute.isCollection()) {
            if (((PluralAttribute)anAttribute).getCollectionType().equals((Object)aReturnCollectionType)) {
                Class aBindableJavaClass = ((PluralAttribute)anAttribute).getBindableJavaType();
                if (attributeElementType != aBindableJavaClass) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{anAttribute.getName(), this, attributeElementType, aBindableJavaClass}));
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_return_type_incorrect", new Object[]{anAttribute.getName(), this, aReturnCollectionType, ((PluralAttribute)anAttribute).getCollectionType()}));
            }
        }
    }

    @Override
    public <E> ListAttribute<? super X, E> getList(String name, Class<E> elementType) {
        ListAttribute anAttribute = (ListAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        this.verifyAttributeTypeAndReturnType(anAttribute, elementType, PluralAttribute.CollectionType.LIST);
        return anAttribute;
    }

    private ManagedTypeImpl getManagedSuperType() {
        ManagedTypeImpl aSuperType = null;
        Class aSuperClass = this.getJavaType().getSuperclass();
        if (null != aSuperClass && aSuperClass != ClassConstants.OBJECT) {
            aSuperType = (ManagedTypeImpl)this.getMetamodel().managedType(aSuperClass);
        }
        return aSuperType;
    }

    @Override
    public MapAttribute<? super X, ?, ?> getMap(String name) {
        MapAttribute anAttribute = (MapAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    @Override
    public <K, V> MapAttribute<? super X, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        MapAttribute<X, ?, ?> anAttribute = this.getMap(name);
        Class aClass = anAttribute.getElementType().getJavaType();
        if (valueType != aClass) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, valueType, aClass}));
        }
        return anAttribute;
    }

    protected Map<String, Attribute<X, ?>> getMembers() {
        return this.members;
    }

    protected MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    @Override
    public SetAttribute<? super X, ?> getSet(String name) {
        SetAttribute anAttribute = (SetAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    @Override
    public <E> SetAttribute<? super X, E> getSet(String name, Class<E> elementType) {
        SetAttribute<X, ?> anAttribute = this.getSet(name);
        Class aClass = anAttribute.getElementType().getJavaType();
        if (elementType != aClass) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, elementType, aClass.getName()}));
        }
        return anAttribute;
    }

    @Override
    public SingularAttribute<? super X, ?> getSingularAttribute(String name) {
        Attribute<X, ?> anAttribute = this.getMembers().get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return (SingularAttribute)anAttribute;
    }

    private boolean isAutoboxedType(Class targetPrimitiveOrWrapperClass, Class actualPrimitiveOrWrapperClass) {
        BasicTypeHelperImpl typeHelper = BasicTypeHelperImpl.getInstance();
        if (targetPrimitiveOrWrapperClass == null || actualPrimitiveOrWrapperClass == null) {
            return false;
        }
        if (targetPrimitiveOrWrapperClass == actualPrimitiveOrWrapperClass || targetPrimitiveOrWrapperClass.getCanonicalName().equals(actualPrimitiveOrWrapperClass.getCanonicalName())) {
            return false;
        }
        if (typeHelper.isWrapperClass(targetPrimitiveOrWrapperClass) || targetPrimitiveOrWrapperClass.isPrimitive()) {
            if (typeHelper.isBooleanType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isBooleanType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isByteType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isByteType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isShortType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isShortType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isCharacterType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isCharacterType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isIntType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isIntType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isLongType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isLongType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isFloatType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isFloatType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isDoubleType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isDoubleType(actualPrimitiveOrWrapperClass);
            }
        }
        return false;
    }

    @Override
    public <Y> SingularAttribute<? super X, Y> getSingularAttribute(String name, Class<Y> type) {
        SingularAttribute<X, ?> anAttribute = this.getSingularAttribute(name);
        Class<?> aClass = anAttribute.getType().getJavaType();
        if (type != aClass && !this.isAutoboxedType(type, aClass)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, type, aClass}));
        }
        return anAttribute;
    }

    @Override
    public Set<SingularAttribute<? super X, ?>> getSingularAttributes() {
        LinkedHashSet singularAttributeSet = new LinkedHashSet();
        for (Attribute<X, ?> anAttribute : this.members.values()) {
            if (((AttributeImpl)anAttribute).isPlural()) continue;
            singularAttributeSet.add((SingularAttribute<X, ?>)anAttribute);
        }
        return singularAttributeSet;
    }

    private boolean isAttributeDeclaredOnlyInLeafType(String attributeName) {
        return this.isAttributeDeclaredOnlyInLeafType(attributeName, this.getMembers().get(attributeName));
    }

    private boolean isAttributeDeclaredOnlyInLeafType(String attributeName, Attribute firstLevelAttribute) {
        Attribute<X, ?> anAttribute = this.getMembers().get(attributeName);
        ManagedTypeImpl aSuperType = this.getManagedSuperType();
        if (null == aSuperType) {
            if (null == anAttribute && null != firstLevelAttribute) {
                return true;
            }
            return null != anAttribute && anAttribute == firstLevelAttribute;
        }
        Attribute<X, ?> aSuperTypeAttribute = aSuperType.getMembers().get(attributeName);
        if (null != aSuperTypeAttribute) {
            return false;
        }
        if (null == aSuperTypeAttribute) {
            return aSuperType.isAttributeDeclaredOnlyInLeafType(attributeName, firstLevelAttribute);
        }
        return anAttribute == firstLevelAttribute;
    }

    private AttributeImpl initializePluralAttributeTypeNotFound(ManagedTypeImpl managedType, CollectionMapping collectionMapping, boolean validation) {
        ListAttributeImpl member = new ListAttributeImpl(managedType, collectionMapping, validation);
        return member;
    }

    protected void initialize() {
        this.members = new HashMap();
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            AttributeImpl member;
            block31: {
                member = null;
                if (mapping.isCollectionMapping()) {
                    CollectionMapping colMapping = (CollectionMapping)mapping;
                    ContainerPolicy collectionContainerPolicy = colMapping.getContainerPolicy();
                    if (collectionContainerPolicy.isMapPolicy() || collectionContainerPolicy.isDirectMapPolicy()) {
                        member = new MapAttributeImpl(this, colMapping, true);
                    } else if (collectionContainerPolicy.isListPolicy()) {
                        Class<?> aType = null;
                        if (colMapping.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
                            Field aField = ((InstanceVariableAttributeAccessor)colMapping.getAttributeAccessor()).getAttributeField();
                            if (null == aField && this.isMappedSuperclass()) {
                                MappedSuperclassTypeImpl aMappedSuperclass = (MappedSuperclassTypeImpl)this;
                                AttributeImpl inheritingTypeMember = aMappedSuperclass.getMemberFromInheritingType(colMapping.getAttributeName());
                                aField = ((InstanceVariableAttributeAccessor)inheritingTypeMember.getMapping().getAttributeAccessor()).getAttributeField();
                            }
                            member = (aType = null == aField ? this.getTypeClassFromAttributeOrMethodLevelAccessor(mapping) : aField.getType()) == List.class ? new ListAttributeImpl(this, colMapping, true) : (aType == Collection.class ? new CollectionAttributeImpl(this, colMapping, true) : this.initializePluralAttributeTypeNotFound(this, colMapping, true));
                        } else if (colMapping.getAttributeAccessor() instanceof MethodAttributeAccessor) {
                            aType = ((MethodAttributeAccessor)colMapping.getAttributeAccessor()).getAttributeClass();
                            if (aType == Collection.class) {
                                member = new CollectionAttributeImpl(this, colMapping, true);
                            } else if (aType == List.class) {
                                member = new ListAttributeImpl(this, colMapping, true);
                            } else {
                                String getMethodName = ((MethodAttributeAccessor)colMapping.getAttributeAccessor()).getGetMethodName();
                                if (null == getMethodName) {
                                    try {
                                        Field field = null;
                                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                            try {
                                                field = (Field)AccessController.doPrivileged(new PrivilegedGetDeclaredField(this.getJavaType(), colMapping.getAttributeName(), false));
                                            }
                                            catch (PrivilegedActionException exception) {
                                                member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                            }
                                        } else {
                                            field = PrivilegedAccessHelper.getDeclaredField(this.getJavaType(), colMapping.getAttributeName(), false);
                                        }
                                        if (null == field) {
                                            member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                            break block31;
                                        }
                                        aType = field.getType();
                                        if (aType == Collection.class) {
                                            member = new CollectionAttributeImpl(this, colMapping, true);
                                            break block31;
                                        }
                                        if (aType == List.class) {
                                            member = new ListAttributeImpl(this, colMapping, true);
                                            break block31;
                                        }
                                        member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                    }
                                    catch (Exception e) {
                                        member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                    }
                                } else {
                                    try {
                                        Method aMethod = null;
                                        aMethod = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(this.getJavaType(), getMethodName, null)) : PrivilegedAccessHelper.getDeclaredMethod(this.getJavaType(), getMethodName, null);
                                        if (null == aMethod) {
                                            member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                            break block31;
                                        }
                                        aType = aMethod.getReturnType();
                                        if (aType == Collection.class) {
                                            member = new CollectionAttributeImpl(this, colMapping, true);
                                            break block31;
                                        }
                                        if (aType == List.class) {
                                            member = new ListAttributeImpl(this, colMapping, true);
                                            break block31;
                                        }
                                        member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                    }
                                    catch (Exception e) {
                                        member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                    }
                                }
                            }
                        }
                    } else {
                        member = collectionContainerPolicy.getContainerClass().isAssignableFrom(Set.class) || collectionContainerPolicy.getContainerClass().isAssignableFrom(IndirectSet.class) ? new SetAttributeImpl(this, colMapping, true) : (collectionContainerPolicy.isCollectionPolicy() ? new CollectionAttributeImpl(this, colMapping, true) : new CollectionAttributeImpl(this, colMapping, true));
                    }
                } else {
                    member = new SingularAttributeImpl(this, mapping, true);
                }
            }
            this.members.put(mapping.getAttributeName(), member);
        }
    }

    protected Class getTypeClassFromAttributeOrMethodLevelAccessor(DatabaseMapping mapping) {
        Class aType = null;
        Field aField = null;
        String getMethodName = null;
        if (mapping.getAttributeAccessor() instanceof MethodAttributeAccessor) {
            getMethodName = ((MethodAttributeAccessor)mapping.getAttributeAccessor()).getGetMethodName();
        } else if (mapping.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            aField = ((InstanceVariableAttributeAccessor)mapping.getAttributeAccessor()).getAttributeField();
        }
        if (null == aField) {
            try {
                aField = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Field)AccessController.doPrivileged(new PrivilegedGetDeclaredField(this.getJavaType(), mapping.getAttributeName(), false)) : PrivilegedAccessHelper.getDeclaredField(this.getJavaType(), mapping.getAttributeName(), false);
            }
            catch (PrivilegedActionException pae) {
            }
            catch (NoSuchFieldException nsfe) {
                // empty catch block
            }
        }
        if (null == aField) {
            Method aMethod = null;
            try {
                aMethod = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(this.getJavaType(), getMethodName, null)) : PrivilegedAccessHelper.getDeclaredMethod(this.getJavaType(), getMethodName, null);
            }
            catch (PrivilegedActionException pae) {
            }
            catch (NoSuchMethodException nsfe) {
                // empty catch block
            }
            if (null != aMethod) {
                aType = aMethod.getReturnType();
            }
        }
        if (null == aField && null == aType && this.isMappedSuperclass()) {
            MappedSuperclassTypeImpl aMappedSuperclass = (MappedSuperclassTypeImpl)this;
            AttributeImpl inheritingTypeMember = aMappedSuperclass.getMemberFromInheritingType(mapping.getAttributeName());
            aField = ((InstanceVariableAttributeAccessor)inheritingTypeMember.getMapping().getAttributeAccessor()).getAttributeField();
        }
        if (null != aField) {
            aType = aField.getType();
        }
        if (null == aType) {
            aType = MetamodelImpl.DEFAULT_ELEMENT_TYPE_FOR_UNSUPPORTED_MAPPINGS;
        }
        return aType;
    }

    @Override
    protected boolean isIdentifiableType() {
        return false;
    }

    @Override
    protected boolean isManagedType() {
        return true;
    }

    @Override
    protected void toStringHelper(StringBuffer aBuffer) {
        aBuffer.append(" descriptor: ");
        aBuffer.append(this.getDescriptor());
        if (null != this.getDescriptor()) {
            aBuffer.append(", mappings: ");
            aBuffer.append(this.getDescriptor().getMappings().size());
        }
    }
}

