/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.eclipse.persistence.dbws.DBWSModel;
import org.eclipse.persistence.dbws.DBWSModelProject;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntity;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntityAccessor;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntityClassLoader;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntityVHAccessor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGenerator;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGeneratorProperties;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.factories.MissingDescriptorListener;
import org.eclipse.persistence.internal.sessions.factories.ObjectPersistenceWorkbenchXMLProject;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigWriter;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectClassConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectXMLConfig;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.DeleteOperation;
import org.eclipse.persistence.internal.xr.InsertOperation;
import org.eclipse.persistence.internal.xr.NamedQueryHandler;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.UpdateOperation;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.platform.DOMPlatform;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.platform.database.MySQLPlatform;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCollection;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherListenerChainAdapter;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherWalker;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.tools.dbws.DBWSBuilderModel;
import org.eclipse.persistence.tools.dbws.DBWSBuilderModelProject;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.DefaultNamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.NamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.OperationModel;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.SQLOperationModel;
import org.eclipse.persistence.tools.dbws.SQLX2003Transformer;
import org.eclipse.persistence.tools.dbws.TableOperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.WSDLGenerator;
import org.eclipse.persistence.tools.dbws.XRPackager;
import org.eclipse.persistence.tools.dbws.jdbc.DbColumn;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;
import org.eclipse.persistence.tools.dbws.jdbc.DbTable;
import org.eclipse.persistence.tools.dbws.jdbc.JDBCHelper;
import org.eclipse.persistence.tools.dbws.oracle.AdvancedJDBCORDescriptorBuilder;
import org.eclipse.persistence.tools.dbws.oracle.AdvancedJDBCOXDescriptorBuilder;
import org.eclipse.persistence.tools.dbws.oracle.AdvancedJDBCQueryBuilder;
import org.eclipse.persistence.tools.dbws.oracle.OracleHelper;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLHelperObjectsBuilder;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLORDescriptorBuilder;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLOXDescriptorBuilder;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLStoredArgument;

public class DBWSBuilder
extends DBWSBuilderModel {
    public static final String BUILDER_FILE_PATH = "-builderFile";
    public static final String BUILDER_PACKAGING = "-packageAs";
    public static final String STAGE_DIR = "-stageDir";
    public static final String DRIVER_KEY = "driver";
    public static final String USERNAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";
    public static final String URL_KEY = "url";
    public static final String PROJNAME_KEY = "projectName";
    public static final String CONTEXT_ROOT_KEY = "contextRoot";
    public static final String DATASOURCE_KEY = "dataSource";
    public static final String SESSIONS_FILENAME_KEY = "sessionsFileName";
    public static final String NO_SESSIONS_FILENAME = "no-sessions-fileName";
    public static final String PLATFORM_CLASSNAME_KEY = "platformClassname";
    public static final String ORSESSION_CUSTOMIZER_KEY = "orSessionCustomizerClassName";
    public static final String OXSESSION_CUSTOMIZER_KEY = "oxSessionCustomizerClassName";
    public static final String WSDL_URI_KEY = "wsdlLocationURI";
    public static final String LOG_LEVEL_KEY = "logLevel";
    public static final String TARGET_NAMESPACE_KEY = "targetNamespace";
    public static final String USE_SOAP12_KEY = "useSOAP12";
    public static final String WSI_SWAREF_XSD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<xsd:schema targetNamespace=\"http://ws-i.org/profiles/basic/1.1/xsd\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"> \n  <xsd:simpleType name=\"swaref\"> \n    <xsd:restriction base=\"xsd:anyURI\"/> \n  </xsd:simpleType> \n</xsd:schema>";
    public static Map<String, DBWSPackager> PACKAGERS = new HashMap<String, DBWSPackager>();
    protected DBWSPackager packager;
    protected Logger logger;
    public boolean quiet = false;
    protected String destDir;
    protected DatabasePlatform databasePlatform;
    protected Connection conn;
    protected Project orProject;
    protected Project oxProject;
    protected WSDLGenerator wsdlGenerator = null;
    protected Schema schema = new Schema();
    protected NamespaceResolver ns = this.schema.getNamespaceResolver();
    protected XRServiceModel xrServiceModel = new DBWSModel();
    protected List<DbTable> dbTables = new ArrayList<DbTable>();
    protected List<DbStoredProcedure> dbStoredProcedures = new ArrayList<DbStoredProcedure>();
    protected Map<DbStoredProcedure, DbStoredProcedureNameAndModel> dbStoredProcedure2QueryName = new HashMap<DbStoredProcedure, DbStoredProcedureNameAndModel>();
    protected NamingConventionTransformer topTransformer;
    protected Set<String> typeDDL = new HashSet<String>();
    protected Set<String> typeDropDDL = new HashSet<String>();

    public DBWSBuilder() {
        this.ns.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.ns.put("xsd", "http://www.w3.org/2001/XMLSchema");
    }

    public static void main(String[] args) throws WSDLException {
        DBWSBuilder builder = new DBWSBuilder();
        builder.start(args);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void start(String[] args) throws WSDLException {
        block13: {
            if (args.length > 5 && BUILDER_FILE_PATH.equals(args[0]) && STAGE_DIR.equals(args[2]) && args[4].startsWith(BUILDER_PACKAGING)) {
                File builderFile;
                String builderFilename = args[1];
                String stageDirname = args[3];
                String packagerTag = args[5];
                String archiverTag = null;
                DBWSPackager.ArchiveUse archiveUse = DBWSPackager.ArchiveUse.ignore;
                int cIdx = args[4].indexOf(58);
                if (cIdx == 10) {
                    archiverTag = args[4].substring(cIdx + 1);
                    if (DBWSPackager.ArchiveUse.archive.name().equals(archiverTag)) {
                        archiveUse = DBWSPackager.ArchiveUse.archive;
                    } else if (DBWSPackager.ArchiveUse.noArchive.name().equals(archiverTag)) {
                        archiveUse = DBWSPackager.ArchiveUse.noArchive;
                    }
                }
                String[] additionalArgs = null;
                if (args.length > 6) {
                    additionalArgs = new String[args.length - 6];
                    System.arraycopy(args, 6, additionalArgs, 0, args.length - 6);
                }
                if ((builderFile = new File(builderFilename)).exists() && builderFile.isFile()) {
                    File stageDir = new File(stageDirname);
                    if (stageDir.exists() && stageDir.isDirectory()) {
                        XMLContext context = new XMLContext((Project)new DBWSBuilderModelProject());
                        XMLUnmarshaller unmarshaller = context.createUnmarshaller();
                        DBWSBuilderModel model = (DBWSBuilderModel)unmarshaller.unmarshal(builderFile);
                        this.properties = model.properties;
                        this.operations = model.operations;
                        if (this.operations.size() == 0) {
                            this.logMessage(Level.SEVERE, "No operations specified");
                            return;
                        }
                        this.packager = PACKAGERS.get(packagerTag);
                        if (this.packager != null) {
                            this.packager.setDBWSBuilder(this);
                            this.packager.setArchiveUse(archiveUse);
                            this.packager.setAdditionalArgs(additionalArgs);
                            this.packager.setStageDir(stageDir);
                            this.packager.setSessionsFileName(this.getSessionsFileName());
                            this.start();
                            return;
                        }
                        break block13;
                    } else {
                        this.logMessage(Level.SEVERE, "DBWSBuilder unable to locate stage directory " + stageDirname);
                        return;
                    }
                }
                this.logMessage(Level.SEVERE, "DBWSBuilder unable to locate dbws-builder.xml file " + builderFilename);
                return;
            }
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append("DBWSBuilder usage ([] indicates optional argument):\nprompt> java -cp eclipselink.jar:eclipselink-dbwsutils.jar:your_favourite_jdbc_driver.jar \\\n\t");
        sb.append(this.getClass().getName());
        sb.append(" ");
        sb.append(BUILDER_FILE_PATH);
        sb.append(" {path_to_dbwsbuilder.xml} \\\n\t");
        sb.append(STAGE_DIR);
        sb.append(" ");
        sb.append(" {path_to_stageDir}");
        sb.append(" ");
        sb.append(BUILDER_PACKAGING);
        sb.append("[:archive_flag - archive, noArchive, ignore] {packager} [additional arguments]\nAvailable packagers:\n\t");
        Iterator<Map.Entry<String, DBWSPackager>> i = PACKAGERS.entrySet().iterator();
        while (true) {
            if (!i.hasNext()) {
                this.logMessage(Level.SEVERE, sb.toString());
                return;
            }
            Map.Entry<String, DBWSPackager> me = i.next();
            sb.append(me.getValue().getUsage());
            if (!i.hasNext()) continue;
            sb.append("\n\t");
        }
    }

    public void start() throws WSDLException {
        this.packager.setHasAttachments(this.hasAttachments());
        OutputStream dbwsSchemaStream = null;
        try {
            dbwsSchemaStream = this.packager.getSchemaStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws-schema.xsd", fnfe);
            return;
        }
        OutputStream dbwsSessionsStream = null;
        try {
            dbwsSessionsStream = this.packager.getSessionsStream(this.getSessionsFileName());
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws-sessions.xml", fnfe);
            return;
        }
        OutputStream dbwsServiceStream = null;
        try {
            dbwsServiceStream = this.packager.getServiceStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws.xml", fnfe);
            return;
        }
        OutputStream dbwsOrStream = null;
        try {
            dbwsOrStream = this.packager.getOrStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws-or.xml", fnfe);
            return;
        }
        OutputStream dbwsOxStream = null;
        try {
            dbwsOxStream = this.packager.getOxStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws-ox.xml", fnfe);
            return;
        }
        OutputStream wsdlStream = null;
        try {
            wsdlStream = this.packager.getWSDLStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws.wsdl", fnfe);
            return;
        }
        OutputStream swarefStream = null;
        try {
            swarefStream = this.packager.getSWARefStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create swaref.xsd", fnfe);
            return;
        }
        OutputStream webXmlStream = null;
        try {
            webXmlStream = this.packager.getWebXmlStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create web.xml", fnfe);
            return;
        }
        OutputStream codeGenProviderStream = null;
        try {
            codeGenProviderStream = this.packager.getProviderClassStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create DBWSProvider.class", fnfe);
            return;
        }
        OutputStream sourceProviderStream = null;
        try {
            sourceProviderStream = this.packager.getProviderSourceStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create DBWSProvider.java", fnfe);
            return;
        }
        this.build(dbwsSchemaStream, dbwsSessionsStream, dbwsServiceStream, dbwsOrStream, dbwsOxStream, swarefStream, webXmlStream, wsdlStream, codeGenProviderStream, sourceProviderStream, this.logger);
    }

    public void build(OutputStream dbwsSchemaStream, OutputStream dbwsSessionsStream, OutputStream dbwsServiceStream, OutputStream dbwsOrStream, OutputStream dbwsOxStream, OutputStream swarefStream, OutputStream webXmlStream, OutputStream wsdlStream, OutputStream codeGenProviderStream, OutputStream sourceProviderStream, Logger logger) throws WSDLException {
        NamingConventionTransformer nextTransformer;
        this.logger = logger;
        this.xrServiceModel.setName(this.getProjectName());
        String sessionsFileName = this.getSessionsFileName();
        if (sessionsFileName != null && sessionsFileName.length() > 0) {
            this.xrServiceModel.setSessionsFile(sessionsFileName);
        }
        ServiceLoader<NamingConventionTransformer> transformers = ServiceLoader.load(NamingConventionTransformer.class);
        Iterator<NamingConventionTransformer> transformerIter = transformers.iterator();
        this.topTransformer = transformerIter.next();
        LinkedList<NamingConventionTransformer> transformerList = new LinkedList<NamingConventionTransformer>();
        if (!((DefaultNamingConventionTransformer)this.topTransformer).isDefaultTransformer()) {
            while (transformerIter.hasNext()) {
                nextTransformer = transformerIter.next();
                if (!((DefaultNamingConventionTransformer)nextTransformer).isDefaultTransformer()) {
                    transformerList.addLast(nextTransformer);
                    continue;
                }
                if (!(nextTransformer instanceof SQLX2003Transformer)) continue;
                transformerList.addLast(nextTransformer);
            }
        } else {
            while (transformerIter.hasNext()) {
                transformerList.addLast(transformerIter.next());
            }
        }
        nextTransformer = this.topTransformer;
        for (NamingConventionTransformer nct : transformerList) {
            ((DefaultNamingConventionTransformer)nextTransformer).setNextTransformer(nct);
            nextTransformer = nct;
        }
        this.packager.start();
        this.buildDbArtifacts();
        this.buildOROXProjects(this.topTransformer);
        this.buildSchema(this.topTransformer);
        this.buildSessionsXML(dbwsSessionsStream);
        this.buildDBWSModel(this.topTransformer, dbwsServiceStream);
        this.writeAttachmentSchema(swarefStream);
        this.buildWSDL(wsdlStream, this.topTransformer);
        this.writeWebXML(webXmlStream);
        this.writeDBWSProviderClass(codeGenProviderStream);
        this.writeDBWSProviderSource(sourceProviderStream);
        this.writeSchema(dbwsSchemaStream);
        this.writeOROXProjects(dbwsOrStream, dbwsOxStream);
        this.packager.end();
    }

    public OutputStream getShadowDDLStream() {
        return XRPackager.__nullStream;
    }

    public void buildDbArtifacts() {
        StringBuilder sb;
        String schemaPattern;
        String catalogPattern;
        boolean isOracle = this.getDatabasePlatform().getClass().getName().contains("Oracle");
        for (OperationModel operation : this.operations) {
            String tableNamePattern;
            TableOperationModel tableModel;
            if (!operation.isTableOperation()) continue;
            catalogPattern = isOracle ? null : tableModel.getCatalogPattern();
            List<DbTable> tables = this.checkTables(this.loadTables(catalogPattern, schemaPattern = (tableModel = (TableOperationModel)operation).getSchemaPattern(), tableNamePattern = tableModel.getTablePattern()));
            if (tables.isEmpty()) {
                sb = new StringBuilder();
                sb.append("No matching tables for pattern ");
                if (catalogPattern != null) {
                    sb.append(catalogPattern);
                    sb.append(".");
                }
                if (schemaPattern != null) {
                    sb.append(schemaPattern);
                    sb.append(".");
                }
                sb.append(tableNamePattern);
                this.logMessage(Level.FINEST, sb.toString());
                continue;
            }
            this.dbTables.addAll(tables);
        }
        for (OperationModel operation : this.operations) {
            if (!operation.isProcedureOperation()) continue;
            ProcedureOperationModel procedureModel = (ProcedureOperationModel)operation;
            catalogPattern = procedureModel.getCatalogPattern();
            schemaPattern = procedureModel.getSchemaPattern();
            String procedurePattern = procedureModel.getProcedurePattern();
            List<DbStoredProcedure> procs = this.loadProcedures(procedureModel, isOracle);
            if (procs.isEmpty()) {
                sb = new StringBuilder();
                sb.append("No matching procedures for pattern ");
                if (catalogPattern != null) {
                    sb.append(catalogPattern);
                    sb.append(".");
                }
                if (schemaPattern != null) {
                    sb.append(schemaPattern);
                    sb.append(".");
                }
                sb.append(procedurePattern);
                this.logMessage(Level.FINEST, sb.toString());
                continue;
            }
            this.dbStoredProcedures.addAll(procs);
        }
        DBWSBuilder.buildDbStoredProcedure2QueryNameMap(this.dbStoredProcedure2QueryName, this.dbStoredProcedures, this.operations, isOracle);
    }

    protected List<DbTable> loadTables(String catalogPattern, String schemaPattern, String tableNamePattern) {
        return this.checkTables(JDBCHelper.buildDbTable(this.getConnection(), this.databasePlatform, catalogPattern, schemaPattern, tableNamePattern));
    }

    public List<DbTable> checkTables(List<DbTable> dbTables) {
        ArrayList<DbTable> supportedTables = new ArrayList<DbTable>(dbTables.size());
        for (DbTable dbTable : dbTables) {
            boolean unSupportedColumnType = false;
            for (DbColumn dbColumn : dbTable.getColumns()) {
                switch (dbColumn.getJDBCType()) {
                    case 70: 
                    case 1111: 
                    case 2000: 
                    case 2002: 
                    case 2003: {
                        unSupportedColumnType = true;
                    }
                }
            }
            if (unSupportedColumnType) continue;
            supportedTables.add(dbTable);
        }
        return supportedTables;
    }

    public void addDbTable(DbTable dbTable) {
        this.dbTables.add(dbTable);
    }

    protected List<DbStoredProcedure> loadProcedures(ProcedureOperationModel procedureModel, boolean isOracle) {
        if (isOracle && (procedureModel.isPLSQLProcedureOperation() || procedureModel.isAdvancedJDBC)) {
            return OracleHelper.buildStoredProcedure(this.getConnection(), this.getUsername(), this.databasePlatform, procedureModel);
        }
        return this.checkStoredProcedures(JDBCHelper.buildStoredProcedure(this.getConnection(), this.databasePlatform, procedureModel), 0);
    }

    public List<DbStoredProcedure> checkStoredProcedures(List<DbStoredProcedure> procedures, int oracleOverload) {
        ArrayList<DbStoredProcedure> supportedProcedures = new ArrayList<DbStoredProcedure>(procedures.size());
        ArrayList<DbStoredProcedure> copyOfProcedures = new ArrayList<DbStoredProcedure>(procedures.size());
        ArrayList<DbStoredProcedure> overloadedProcedure = new ArrayList<DbStoredProcedure>(1);
        if (oracleOverload == 0) {
            copyOfProcedures.addAll(procedures);
        } else {
            for (DbStoredProcedure storedProcedure : procedures) {
                if (storedProcedure.getOverload() != oracleOverload) continue;
                overloadedProcedure.add(storedProcedure);
                break;
            }
            copyOfProcedures.addAll(overloadedProcedure);
        }
        for (DbStoredProcedure storedProcedure : copyOfProcedures) {
            boolean unSupportedArgType = false;
            for (DbStoredArgument arg : storedProcedure.getArguments()) {
                int jdbcType = arg.getJdbcType();
                if (jdbcType == 1111) {
                    if (arg.getJdbcTypeName().contains("CURSOR") && arg.getInOut() == Util.InOut.OUT) continue;
                    unSupportedArgType = true;
                    break;
                }
                if (jdbcType != 2003 && jdbcType != 2002 && jdbcType != 70 && jdbcType != 2000) continue;
                unSupportedArgType = true;
                break;
            }
            if (unSupportedArgType) continue;
            supportedProcedures.add(storedProcedure);
        }
        return supportedProcedures;
    }

    public void addDbStoredProcedure(DbStoredProcedure dbStoredProcedure) {
        this.dbStoredProcedures.add(dbStoredProcedure);
    }

    public void addSqlOperation(SQLOperationModel sqlOperation) {
        this.operations.add(sqlOperation);
    }

    protected void buildOROXProjects(NamingConventionTransformer nct) {
        String projectName = this.getProjectName();
        this.orProject = new Project();
        this.orProject.setName(projectName + "-" + "dbws-or");
        if (this.dbTables.isEmpty()) {
            this.logMessage(Level.FINEST, "No tables specified");
            this.oxProject = new SimpleXMLFormatProject();
        } else {
            this.oxProject = new Project();
        }
        this.oxProject.setName(projectName + "-" + "dbws-ox");
        for (DbTable dbTable : this.dbTables) {
            RelationalDescriptor desc = new RelationalDescriptor();
            this.orProject.addDescriptor((ClassDescriptor)desc);
            String tableName = dbTable.getName();
            String tablenameAlias = nct.generateSchemaAlias(tableName);
            desc.addTableName(tableName);
            desc.setAlias(tablenameAlias);
            String generatedJavaClassName = this.getGeneratedJavaClassName(tableName);
            desc.setJavaClassName(generatedJavaClassName);
            desc.useWeakIdentityMap();
            XMLDescriptor xdesc = new XMLDescriptor();
            this.oxProject.addDescriptor((ClassDescriptor)xdesc);
            xdesc.setJavaClassName(generatedJavaClassName);
            xdesc.setAlias(tablenameAlias);
            NamespaceResolver nr = new NamespaceResolver();
            nr.setDefaultNamespaceURI(this.getTargetNamespace());
            nr.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xdesc.setNamespaceResolver(nr);
            xdesc.setDefaultRootElement(tablenameAlias);
            XMLSchemaURLReference schemaReference = new XMLSchemaURLReference("");
            schemaReference.setSchemaContext("/" + tablenameAlias);
            schemaReference.setType(1);
            xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
            for (DbColumn dbColumn : dbTable.getColumns()) {
                String columnName = dbColumn.getName();
                int jdbcType = dbColumn.getJDBCType();
                String dmdTypeName = dbColumn.getJDBCTypeName();
                this.logMessage(Level.FINE, "Building mappings for " + tableName + "." + columnName);
                XMLDirectMapping xdm = null;
                QName qName = Util.getXMLTypeFromJDBCType(jdbcType);
                boolean isSwaRef = false;
                if (qName == XMLConstants.BASE_64_BINARY_QNAME) {
                    block2: for (OperationModel om : this.operations) {
                        if (!om.isTableOperation()) continue;
                        TableOperationModel tom = (TableOperationModel)om;
                        if (tom.additionalOperations.size() <= 0) continue;
                        for (OperationModel om2 : tom.additionalOperations) {
                            ProcedureOperationModel pom;
                            if (!om2.isProcedureOperation() || !(pom = (ProcedureOperationModel)om2).getBinaryAttachment()) continue;
                            isSwaRef = true;
                            continue block2;
                        }
                    }
                    if (isSwaRef) {
                        xdm = new XMLBinaryDataMapping();
                        XMLBinaryDataMapping xbdm = (XMLBinaryDataMapping)xdm;
                        xbdm.setSwaRef(isSwaRef);
                        xbdm.setMimeType("application/octet-stream");
                    } else {
                        xdm = new XMLDirectMapping();
                        SerializedObjectConverter converter = new SerializedObjectConverter((DatabaseMapping)xdm);
                        xdm.setConverter((Converter)converter);
                    }
                } else {
                    xdm = new XMLDirectMapping();
                }
                DirectToFieldMapping dtfm = new DirectToFieldMapping();
                Class attributeClass = org.eclipse.persistence.internal.xr.Util.getClassFromJDBCType((String)dmdTypeName.toUpperCase(), (DatabasePlatform)this.databasePlatform);
                if (qName == XMLConstants.BASE_64_BINARY_QNAME && attributeClass == ClassConstants.ABYTE) {
                    attributeClass = ClassConstants.APBYTE;
                }
                dtfm.setAttributeClassificationName(attributeClass.getName());
                String fieldName = nct.generateElementAlias(columnName);
                dtfm.setAttributeName(fieldName);
                DatabaseField databaseField = new DatabaseField(columnName, tableName);
                databaseField.setSqlType(jdbcType);
                dtfm.setField(databaseField);
                xdm.setAttributeName(fieldName);
                xdm.setAttributeClassificationName(attributeClass.getName());
                String xPath = "";
                NamingConventionTransformer.ElementStyle style = nct.styleForElement(columnName);
                if (style == NamingConventionTransformer.ElementStyle.NONE) continue;
                if (style == NamingConventionTransformer.ElementStyle.ATTRIBUTE) {
                    xPath = xPath + "@" + fieldName;
                } else if (style == NamingConventionTransformer.ElementStyle.ELEMENT) {
                    xPath = xPath + fieldName;
                    AbstractNullPolicy nullPolicy = xdm.getNullPolicy();
                    nullPolicy.setNullRepresentedByEmptyNode(false);
                    nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                    nullPolicy.setNullRepresentedByXsiNil(true);
                    xdm.setNullPolicy(nullPolicy);
                }
                desc.addMapping((DatabaseMapping)dtfm);
                xdesc.addMapping((DatabaseMapping)xdm);
                if (!isSwaRef && style == NamingConventionTransformer.ElementStyle.ELEMENT) {
                    xPath = xPath + "/text()";
                }
                xdm.setXPath(xPath);
                XMLField xmlField = (XMLField)xdm.getField();
                xmlField.setRequired(true);
                xmlField.setSchemaType(qName);
                if (!isSwaRef && qName == XMLConstants.BASE_64_BINARY_QNAME) {
                    nr.put("xsd", "http://www.w3.org/2001/XMLSchema");
                }
                if (!dbColumn.isPK()) continue;
                desc.addPrimaryKeyField(databaseField);
            }
            ReadObjectQuery roq = new ReadObjectQuery();
            roq.setReferenceClassName(generatedJavaClassName);
            Expression expression = null;
            ExpressionBuilder builder = new ExpressionBuilder();
            List primaryKeyFields = desc.getPrimaryKeyFields();
            for (int index = 0; index < primaryKeyFields.size(); ++index) {
                DatabaseField primaryKeyField = (DatabaseField)primaryKeyFields.get(index);
                Expression subExp1 = builder.getField(primaryKeyField);
                Expression subExp2 = builder.getParameter(primaryKeyField.getName().toLowerCase());
                Expression subExpression = subExp1.equal(subExp2);
                expression = expression == null ? subExpression : expression.and(subExpression);
                roq.addArgument(primaryKeyField.getName().toLowerCase());
            }
            roq.setSelectionCriteria(expression);
            desc.getQueryManager().addQuery("findByPrimaryKey", (DatabaseQuery)roq);
            ReadAllQuery raq = new ReadAllQuery();
            raq.setReferenceClassName(generatedJavaClassName);
            desc.getQueryManager().addQuery("findAll", (DatabaseQuery)raq);
        }
        for (OperationModel opModel : this.operations) {
            ProcedureOperationModel procOpModel;
            if (!opModel.isProcedureOperation() || (procOpModel = (ProcedureOperationModel)opModel).getJPubType() == null) continue;
            if (procOpModel.isPLSQLProcedureOperation()) {
                this.buildOROXProjectsForAdvancedPLSQLProcedure(procOpModel);
                continue;
            }
            this.buildOROXProjectsForAdvancedProcedure(procOpModel, nct);
        }
        DatabaseLogin databaseLogin = new DatabaseLogin();
        databaseLogin.removeProperty("user");
        databaseLogin.removeProperty(PASSWORD_KEY);
        databaseLogin.setDriverClassName(null);
        databaseLogin.setConnectionString(null);
        this.orProject.setLogin(databaseLogin);
        XMLLogin xmlLogin = new XMLLogin();
        xmlLogin.setDatasourcePlatform((Platform)new DOMPlatform());
        xmlLogin.getProperties().remove("user");
        xmlLogin.getProperties().remove(PASSWORD_KEY);
        this.oxProject.setLogin((Login)xmlLogin);
    }

    protected void buildOROXProjectsForAdvancedPLSQLProcedure(ProcedureOperationModel procOpModel) {
        PLSQLHelperObjectsBuilder helperObjectsBuilder = new PLSQLHelperObjectsBuilder(this);
        PLSQLORDescriptorBuilder orDescriptorBuilder = new PLSQLORDescriptorBuilder();
        PLSQLOXDescriptorBuilder oxDescriptorBuilder = new PLSQLOXDescriptorBuilder(this.getTargetNamespace());
        PublisherListenerChainAdapter chain = new PublisherListenerChainAdapter();
        chain.addListener(helperObjectsBuilder);
        chain.addListener(orDescriptorBuilder);
        chain.addListener(oxDescriptorBuilder);
        PublisherWalker walker = new PublisherWalker(chain);
        procOpModel.getJPubType().accept(walker);
        if (orDescriptorBuilder.getDescriptors() != null) {
            for (ObjectRelationalDataTypeDescriptor ordtDescriptor : orDescriptorBuilder.getDescriptors()) {
                this.orProject.addDescriptor((ClassDescriptor)ordtDescriptor);
            }
        }
        if (oxDescriptorBuilder.getDescriptors() != null) {
            for (XMLDescriptor xdesc : oxDescriptorBuilder.getDescriptors()) {
                this.oxProject.addDescriptor((ClassDescriptor)xdesc);
            }
        }
        for (DbStoredProcedure storedProcedure : this.dbStoredProcedures) {
            boolean isPLSQLStoredProc = false;
            for (DbStoredArgument arg : storedProcedure.getArguments()) {
                if (!arg.isPLSQLArgument()) continue;
                isPLSQLStoredProc = true;
                break;
            }
            if (!isPLSQLStoredProc) continue;
            PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
            String catalogPrefix = null;
            String cat = storedProcedure.getCatalog();
            catalogPrefix = cat == null | cat.length() == 0 ? "" : cat + ".";
            call.setProcedureName(catalogPrefix + storedProcedure.getName());
            Object dq = null;
            DbStoredProcedureNameAndModel nameAndModel = this.dbStoredProcedure2QueryName.get(storedProcedure);
            String returnType = nameAndModel.procOpModel.getReturnType();
            boolean hasResponse = returnType != null;
            String typ = null;
            XMLDescriptor xdesc = null;
            if (hasResponse) {
                int idx = 0;
                int colonIdx = returnType.indexOf(":");
                idx = colonIdx == -1 ? returnType.indexOf("}") : colonIdx;
                if (idx > 0) {
                    typ = returnType.substring(idx + 1);
                    for (XMLDescriptor xd : this.oxProject.getOrderedDescriptors()) {
                        String context;
                        if (xd.getSchemaReference() == null || !(context = xd.getSchemaReference().getSchemaContext()).substring(1).equals(typ)) continue;
                        xdesc = xd;
                        break;
                    }
                }
            }
            dq = hasResponse ? (nameAndModel.procOpModel.isCollection ? new DataReadQuery() : new ValueReadQuery()) : new DataModifyQuery();
            dq.bindAllParameters();
            dq.setName(nameAndModel.name);
            dq.setCall((Call)call);
            DatabaseType[] typesForMethod = helperObjectsBuilder.getTypesForMethod(storedProcedure.getName());
            int len = typesForMethod.length;
            for (int i = 0; i < len; ++i) {
                DbStoredArgument arg = storedProcedure.getArguments().get(i);
                DatabaseType databaseType = typesForMethod[i];
                Util.InOut direction = arg.getInOut();
                if (direction == Util.InOut.OUT) {
                    call.addNamedOutputArgument(arg.getName(), databaseType);
                } else if (direction == Util.InOut.IN) {
                    call.addNamedArgument(arg.getName(), databaseType);
                } else {
                    call.addNamedInOutputArgument(arg.getName(), databaseType);
                }
                if (!(direction == Util.InOut.IN | direction == Util.InOut.INOUT)) continue;
                if (xdesc != null) {
                    dq.addArgumentByTypeName(arg.getName(), xdesc.getJavaClassName());
                    continue;
                }
                if (databaseType instanceof PLSQLCollection) {
                    dq.addArgument(arg.getName(), Array.class);
                    continue;
                }
                if (databaseType instanceof PLSQLrecord) {
                    dq.addArgument(arg.getName(), Struct.class);
                    continue;
                }
                dq.addArgument(arg.getName(), JDBCTypes.getClassForCode((int)databaseType.getConversionCode()));
            }
            this.orProject.getQueries().add(dq);
        }
    }

    protected void buildOROXProjectsForAdvancedProcedure(ProcedureOperationModel procOpModel, NamingConventionTransformer nct) {
        List<DatabaseQuery> newQueries;
        AdvancedJDBCQueryBuilder queryBuilder = new AdvancedJDBCQueryBuilder(this.dbStoredProcedures, this.dbStoredProcedure2QueryName);
        AdvancedJDBCORDescriptorBuilder orDescriptorBuilder = new AdvancedJDBCORDescriptorBuilder();
        AdvancedJDBCOXDescriptorBuilder oxDescriptorBuilder = new AdvancedJDBCOXDescriptorBuilder(this.getTargetNamespace(), nct);
        PublisherListenerChainAdapter chain = new PublisherListenerChainAdapter();
        chain.addListener(queryBuilder);
        chain.addListener(orDescriptorBuilder);
        chain.addListener(oxDescriptorBuilder);
        PublisherWalker walker = new PublisherWalker(chain);
        procOpModel.getJPubType().accept(walker);
        if (orDescriptorBuilder.getDescriptors() != null) {
            for (ObjectRelationalDataTypeDescriptor ordtDescriptor : orDescriptorBuilder.getDescriptors()) {
                this.orProject.addDescriptor((ClassDescriptor)ordtDescriptor);
            }
        }
        if (oxDescriptorBuilder.getDescriptors() != null) {
            for (XMLDescriptor xdesc : oxDescriptorBuilder.getDescriptors()) {
                this.oxProject.addDescriptor((ClassDescriptor)xdesc);
            }
        }
        if ((newQueries = queryBuilder.getQueries()) != null) {
            this.orProject.getQueries().addAll(newQueries);
        }
    }

    protected void writeOROXProjects(OutputStream dbwsOrStream, OutputStream dbwsOxStream) {
        boolean writeORProject = false;
        if (this.dbTables.size() > 0) {
            writeORProject = true;
        } else if (this.dbStoredProcedures.size() > 0) {
            for (DbStoredProcedure storedProcedure : this.dbStoredProcedures) {
                for (DbStoredArgument storedArgument : storedProcedure.getArguments()) {
                    if (!(storedArgument instanceof PLSQLStoredArgument)) continue;
                    writeORProject = true;
                    break;
                }
                if (!writeORProject) continue;
                break;
            }
            if (!writeORProject) {
                if (this.orProject.getQueries().size() > 0) {
                    writeORProject = true;
                } else if (this.orProject.getDescriptors().size() > 0) {
                    Collection descriptors = this.orProject.getDescriptors().values();
                    for (ClassDescriptor desc : descriptors) {
                        if (!desc.isObjectRelationalDataTypeDescriptor()) continue;
                        writeORProject = true;
                        break;
                    }
                }
            }
        }
        if (writeORProject && !this.isNullStream(dbwsOrStream)) {
            XMLContext context = new XMLContext((Project)new ObjectPersistenceWorkbenchXMLProject());
            context.getSession((Object)this.orProject).getEventManager().addListener((SessionEventListener)new MissingDescriptorListener());
            XMLMarshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)this.orProject, (Writer)new OutputStreamWriter(dbwsOrStream));
        }
        if (!this.isNullStream(dbwsOxStream)) {
            boolean writeOXProject = false;
            if (this.dbTables.size() > 0) {
                writeOXProject = true;
            } else if (this.dbStoredProcedures.size() > 0) {
                for (DbStoredProcedure storedProcedure : this.dbStoredProcedures) {
                    for (DbStoredArgument storedArgument : storedProcedure.getArguments()) {
                        if (!(storedArgument instanceof PLSQLStoredArgument)) continue;
                        writeOXProject = true;
                        break;
                    }
                    if (!writeOXProject) continue;
                    break;
                }
                if (!writeOXProject) {
                    if (this.orProject.getQueries().size() > 0) {
                        writeOXProject = true;
                    } else if (this.orProject.getDescriptors().size() > 0) {
                        Collection descriptors = this.orProject.getDescriptors().values();
                        for (ClassDescriptor desc : descriptors) {
                            if (!desc.isObjectRelationalDataTypeDescriptor()) continue;
                            writeOXProject = true;
                            break;
                        }
                    }
                }
            }
            if (writeOXProject) {
                XMLContext context = new XMLContext((Project)new ObjectPersistenceWorkbenchXMLProject());
                context.getSession((Object)this.oxProject).getEventManager().addListener((SessionEventListener)new MissingDescriptorListener());
                XMLMarshaller marshaller = context.createMarshaller();
                marshaller.marshal((Object)this.oxProject, (Writer)new OutputStreamWriter(dbwsOxStream));
            }
        }
        this.packager.closeOrStream(dbwsOrStream);
        this.packager.closeOxStream(dbwsOxStream);
    }

    protected void writeDBWSProviderClass(OutputStream codeGenProviderStream) {
        if (!this.isNullStream(codeGenProviderStream)) {
            this.logMessage(Level.FINEST, "writing DBWSProvider.class");
            this.packager.writeProviderClass(codeGenProviderStream, this);
            this.packager.closeProviderClassStream(codeGenProviderStream);
        }
    }

    public void writeDBWSProviderSource(OutputStream sourceProviderStream) {
        if (!this.isNullStream(sourceProviderStream)) {
            this.logMessage(Level.FINEST, "writing DBWSProvider.java");
            this.packager.writeProviderSource(sourceProviderStream, this);
            this.packager.closeProviderSourceStream(sourceProviderStream);
        }
    }

    protected void buildSchema(NamingConventionTransformer nct) {
        ArrayList<XMLDescriptor> descriptorsToProcess = new ArrayList<XMLDescriptor>();
        for (XMLDescriptor desc : this.oxProject.getOrderedDescriptors()) {
            String alias = desc.getAlias();
            if ("simple-xml-format".equals(alias)) continue;
            descriptorsToProcess.add(desc);
        }
        if (descriptorsToProcess.size() > 0) {
            StringWriter sw = new StringWriter();
            XMLProjectWriter.write((Project)this.oxProject, (Writer)sw);
            BaseEntityClassLoader specialLoader = new BaseEntityClassLoader(this.getClass().getClassLoader());
            Project oxProjectClone = XMLProjectReader.read((Reader)new StringReader(sw.toString()), (ClassLoader)specialLoader);
            oxProjectClone.convertClassNamesToClasses((ClassLoader)specialLoader);
            for (ClassDescriptor xdesc : oxProjectClone.getDescriptors().values()) {
                if (!BaseEntity.class.isAssignableFrom(xdesc.getJavaClass())) continue;
                int idx = 0;
                for (DatabaseMapping xdm : xdesc.getMappings()) {
                    String attributeName = xdm.getAttributeName();
                    xdm.setAttributeAccessor((AttributeAccessor)new BaseEntityAccessor(attributeName, idx));
                    if (xdm != null) {
                        if (xdm.isForeignReferenceMapping()) {
                            ForeignReferenceMapping frm = (ForeignReferenceMapping)xdm;
                            if (frm.usesIndirection() && frm.getIndirectionPolicy().getClass().isAssignableFrom(BasicIndirectionPolicy.class)) {
                                xdm.setAttributeAccessor((AttributeAccessor)new BaseEntityVHAccessor(attributeName, idx));
                            } else {
                                xdm.setAttributeAccessor((AttributeAccessor)new BaseEntityAccessor(attributeName, idx));
                            }
                        } else {
                            Class clz;
                            XMLField xmlField;
                            xdm.setAttributeAccessor((AttributeAccessor)new BaseEntityAccessor(attributeName, idx));
                            if (xdm.isDirectToFieldMapping()) {
                                XMLDirectMapping xmlDM = (XMLDirectMapping)xdm;
                                xmlField = (XMLField)xmlDM.getField();
                                clz = (Class)org.eclipse.persistence.internal.xr.Util.SCHEMA_2_CLASS.get(xmlField.getSchemaType());
                                if (clz != null) {
                                    xmlField.setType(clz);
                                } else {
                                    xmlField.setType(ClassConstants.OBJECT);
                                }
                            } else if (xdm.isAbstractCompositeDirectCollectionMapping()) {
                                AbstractCompositeDirectCollectionMapping acdcm = (AbstractCompositeDirectCollectionMapping)xdm;
                                xmlField = (XMLField)acdcm.getField();
                                clz = (Class)org.eclipse.persistence.internal.xr.Util.SCHEMA_2_CLASS.get(xmlField.getSchemaType());
                                if (clz != null) {
                                    xmlField.setType(clz);
                                } else {
                                    xmlField.setType(ClassConstants.OBJECT);
                                }
                            }
                        }
                    }
                    ++idx;
                }
                try {
                    Class clz = xdesc.getJavaClass();
                    Method setNumAttrs = clz.getMethod("setNumAttributes", Integer.class);
                    setNumAttrs.invoke((Object)clz, new Integer(idx));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            specialLoader.dontGenerateSubclasses();
            XMLLogin xmlLogin = new XMLLogin();
            DOMPlatform domPlatform = new DOMPlatform();
            domPlatform.getConversionManager().setLoader((ClassLoader)specialLoader);
            xmlLogin.setPlatform((Platform)domPlatform);
            oxProjectClone.setLogin((Login)xmlLogin);
            oxProjectClone.createDatabaseSession();
            SchemaModelGenerator schemaGenerator = new SchemaModelGenerator();
            SchemaModelGeneratorProperties sgProperties = new SchemaModelGeneratorProperties();
            sgProperties.addProperty(this.getTargetNamespace(), "elementFormQualified", (Object)true);
            Map schemaMap = schemaGenerator.generateSchemas(descriptorsToProcess, sgProperties);
            Schema s = (Schema)schemaMap.get(this.getTargetNamespace());
            if (this.schema != null && s != null) {
                Map topLevelComplexTypes = this.schema.getTopLevelComplexTypes();
                for (Map.Entry me : topLevelComplexTypes.entrySet()) {
                    s.addTopLevelComplexTypes((ComplexType)me.getValue());
                }
                NamespaceResolver nr = this.schema.getNamespaceResolver();
                this.schema = s;
                this.schema.setNamespaceResolver(nr);
            }
        } else {
            Util.addSimpleXMLFormat(this.schema);
            this.schema.setTargetNamespace(this.getTargetNamespace());
        }
    }

    protected void writeSchema(OutputStream dbwsSchemaStream) {
        if (!this.isNullStream(dbwsSchemaStream)) {
            boolean hasSwaRef;
            SchemaModelProject schemaProject = new SchemaModelProject();
            boolean bl = hasSwaRef = this.schema.getNamespaceResolver().resolveNamespacePrefix("ref") != null;
            if (hasSwaRef) {
                XMLDescriptor descriptor = (XMLDescriptor)schemaProject.getClassDescriptor(Schema.class);
                descriptor.getNamespaceResolver().put("ref", "http://ws-i.org/profiles/basic/1.1/xsd");
            }
            XMLContext context = new XMLContext((Project)schemaProject);
            XMLMarshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)this.schema, dbwsSchemaStream);
            this.packager.closeSchemaStream(dbwsSchemaStream);
        }
    }

    protected void buildSessionsXML(OutputStream dbwsSessionsStream) {
        if (!this.isNullStream(dbwsSessionsStream)) {
            this.logMessage(Level.FINEST, "Building " + this.getSessionsFileName());
            SessionConfigs ts = this.packager.buildSessionsXML(dbwsSessionsStream, this);
            XMLSessionConfigWriter.write((SessionConfigs)ts, (Writer)new OutputStreamWriter(dbwsSessionsStream));
            this.packager.closeSessionsStream(dbwsSessionsStream);
        }
    }

    protected void buildDBWSModel(NamingConventionTransformer nct, OutputStream dbwsServiceStream) {
        if (!this.isNullStream(dbwsServiceStream)) {
            for (ClassDescriptor desc : this.orProject.getOrderedDescriptors()) {
                String tablenameAlias = desc.getAlias();
                boolean buildCRUDoperations = false;
                for (DbTable dbTable : this.dbTables) {
                    if (!nct.generateSchemaAlias(dbTable.getName()).equals(tablenameAlias)) continue;
                    buildCRUDoperations = true;
                    break;
                }
                if (!buildCRUDoperations) continue;
                QueryOperation findByPKQueryOperation = new QueryOperation();
                findByPKQueryOperation.setName("findByPrimaryKey_" + tablenameAlias);
                findByPKQueryOperation.setUserDefined(false);
                NamedQueryHandler nqh1 = new NamedQueryHandler();
                nqh1.setName("findByPrimaryKey");
                nqh1.setDescriptor(tablenameAlias);
                Result result = new Result();
                QName theInstanceType = new QName(this.getTargetNamespace(), tablenameAlias, "ns1");
                result.setType(theInstanceType);
                findByPKQueryOperation.setResult(result);
                findByPKQueryOperation.setQueryHandler((QueryHandler)nqh1);
                for (DatabaseField field : desc.getPrimaryKeyFields()) {
                    Parameter p = new Parameter();
                    p.setName(field.getName().toLowerCase());
                    p.setType(Util.getXMLTypeFromJDBCType(field.getSqlType()));
                    findByPKQueryOperation.getParameters().add(p);
                }
                this.xrServiceModel.getOperations().put(findByPKQueryOperation.getName(), findByPKQueryOperation);
                QueryOperation findAllOperation = new QueryOperation();
                findAllOperation.setName("findAll_" + tablenameAlias);
                findAllOperation.setUserDefined(false);
                NamedQueryHandler nqh2 = new NamedQueryHandler();
                nqh2.setName("findAll");
                nqh2.setDescriptor(tablenameAlias);
                CollectionResult result2 = new CollectionResult();
                result2.setType(theInstanceType);
                findAllOperation.setResult((Result)result2);
                findAllOperation.setQueryHandler((QueryHandler)nqh2);
                this.xrServiceModel.getOperations().put(findAllOperation.getName(), findAllOperation);
                InsertOperation insertOperation = new InsertOperation();
                insertOperation.setName("create_" + tablenameAlias);
                Parameter theInstance = new Parameter();
                theInstance.setName("theInstance");
                theInstance.setType(theInstanceType);
                insertOperation.getParameters().add(theInstance);
                this.xrServiceModel.getOperations().put(insertOperation.getName(), insertOperation);
                UpdateOperation updateOperation = new UpdateOperation();
                updateOperation.setName("update_" + tablenameAlias);
                updateOperation.getParameters().add(theInstance);
                this.xrServiceModel.getOperations().put(updateOperation.getName(), updateOperation);
                DeleteOperation deleteOperation = new DeleteOperation();
                deleteOperation.setName("delete_" + tablenameAlias);
                deleteOperation.setDescriptorName(tablenameAlias);
                for (DatabaseField field : desc.getPrimaryKeyFields()) {
                    Parameter p = new Parameter();
                    p.setName(field.getName().toLowerCase());
                    p.setType(Util.getXMLTypeFromJDBCType(field.getSqlType()));
                    deleteOperation.getParameters().add(p);
                }
                this.xrServiceModel.getOperations().put(deleteOperation.getName(), deleteOperation);
            }
            for (OperationModel operation : this.operations) {
                if (operation.isTableOperation()) {
                    TableOperationModel tableModel = (TableOperationModel)operation;
                    if (tableModel.additionalOperations == null || tableModel.additionalOperations.size() <= 0) continue;
                    for (OperationModel additionalOperation : tableModel.additionalOperations) {
                        additionalOperation.buildOperation(this);
                    }
                    continue;
                }
                operation.buildOperation(this);
            }
            DBWSModelProject modelProject = new DBWSModelProject();
            modelProject.ns.put("ns1", this.getTargetNamespace());
            XMLContext context = new XMLContext((Project)modelProject);
            XMLMarshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)this.xrServiceModel, dbwsServiceStream);
            this.packager.closeServiceStream(dbwsServiceStream);
        }
    }

    protected void writeAttachmentSchema(OutputStream swarefStream) {
        if (!this.isNullStream(swarefStream)) {
            this.logMessage(Level.FINEST, "writing swaref.xsd");
            OutputStreamWriter osw = new OutputStreamWriter(new BufferedOutputStream(swarefStream));
            try {
                osw.write(WSI_SWAREF_XSD);
                osw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.packager.closeSWARefStream(swarefStream);
        }
    }

    protected void writeWebXML(OutputStream webXmlStream) {
        if (!this.isNullStream(webXmlStream)) {
            this.logMessage(Level.FINEST, "writing web.xml");
            this.packager.writeWebXml(webXmlStream, this);
            this.packager.closeWebXmlStream(webXmlStream);
        }
    }

    public void buildWSDL(OutputStream wsdlStream, NamingConventionTransformer nct) throws WSDLException {
        if (!this.isNullStream(wsdlStream)) {
            this.logMessage(Level.FINEST, "building eclipselink-dbws.wsdl");
            this.wsdlGenerator = new WSDLGenerator(this.xrServiceModel, nct, this.getWsdlLocationURI(), this.packager.hasAttachments(), this.getTargetNamespace(), wsdlStream);
            this.wsdlGenerator.generateWSDL(this.usesSOAP12());
            this.packager.closeWSDLStream(wsdlStream);
        }
    }

    protected ProjectConfig buildORProjectConfig() {
        ProjectXMLConfig orProjectConfig = null;
        boolean useProjectXML = false;
        if (this.dbTables.size() > 0) {
            useProjectXML = true;
        } else if (this.dbStoredProcedures.size() > 0) {
            for (DbStoredProcedure storedProcedure : this.dbStoredProcedures) {
                for (DbStoredArgument storedArgument : storedProcedure.getArguments()) {
                    if (!(storedArgument instanceof PLSQLStoredArgument)) continue;
                    useProjectXML = true;
                    break;
                }
                if (!useProjectXML) continue;
                break;
            }
            if (!useProjectXML) {
                if (this.orProject.getQueries().size() > 0) {
                    useProjectXML = true;
                } else if (this.orProject.getDescriptors().size() > 0) {
                    Collection descriptors = this.orProject.getDescriptors().values();
                    for (ClassDescriptor desc : descriptors) {
                        if (!desc.isObjectRelationalDataTypeDescriptor()) continue;
                        useProjectXML = true;
                        break;
                    }
                }
            }
        }
        if (useProjectXML) {
            orProjectConfig = new ProjectXMLConfig();
            String pathPrefix = this.packager.getOrProjectPathPrefix();
            orProjectConfig.setProjectString(pathPrefix == null ? "eclipselink-dbws-or.xml" : pathPrefix + "eclipselink-dbws-or.xml");
        } else {
            orProjectConfig = new ProjectClassConfig();
            orProjectConfig.setProjectString(Project.class.getName());
        }
        return orProjectConfig;
    }

    protected ProjectConfig buildOXProjectConfig() {
        ProjectXMLConfig oxProjectConfig = null;
        boolean useProjectXML = false;
        if (this.dbTables.size() > 0) {
            useProjectXML = true;
        } else if (this.dbStoredProcedures.size() > 0) {
            for (DbStoredProcedure storedProcedure : this.dbStoredProcedures) {
                for (DbStoredArgument storedArgument : storedProcedure.getArguments()) {
                    if (!(storedArgument instanceof PLSQLStoredArgument)) continue;
                    useProjectXML = true;
                    break;
                }
                if (!useProjectXML) continue;
                break;
            }
            if (!useProjectXML) {
                if (this.orProject.getQueries().size() > 0) {
                    useProjectXML = true;
                } else if (this.orProject.getDescriptors().size() > 0) {
                    Collection descriptors = this.orProject.getDescriptors().values();
                    for (ClassDescriptor desc : descriptors) {
                        if (!desc.isObjectRelationalDataTypeDescriptor()) continue;
                        useProjectXML = true;
                        break;
                    }
                }
            }
        }
        if (useProjectXML) {
            oxProjectConfig = new ProjectXMLConfig();
            String pathPrefix = this.packager.getOxProjectPathPrefix();
            oxProjectConfig.setProjectString(pathPrefix == null ? "eclipselink-dbws-ox.xml" : pathPrefix + "eclipselink-dbws-ox.xml");
        } else {
            oxProjectConfig = new ProjectClassConfig();
            oxProjectConfig.setProjectString(SimpleXMLFormatProject.class.getName());
        }
        return oxProjectConfig;
    }

    protected String getGeneratedJavaClassName(String tableName) {
        String first = tableName.substring(0, 1).toUpperCase();
        String rest = tableName.toLowerCase().substring(1);
        return this.getProjectName().toLowerCase() + "." + first + rest;
    }

    protected boolean hasAttachments() {
        for (Operation op : this.xrServiceModel.getOperationsList()) {
            if (!(op instanceof QueryOperation) || !((QueryOperation)op).isAttachment()) continue;
            return true;
        }
        return false;
    }

    public DBWSPackager getPackager() {
        return this.packager;
    }

    public void setPackager(DBWSPackager packager) {
        this.packager = packager;
    }

    public String getDriver() {
        return (String)this.properties.get(DRIVER_KEY);
    }

    public void setDriver(String driver) {
        this.properties.put(DRIVER_KEY, driver);
    }

    public String getUsername() {
        return (String)this.properties.get(USERNAME_KEY);
    }

    public void setUsername(String username) {
        this.properties.put(USERNAME_KEY, username);
    }

    public String getPassword() {
        return (String)this.properties.get(PASSWORD_KEY);
    }

    public void setPassword(String password) {
        this.properties.put(PASSWORD_KEY, password);
    }

    public String getUrl() {
        return (String)this.properties.get(URL_KEY);
    }

    public void setUrl(String url) {
        this.properties.put(URL_KEY, url);
    }

    public Connection getConnection() {
        if (this.conn == null) {
            String driverClassName = this.getDriver();
            try {
                Class driverClass = null;
                driverClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(driverClassName)) : PrivilegedAccessHelper.getClassForName((String)driverClassName);
                Properties props = new Properties();
                props.put("user", this.getUsername());
                props.put(PASSWORD_KEY, this.getPassword());
                if (this.getPlatformClassname().contains("MySQL")) {
                    props.put("useInformationSchema", "true");
                }
                this.conn = DriverManager.getConnection(this.getUrl(), props);
            }
            catch (Exception e) {
                this.logMessage(Level.SEVERE, "JDBC driver error" + driverClassName, e);
            }
        }
        return this.conn;
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public String getProjectName() {
        return (String)this.properties.get(PROJNAME_KEY);
    }

    public void setProjectName(String projectName) {
        this.properties.put(PROJNAME_KEY, projectName);
    }

    public String getContextRoot() {
        String contextRoot = (String)this.properties.get(CONTEXT_ROOT_KEY);
        if (contextRoot == null) {
            contextRoot = "/" + this.getProjectName();
            this.setContextRoot(contextRoot);
        }
        return contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.properties.put(CONTEXT_ROOT_KEY, contextRoot);
    }

    public String getDataSource() {
        return (String)this.properties.get(DATASOURCE_KEY);
    }

    public void setDataSource(String dataSource) {
        this.properties.put(DATASOURCE_KEY, dataSource);
    }

    public String getSessionsFileName() {
        String sessionsFileName = (String)this.properties.get(SESSIONS_FILENAME_KEY);
        if (NO_SESSIONS_FILENAME.equals(sessionsFileName)) {
            return null;
        }
        if (sessionsFileName == null || sessionsFileName.length() == 0) {
            sessionsFileName = "eclipselink-dbws-sessions.xml";
            this.setSessionsFileName(sessionsFileName);
        }
        return sessionsFileName;
    }

    public void setSessionsFileName(String sessionsFileName) {
        this.properties.put(SESSIONS_FILENAME_KEY, sessionsFileName);
    }

    public String getPlatformClassname() {
        String platformClassname = (String)this.properties.get(PLATFORM_CLASSNAME_KEY);
        if (platformClassname == null || platformClassname.length() == 0) {
            platformClassname = "org.eclipse.persistence.platform.database.OraclePlatform";
            this.setPlatformClassname(platformClassname);
        }
        return platformClassname;
    }

    public void setPlatformClassname(String platformClassname) {
        this.properties.put(PLATFORM_CLASSNAME_KEY, platformClassname);
    }

    public DatabasePlatform getDatabasePlatform() {
        String platformClassname = this.getPlatformClassname();
        try {
            Class platformClass = null;
            platformClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(platformClassname)) : PrivilegedAccessHelper.getClassForName((String)platformClassname);
            this.databasePlatform = (DatabasePlatform)Helper.getInstanceFromClass((Class)platformClass);
        }
        catch (Exception e) {
            this.databasePlatform = new MySQLPlatform();
        }
        return this.databasePlatform;
    }

    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    public Project getOrProject() {
        return this.orProject;
    }

    public Project getOxProject() {
        return this.oxProject;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public XRServiceModel getXrServiceModel() {
        return this.xrServiceModel;
    }

    public String getOrSessionCustomizerClassName() {
        return (String)this.properties.get(ORSESSION_CUSTOMIZER_KEY);
    }

    public void setOrSessionCustomizerClassName(String sessionCustomizerClassName) {
        this.properties.put(ORSESSION_CUSTOMIZER_KEY, sessionCustomizerClassName);
    }

    public String getOxSessionCustomizerClassName() {
        return (String)this.properties.get(OXSESSION_CUSTOMIZER_KEY);
    }

    public void setOXSessionCustomizerClassName(String sessionCustomizerClassName) {
        this.properties.put(OXSESSION_CUSTOMIZER_KEY, sessionCustomizerClassName);
    }

    public WSDLGenerator getWSDLGenerator() {
        return this.wsdlGenerator;
    }

    public String getWsdlLocationURI() {
        String wsdlLocationURI = (String)this.properties.get(WSDL_URI_KEY);
        if (wsdlLocationURI == null || wsdlLocationURI.length() == 0) {
            wsdlLocationURI = "REPLACE_WITH_ENDPOINT_ADDRESS";
        }
        return wsdlLocationURI;
    }

    public void setWsdlLocationURI(String wsdlLocationURI) {
        this.properties.put(WSDL_URI_KEY, wsdlLocationURI);
    }

    public String getLogLevel() {
        return (String)this.properties.get(LOG_LEVEL_KEY);
    }

    public void setLogLevel(String logLevel) {
        this.properties.put(LOG_LEVEL_KEY, logLevel);
    }

    public String getTargetNamespace() {
        String targetNamespace = (String)this.properties.get(TARGET_NAMESPACE_KEY);
        if (targetNamespace == null) {
            targetNamespace = "urn:" + this.getProjectName();
            this.setTargetNamespace(targetNamespace);
        }
        return targetNamespace;
    }

    public Set<String> getTypeDDL() {
        return this.typeDDL;
    }

    public Set<String> getTypeDropDDL() {
        return this.typeDropDDL;
    }

    public void useSOAP12() {
        this.properties.put(USE_SOAP12_KEY, "true");
    }

    public boolean usesSOAP12() {
        boolean useSOAP12 = false;
        String s = (String)this.properties.get(USE_SOAP12_KEY);
        if (s != null) {
            useSOAP12 = s.toLowerCase().equals("true");
        }
        return useSOAP12;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.properties.put(TARGET_NAMESPACE_KEY, targetNamespace);
    }

    protected void logMessage(Level level, String message) {
        if (this.logger != null) {
            this.logger.log(level, message);
        } else if (!this.quiet) {
            System.out.println(message);
        }
    }

    protected void logMessage(Level severe, String message, Exception e) {
        if (this.logger != null) {
            this.logger.log(severe, message, e);
        } else {
            PrintWriter pw = new PrintWriter(System.out);
            e.printStackTrace(pw);
            System.out.println(message);
        }
    }

    protected boolean isNullStream(OutputStream outputStream) {
        return outputStream == null | outputStream == XRPackager.__nullStream;
    }

    public static void buildDbStoredProcedure2QueryNameMap(Map<DbStoredProcedure, DbStoredProcedureNameAndModel> dbStoredProcedure2QueryName, List<DbStoredProcedure> dbStoredProcedures, ArrayList<OperationModel> operations, boolean isOracle) {
        for (OperationModel opModel : operations) {
            if (!opModel.isProcedureOperation()) continue;
            ProcedureOperationModel procOpModel = (ProcedureOperationModel)opModel;
            ArrayList<DbStoredProcedure> matches = new ArrayList<DbStoredProcedure>();
            String modelCatalogPattern = Util.escapePunctuation(procOpModel.getCatalogPattern(), isOracle);
            if ("TOPLEVEL".equalsIgnoreCase(modelCatalogPattern)) {
                modelCatalogPattern = null;
            }
            String modelSchemaPattern = Util.escapePunctuation(procOpModel.getSchemaPattern(), isOracle);
            String modelProcedureNamePattern = Util.escapePunctuation(procOpModel.getProcedurePattern(), isOracle);
            for (DbStoredProcedure storedProc : dbStoredProcedures) {
                boolean procedureNameMatch = Util.sqlMatch(modelProcedureNamePattern, storedProc.getName());
                if (storedProc.getCatalog() == null || modelCatalogPattern == null) {
                    if (storedProc.getSchema() == null) {
                        if (!procedureNameMatch) continue;
                        matches.add(storedProc);
                        continue;
                    }
                    if (!Util.sqlMatch(modelSchemaPattern, storedProc.getSchema()) || !procedureNameMatch) continue;
                    matches.add(storedProc);
                    continue;
                }
                boolean catalogMatch = Util.sqlMatch(modelCatalogPattern, storedProc.getCatalog());
                if (storedProc.getSchema() == null) {
                    if (!catalogMatch || !procedureNameMatch) continue;
                    matches.add(storedProc);
                    continue;
                }
                if (!Util.sqlMatch(modelSchemaPattern, storedProc.getSchema()) || !catalogMatch || !procedureNameMatch) continue;
                matches.add(storedProc);
            }
            if (matches.size() == 1) {
                DbStoredProcedureNameAndModel nameAndModel = new DbStoredProcedureNameAndModel(procOpModel.getName(), procOpModel);
                dbStoredProcedure2QueryName.put((DbStoredProcedure)matches.get(0), nameAndModel);
                continue;
            }
            int len = matches.size();
            for (int i = 0; i < len; ++i) {
                DbStoredProcedureNameAndModel nameAndModel = new DbStoredProcedureNameAndModel(procOpModel.getName() + (i + 1), procOpModel);
                dbStoredProcedure2QueryName.put((DbStoredProcedure)matches.get(i), nameAndModel);
            }
        }
    }

    public NamingConventionTransformer getTopNamingConventionTransformer() {
        return this.topTransformer;
    }

    public void setTopNamingConventionTransformer(NamingConventionTransformer topTransformer) {
        this.topTransformer = topTransformer;
    }

    static {
        ServiceLoader<DBWSPackager> packagers = ServiceLoader.load(DBWSPackager.class);
        for (DBWSPackager packager : packagers) {
            PACKAGERS.put(packager.getPackagerLabel(), packager);
        }
    }

    public static class DbStoredProcedureNameAndModel {
        public String name;
        public ProcedureOperationModel procOpModel;

        DbStoredProcedureNameAndModel(String name, ProcedureOperationModel procOpModel) {
            this.name = name;
            this.procOpModel = procOpModel;
        }
    }
}

