/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import javax.persistence.ValidationMode;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.JPAClassLoaderHolder;
import org.eclipse.persistence.internal.helper.JPAConversionManager;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.deployment.BeanValidationInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAsmFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.weaving.PersistenceWeaver;
import org.eclipse.persistence.internal.jpa.weaving.TransformerFactory;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.security.SecurableObjectHolder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.database.converters.StructConverter;
import org.eclipse.persistence.platform.server.CustomServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.coordination.CommandProcessor;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.eclipse.persistence.sessions.coordination.jms.JMSTopicTransportManager;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ReadConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;
import org.eclipse.persistence.tools.profiler.QueryMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerSetupImpl {
    protected MetadataProcessor processor = null;
    protected PersistenceWeaver weaver = null;
    protected PersistenceUnitInfo persistenceUnitInfo = null;
    protected Map predeployProperties = null;
    protected int factoryCount = 0;
    protected ServerSession session = null;
    protected boolean isInContainerMode = false;
    protected boolean isSessionLoadedFromSessionsXML = false;
    protected Boolean enableWeaving = null;
    protected boolean isWeavingStatic = false;
    protected SecurableObjectHolder securableObjectHolder = new SecurableObjectHolder();
    protected PersistenceInitializationHelper persistenceInitializationHelper = null;
    protected Metamodel metaModel;
    protected List<StructConverter> structConverters = null;
    public static final String STATE_INITIAL = "Initial";
    public static final String STATE_PREDEPLOYED = "Predeployed";
    public static final String STATE_DEPLOYED = "Deployed";
    public static final String STATE_PREDEPLOY_FAILED = "PredeployFailed";
    public static final String STATE_DEPLOY_FAILED = "DeployFailed";
    public static final String STATE_UNDEPLOYED = "Undeployed";
    protected String state = "Initial";
    public static final String ERROR_LOADING_XML_FILE = "error_loading_xml_file";
    public static final String EXCEPTION_LOADING_ENTITY_CLASS = "exception_loading_entity_class";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSessionFromGlobalSessionManager() {
        if (this.session != null) {
            try {
                if (this.session.isConnected()) {
                    this.session.logout();
                }
            }
            finally {
                SessionManager.getManager().getSessions().remove(this.session.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession deploy(ClassLoader realClassLoader, Map additionalProperties) {
        ServerSession serverSession;
        if (this.state != STATE_PREDEPLOYED && this.state != STATE_DEPLOYED) {
            throw new PersistenceException((Throwable)EntityManagerSetupException.cannotDeployWithoutPredeploy((String)this.persistenceUnitInfo.getPersistenceUnitName(), (String)this.state));
        }
        this.session.log(1, "properties", "deploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
        try {
            Map deployProperties = EntityManagerFactoryProvider.mergeMaps(additionalProperties, this.predeployProperties);
            EntityManagerFactoryProvider.translateOldProperties(deployProperties, (AbstractSession)this.session);
            if (this.state == STATE_PREDEPLOYED) {
                serverSession = this.session;
                synchronized (serverSession) {
                    if (this.state == STATE_PREDEPLOYED) {
                        try {
                            this.session.getProject().convertClassNamesToClasses(realClassLoader);
                            if (!this.isSessionLoadedFromSessionsXML) {
                                this.processor.setClassLoader(realClassLoader);
                                this.processor.addEntityListeners();
                                this.addBeanValidationListeners(deployProperties, realClassLoader);
                                this.processor.addNamedQueries();
                                this.processor.processCustomizers();
                                this.structConverters = this.processor.getStructConverters();
                                this.processor = null;
                            }
                            this.initServerSession(deployProperties);
                            if (this.session.getIntegrityChecker().hasErrors()) {
                                this.session.handleException((RuntimeException)new IntegrityException(this.session.getIntegrityChecker()));
                            }
                            this.session.getDatasourcePlatform().getConversionManager().setLoader(realClassLoader);
                            this.state = STATE_DEPLOYED;
                        }
                        catch (RuntimeException ex) {
                            this.state = STATE_DEPLOY_FAILED;
                            throw new PersistenceException((Throwable)EntityManagerSetupException.deployFailed((String)this.persistenceUnitInfo.getPersistenceUnitName(), (RuntimeException)ex));
                        }
                    }
                }
            }
            if (!this.session.isConnected()) {
                serverSession = this.session;
                synchronized (serverSession) {
                    if (!this.session.isConnected()) {
                        this.session.setProperties(deployProperties);
                        this.updateServerSession(deployProperties, realClassLoader);
                        if (this.isValidationOnly(deployProperties, false)) {
                            this.session.initializeDescriptors();
                        } else {
                            if (this.isSessionLoadedFromSessionsXML) {
                                if (!this.session.isConnected()) {
                                    this.session.login();
                                }
                            } else {
                                EntityManagerFactoryProvider.login(this.session, deployProperties);
                            }
                            if (!this.isSessionLoadedFromSessionsXML) {
                                this.addStructConverters((Session)this.session, this.structConverters);
                            }
                            EntityManagerFactoryProvider.generateDDL(this.session, deployProperties);
                        }
                    }
                }
            }
            if (this.weaver != null) {
                this.weaver.clear();
                this.weaver = null;
            }
            this.getMetamodel();
            serverSession = this.session;
        }
        catch (Exception exception) {
            try {
                PersistenceException persistenceException = null;
                persistenceException = exception instanceof PersistenceException ? (PersistenceException)exception : new PersistenceException((Throwable)exception);
                this.session.logThrowable(7, "ejb", (Throwable)exception);
                throw persistenceException;
            }
            catch (Throwable throwable) {
                this.session.log(1, "properties", "deploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
                throw throwable;
            }
        }
        this.session.log(1, "properties", "deploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
        return serverSession;
    }

    protected void addProjectToSession(ServerSession session, Project project) {
        DatasourcePlatform sessionPlatform = (DatasourcePlatform)session.getDatasourceLogin().getDatasourcePlatform();
        DatasourcePlatform projectPlatform = (DatasourcePlatform)project.getDatasourceLogin().getDatasourcePlatform();
        if (!sessionPlatform.hasDefaultSequence() && projectPlatform.hasDefaultSequence()) {
            sessionPlatform.setDefaultSequence(projectPlatform.getDefaultSequence());
        }
        if (sessionPlatform.getSequences() == null || sessionPlatform.getSequences().isEmpty()) {
            if (projectPlatform.getSequences() != null && !projectPlatform.getSequences().isEmpty()) {
                sessionPlatform.setSequences(projectPlatform.getSequences());
            }
        } else if (projectPlatform.getSequences() != null && !projectPlatform.getSequences().isEmpty()) {
            for (Sequence sequence : projectPlatform.getSequences().values()) {
                if (sessionPlatform.getSequences().containsKey(sequence.getName())) continue;
                sessionPlatform.addSequence(sequence);
            }
        }
        session.addDescriptors(project);
    }

    protected void addSessionToGlobalSessionManager() {
        AbstractSession oldSession = (AbstractSession)SessionManager.getManager().getSessions().get(this.session.getName());
        if (oldSession != null) {
            throw new PersistenceException((Throwable)EntityManagerSetupException.attemptedRedeployWithoutClose((String)this.session.getName()));
        }
        SessionManager.getManager().addSession((Session)this.session);
    }

    public void addStructConverters(Session session, List<StructConverter> structConverters) {
        for (StructConverter structConverter : structConverters) {
            if (session.getPlatform().getTypeConverters().get(structConverter.getJavaType()) != null) {
                throw ValidationException.twoStructConvertersAddedForSameClass((String)structConverter.getJavaType().getName());
            }
            session.getPlatform().addStructConverter(structConverter);
        }
    }

    protected void assignCMP3Policy() {
        Project project = this.session.getProject();
        for (ClassDescriptor descriptor : project.getDescriptors().values()) {
            if (descriptor.getCMPPolicy() != null) continue;
            descriptor.setCMPPolicy((CMPPolicy)new CMP3Policy());
        }
    }

    protected boolean updateServerPlatform(Map m, ClassLoader loader) {
        String serverPlatformClassName = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.target-server", (Map)m, (AbstractSession)this.session);
        if (serverPlatformClassName == null) {
            return false;
        }
        ServerPlatform originalServerPlatform = this.session.getServerPlatform();
        String originalServerPlatformClassName = originalServerPlatform.getClass().getName();
        if (originalServerPlatformClassName.equals(serverPlatformClassName)) {
            return false;
        }
        ServerPlatform serverPlatform = null;
        Class cls = EntityManagerSetupImpl.findClassForProperty(serverPlatformClassName, "eclipselink.target-server", loader);
        try {
            Constructor constructor = cls.getConstructor(DatabaseSession.class);
            serverPlatform = (ServerPlatform)constructor.newInstance(this.session);
        }
        catch (Exception ex) {
            if (ExternalTransactionController.class.isAssignableFrom(cls)) {
                if (originalServerPlatform.getClass().equals(CustomServerPlatform.class)) {
                    CustomServerPlatform originalCustomServerPlatform = (CustomServerPlatform)originalServerPlatform;
                    if (!cls.equals(originalCustomServerPlatform.getExternalTransactionControllerClass())) {
                        originalCustomServerPlatform.setExternalTransactionControllerClass(cls);
                    }
                } else {
                    CustomServerPlatform customServerPlatform = new CustomServerPlatform((DatabaseSession)this.session);
                    customServerPlatform.setExternalTransactionControllerClass(cls);
                    serverPlatform = customServerPlatform;
                }
            }
            throw EntityManagerSetupException.failedToInstantiateServerPlatform((String)serverPlatformClassName, (String)"eclipselink.target-server", (Exception)ex);
        }
        if (serverPlatform != null) {
            this.session.setServerPlatform(serverPlatform);
            return true;
        }
        return false;
    }

    protected void updateLoggers(Map persistenceProperties, boolean serverPlatformChanged, boolean sessionNameChanged, ClassLoader loader) {
        block17: {
            String loggerClassName = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.logging.logger", (Map)persistenceProperties, (AbstractSession)this.session);
            SessionLog singletonLog = null;
            SessionLog sessionLog = null;
            if (loggerClassName != null) {
                SessionLog currentLog = this.session.getSessionLog();
                if (loggerClassName.equals("ServerLogger")) {
                    ServerPlatform serverPlatform = this.session.getServerPlatform();
                    singletonLog = serverPlatform.getServerLog();
                    sessionLog = serverPlatform.getServerLog();
                } else if (!currentLog.getClass().getName().equals(loggerClassName)) {
                    Class sessionLogClass = EntityManagerSetupImpl.findClassForProperty(loggerClassName, "eclipselink.logging.logger", loader);
                    try {
                        singletonLog = (SessionLog)sessionLogClass.newInstance();
                        sessionLog = (SessionLog)sessionLogClass.newInstance();
                    }
                    catch (Exception ex) {
                        throw EntityManagerSetupException.failedToInstantiateLogger((String)loggerClassName, (String)"eclipselink.logging.logger", (Exception)ex);
                    }
                }
            } else if (serverPlatformChanged) {
                ServerPlatform serverPlatform = this.session.getServerPlatform();
                singletonLog = serverPlatform.getServerLog();
                sessionLog = serverPlatform.getServerLog();
            }
            if (singletonLog != null && sessionLog != null) {
                AbstractSessionLog.setLog(singletonLog);
                this.session.setSessionLog(sessionLog);
            } else if (sessionNameChanged) {
                this.session.getSessionLog().setSession((Session)this.session);
            }
            this.initOrUpdateLogging(persistenceProperties, AbstractSessionLog.getLog());
            this.initOrUpdateLogging(persistenceProperties, this.session.getSessionLog());
            String loggingFileString = (String)persistenceProperties.get("eclipselink.logging.file");
            if (loggingFileString != null) {
                if (!loggingFileString.trim().equals("")) {
                    try {
                        if (sessionLog == null) break block17;
                        if (sessionLog instanceof AbstractSessionLog) {
                            FileOutputStream fos = new FileOutputStream(loggingFileString);
                            ((AbstractSessionLog)sessionLog).setWriter((OutputStream)fos);
                            break block17;
                        }
                        FileWriter fw = new FileWriter(loggingFileString);
                        sessionLog.setWriter((Writer)fw);
                    }
                    catch (IOException e) {
                        this.session.handleException((RuntimeException)ValidationException.invalidLoggingFile((String)loggingFileString, (Exception)e));
                    }
                } else {
                    this.session.handleException((RuntimeException)ValidationException.invalidLoggingFile());
                }
            }
        }
    }

    protected void updateProfiler(Map persistenceProperties, ClassLoader loader) {
        String newProfilerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.profiler", persistenceProperties, (AbstractSession)this.session);
        if (newProfilerClassName == null) {
            ((ServerPlatformBase)this.session.getServerPlatform()).configureProfiler((Session)this.session);
        } else {
            if (newProfilerClassName.equals("NoProfiler")) {
                this.session.setProfiler(null);
                return;
            }
            if (newProfilerClassName.equals("QueryMonitor")) {
                this.session.setProfiler(null);
                QueryMonitor.shouldMonitor = true;
                return;
            }
            if (newProfilerClassName.equals("PerformanceProfiler")) {
                this.session.setProfiler((SessionProfiler)new PerformanceProfiler());
                return;
            }
            String originalProfilerClassNamer = null;
            if (this.session.getProfiler() != null && (originalProfilerClassNamer = this.session.getProfiler().getClass().getName()).equals(newProfilerClassName)) {
                return;
            }
            try {
                Class newProfilerClass = EntityManagerSetupImpl.findClassForProperty(newProfilerClassName, "eclipselink.profiler", loader);
                SessionProfiler sessionProfiler = (SessionProfiler)EntityManagerSetupImpl.buildObjectForClass(newProfilerClass, SessionProfiler.class);
                if (sessionProfiler != null) {
                    this.session.setProfiler(sessionProfiler);
                } else {
                    this.session.handleException((RuntimeException)ValidationException.invalidProfilerClass((String)newProfilerClassName));
                }
            }
            catch (IllegalAccessException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateProfilerClass((String)newProfilerClassName, (Exception)e));
            }
            catch (PrivilegedActionException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateProfilerClass((String)newProfilerClassName, (Exception)e));
            }
            catch (InstantiationException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateProfilerClass((String)newProfilerClassName, (Exception)e));
            }
        }
    }

    protected static Class findClass(String className, ClassLoader loader) throws ClassNotFoundException, PrivilegedActionException {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, loader));
        }
        return PrivilegedAccessHelper.getClassForName((String)className, (boolean)true, (ClassLoader)loader);
    }

    protected static Class findClassForProperty(String className, String propertyName, ClassLoader loader) {
        try {
            return EntityManagerSetupImpl.findClass(className, loader);
        }
        catch (PrivilegedActionException exception1) {
            throw EntityManagerSetupException.classNotFoundForProperty((String)className, (String)propertyName, (Exception)exception1.getException());
        }
        catch (ClassNotFoundException exception2) {
            throw EntityManagerSetupException.classNotFoundForProperty((String)className, (String)propertyName, (Exception)exception2);
        }
    }

    public ServerSession getSession() {
        return this.session;
    }

    protected static Object buildObjectForClass(Class clazz, Class mustBeImplementedInterface) throws IllegalAccessException, PrivilegedActionException, InstantiationException {
        if (clazz != null && Helper.classImplementsInterface((Class)clazz, (Class)mustBeImplementedInterface)) {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
            }
            return PrivilegedAccessHelper.newInstanceFromClass((Class)clazz);
        }
        return null;
    }

    protected void updateDescriptorCacheSettings(Map m, ClassLoader loader) {
        String defaultSharedString;
        String defaultSizeString;
        Map typeMap = PropertiesHandler.getPrefixValuesLogDebug((String)"eclipselink.cache.type.", (Map)m, (AbstractSession)this.session);
        Map sizeMap = PropertiesHandler.getPrefixValuesLogDebug((String)"eclipselink.cache.size.", (Map)m, (AbstractSession)this.session);
        Map sharedMap = PropertiesHandler.getPrefixValuesLogDebug((String)"eclipselink.cache.shared.", (Map)m, (AbstractSession)this.session);
        if (typeMap.isEmpty() && sizeMap.isEmpty() && sharedMap.isEmpty()) {
            return;
        }
        String defaultTypeName = (String)typeMap.remove("default");
        if (defaultTypeName != null) {
            Class defaultType = EntityManagerSetupImpl.findClassForProperty(defaultTypeName, "eclipselink.cache.type.default", this.getClass().getClassLoader());
            this.session.getProject().setDefaultIdentityMapClass(defaultType);
        }
        if ((defaultSizeString = (String)sizeMap.remove("default")) != null) {
            int defaultSize = Integer.parseInt(defaultSizeString);
            this.session.getProject().setDefaultIdentityMapSize(defaultSize);
        }
        if ((defaultSharedString = (String)sharedMap.remove("default")) != null) {
            boolean defaultShared = Boolean.parseBoolean(defaultSharedString);
            this.session.getProject().setDefaultIsIsolated(!defaultShared);
        }
        Iterator it = this.session.getDescriptors().values().iterator();
        while (!(!it.hasNext() || typeMap.isEmpty() && sizeMap.isEmpty() && sharedMap.isEmpty())) {
            String sharedString;
            String sizeString;
            ClassDescriptor descriptor = (ClassDescriptor)it.next();
            if (descriptor.isDescriptorTypeAggregate()) continue;
            String entityName = descriptor.getAlias();
            String className = descriptor.getJavaClass().getName();
            String name = entityName;
            String typeName = (String)typeMap.remove(name);
            if (typeName == null) {
                name = className;
                typeName = (String)typeMap.remove(name);
            }
            if (typeName != null) {
                Class type = EntityManagerSetupImpl.findClassForProperty(typeName, "eclipselink.cache.type." + name, this.getClass().getClassLoader());
                descriptor.setIdentityMapClass(type);
            }
            if ((sizeString = (String)sizeMap.remove(name = entityName)) == null) {
                name = className;
                sizeString = (String)sizeMap.remove(name);
            }
            if (sizeString != null) {
                int size = Integer.parseInt(sizeString);
                descriptor.setIdentityMapSize(size);
            }
            if ((sharedString = (String)sharedMap.remove(name = entityName)) == null) {
                name = className;
                sharedString = (String)sharedMap.remove(name);
            }
            if (sharedString == null) continue;
            boolean shared = Boolean.parseBoolean(sharedString);
            descriptor.setIsIsolated(!shared);
        }
    }

    protected void updateConnectionPolicy(Map m) {
        ConnectionPolicy.ExclusiveMode exclusiveMode;
        String isLazyString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.exclusive-connection.is-lazy", m, (AbstractSession)this.session);
        if (isLazyString != null) {
            this.session.getDefaultConnectionPolicy().setIsLazy(Boolean.parseBoolean(isLazyString));
        }
        if ((exclusiveMode = EntityManagerSetupImpl.getConnectionPolicyExclusiveModeFromProperties(m, (AbstractSession)this.session, true)) != null) {
            this.session.getDefaultConnectionPolicy().setExclusiveMode(exclusiveMode);
        }
    }

    public static ConnectionPolicy.ExclusiveMode getConnectionPolicyExclusiveModeFromProperties(Map m, AbstractSession abstractSession, boolean useSystemAsDefault) {
        String exclusiveConnectionModeString = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.jdbc.exclusive-connection.mode", (Map)m, (AbstractSession)abstractSession, (boolean)useSystemAsDefault);
        if (exclusiveConnectionModeString != null) {
            if (exclusiveConnectionModeString == "Isolated") {
                return ConnectionPolicy.ExclusiveMode.Isolated;
            }
            if (exclusiveConnectionModeString == "Always") {
                return ConnectionPolicy.ExclusiveMode.Always;
            }
            return ConnectionPolicy.ExclusiveMode.Transactional;
        }
        return null;
    }

    public synchronized ClassTransformer predeploy(PersistenceUnitInfo info, Map extendedProperties) {
        ClassLoader privateClassLoader = null;
        if (this.state == STATE_DEPLOY_FAILED) {
            throw new PersistenceException((Throwable)EntityManagerSetupException.cannotPredeploy((String)this.persistenceUnitInfo.getPersistenceUnitName(), (String)this.state));
        }
        if (this.state == STATE_PREDEPLOYED || this.state == STATE_DEPLOYED) {
            this.session.log(1, "properties", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
            ++this.factoryCount;
            this.session.log(1, "properties", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
            return null;
        }
        if (this.state == STATE_INITIAL || this.state == STATE_UNDEPLOYED) {
            this.persistenceUnitInfo = info;
        }
        try {
            this.predeployProperties = EntityManagerFactoryProvider.mergeMaps(extendedProperties, this.persistenceUnitInfo.getProperties());
            EntityManagerFactoryProvider.translateOldProperties(this.predeployProperties, null);
            String sessionsXMLStr = (String)this.predeployProperties.get("eclipselink.sessions-xml");
            String sessionNameStr = (String)this.predeployProperties.get("eclipselink.session-name");
            if (sessionsXMLStr != null) {
                this.isSessionLoadedFromSessionsXML = true;
            }
            this.session = new ServerSession(new Project(new DatabaseLogin()));
            this.setServerSessionName(this.predeployProperties);
            ClassLoader realClassLoader = this.persistenceUnitInfo.getClassLoader();
            this.updateServerPlatform(this.predeployProperties, realClassLoader);
            this.updateLoggers(this.predeployProperties, true, false, realClassLoader);
            if (!this.isInContainerMode && this.state == STATE_UNDEPLOYED) {
                privateClassLoader = realClassLoader;
            } else {
                JPAClassLoaderHolder privateClassLoaderHolder = this.session.getServerPlatform().getNewTempClassLoader(info);
                privateClassLoader = privateClassLoaderHolder.getClassLoader();
                if (!privateClassLoaderHolder.isTempClassLoader()) {
                    // empty if block
                }
            }
            this.updateProfiler(this.predeployProperties, realClassLoader);
            this.session.log(1, "properties", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
            if (this.isSessionLoadedFromSessionsXML) {
                this.session.log(1, "properties", "loading_session_xml", (Object)sessionsXMLStr, (Object)sessionNameStr);
                if (sessionNameStr == null) {
                    throw new PersistenceException((Throwable)EntityManagerSetupException.sessionNameNeedBeSpecified((String)info.getPersistenceUnitName(), (String)sessionsXMLStr));
                }
                XMLSessionConfigLoader xmlLoader = new XMLSessionConfigLoader(sessionsXMLStr);
                AbstractSession tempSession = new SessionManager().getSession(xmlLoader, sessionNameStr, privateClassLoader, false, false);
                this.session.log(1, "properties", "sessions_xml_path_where_session_load_from", (Object)xmlLoader.getSessionName(), (Object)xmlLoader.getResourcePath());
                if (tempSession == null) {
                    throw new PersistenceException((Throwable)ValidationException.noSessionFound((String)sessionNameStr, (String)sessionsXMLStr));
                }
                if (!tempSession.isServerSession()) {
                    throw new PersistenceException((Throwable)EntityManagerSetupException.sessionLoadedFromSessionsXMLMustBeServerSession((String)info.getPersistenceUnitName(), (String)((String)this.predeployProperties.get("eclipselink.sessions-xml")), (Object)tempSession));
                }
                this.session = (ServerSession)tempSession;
                this.setServerSessionName(this.predeployProperties);
                this.updateServerPlatform(this.predeployProperties, privateClassLoader);
                this.updateLoggers(this.predeployProperties, true, false, privateClassLoader);
            }
            EntityManagerFactoryProvider.warnOldProperties(this.predeployProperties, (AbstractSession)this.session);
            this.session.getPlatform().setConversionManager((ConversionManager)new JPAConversionManager());
            PersistenceUnitTransactionType transactionType = null;
            String transTypeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", this.predeployProperties, (AbstractSession)this.session);
            if (transTypeString != null) {
                transactionType = PersistenceUnitTransactionType.valueOf((String)transTypeString);
            } else if (this.persistenceUnitInfo != null) {
                transactionType = this.persistenceUnitInfo.getTransactionType();
            }
            if (!this.isValidationOnly(this.predeployProperties, false) && this.persistenceUnitInfo != null && transactionType == PersistenceUnitTransactionType.JTA && this.predeployProperties.get("javax.persistence.jtaDataSource") == null && this.persistenceUnitInfo.getJtaDataSource() == null) {
                throw new PersistenceException((Throwable)EntityManagerSetupException.jtaPersistenceUnitInfoMissingJtaDataSource((String)this.persistenceUnitInfo.getPersistenceUnitName()));
            }
            if (this.state == STATE_INITIAL || this.state == STATE_UNDEPLOYED) {
                if (null == this.enableWeaving) {
                    this.enableWeaving = Boolean.TRUE;
                }
                this.isWeavingStatic = false;
                String weaving = this.getConfigPropertyAsString("eclipselink.weaving");
                if (weaving != null && weaving.equalsIgnoreCase("false")) {
                    this.enableWeaving = Boolean.FALSE;
                } else if (weaving != null && weaving.equalsIgnoreCase("static")) {
                    this.isWeavingStatic = true;
                }
            }
            boolean throwExceptionOnFail = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.orm.throw.exceptions", this.predeployProperties, "true", (AbstractSession)this.session));
            boolean weaveChangeTracking = false;
            boolean weaveLazy = false;
            boolean weaveEager = false;
            boolean weaveFetchGroups = false;
            boolean weaveInternal = false;
            if (this.enableWeaving.booleanValue()) {
                weaveChangeTracking = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.changetracking", this.predeployProperties, "true", (AbstractSession)this.session));
                weaveLazy = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.lazy", this.predeployProperties, "true", (AbstractSession)this.session));
                weaveEager = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.eager", this.predeployProperties, "false", (AbstractSession)this.session));
                weaveFetchGroups = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.fetchgroups", this.predeployProperties, "true", (AbstractSession)this.session));
                weaveInternal = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.internal", this.predeployProperties, "true", (AbstractSession)this.session));
            }
            if (!this.isSessionLoadedFromSessionsXML) {
                this.processor = new MetadataProcessor(this.persistenceUnitInfo, (AbstractSession)this.session, privateClassLoader, this.enableWeaving, weaveEager);
                PersistenceUnitProcessor.processORMetadata(this.processor, throwExceptionOnFail);
                if (this.session.getIntegrityChecker().hasErrors()) {
                    this.session.handleException((RuntimeException)new IntegrityException(this.session.getIntegrityChecker()));
                }
                if (this.enableWeaving.booleanValue()) {
                    Collection<MetadataClass> entities = PersistenceUnitProcessor.buildEntityList(this.processor, privateClassLoader);
                    this.weaver = TransformerFactory.createTransformerAndModifyProject((Session)this.session, entities, privateClassLoader, weaveLazy, weaveChangeTracking, weaveFetchGroups, weaveInternal);
                }
            } else if (this.enableWeaving.booleanValue()) {
                ArrayList<MetadataClass> persistenceClasses = new ArrayList<MetadataClass>();
                MetadataAsmFactory factory = new MetadataAsmFactory(new MetadataLogger((AbstractSession)this.session), privateClassLoader);
                Iterator iterator = this.session.getProject().getDescriptors().keySet().iterator();
                while (iterator.hasNext()) {
                    persistenceClasses.add(factory.getMetadataClass(((Class)iterator.next()).getName()));
                }
                this.weaver = TransformerFactory.createTransformerAndModifyProject((Session)this.session, persistenceClasses, privateClassLoader, weaveLazy, weaveChangeTracking, weaveFetchGroups, weaveInternal);
            }
            if (this.state != STATE_INITIAL && this.state != STATE_UNDEPLOYED || this.isInContainerMode()) {
                ++this.factoryCount;
            }
            this.state = STATE_PREDEPLOYED;
            this.session.log(1, "properties", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
            if (this.isWeavingStatic) {
                return null;
            }
            return this.weaver;
        }
        catch (RuntimeException ex) {
            this.state = STATE_PREDEPLOY_FAILED;
            this.session = null;
            throw new PersistenceException((Throwable)EntityManagerSetupException.predeployFailed((String)this.persistenceUnitInfo.getPersistenceUnitName(), (RuntimeException)ex));
        }
    }

    public String getConfigPropertyAsString(String propertyKey, String defaultValue) {
        return EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(propertyKey, this.predeployProperties, defaultValue, (AbstractSession)this.session);
    }

    public String getConfigPropertyAsString(String propertyKey) {
        return EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(propertyKey, this.predeployProperties, (AbstractSession)this.session);
    }

    public String getDeployedSessionName() {
        return this.session != null ? this.session.getName() : null;
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.persistenceUnitInfo;
    }

    public boolean isValidationOnly(Map m) {
        return this.isValidationOnly(m, true);
    }

    protected boolean isValidationOnly(Map m, boolean shouldMergeMap) {
        String validationOnlyString;
        if (shouldMergeMap) {
            m = this.mergeWithExistingMap(m);
        }
        if ((validationOnlyString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.validation-only", m, (AbstractSession)this.session)) != null) {
            return Boolean.parseBoolean(validationOnlyString);
        }
        return false;
    }

    public boolean shouldGetSessionOnCreateFactory(Map m) {
        m = this.mergeWithExistingMap(m);
        return this.isValidationOnly(m, false);
    }

    protected Map mergeWithExistingMap(Map m) {
        if (this.predeployProperties != null) {
            return EntityManagerFactoryProvider.mergeMaps(m, this.predeployProperties);
        }
        if (this.persistenceUnitInfo != null) {
            return EntityManagerFactoryProvider.mergeMaps(m, this.persistenceUnitInfo.getProperties());
        }
        return m;
    }

    public boolean isInContainerMode() {
        return this.isInContainerMode;
    }

    protected void updateCacheCoordination(Map m, ClassLoader loader) {
        String protocol = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.protocol", m, (AbstractSession)this.session);
        if (protocol != null) {
            String channel;
            String asynch;
            String removeOnError;
            String context;
            String password;
            String user;
            RemoteCommandManager rcm = new RemoteCommandManager((CommandProcessor)this.session);
            if (protocol.equalsIgnoreCase("jms")) {
                String factory;
                String topic;
                JMSTopicTransportManager transport = new JMSTopicTransportManager(rcm);
                rcm.setTransportManager((TransportManager)transport);
                String host = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.host", m, (AbstractSession)this.session);
                if (host != null) {
                    transport.setTopicHostUrl(host);
                }
                if ((topic = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.topic", m, (AbstractSession)this.session)) != null) {
                    transport.setTopicName(topic);
                }
                if ((factory = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.factory", m, (AbstractSession)this.session)) != null) {
                    transport.setTopicConnectionFactoryName(factory);
                }
            } else if (protocol.equalsIgnoreCase("rmi")) {
                String url;
                String timeToLive;
                String port;
                String multicast;
                String delay = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.announcement-delay", m, (AbstractSession)this.session);
                if (delay != null) {
                    rcm.getDiscoveryManager().setAnnouncementDelay(Integer.parseInt(delay));
                }
                if ((multicast = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.multicast-group", m, (AbstractSession)this.session)) != null) {
                    rcm.getDiscoveryManager().setMulticastGroupAddress(multicast);
                }
                if ((port = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.multicast-group.port", m, (AbstractSession)this.session)) != null) {
                    rcm.getDiscoveryManager().setMulticastPort(Integer.parseInt(port));
                }
                if ((timeToLive = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.packet-time-to-live", m, (AbstractSession)this.session)) != null) {
                    rcm.getDiscoveryManager().setPacketTimeToLive(Integer.parseInt(timeToLive));
                }
                if ((url = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.url", m, (AbstractSession)this.session)) != null) {
                    rcm.setUrl(url);
                }
            } else {
                Class transportClass = EntityManagerSetupImpl.findClassForProperty(protocol, "eclipselink.cache.coordination.protocol", loader);
                try {
                    rcm.setTransportManager((TransportManager)transportClass.newInstance());
                }
                catch (Exception invalid) {
                    throw new RuntimeException(invalid);
                }
            }
            String naming = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.naming-service", m, (AbstractSession)this.session);
            if (naming != null) {
                if (naming.equalsIgnoreCase("jndi")) {
                    rcm.getTransportManager().setNamingServiceType(0);
                } else if (naming.equalsIgnoreCase("rmi")) {
                    rcm.getTransportManager().setNamingServiceType(1);
                }
            }
            if ((user = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jndi.user", m, (AbstractSession)this.session)) != null) {
                rcm.getTransportManager().setUserName(user);
            }
            if ((password = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jndi.password", m, (AbstractSession)this.session)) != null) {
                rcm.getTransportManager().setPassword(password);
            }
            if ((context = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jndi.initial-context-factory", m, (AbstractSession)this.session)) != null) {
                rcm.getTransportManager().setInitialContextFactoryName(context);
            }
            if ((removeOnError = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.remove-connection-on-error", m, (AbstractSession)this.session)) != null) {
                rcm.getTransportManager().setShouldRemoveConnectionOnError(removeOnError.equalsIgnoreCase("true"));
            }
            if ((asynch = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.propagate-asynchronously", m, (AbstractSession)this.session)) != null) {
                rcm.setShouldPropagateAsynchronously(asynch.equalsIgnoreCase("true"));
            }
            if ((channel = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.channel", m, (AbstractSession)this.session)) != null) {
                rcm.setChannel(channel);
            }
            this.session.setCommandManager((CommandManager)rcm);
            this.session.setShouldPropagateChanges(true);
        }
    }

    protected void updateLogins(Map m) {
        String eclipselinkPlatform;
        DatabaseLogin login = this.session.getLogin();
        String user = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.user", m, (AbstractSession)this.session);
        String password = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.password", m, (AbstractSession)this.session);
        if (user != null) {
            login.setUserName(user);
        }
        if (password != null) {
            login.setPassword(this.securableObjectHolder.getSecurableObject().decryptPassword(password));
        }
        if ((eclipselinkPlatform = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.target-database", (Map)m, (AbstractSession)this.session)) != null) {
            login.setPlatformClassName(eclipselinkPlatform, this.persistenceUnitInfo.getClassLoader());
        }
        PersistenceUnitTransactionType transactionType = this.persistenceUnitInfo.getTransactionType();
        String transTypeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", m, (AbstractSession)this.session);
        if (transTypeString != null) {
            transactionType = PersistenceUnitTransactionType.valueOf((String)transTypeString);
        }
        DataSource jtaDatasource = this.getDatasourceFromProperties(m, "javax.persistence.jtaDataSource", this.persistenceUnitInfo.getJtaDataSource());
        DataSource nonjtaDatasource = this.getDatasourceFromProperties(m, "javax.persistence.nonJtaDataSource", this.persistenceUnitInfo.getNonJtaDataSource());
        if (this.isValidationOnly(m, false) && transactionType == PersistenceUnitTransactionType.JTA && jtaDatasource == null) {
            this.updateLoginDefaultConnector((DatasourceLogin)login, m);
            return;
        }
        login.setUsesExternalTransactionController(transactionType == PersistenceUnitTransactionType.JTA);
        DataSource mainDatasource = null;
        DataSource readDatasource = null;
        if (login.shouldUseExternalTransactionController()) {
            mainDatasource = jtaDatasource;
            readDatasource = nonjtaDatasource;
        } else {
            if (jtaDatasource != null) {
                this.session.log(6, "transaction", "resource_local_persistence_init_info_ignores_jta_data_source", (Object)this.persistenceUnitInfo.getPersistenceUnitName());
            }
            if (nonjtaDatasource != null) {
                mainDatasource = nonjtaDatasource;
            } else {
                this.updateLoginDefaultConnector((DatasourceLogin)login, m);
                return;
            }
        }
        if (!(login.getConnector() instanceof JNDIConnector)) {
            JNDIConnector jndiConnector = mainDatasource instanceof DataSourceImpl ? new JNDIConnector(((DataSourceImpl)mainDatasource).getName()) : new JNDIConnector(mainDatasource);
            login.setConnector((Connector)jndiConnector);
            login.setUsesExternalConnectionPooling(true);
        }
        if (readDatasource != null) {
            DatasourceLogin readLogin = (DatasourceLogin)login.clone();
            readLogin.dontUseExternalTransactionController();
            JNDIConnector jndiConnector = readDatasource instanceof DataSourceImpl ? new JNDIConnector(((DataSourceImpl)readDatasource).getName()) : new JNDIConnector(readDatasource);
            readLogin.setConnector((Connector)jndiConnector);
            this.session.setReadConnectionPool((Login)readLogin);
        }
    }

    protected DataSource getDatasourceFromProperties(Map m, String property, DataSource defaultDataSource) {
        Object datasource = EntityManagerFactoryProvider.getConfigPropertyLogDebug(property, m, (AbstractSession)this.session);
        if (datasource == null) {
            return defaultDataSource;
        }
        if (datasource instanceof String) {
            return new DataSourceImpl((String)datasource, null, null, null);
        }
        if (!(datasource instanceof DataSource)) {
            this.session.log(6, "properties", "invalid_datasource_property_value", (Object)property, datasource);
            return defaultDataSource;
        }
        return (DataSource)datasource;
    }

    protected void updateLoginDefaultConnector(DatasourceLogin login, Map m) {
        if (login.getConnector() instanceof DefaultConnector) {
            DatabaseLogin dbLogin = (DatabaseLogin)login;
            String jdbcDriver = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.driver", m, (AbstractSession)this.session);
            String connectionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.url", m, (AbstractSession)this.session);
            if (connectionString != null) {
                dbLogin.setConnectionString(connectionString);
            }
            if (jdbcDriver != null) {
                dbLogin.setDriverClassName(jdbcDriver);
            }
        }
    }

    protected void updatePools(Map m) {
        String sequenceDataSource;
        String sequence;
        if (!this.session.getDefaultConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
            String initial;
            String max;
            String min = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.connections.min", m, (AbstractSession)this.session);
            if (min != null) {
                this.session.getDefaultConnectionPool().setMinNumberOfConnections(Integer.parseInt(min));
            }
            if ((max = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.connections.max", m, (AbstractSession)this.session)) != null) {
                this.session.getDefaultConnectionPool().setMaxNumberOfConnections(Integer.parseInt(max));
            }
            if ((initial = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.connections.initial", m, (AbstractSession)this.session)) != null) {
                this.session.getDefaultConnectionPool().setInitialNumberOfConnections(Integer.parseInt(initial));
            }
            if ((min = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.write-connections.min", m, (AbstractSession)this.session)) != null) {
                this.session.getDefaultConnectionPool().setMinNumberOfConnections(Integer.parseInt(min));
            }
            if ((max = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.write-connections.max", m, (AbstractSession)this.session)) != null) {
                this.session.getDefaultConnectionPool().setMaxNumberOfConnections(Integer.parseInt(max));
            }
            if ((initial = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.write-connections.initial", m, (AbstractSession)this.session)) != null) {
                this.session.getDefaultConnectionPool().setInitialNumberOfConnections(Integer.parseInt(initial));
            }
        }
        if (!this.session.getReadConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
            String wait;
            String initial;
            String max;
            String shared = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.shared", m, (AbstractSession)this.session);
            boolean isShared = false;
            if (shared != null) {
                isShared = Boolean.parseBoolean(shared);
            }
            Object pool = null;
            pool = isShared ? new ReadConnectionPool("read", this.session.getReadConnectionPool().getLogin(), this.session) : new ConnectionPool("read", this.session.getReadConnectionPool().getLogin(), this.session);
            String min = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.min", m, (AbstractSession)this.session);
            if (min != null) {
                pool.setMinNumberOfConnections(Integer.parseInt(min));
            }
            if ((max = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.max", m, (AbstractSession)this.session)) != null) {
                pool.setMaxNumberOfConnections(Integer.parseInt(max));
            }
            if ((initial = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.initial", m, (AbstractSession)this.session)) != null) {
                pool.setInitialNumberOfConnections(Integer.parseInt(initial));
            }
            if (isShared || min != null || max != null || initial != null) {
                this.session.setReadConnectionPool((ConnectionPool)pool);
            }
            if ((wait = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.connections.wait-timeout", m, (AbstractSession)this.session)) != null) {
                this.session.getDefaultConnectionPool().setWaitTimeout(Integer.parseInt(wait));
                pool.setWaitTimeout(Integer.parseInt(wait));
            }
        }
        if ((sequence = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool", m, (AbstractSession)this.session)) != null) {
            this.session.getSequencingControl().setShouldUseSeparateConnection(Boolean.parseBoolean(sequence));
        }
        if ((sequenceDataSource = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.non-jta-data-source", m, (AbstractSession)this.session)) != null) {
            DatasourceLogin login = (DatasourceLogin)this.session.getLogin().clone();
            login.dontUseExternalTransactionController();
            JNDIConnector jndiConnector = new JNDIConnector(sequenceDataSource);
            login.setConnector((Connector)jndiConnector);
            this.session.getSequencingControl().setLogin((Login)login);
        }
        if (!this.session.getReadConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
            String initial;
            String max;
            String min = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.min", m, (AbstractSession)this.session);
            if (min != null) {
                this.session.getSequencingControl().setMinPoolSize(Integer.parseInt(min));
            }
            if ((max = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.max", m, (AbstractSession)this.session)) != null) {
                this.session.getSequencingControl().setMaxPoolSize(Integer.parseInt(max));
            }
            if ((initial = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.initial", m, (AbstractSession)this.session)) != null) {
                this.session.getSequencingControl().setInitialPoolSize(Integer.parseInt(initial));
            }
        }
    }

    protected void initServerSession(Map properties) {
        this.assignCMP3Policy();
        String newName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session-name", properties, (AbstractSession)this.session);
        if (newName != null && !newName.equals(this.session.getName())) {
            this.session.setName(newName);
        }
        this.addSessionToGlobalSessionManager();
    }

    protected void setServerSessionName(Map m) {
        String name = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.session-name", m);
        if (name == null) {
            name = this.persistenceUnitInfo.getPersistenceUnitRootUrl() != null ? this.persistenceUnitInfo.getPersistenceUnitRootUrl().toString() + "-" + this.persistenceUnitInfo.getPersistenceUnitName() : this.persistenceUnitInfo.getPersistenceUnitName();
        }
        this.session.setName(name);
    }

    protected void updateServerSession(Map m, ClassLoader loader) {
        if (this.session == null || this.session.isConnected()) {
            return;
        }
        boolean serverPlatformChanged = this.updateServerPlatform(m, loader);
        boolean sessionNameChanged = this.updateSessionName(m);
        this.updateLoggers(m, serverPlatformChanged, sessionNameChanged, loader);
        this.updateProfiler(m, loader);
        String shouldBindString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.bind-parameters", m, (AbstractSession)this.session);
        if (shouldBindString != null) {
            this.session.getPlatform().setShouldBindAllParameters(Boolean.parseBoolean(shouldBindString));
        }
        this.updateLogins(m);
        if (!this.session.getLogin().shouldUseExternalTransactionController()) {
            this.session.getServerPlatform().disableJTA();
        }
        this.setSessionEventListener(m, loader);
        this.setExceptionHandler(m, loader);
        this.updatePools(m);
        if (!this.isSessionLoadedFromSessionsXML) {
            this.updateDescriptorCacheSettings(m, loader);
        }
        this.updateConnectionPolicy(m);
        this.updateBatchWritingSetting(m);
        this.updateNativeSQLSetting(m);
        this.updateUppercaseSetting(m);
        this.updateCacheStatementSettings(m);
        this.updateTemporalMutableSetting(m);
        this.updateAllowZeroIdSetting(m);
        this.updatePessimisticLockTimeout(m);
        this.updateQueryTimeout(m);
        this.updateCacheCoordination(m, loader);
        this.processDescriptorCustomizers(m, loader);
        this.processSessionCustomizer(m, loader);
        this.setDescriptorNamedQueries(m);
    }

    public void setIsInContainerMode(boolean isInContainerMode) {
        this.isInContainerMode = isInContainerMode;
    }

    protected void processSessionCustomizer(Map m, ClassLoader loader) {
        String sessionCustomizerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session.customizer", m, (AbstractSession)this.session);
        if (sessionCustomizerClassName == null) {
            return;
        }
        Class sessionCustomizerClass = EntityManagerSetupImpl.findClassForProperty(sessionCustomizerClassName, "eclipselink.session.customizer", loader);
        try {
            SessionCustomizer sessionCustomizer = (SessionCustomizer)sessionCustomizerClass.newInstance();
            sessionCustomizer.customize((Session)this.session);
        }
        catch (Exception ex) {
            throw EntityManagerSetupException.failedWhileProcessingProperty((String)"eclipselink.session.customizer", (String)sessionCustomizerClassName, (Exception)ex);
        }
    }

    protected void initOrUpdateLogging(Map m, SessionLog log) {
        String exString;
        String sessionString;
        String threadString;
        String tsString;
        Map categoryLogLevelMap;
        String logLevelString = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.logging.level", (Map)m, (AbstractSession)this.session);
        if (logLevelString != null) {
            log.setLevel(AbstractSessionLog.translateStringToLoggingLevel((String)logLevelString));
        }
        if (!(categoryLogLevelMap = PropertiesHandler.getPrefixValuesLogDebug((String)"eclipselink.logging.level.", (Map)m, (AbstractSession)this.session)).isEmpty()) {
            for (Map.Entry entry : categoryLogLevelMap.entrySet()) {
                String category = (String)entry.getKey();
                String value = (String)entry.getValue();
                log.setLevel(AbstractSessionLog.translateStringToLoggingLevel((String)value), category);
            }
        }
        if ((tsString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.timestamp", m, (AbstractSession)this.session)) != null) {
            log.setShouldPrintDate(Boolean.parseBoolean(tsString));
        }
        if ((threadString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.thread", m, (AbstractSession)this.session)) != null) {
            log.setShouldPrintThread(Boolean.parseBoolean(threadString));
        }
        if ((sessionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.session", m, (AbstractSession)this.session)) != null) {
            log.setShouldPrintSession(Boolean.parseBoolean(sessionString));
        }
        if ((exString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.exceptions", m, (AbstractSession)this.session)) != null) {
            log.setShouldLogExceptionStackTrace(Boolean.parseBoolean(exString));
        }
    }

    protected boolean updateSessionName(Map m) {
        String newName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session-name", m, (AbstractSession)this.session);
        if (newName == null || newName.equals(this.session.getName())) {
            return false;
        }
        this.removeSessionFromGlobalSessionManager();
        this.session.setName(newName);
        this.addSessionToGlobalSessionManager();
        return true;
    }

    protected void processDescriptorCustomizers(Map m, ClassLoader loader) {
        Map customizerMap = PropertiesHandler.getPrefixValuesLogDebug((String)"eclipselink.descriptor.customizer.", (Map)m, (AbstractSession)this.session);
        if (customizerMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : customizerMap.entrySet()) {
            String name = (String)entry.getKey();
            ClassDescriptor descriptor = this.session.getDescriptorForAlias(name);
            if (descriptor == null) {
                try {
                    Class javaClass = EntityManagerSetupImpl.findClass(name, loader);
                    descriptor = this.session.getDescriptor(javaClass);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (descriptor == null) continue;
            String customizerClassName = (String)entry.getValue();
            Class customizerClass = EntityManagerSetupImpl.findClassForProperty(customizerClassName, "eclipselink.descriptor.customizer." + name, loader);
            try {
                DescriptorCustomizer customizer = (DescriptorCustomizer)customizerClass.newInstance();
                customizer.customize(descriptor);
            }
            catch (Exception ex) {
                throw EntityManagerSetupException.failedWhileProcessingProperty((String)("eclipselink.descriptor.customizer." + name), (String)customizerClassName, (Exception)ex);
            }
        }
    }

    public boolean isInitial() {
        return this.state == STATE_INITIAL;
    }

    public boolean isPredeployed() {
        return this.state == STATE_PREDEPLOYED;
    }

    public boolean isDeployed() {
        return this.state == STATE_DEPLOYED;
    }

    public boolean isUndeployed() {
        return this.state == STATE_UNDEPLOYED;
    }

    public boolean isPredeployFailed() {
        return this.state == STATE_PREDEPLOY_FAILED;
    }

    public boolean isDeployFailed() {
        return this.state == STATE_DEPLOY_FAILED;
    }

    public int getFactoryCount() {
        return this.factoryCount;
    }

    public boolean shouldRedeploy() {
        return this.state == STATE_UNDEPLOYED || this.state == STATE_PREDEPLOY_FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undeploy() {
        block13: {
            block12: {
                if (this.state == STATE_INITIAL || this.state == STATE_PREDEPLOY_FAILED || this.state == STATE_UNDEPLOYED) {
                    return;
                }
                this.session.log(1, "properties", "undeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
                try {
                    --this.factoryCount;
                    if (this.factoryCount <= 0) break block12;
                }
                catch (Throwable throwable) {
                    this.session.log(1, "properties", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
                    if (this.state == STATE_UNDEPLOYED) {
                        this.session = null;
                    }
                    throw throwable;
                }
                this.session.log(1, "properties", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
                if (this.state == STATE_UNDEPLOYED) {
                    this.session = null;
                }
                return;
            }
            this.state = STATE_UNDEPLOYED;
            this.removeSessionFromGlobalSessionManager();
            HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
            synchronized (hashMap) {
                String puName;
                String esiName = puName = PersistenceUnitProcessor.buildPersistenceUnitName(this.getPersistenceUnitInfo().getPersistenceUnitRootUrl(), this.getPersistenceUnitInfo().getPersistenceUnitName());
                if (this.predeployProperties.get("eclipselink.session-name") != null) {
                    esiName = puName + this.predeployProperties.get("eclipselink.session-name");
                }
                EntityManagerFactoryProvider.emSetupImpls.remove(esiName);
                if (--EntityManagerFactoryProvider.PUIUsageCount <= 0) {
                    EntityManagerFactoryProvider.persistenceUnits.remove(puName);
                }
            }
            if (null == this.persistenceInitializationHelper) break block13;
            this.persistenceInitializationHelper.unsetInitializer();
        }
        this.session.log(1, "properties", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
        if (this.state == STATE_UNDEPLOYED) {
            this.session = null;
        }
    }

    protected void setSessionEventListener(Map m, ClassLoader loader) {
        String sessionEventListenerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session-event-listener", m, (AbstractSession)this.session);
        if (sessionEventListenerClassName != null) {
            Class sessionEventListenerClass = EntityManagerSetupImpl.findClassForProperty(sessionEventListenerClassName, "eclipselink.session-event-listener", loader);
            try {
                SessionEventListener sessionEventListener = (SessionEventListener)EntityManagerSetupImpl.buildObjectForClass(sessionEventListenerClass, SessionEventListener.class);
                if (sessionEventListener != null) {
                    this.session.getEventManager().getListeners().add(sessionEventListener);
                } else {
                    this.session.handleException((RuntimeException)ValidationException.invalidSessionEventListenerClass((String)sessionEventListenerClassName));
                }
            }
            catch (IllegalAccessException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateSessionEventListenerClass((String)sessionEventListenerClassName, (Exception)e));
            }
            catch (PrivilegedActionException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateSessionEventListenerClass((String)sessionEventListenerClassName, (Exception)e));
            }
            catch (InstantiationException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateSessionEventListenerClass((String)sessionEventListenerClassName, (Exception)e));
            }
        }
    }

    protected void setExceptionHandler(Map m, ClassLoader loader) {
        String exceptionHandlerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.exception-handler", m, (AbstractSession)this.session);
        if (exceptionHandlerClassName != null) {
            Class exceptionHandlerClass = EntityManagerSetupImpl.findClassForProperty(exceptionHandlerClassName, "eclipselink.exception-handler", loader);
            try {
                ExceptionHandler exceptionHandler = (ExceptionHandler)EntityManagerSetupImpl.buildObjectForClass(exceptionHandlerClass, ExceptionHandler.class);
                if (exceptionHandler != null) {
                    this.session.setExceptionHandler(exceptionHandler);
                } else {
                    this.session.handleException((RuntimeException)ValidationException.invalidExceptionHandlerClass((String)exceptionHandlerClassName));
                }
            }
            catch (IllegalAccessException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateExceptionHandlerClass((String)exceptionHandlerClassName, (Exception)e));
            }
            catch (PrivilegedActionException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateExceptionHandlerClass((String)exceptionHandlerClassName, (Exception)e));
            }
            catch (InstantiationException e) {
                this.session.handleException((RuntimeException)ValidationException.cannotInstantiateExceptionHandlerClass((String)exceptionHandlerClassName, (Exception)e));
            }
        }
    }

    protected void updateBatchWritingSetting(Map persistenceProperties) {
        String sizeString;
        String batchWritingSettingString = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.jdbc.batch-writing", (Map)persistenceProperties, (AbstractSession)this.session);
        if (batchWritingSettingString != null) {
            this.session.getPlatform().setUsesBatchWriting(batchWritingSettingString != "None");
            if (batchWritingSettingString == "JDBC") {
                this.session.getPlatform().setUsesJDBCBatchWriting(true);
                this.session.getPlatform().setUsesNativeBatchWriting(false);
            } else if (batchWritingSettingString == "Buffered") {
                this.session.getPlatform().setUsesJDBCBatchWriting(false);
                this.session.getPlatform().setUsesNativeBatchWriting(false);
            } else if (batchWritingSettingString == "Oracle-JDBC") {
                this.session.getPlatform().setUsesNativeBatchWriting(true);
                this.session.getPlatform().setUsesJDBCBatchWriting(true);
            }
        }
        if ((sizeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.batch-writing.size", persistenceProperties, (AbstractSession)this.session)) != null) {
            try {
                this.session.getPlatform().setMaxBatchWritingSize(Integer.parseInt(sizeString));
            }
            catch (NumberFormatException invalid) {
                this.session.handleException((RuntimeException)ValidationException.invalidValueForProperty((String)sizeString, (String)"eclipselink.jdbc.batch-writing.size", (Exception)invalid));
            }
        }
    }

    protected void updateNativeSQLSetting(Map m) {
        String nativeSQLString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.native-sql", m, (AbstractSession)this.session);
        if (nativeSQLString != null) {
            if (nativeSQLString.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().useNativeSQL();
            } else if (nativeSQLString.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().dontUseNativeSQL();
            } else {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForSettingNativeSQL((String)nativeSQLString));
            }
        }
    }

    protected void updateUppercaseSetting(Map m) {
        String uppercaseString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.uppercase-columns", m, (AbstractSession)this.session);
        if (uppercaseString != null) {
            if (uppercaseString.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(true);
            } else if (uppercaseString.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(false);
            } else {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForProperty((String)uppercaseString, (String)"eclipselink.jdbc.uppercase-columns"));
            }
        }
    }

    protected void updatePessimisticLockTimeout(Map persistenceProperties) {
        String pessimisticLockTimeout = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.lock.timeout", persistenceProperties, (AbstractSession)this.session);
        if (pessimisticLockTimeout != null) {
            try {
                this.session.setPessimisticLockTimeoutDefault(Integer.valueOf(Integer.parseInt(pessimisticLockTimeout)));
            }
            catch (NumberFormatException invalid) {
                this.session.handleException((RuntimeException)ValidationException.invalidValueForProperty((String)pessimisticLockTimeout, (String)"javax.persistence.lock.timeout", (Exception)invalid));
            }
        }
    }

    protected void updateCacheStatementSettings(Map m) {
        String cacheStatementsSize;
        String statmentsNeedBeCached = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.cache-statements", m, (AbstractSession)this.session);
        if (statmentsNeedBeCached != null) {
            if (statmentsNeedBeCached.equalsIgnoreCase("true")) {
                if (this.session.getConnectionPools().size() > 0) {
                    this.session.getProject().getLogin().setShouldCacheAllStatements(true);
                } else {
                    this.session.log(6, "properties", "persistence_unit_ignores_statments_cache_setting", new Object[]{null});
                }
            } else if (statmentsNeedBeCached.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().setShouldCacheAllStatements(false);
            } else {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForEnableStatmentsCached((String)statmentsNeedBeCached));
            }
        }
        if ((cacheStatementsSize = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.cache-statements.size", m, (AbstractSession)this.session)) != null) {
            try {
                this.session.getProject().getLogin().setStatementCacheSize(Integer.parseInt(cacheStatementsSize));
            }
            catch (NumberFormatException e) {
                this.session.handleException((RuntimeException)ValidationException.invalidCacheStatementsSize((String)cacheStatementsSize, (String)e.getMessage()));
            }
        }
    }

    protected void updateAllowZeroIdSetting(Map m) {
        String allowZero = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.allow-zero-id", m, (AbstractSession)this.session);
        if (allowZero != null) {
            if (allowZero.equalsIgnoreCase("true")) {
                Helper.isZeroValidPrimaryKey = true;
            } else if (allowZero.equalsIgnoreCase("false")) {
                Helper.isZeroValidPrimaryKey = false;
            } else {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForProperty((String)allowZero, (String)"eclipselink.allow-zero-id"));
            }
        }
    }

    protected void updateTemporalMutableSetting(Map m) {
        String temporalMutable = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.temporal.mutable", m, (AbstractSession)this.session);
        if (temporalMutable != null) {
            if (temporalMutable.equalsIgnoreCase("true")) {
                this.session.getProject().setDefaultTemporalMutable(true);
            } else if (temporalMutable.equalsIgnoreCase("false")) {
                this.session.getProject().setDefaultTemporalMutable(false);
            } else {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForProperty((String)temporalMutable, (String)"eclipselink.temporal.mutable"));
            }
        }
    }

    protected void setDescriptorNamedQueries(Map m) {
        String addNamedQueriesString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session.include.descriptor.queries", m, (AbstractSession)this.session);
        if (addNamedQueriesString != null) {
            if (addNamedQueriesString.equalsIgnoreCase("true")) {
                this.session.copyDescriptorNamedQueries(false);
            } else if (!addNamedQueriesString.equalsIgnoreCase("false")) {
                this.session.handleException((RuntimeException)ValidationException.invalidBooleanValueForAddingNamedQueries((String)addNamedQueriesString));
            }
        }
    }

    public PersistenceInitializationHelper getPersistenceInitializationHelper() {
        return this.persistenceInitializationHelper;
    }

    public void setPersistenceInitializationHelper(PersistenceInitializationHelper persistenceInitializationHelper) {
        this.persistenceInitializationHelper = persistenceInitializationHelper;
    }

    private void updateQueryTimeout(Map persistenceProperties) {
        String QueryTimeout = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.query.timeout", persistenceProperties, (AbstractSession)this.session);
        if (QueryTimeout != null) {
            this.session.setQueryTimeoutDefault(Integer.parseInt(QueryTimeout));
        }
    }

    private void addBeanValidationListeners(Map puProperties, ClassLoader appClassLoader) {
        ValidationMode validationMode = EntityManagerSetupImpl.getValidationMode(this.persistenceUnitInfo, puProperties);
        if (validationMode == ValidationMode.AUTO || validationMode == ValidationMode.CALLBACK) {
            String helperClassName = "org.eclipse.persistence.internal.jpa.deployment.BeanValidationInitializationHelper$BeanValidationInitializationHelperImpl";
            ClassLoader eclipseLinkClassLoader = EntityManagerSetupImpl.class.getClassLoader();
            try {
                Class helperClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(helperClassName, true, eclipseLinkClassLoader)) : PrivilegedAccessHelper.getClassForName((String)helperClassName, (boolean)true, (ClassLoader)eclipseLinkClassLoader);
                BeanValidationInitializationHelper beanValidationInitializationHelper = (BeanValidationInitializationHelper)helperClass.newInstance();
                beanValidationInitializationHelper.bootstrapBeanValidation(puProperties, (AbstractSession)this.session, this.processor.getProject(), appClassLoader);
            }
            catch (Throwable e) {
                if (validationMode == ValidationMode.CALLBACK) {
                    throw PersistenceUnitLoadingException.exceptionObtainingRequiredBeanValidatorFactory((Throwable)e);
                }
                this.session.logMessage("Could not initialize Validation Factory. Encountered following exception: " + e);
            }
        }
    }

    private static ValidationMode getValidationMode(PersistenceUnitInfo persitenceUnitInfo, Map puProperties) {
        String validationModeAtEMFCreation;
        ValidationMode validationMode = null;
        try {
            Method method = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                method = (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(PersistenceUnitInfo.class, "getValidationMode", null));
                validationMode = (ValidationMode)AccessController.doPrivileged(new PrivilegedMethodInvoker(method, (Object)persitenceUnitInfo));
            } else {
                method = PrivilegedAccessHelper.getDeclaredMethod(PersistenceUnitInfo.class, (String)"getValidationMode", null);
                validationMode = (ValidationMode)PrivilegedAccessHelper.invokeMethod((Method)method, (Object)persitenceUnitInfo, null);
            }
        }
        catch (Throwable exception) {
            // empty catch block
        }
        if (validationMode == null) {
            validationMode = ValidationMode.AUTO;
        }
        if ((validationModeAtEMFCreation = (String)puProperties.get("javax.persistence.validation.mode")) != null) {
            validationMode = ValidationMode.valueOf((String)validationModeAtEMFCreation);
        }
        return validationMode;
    }

    public Metamodel getMetamodel() {
        if (null == this.metaModel) {
            this.metaModel = new MetamodelImpl(this);
            this.initializeCanonicalMetamodel(this.metaModel);
        }
        return this.metaModel;
    }

    /*
     * Exception decompiling
     */
    protected void initializeCanonicalMetamodel(Metamodel model) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setMetamodel(Metamodel aMetamodel) {
        this.metaModel = aMetamodel;
    }
}

