/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.deployment.Archive;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.logging.AbstractSessionLog;

public abstract class JPAInitializer {
    protected boolean shouldCreateInternalLoader = true;
    protected ClassLoader initializationClassloader = null;

    public static void initializeTopLinkLoggingFile() {
        String loggingFile = System.getProperty("eclipselink.logging.file");
        try {
            if (loggingFile != null) {
                AbstractSessionLog.getLog().setWriter((Writer)new FileWriter(loggingFile));
            }
        }
        catch (IOException e) {
            AbstractSessionLog.getLog().log(6, "cmp_init_default_logging_file_is_invalid", (Object)loggingFile, (Object)e);
        }
    }

    public boolean callPredeploy(PersistenceUnitInfo persistenceUnitInfo, Map m, PersistenceInitializationHelper persistenceHelper) {
        String providerClassName = persistenceUnitInfo.getPersistenceProviderClassName();
        if (this.isPersistenceProviderSupported(providerClassName)) {
            String emName;
            EntityManagerSetupImpl emSetupImpl;
            String sessionName = (String)m.get("eclipselink.session-name");
            if (sessionName == null) {
                sessionName = (String)persistenceUnitInfo.getProperties().get("eclipselink.session-name");
            }
            if (sessionName == null) {
                sessionName = "";
            }
            if ((emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(emName = PersistenceUnitProcessor.buildPersistenceUnitName(persistenceUnitInfo.getPersistenceUnitRootUrl(), persistenceUnitInfo.getPersistenceUnitName()) + sessionName)) != null && !emSetupImpl.isUndeployed()) {
                return false;
            }
            AbstractSessionLog.getLog().log(2, "cmp_init_invoke_predeploy", (Object)persistenceUnitInfo.getPersistenceUnitName());
            Map mergedProperties = EntityManagerFactoryProvider.mergeMaps(m, persistenceUnitInfo.getProperties());
            this.checkWeaving(mergedProperties);
            if (persistenceUnitInfo instanceof SEPersistenceUnitInfo) {
                Set<String> tempLoaderSet = PersistenceUnitProcessor.buildClassSet(persistenceUnitInfo, Thread.currentThread().getContextClassLoader());
                ClassLoader tempLoader = this.createTempLoader(tempLoaderSet);
                ((SEPersistenceUnitInfo)persistenceUnitInfo).setNewTempClassLoader(tempLoader);
                ((SEPersistenceUnitInfo)persistenceUnitInfo).setClassLoader(persistenceHelper.getClassLoader(persistenceUnitInfo.getPersistenceUnitName(), m));
            }
            if (emSetupImpl == null) {
                emSetupImpl = new EntityManagerSetupImpl();
                EntityManagerFactoryProvider.addEntityManagerSetupImpl(emName, emSetupImpl);
                ++EntityManagerFactoryProvider.PUIUsageCount;
            }
            ClassTransformer transformer = emSetupImpl.predeploy(persistenceUnitInfo, mergedProperties);
            this.registerTransformer(transformer, persistenceUnitInfo);
            return true;
        }
        return false;
    }

    public abstract void checkWeaving(Map var1);

    protected abstract ClassLoader createTempLoader(Collection var1);

    protected abstract ClassLoader createTempLoader(Collection var1, boolean var2);

    public void initialize(Map m, PersistenceInitializationHelper persistenceHelper) {
        this.initializeClassLoader(persistenceHelper);
        Set<Archive> pars = PersistenceUnitProcessor.findPersistenceArchives(this.initializationClassloader);
        for (Archive archive : pars) {
            AbstractSessionLog.getLog().log(2, "cmp_init_initialize", (Object)archive);
            this.initPersistenceUnits(archive, m, persistenceHelper);
        }
    }

    protected void initPersistenceUnits(Archive archive, Map m, PersistenceInitializationHelper persistenceActivator) {
        for (SEPersistenceUnitInfo persistenceUnitInfo : PersistenceUnitProcessor.getPersistenceUnits(archive, this.initializationClassloader)) {
            EntityManagerFactoryProvider.persistenceUnits.put(PersistenceUnitProcessor.buildPersistenceUnitName(persistenceUnitInfo.getPersistenceUnitRootUrl(), persistenceUnitInfo.getPersistenceUnitName()), persistenceUnitInfo);
            this.callPredeploy(persistenceUnitInfo, m, persistenceActivator);
        }
    }

    public boolean isPersistenceProviderSupported(String providerClassName) {
        return providerClassName == null || providerClassName.equals("") || providerClassName.equals(EntityManagerFactoryProvider.class.getName()) || providerClassName.equals(PersistenceProvider.class.getName());
    }

    protected Set loadEntityClasses(Collection entityNames, ClassLoader classLoader) {
        HashSet entityClasses = new HashSet();
        AbstractSessionLog.getLog().log(2, "cmp_loading_entities_using_loader", (Object)classLoader);
        for (String entityClassName : entityNames) {
            try {
                entityClasses.add(classLoader.loadClass(entityClassName));
            }
            catch (ClassNotFoundException cnfEx) {
                throw ValidationException.entityClassNotFound((String)entityClassName, (ClassLoader)classLoader, (Exception)cnfEx);
            }
        }
        return entityClasses;
    }

    public abstract void registerTransformer(ClassTransformer var1, PersistenceUnitInfo var2);

    public void initializeClassLoader(PersistenceInitializationHelper persistenceHelper) {
    }
}

