/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.JavaSECMPInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceInitializationHelper {
    public static final String PERSISTENCE_XML_PATH = "META-INF/persistence.xml";

    public JPAInitializer getInitializer(ClassLoader classLoader, Map m) {
        return JavaSECMPInitializer.getJavaSECMPInitializer();
    }

    public void unsetInitializer() {
        if (null != JavaSECMPInitializer.javaSECMPInitializer) {
            if (JavaSECMPInitializer.javaSECMPInitializer.isSingletonInitialized()) {
                JavaSECMPInitializer.javaSECMPInitializer.initializationClassloader = null;
                JavaSECMPInitializer.globalInstrumentation = null;
            }
        }
    }

    public ClassLoader getClassLoader(String emName, Map properties) {
        ClassLoader classloader = null;
        if (properties != null) {
            classloader = (ClassLoader)properties.get("eclipselink.classloader");
        }
        if (classloader == null) {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        return classloader;
    }

    public Enumeration<URL> getPersistenceResources(ClassLoader classloader) {
        Enumeration<URL> persistenceResources = EmptyPersistenceResourcesEnumeration.theEmptyEnumeration;
        try {
            persistenceResources = classloader.getResources(PERSISTENCE_XML_PATH);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return persistenceResources;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyPersistenceResourcesEnumeration
    implements Enumeration<URL> {
        static EmptyPersistenceResourcesEnumeration theEmptyEnumeration = new EmptyPersistenceResourcesEnumeration();

        private EmptyPersistenceResourcesEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            throw new NoSuchElementException();
        }
    }
}

