/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sessions.Session;

public class WriteLockManager {
    public static int MAXTRIES = 10000;
    protected ExposedNodeLinkedList prevailingQueue = new ExposedNodeLinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map acquireLocksForClone(Object objectForClone, ClassDescriptor descriptor, CacheKey cacheKey, AbstractSession session, UnitOfWorkImpl unitOfWork) {
        boolean successful = false;
        IdentityHashMap lockedObjects = new IdentityHashMap();
        IdentityHashMap<Object, Object> refreshedObjects = new IdentityHashMap<Object, Object>();
        try {
            CacheKey toWaitOn = this.acquireLockAndRelatedLocks(objectForClone, lockedObjects, refreshedObjects, cacheKey, descriptor, session, unitOfWork);
            int tries = 0;
            while (toWaitOn != null) {
                Object lockedList = lockedObjects.values().iterator();
                while (lockedList.hasNext()) {
                    ((CacheKey)lockedList.next()).releaseReadLock();
                    lockedList.remove();
                }
                lockedList = toWaitOn.getMutex();
                synchronized (lockedList) {
                    try {
                        if (toWaitOn.isAcquired()) {
                            toWaitOn.getMutex().wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                Object waitObject = toWaitOn.getObject();
                if (waitObject != null) {
                    unitOfWork.checkInvalidObject(waitObject, toWaitOn, session.getDescriptor(waitObject));
                    refreshedObjects.put(waitObject, waitObject);
                }
                if ((toWaitOn = this.acquireLockAndRelatedLocks(objectForClone, lockedObjects, refreshedObjects, cacheKey, descriptor, session, unitOfWork)) == null || ++tries <= MAXTRIES) continue;
                throw ConcurrencyException.maxTriesLockOnCloneExceded(objectForClone);
            }
            successful = true;
        }
        finally {
            if (!successful) {
                Iterator lockedList = lockedObjects.values().iterator();
                while (lockedList.hasNext()) {
                    ((CacheKey)lockedList.next()).releaseReadLock();
                    lockedList.remove();
                }
            }
        }
        return lockedObjects;
    }

    public CacheKey acquireLockAndRelatedLocks(Object objectForClone, Map lockedObjects, Map refreshedObjects, CacheKey cacheKey, ClassDescriptor descriptor, AbstractSession session, UnitOfWorkImpl unitOfWork) {
        if (!refreshedObjects.containsKey(objectForClone) && this.checkInvalidObject(objectForClone, cacheKey, descriptor, unitOfWork)) {
            return cacheKey;
        }
        if (cacheKey.acquireReadLockNoWait()) {
            if (cacheKey.getObject() == null) {
                lockedObjects.put(objectForClone, cacheKey);
            } else {
                objectForClone = cacheKey.getObject();
                if (lockedObjects.containsKey(objectForClone)) {
                    cacheKey.releaseReadLock();
                    return null;
                }
                lockedObjects.put(objectForClone, cacheKey);
            }
            return this.traverseRelatedLocks(objectForClone, lockedObjects, refreshedObjects, descriptor, session, unitOfWork);
        }
        return cacheKey;
    }

    public boolean checkInvalidObject(Object object, CacheKey cacheKey, ClassDescriptor descriptor, UnitOfWorkImpl unitOfWork) {
        if (!unitOfWork.isNestedUnitOfWork() && cacheKey.getObject() != null) {
            CacheInvalidationPolicy cachePolicy = descriptor.getCacheInvalidationPolicy();
            return cachePolicy.shouldRefreshInvalidObjectsInUnitOfWork() && cachePolicy.isInvalidated(cacheKey);
        }
        return false;
    }

    public void transitionToDeferredLocks(MergeManager mergeManager) {
        try {
            if (mergeManager.isTransitionedToDeferredLocks()) {
                return;
            }
            for (CacheKey cacheKey : mergeManager.getAcquiredLocks()) {
                cacheKey.transitionToDeferredLock();
            }
            mergeManager.transitionToDeferredLocks();
        }
        catch (RuntimeException ex) {
            for (CacheKey cacheKey : mergeManager.getAcquiredLocks()) {
                cacheKey.release();
            }
            ConcurrencyManager.getDeferredLockManager(Thread.currentThread()).setIsThreadComplete(true);
            ConcurrencyManager.removeDeferredLockManager(Thread.currentThread());
            mergeManager.getAcquiredLocks().clear();
            throw ex;
        }
    }

    public CacheKey traverseRelatedLocks(Object objectForClone, Map lockedObjects, Map refreshedObjects, ClassDescriptor descriptor, AbstractSession session, UnitOfWorkImpl unitOfWork) {
        if (descriptor.shouldAcquireCascadedLocks()) {
            FetchGroupManager fetchGroupManager = descriptor.getFetchGroupManager();
            boolean isPartialObject = fetchGroupManager != null && fetchGroupManager.isPartialObject(objectForClone);
            for (DatabaseMapping mapping : descriptor.getLockableMappings()) {
                CacheKey toWaitOn;
                if (isPartialObject && !fetchGroupManager.isAttributeFetched(objectForClone, mapping.getAttributeName())) continue;
                Object objectToLock = mapping.getAttributeValueFromObject(objectForClone);
                if (mapping.isCollectionMapping()) {
                    if (objectToLock == null) continue;
                    ContainerPolicy cp = mapping.getContainerPolicy();
                    Object iterator = cp.iteratorFor(objectToLock);
                    while (cp.hasNext(iterator)) {
                        CacheKey toWaitOn2;
                        Object object = cp.next(iterator, session);
                        if (mapping.getReferenceDescriptor().hasWrapperPolicy()) {
                            object = mapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(object, session);
                        }
                        if ((toWaitOn2 = this.checkAndLockObject(object, lockedObjects, refreshedObjects, mapping, session, unitOfWork)) == null) continue;
                        return toWaitOn2;
                    }
                    continue;
                }
                if (mapping.getReferenceDescriptor().hasWrapperPolicy()) {
                    objectToLock = mapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(objectToLock, session);
                }
                if ((toWaitOn = this.checkAndLockObject(objectToLock, lockedObjects, refreshedObjects, mapping, session, unitOfWork)) == null) continue;
                return toWaitOn;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireRequiredLocks(MergeManager mergeManager, UnitOfWorkChangeSet changeSet) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        boolean locksToAcquire = true;
        try {
            mergeManager.setLockThread(Thread.currentThread());
            Object session = mergeManager.getSession();
            if (((AbstractSession)session).isUnitOfWork()) {
                session = ((UnitOfWorkImpl)session).getParent();
            }
            block19: while (locksToAcquire) {
                locksToAcquire = false;
                for (Map<ObjectChangeSet, ObjectChangeSet> changeSets : changeSet.getObjectChanges().values()) {
                    ClassDescriptor descriptor = null;
                    for (ObjectChangeSet objectChangeSet : changeSets.values()) {
                        if (objectChangeSet.getCacheKey() == null) continue;
                        if (descriptor == null && (descriptor = objectChangeSet.getDescriptor()) == null) {
                            descriptor = ((AbstractSession)session).getDescriptor(objectChangeSet.getClassType((Session)session));
                        }
                        if (descriptor.shouldIsolateObjectsInUnitOfWork()) break;
                        CacheKey activeCacheKey = this.attemptToAcquireLock(descriptor, objectChangeSet.getCacheKey(), (AbstractSession)session);
                        if (activeCacheKey == null) {
                            if (this.prevailingQueue.getFirst() == mergeManager) {
                                activeCacheKey = this.waitOnObjectLock(descriptor, objectChangeSet.getCacheKey(), (AbstractSession)session, (int)Math.round(Math.random() * 500.0));
                            }
                            if (activeCacheKey == null) {
                                block32: {
                                    Object[] params;
                                    this.releaseAllAcquiredLocks(mergeManager);
                                    activeCacheKey = ((AbstractSession)session).getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(objectChangeSet.getCacheKey().getKey(), descriptor.getJavaClass(), descriptor);
                                    if (((AbstractSession)session).shouldLog(2, "cache")) {
                                        params = new Object[]{descriptor.getJavaClass(), objectChangeSet.getCacheKey() != null ? objectChangeSet.getCacheKey().getKey() : new Vector(), Thread.currentThread().getName()};
                                        ((AbstractSession)session).log(2, "cache", "dead_lock_encountered_on_write_no_cachekey", params, null, true);
                                    }
                                    if (mergeManager.getWriteLockQueued() == null) {
                                        params = this.prevailingQueue;
                                        synchronized (params) {
                                            mergeManager.setQueueNode(this.prevailingQueue.addLast(mergeManager));
                                        }
                                    }
                                    mergeManager.setWriteLockQueued(objectChangeSet.getCacheKey());
                                    try {
                                        if (activeCacheKey == null) break block32;
                                        params = activeCacheKey.getMutex();
                                        synchronized (params) {
                                            if (activeCacheKey.getMutex().isAcquired() && activeCacheKey.getMutex().getActiveThread() != Thread.currentThread()) {
                                                activeCacheKey.getMutex().wait();
                                            }
                                        }
                                    }
                                    catch (InterruptedException exception) {
                                        throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
                                    }
                                }
                                locksToAcquire = true;
                                break;
                            }
                            objectChangeSet.setActiveCacheKey(activeCacheKey);
                            mergeManager.getAcquiredLocks().add(activeCacheKey);
                            continue;
                        }
                        objectChangeSet.setActiveCacheKey(activeCacheKey);
                        mergeManager.getAcquiredLocks().add(activeCacheKey);
                    }
                    if (!locksToAcquire) continue;
                    continue block19;
                }
            }
        }
        catch (RuntimeException exception) {
            this.releaseAllAcquiredLocks(mergeManager);
            throw exception;
        }
        finally {
            if (mergeManager.getWriteLockQueued() != null) {
                ExposedNodeLinkedList exposedNodeLinkedList = this.prevailingQueue;
                synchronized (exposedNodeLinkedList) {
                    this.prevailingQueue.remove(mergeManager.getQueueNode());
                }
                mergeManager.setWriteLockQueued(null);
            }
        }
    }

    public Object appendLock(Vector primaryKeys, Object objectToLock, ClassDescriptor descriptor, MergeManager mergeManager, AbstractSession session) {
        CacheKey lockedCacheKey = session.getIdentityMapAccessorInstance().acquireLockNoWait(primaryKeys, descriptor.getJavaClass(), true, descriptor);
        if (lockedCacheKey == null) {
            session.getIdentityMapAccessorInstance().getWriteLockManager().transitionToDeferredLocks(mergeManager);
            lockedCacheKey = session.getIdentityMapAccessorInstance().acquireDeferredLock(primaryKeys, descriptor.getJavaClass(), descriptor);
            Object cachedObject = lockedCacheKey.getObject();
            if (cachedObject == null) {
                cachedObject = lockedCacheKey.waitForObject();
            }
            lockedCacheKey.releaseDeferredLock();
            return cachedObject;
        }
        if (lockedCacheKey.getObject() == null) {
            lockedCacheKey.setObject(objectToLock);
        }
        mergeManager.getAcquiredLocks().add(lockedCacheKey);
        return lockedCacheKey.getObject();
    }

    protected CacheKey attemptToAcquireLock(ClassDescriptor descriptor, CacheKey cacheKey, AbstractSession session) {
        return session.getIdentityMapAccessorInstance().acquireLockNoWait(cacheKey.getKey(), descriptor.getJavaClass(), true, descriptor);
    }

    protected CacheKey checkAndLockObject(Object objectToLock, Map lockedObjects, Map refreshedObjects, DatabaseMapping mapping, AbstractSession session, UnitOfWorkImpl unitOfWork) {
        if (objectToLock != null && !lockedObjects.containsKey(objectToLock)) {
            Vector primaryKeysToLock = null;
            ClassDescriptor referenceDescriptor = null;
            referenceDescriptor = mapping.getReferenceDescriptor().hasInheritance() || mapping.getReferenceDescriptor().isDescriptorForInterface() ? session.getDescriptor(objectToLock) : mapping.getReferenceDescriptor();
            if (referenceDescriptor.isDescriptorTypeAggregate()) {
                this.traverseRelatedLocks(objectToLock, lockedObjects, refreshedObjects, referenceDescriptor, session, unitOfWork);
            } else {
                CacheKey toWaitOn;
                primaryKeysToLock = referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(objectToLock, session);
                CacheKey cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(primaryKeysToLock, objectToLock.getClass(), referenceDescriptor);
                if (cacheKey == null) {
                    cacheKey = new CacheKey(primaryKeysToLock);
                    cacheKey.setReadTime(System.currentTimeMillis());
                }
                if ((toWaitOn = this.acquireLockAndRelatedLocks(objectToLock, lockedObjects, refreshedObjects, cacheKey, referenceDescriptor, session, unitOfWork)) != null) {
                    return toWaitOn;
                }
            }
        }
        return null;
    }

    public void releaseAllAcquiredLocks(MergeManager mergeManager) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        Iterator<CacheKey> locks = mergeManager.getAcquiredLocks().iterator();
        while (locks.hasNext()) {
            CacheKey cacheKeyToRemove = locks.next();
            if (cacheKeyToRemove.getObject() == null) {
                cacheKeyToRemove.removeFromOwningMap();
            }
            if (mergeManager.isTransitionedToDeferredLocks()) {
                cacheKeyToRemove.releaseDeferredLock();
            } else {
                cacheKeyToRemove.release();
            }
            locks.remove();
        }
    }

    protected CacheKey waitOnObjectLock(ClassDescriptor descriptor, CacheKey cacheKey, AbstractSession session, int waitTime) {
        return session.getIdentityMapAccessorInstance().acquireLockWithWait(cacheKey.getKey(), descriptor.getJavaClass(), true, descriptor, waitTime);
    }
}

