/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.apache.tools.ant.BuildException;
import org.eclipse.persistence.tools.workbench.ant.ProjectRunner;
import org.eclipse.persistence.tools.workbench.ant.ProjectValidatorInterface;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class ProjectValidator
extends ProjectRunner
implements ProjectValidatorInterface {
    public ProjectValidator() {
    }

    public ProjectValidator(PrintStream log) {
        super(log);
    }

    public int execute(String projectFileName, String reportfile, String reportformat, Vector ignoreErrorCodes) {
        int status = 0;
        File projectFile = new File(projectFileName);
        try {
            MWProject project = new ProjectIOManager().read(projectFile, Preferences.userNodeForPackage(this.getClass()));
            project.validateBranch();
            Collection problems = CollectionTools.collection((Iterator)project.branchProblems());
            Vector igoredProblems = this.getIgnoredProblems(problems, ignoreErrorCodes);
            CollectionTools.removeAll((Collection)problems, igoredProblems.iterator());
            this.generateReport(reportfile, reportformat, project, problems, igoredProblems, ignoreErrorCodes);
            status = problems.size();
        }
        catch (Throwable e) {
            Throwable t = e.getCause() == null ? e : e.getCause();
            String msg = t.getMessage() == null ? t.toString() : t.getMessage();
            throw new BuildException(this.stringRepository.getString("errorWhileValidating", msg), e);
        }
        return status;
    }

    protected void generateReport(String reportfileName, String reportformat, MWProject project, Collection problems, Collection igoredProblems, Collection ignoreErrorCodes) throws FileNotFoundException {
        StringBuffer sb = this.problemsSummary(project, project.branchProblemsSize());
        sb.append(this.problemsReport(problems)).append('\n');
        sb.append(this.igoredProblemsSummary(igoredProblems, ignoreErrorCodes));
        sb.append(this.problemsReport(igoredProblems)).append('\n');
        this.log(sb);
        if (reportfileName.length() > 0) {
            this.log(this.stringRepository.getString("generatingReport", reportfileName) + "\n");
            String title = project.displayString() + " - " + DateFormat.getDateInstance().format(new Date());
            this.buildReportFile(reportfileName, reportformat, sb, title);
        }
    }
}

