/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.resources;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.KeyStroke;
import org.eclipse.persistence.tools.workbench.framework.resources.AcceleratorRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.MissingAcceleratorException;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DefaultAcceleratorRepository
implements AcceleratorRepository {
    private ResourceBundle resourceBundle;

    public DefaultAcceleratorRepository(String resourceClassName) {
        this.initialize(resourceClassName);
    }

    public DefaultAcceleratorRepository(Class resourceClass) {
        this(resourceClass.getName());
    }

    protected void initialize(String resourceClassName) {
        this.resourceBundle = ResourceBundle.getBundle(resourceClassName);
    }

    public boolean hasAccelerator(String key) {
        return key == null || CollectionTools.contains(this.resourceBundle.getKeys(), (Object)key);
    }

    public KeyStroke getAccelerator(String key) {
        return key == null ? null : KeyStroke.getKeyStroke(this.getString(key));
    }

    protected String getString(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            if (ex.getKey().equals(key)) {
                throw new MissingAcceleratorException("Missing accelerator: " + key, key);
            }
            throw ex;
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.resourceBundle.getClass().getName());
    }
}

