/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.sourcegen;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.ExceptionDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooser;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.mappingsplugin.sourcegen.SourceCodeGenerator;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;

public final class ModelSourceGenerationCoordinator
implements SourceCodeGenerator.FileAlreadyExistsListener,
SourceCodeGenerator.ContinuableExceptionListener {
    private WorkbenchContext context;
    private SourceCodeGenerator generator;
    private boolean processCanceled = false;
    private boolean processErrorless = true;

    public ModelSourceGenerationCoordinator(WorkbenchContext context) {
        this.initialize(context);
    }

    private void initialize(WorkbenchContext ctx) {
        this.context = ctx;
        this.setGenerator(new SourceCodeGenerator(ctx.getApplicationContext()));
    }

    private void setGenerator(SourceCodeGenerator generator) {
        this.generator = generator;
        this.generator.addContinuableExceptionListener(this);
        this.generator.addFileAlreadyExistsListener(this);
    }

    public void exportModelJavaSource(MWProject project, Collection descriptors) {
        try {
            this.validateModelSourceRootDirectory(project);
            this.generator.generateSourceCode(project, descriptors);
        }
        catch (CancelException ce) {
            return;
        }
        this.showUserFeedback(project);
    }

    private void validateModelSourceRootDirectory(MWProject project) {
        if (project.getModelSourceDirectoryName().equals("")) {
            this.promptForModelSourceRootDirectory(project);
        }
        if (project.absoluteModelSourceDirectory().isFile()) {
            this.promptForNonFileModelSourceRootDirectory(project);
        }
        if (!project.absoluteModelSourceDirectory().exists()) {
            this.promptToCreateModelSourceRootDirectory(project);
        }
    }

    private void promptForModelSourceRootDirectory(MWProject project) {
        String description = this.resourceRepository().getString("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG_NO_DIRECTORY_CHOSEN.message");
        this.promptForDirectory(project, description);
    }

    private void promptForNonFileModelSourceRootDirectory(MWProject project) {
        String description = this.resourceRepository().getString("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_IS_A_FILE.message", new Object[]{project.absoluteModelSourceDirectory()});
        this.promptForDirectory(project, description);
    }

    private void promptForValidModelSourceRootDirectory(MWProject project) {
        String description = this.resourceRepository().getString("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_IS_INVALID.message", new Object[]{project.absoluteModelSourceDirectory()});
        this.promptForDirectory(project, description);
    }

    private void promptForCreatableModelSourceRootDirectory(MWProject project) {
        String description = this.resourceRepository().getString("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_COULD_NOT_BE_CREATED.message", new Object[]{project.absoluteModelSourceDirectory()});
        this.promptForDirectory(project, description);
    }

    private Preferences preferences() {
        return this.context.getApplicationContext().getPreferences();
    }

    private void promptForDirectory(MWProject project, String description) {
        File startDir = MappingsPlugin.buildExportDirectory(project, project.getModelSourceDirectoryName(), this.preferences());
        FileChooser fileChooser = new FileChooser(startDir, project.getSaveDirectory());
        fileChooser.setDialogTitle(this.resourceRepository().getString("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG.title", project.getName()));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setApproveButtonText(this.resourceRepository().getString("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG_SELECT_BUTTON"));
        fileChooser.setApproveButtonMnemonic(this.resourceRepository().getMnemonic("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG_SELECT_BUTTON"));
        int option = fileChooser.showSaveDialog(this.context.getCurrentWindow());
        if (option == 1) {
            throw new CancelException();
        }
        File directory = ((JFileChooser)fileChooser).getSelectedFile();
        project.setModelSourceDirectoryName(directory.getPath());
        if (directory != null && directory.isAbsolute() && !directory.equals(project.getSaveDirectory())) {
            this.preferences().put("export location", directory.getPath());
        }
    }

    private void promptToCreateModelSourceRootDirectory(MWProject project) {
        File canonicalDirectory;
        try {
            canonicalDirectory = project.absoluteModelSourceDirectory().getCanonicalFile();
        }
        catch (IOException ioe) {
            this.promptForValidModelSourceRootDirectory(project);
            return;
        }
        int input = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("CREATE_MODEL_SOURCE_ROOT_DIRECTORY_DIALOG.message", new Object[]{canonicalDirectory}), this.resourceRepository().getString("CREATE_MODEL_SOURCE_ROOT_DIRECTORY_DIALOG.title"), 0, 3);
        if (input != 0) {
            throw new CancelException();
        }
        if (!project.absoluteModelSourceDirectory().mkdirs()) {
            this.promptForCreatableModelSourceRootDirectory(project);
        }
    }

    private boolean promptToConformEntityBeans() {
        int input = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("sourceCodeGeneration_specCompliance.message"), this.resourceRepository().getString("sourceCodeGeneration_specCompliance.title"), 0, 3);
        return input == 0;
    }

    private boolean promptToGenerateAssociatedClasses() {
        int input = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("sourceCodeGeneration_generateAssociatedClasses.message"), this.resourceRepository().getString("sourceCodeGeneration_generateAssociatedClasses.title"), 0, 3);
        return input == 0;
    }

    public boolean continueOnException(SourceCodeGenerator.ContinuableExceptionEvent cee) {
        this.processErrorless = false;
        ExceptionDialog dialog = new ExceptionDialog(this.resourceRepository().getString("EXPORT_MODEL_SOURCE_CONTINUABLE_ERROR_DIALOG.message"), cee.getException(), this.context, this.resourceRepository().getString("EXPORT_MODEL_SOURCE_CONTINUABLE_ERROR_DIALOG.title")){

            protected String buildOKText() {
                return this.resourceRepository().getString("EXPORT_MODEL_SOURCE_YES_BUTTON");
            }

            protected String buildCancelText() {
                return this.resourceRepository().getString("EXPORT_MODEL_SOURCE_NO_BUTTON");
            }
        };
        dialog.show();
        return dialog.wasConfirmed();
    }

    public boolean fileAlreadyExists(MWProject project, SourceCodeGenerator.FileAlreadyExistsEvent faee) {
        int input = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("sourceCodeGeneration_fileExists.message"), this.resourceRepository().getString("sourceCodeGeneration_fileExists.title"), 1, 3);
        this.generator.setOverwriteFiles(input == 0);
        if (input == 1) {
            this.promptForModelSourceRootDirectory(project);
            this.validateModelSourceRootDirectory(project);
            this.generator.checkForExistingFiles();
        }
        return input != 2;
    }

    private void showUserFeedback(MWProject project) {
        if (this.processCanceled) {
            return;
        }
        if (this.generator.isAnyFileWritten()) {
            if (this.processErrorless) {
                this.showSuccessDialog(project);
            } else {
                this.showCompletionDialog(project);
            }
        }
    }

    private void showSuccessDialog(MWProject project) {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("EXPORT_MODEL_SOURCE_SUCCESS_DIALOG.message"), this.resourceRepository().getString("EXPORT_MODEL_SOURCE_SUCCESS_DIALOG.title", project.getName()), 1);
    }

    private void showCompletionDialog(MWProject project) {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("EXPORT_MODEL_SOURCE_COMPLETION_DIALOG.message"), this.resourceRepository().getString("EXPORT_MODEL_SOURCE_COMPLETION_DIALOG.title", project.getName()), 1);
    }

    private ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }
}

