/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorEventsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.Transformer;

public final class EventsPolicyPropertiesPage
extends ScrollablePropertiesPage {
    public static final int EDITOR_WEIGHT = 11;
    private PropertyValueModel eventsPolicyValueModel;
    private SimplePropertyValueModel methodTypesSelectionModel;
    private JPanel postXMethodsPanel;
    private JPanel updatingMethodsPanel;
    private JPanel insertingMethodsPanel;
    private JPanel writingMethodsPanel;
    private JPanel deletingMethodsPanel;
    private JList methodTypeSelectionList;
    private String POST_X_METHODS;
    private String UPDATING_METHODS;
    private String INSERTING_METHODS;
    private String WRITING_METHODS;
    private String DELETING_METHODS;

    EventsPolicyPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.POST_X_METHODS = this.resourceRepository().getString("EVENTS_POLICY_POST_X_METHODS");
        this.UPDATING_METHODS = this.resourceRepository().getString("EVENTS_POLICY_UPDATING_METHODS");
        this.INSERTING_METHODS = this.resourceRepository().getString("EVENTS_POLICY_INSERTING_METHODS");
        this.WRITING_METHODS = this.resourceRepository().getString("EVENTS_POLICY_WRITING_METHODS");
        this.DELETING_METHODS = this.resourceRepository().getString("EVENTS_POLICY_DELETING_METHODS");
    }

    protected String getHelpTopicId() {
        return "descriptor.events";
    }

    protected Component buildPage() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JComponent methodTypeListPanel = this.buildMethodTypeListPanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 3;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)methodTypeListPanel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 5, 0, 0);
        SwitcherPanel methodsSwitchingPanel = new SwitcherPanel(this.buildMethodTypeValueModel(), new MethodTypeTransformer());
        mainPanel.add((Component)methodsSwitchingPanel, constraints);
        this.getMethodTypeSelectionList().setSelectedValue(this.POST_X_METHODS, true);
        Dimension originalDimension = this.getMethodTypeSelectionList().getPreferredSize();
        this.getMethodTypeSelectionList().setPreferredSize(new Dimension(originalDimension.width + 20, originalDimension.height));
        this.addHelpTopicId(mainPanel, this.getHelpTopicId());
        return mainPanel;
    }

    private JComponent buildMethodTypeListPanel() {
        JList methodTypeList = this.getMethodTypeSelectionList();
        return new JScrollPane(methodTypeList, 21, 31);
    }

    private JPanel buildPostXMethodsPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel postXMethodPanel = new JPanel(new GridBagLayout());
        postXMethodPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel postBuildMethodLabel = this.buildLabel("EVENTS_POLICY_BUILD");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        postXMethodPanel.add((Component)postBuildMethodLabel, constraints);
        ListChooser postBuildMethodChooser = this.buildPostBuildMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 0);
        postXMethodPanel.add((Component)postBuildMethodChooser, constraints);
        postBuildMethodLabel.setLabelFor(postBuildMethodChooser);
        JLabel postCloneMethodLabel = this.buildLabel("EVENTS_POLICY_CLONE");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        postXMethodPanel.add((Component)postCloneMethodLabel, constraints);
        ListChooser postCloneMethodChooser = this.buildPostCloneMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 5, 0);
        postXMethodPanel.add((Component)postCloneMethodChooser, constraints);
        postCloneMethodLabel.setLabelFor(postCloneMethodChooser);
        JLabel postMergeMethodLabel = this.buildLabel("EVENTS_POLICY_MERGE");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        postXMethodPanel.add((Component)postMergeMethodLabel, constraints);
        ListChooser postMergeMethodChooser = this.buildPostMergeMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 0);
        postXMethodPanel.add((Component)postMergeMethodChooser, constraints);
        postMergeMethodLabel.setLabelFor(postMergeMethodChooser);
        JLabel postRefreshMethodLabel = this.buildLabel("EVENTS_POLICY_REFRESH");
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        postXMethodPanel.add((Component)postRefreshMethodLabel, constraints);
        ListChooser postRefreshMethodChooser = this.buildPostRefreshMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 0);
        postXMethodPanel.add((Component)postRefreshMethodChooser, constraints);
        postRefreshMethodLabel.setLabelFor(postRefreshMethodChooser);
        this.addHelpTopicId(postXMethodPanel, this.getHelpTopicId() + ".postX");
        return postXMethodPanel;
    }

    protected JPanel buildDeleteMethodsPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel deletePanel = new JPanel(new GridBagLayout());
        deletePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel preDeleteMethodLabel = this.buildLabel("EVENTS_POLICY_PRE");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        deletePanel.add((Component)preDeleteMethodLabel, constraints);
        ListChooser preDeleteChooser = this.buildPreDeleteMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 0);
        deletePanel.add((Component)preDeleteChooser, constraints);
        preDeleteMethodLabel.setLabelFor(preDeleteChooser);
        JLabel postDeleteMethodLabel = this.buildLabel("EVENTS_POLICY_POST");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        deletePanel.add((Component)postDeleteMethodLabel, constraints);
        ListChooser postDeleteChooser = this.buildPostDeleteMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 0);
        deletePanel.add((Component)postDeleteChooser, constraints);
        postDeleteMethodLabel.setLabelFor(postDeleteChooser);
        this.addHelpTopicId(deletePanel, this.getHelpTopicId() + ".delete");
        return deletePanel;
    }

    private JPanel buildInsertMethodsPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel insertPanel = new JPanel(new GridBagLayout());
        insertPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel preInsertMethodLabel = this.buildLabel("EVENTS_POLICY_PRE");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        insertPanel.add((Component)preInsertMethodLabel, constraints);
        ListChooser preInsertChooser = this.buildPreInsertMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 0);
        insertPanel.add((Component)preInsertChooser, constraints);
        preInsertMethodLabel.setLabelFor(preInsertChooser);
        JLabel aboutToInsertMethodLabel = this.buildLabel("EVENTS_POLICY_ABOUT_TO");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        insertPanel.add((Component)aboutToInsertMethodLabel, constraints);
        ListChooser aboutToInsertChooser = this.buildAboutToInsertMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 0);
        insertPanel.add((Component)aboutToInsertChooser, constraints);
        aboutToInsertMethodLabel.setLabelFor(aboutToInsertChooser);
        JLabel postInsertMethodLabel = this.buildLabel("EVENTS_POLICY_POST");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        insertPanel.add((Component)postInsertMethodLabel, constraints);
        ListChooser postInsertChooser = this.buildPostInsertMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 0);
        insertPanel.add((Component)postInsertChooser, constraints);
        postInsertMethodLabel.setLabelFor(postInsertChooser);
        this.addHelpTopicId(insertPanel, this.getHelpTopicId() + ".insert");
        return insertPanel;
    }

    protected JPanel buildUpdateMethodPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel updatePanel = new JPanel(new GridBagLayout());
        updatePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel preUpdateMethodLabel = this.buildLabel("EVENTS_POLICY_PRE");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        updatePanel.add((Component)preUpdateMethodLabel, constraints);
        ListChooser preUpdateChooser = this.buildPreUpdateMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 0);
        updatePanel.add((Component)preUpdateChooser, constraints);
        preUpdateMethodLabel.setLabelFor(preUpdateChooser);
        JLabel aboutToUpdateMethodLabel = this.buildLabel("EVENTS_POLICY_ABOUT_TO");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        updatePanel.add((Component)aboutToUpdateMethodLabel, constraints);
        ListChooser aboutToUpdateChooser = this.buildAboutToUpdateMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 0);
        updatePanel.add((Component)aboutToUpdateChooser, constraints);
        aboutToUpdateMethodLabel.setLabelFor(aboutToUpdateChooser);
        JLabel postUpdateMethodLabel = this.buildLabel("EVENTS_POLICY_POST");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        updatePanel.add((Component)postUpdateMethodLabel, constraints);
        ListChooser postUpdateChooser = this.buildPostUpdateMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 0);
        updatePanel.add((Component)postUpdateChooser, constraints);
        postUpdateMethodLabel.setLabelFor(postUpdateChooser);
        this.addHelpTopicId(updatePanel, this.getHelpTopicId() + ".update");
        return updatePanel;
    }

    protected JPanel buildWriteMethodPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel writePanel = new JPanel(new GridBagLayout());
        writePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel preWriteMethodLabel = this.buildLabel("EVENTS_POLICY_PRE");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        writePanel.add((Component)preWriteMethodLabel, constraints);
        ListChooser preWriteChooser = this.buildPreWritingMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 0);
        writePanel.add((Component)preWriteChooser, constraints);
        preWriteMethodLabel.setLabelFor(preWriteChooser);
        JLabel postWriteMethodLabel = this.buildLabel("EVENTS_POLICY_POST");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        writePanel.add((Component)postWriteMethodLabel, constraints);
        ListChooser postWriteChooser = this.buildPostWritingMethodListChooser();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 5, 5, 0);
        writePanel.add((Component)postWriteChooser, constraints);
        postWriteMethodLabel.setLabelFor(postWriteChooser);
        this.addHelpTopicId(writePanel, this.getHelpTopicId() + ".write");
        return writePanel;
    }

    private PropertyValueModel buildEventsPolicyHolder() {
        if (this.eventsPolicyValueModel == null) {
            this.eventsPolicyValueModel = new PropertyAspectAdapter(this.getSelectionHolder(), "eventsPolicy"){

                protected Object getValueFromSubject() {
                    MWDescriptorPolicy policy = ((MWMappingDescriptor)this.subject).getEventsPolicy();
                    return policy.isActive() ? policy : null;
                }
            };
        }
        return this.eventsPolicyValueModel;
    }

    private CollectionValueModel buildEventMethodCollectionHolder() {
        return new CollectionAspectAdapter(this.buildEventMethodTypeHolder(), "methods"){

            protected Iterator getValueFromSubject() {
                return ((MWClass)this.subject).allMethods();
            }
        };
    }

    private ItemPropertyListValueModelAdapter buildEventMethodPropertyListAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildEventMethodCollectionHolder(), "signature");
    }

    private FilteringCollectionValueModel buildEventMethodFilteringCollectionModel() {
        return new FilteringCollectionValueModel(this.buildEventMethodPropertyListAdapter()){

            protected boolean accept(Object value) {
                return ((MWMethod)value).isCandidateDescriptorEventMethod();
            }
        };
    }

    private PropertyValueModel buildEventMethodTypeHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "mwClass"){

            protected Object getValueFromSubject() {
                return ((MWDescriptor)this.subject).getMWClass();
            }
        };
    }

    private JPanel getDeletingMethodsPanel() {
        if (this.deletingMethodsPanel == null) {
            this.deletingMethodsPanel = this.buildDeleteMethodsPanel();
        }
        return this.deletingMethodsPanel;
    }

    private JPanel getInsertingMethodsPanel() {
        if (this.insertingMethodsPanel == null) {
            this.insertingMethodsPanel = this.buildInsertMethodsPanel();
        }
        return this.insertingMethodsPanel;
    }

    private JPanel getPostXMethodsPanel() {
        if (this.postXMethodsPanel == null) {
            this.postXMethodsPanel = this.buildPostXMethodsPanel();
        }
        return this.postXMethodsPanel;
    }

    private JPanel getUpdatingMethodsPanel() {
        if (this.updatingMethodsPanel == null) {
            this.updatingMethodsPanel = this.buildUpdateMethodPanel();
        }
        return this.updatingMethodsPanel;
    }

    private JPanel getWritingMethodsPanel() {
        if (this.writingMethodsPanel == null) {
            this.writingMethodsPanel = this.buildWriteMethodPanel();
        }
        return this.writingMethodsPanel;
    }

    private JList getMethodTypeSelectionList() {
        if (this.methodTypeSelectionList == null) {
            this.methodTypeSelectionList = this.buildMethodTypeSelectionJList();
        }
        return this.methodTypeSelectionList;
    }

    private ListChooser buildPostBuildMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostBuildComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostCloneMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostCloneComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostMergeMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostMergeComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostRefreshMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostRefreshComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPreDeleteMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPreDeleteComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostDeleteMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostDeleteComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPreInsertMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPreInsertComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildAboutToInsertMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildAboutToInsertComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostInsertMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostInsertComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPreUpdateMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPreUpdateComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildAboutToUpdateMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildAboutToUpdateComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostUpdateMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostUpdateComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPreWritingMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPreWritingComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostWritingMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostWritingComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ComboBoxModel buildPostBuildComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostBuildMethodSelectionHolder());
    }

    private ComboBoxModel buildPostCloneComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostCloneMethodSelectionHolder());
    }

    private ComboBoxModel buildPostMergeComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostMergeMethodSelectionHolder());
    }

    private ComboBoxModel buildPostRefreshComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostRefreshMethodSelectionHolder());
    }

    private ComboBoxModel buildPreDeleteComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPreDeleteMethodSelectionHolder());
    }

    private ComboBoxModel buildPostDeleteComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostDeleteMethodSelectionHolder());
    }

    private ComboBoxModel buildPreInsertComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPreInsertMethodSelectionHolder());
    }

    private ComboBoxModel buildAboutToInsertComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildAboutToInsertMethodSelectionHolder());
    }

    private ComboBoxModel buildPostInsertComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostInsertMethodSelectionHolder());
    }

    private ComboBoxModel buildPreUpdateComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPreUpdateMethodSelectionHolder());
    }

    private ComboBoxModel buildAboutToUpdateComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildAboutToUpdateMethodSelectionHolder());
    }

    private ComboBoxModel buildPostUpdateComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostUpdateMethodSelectionHolder());
    }

    private ComboBoxModel buildPreWritingComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPreWritingMethodSelectionHolder());
    }

    private ComboBoxModel buildPostWritingComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostWritingMethodSelectionHolder());
    }

    private PropertyValueModel buildPostBuildMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postBuildMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostBuildMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setPostBuildMethod((MWMethod)value);
            }
        };
    }

    private PropertyValueModel buildPostCloneMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postCloneMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostCloneMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setPostCloneMethod((MWMethod)value);
            }
        };
    }

    private PropertyValueModel buildPostMergeMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postMergeMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostMergeMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setPostMergeMethod((MWMethod)value);
            }
        };
    }

    private PropertyValueModel buildPostRefreshMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postRefreshMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostRefreshMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setPostRefreshMethod((MWMethod)value);
            }
        };
    }

    private PropertyValueModel buildPreDeleteMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "preDeletingMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPreDeletingMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setPreDeletingMethod((MWMethod)value);
            }
        };
    }

    private PropertyValueModel buildPostDeleteMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postDeletingMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostDeletingMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setPostDeletingMethod((MWMethod)value);
            }
        };
    }

    private PropertyValueModel buildPreInsertMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "preInsertMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPreInsertMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setPreInsertMethod((MWMethod)value);
            }
        };
    }

    private PropertyValueModel buildAboutToInsertMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "aboutToInsertMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getAboutToInsertMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setAboutToInsertMethod((MWMethod)value);
            }
        };
    }

    private PropertyValueModel buildPostInsertMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postInsertMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostInsertMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setPostInsertMethod((MWMethod)value);
            }
        };
    }

    private PropertyValueModel buildPreUpdateMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "preUpdateMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPreUpdateMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setPreUpdateMethod((MWMethod)value);
            }
        };
    }

    private PropertyValueModel buildAboutToUpdateMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "aboutToUpdateMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getAboutToUpdateMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setAboutToUpdateMethod((MWMethod)value);
            }
        };
    }

    private PropertyValueModel buildPostUpdateMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postUpdateMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostUpdateMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setPostUpdateMethod((MWMethod)value);
            }
        };
    }

    private PropertyValueModel buildPreWritingMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "preWritingMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPreWritingMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setPreWritingMethod((MWMethod)value);
            }
        };
    }

    private PropertyValueModel buildPostWritingMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postWritingMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostWritingMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorEventsPolicy)this.subject).setPostWritingMethod((MWMethod)value);
            }
        };
    }

    private JList buildMethodTypeSelectionJList() {
        ListModelAdapter listModel = new ListModelAdapter(this.buildMethodTypesModel());
        JList methodTypeList = SwingComponentFactory.buildList(listModel);
        methodTypeList.getSelectionModel().setSelectionMode(0);
        methodTypeList.addListSelectionListener(new MethodTypesListDataListener(methodTypeList, this.buildMethodTypeValueModel()));
        return methodTypeList;
    }

    private ReadOnlyListValueModel buildMethodTypesModel() {
        return new ReadOnlyListValueModel(this.buildMethodTypeSelectionList());
    }

    private List buildMethodTypeSelectionList() {
        ArrayList<String> methodTypeList = new ArrayList<String>();
        methodTypeList.add(this.DELETING_METHODS);
        methodTypeList.add(this.INSERTING_METHODS);
        methodTypeList.add(this.POST_X_METHODS);
        methodTypeList.add(this.UPDATING_METHODS);
        methodTypeList.add(this.WRITING_METHODS);
        return methodTypeList;
    }

    private SimplePropertyValueModel buildMethodTypeValueModel() {
        if (this.methodTypesSelectionModel == null) {
            this.methodTypesSelectionModel = new SimplePropertyValueModel();
        }
        return this.methodTypesSelectionModel;
    }

    private class MethodTypeTransformer
    implements Transformer {
        private MethodTypeTransformer() {
        }

        public Object transform(Object o) {
            String selectionChoice = (String)o;
            if (selectionChoice == EventsPolicyPropertiesPage.this.POST_X_METHODS) {
                return EventsPolicyPropertiesPage.this.getPostXMethodsPanel();
            }
            if (selectionChoice == EventsPolicyPropertiesPage.this.DELETING_METHODS) {
                return EventsPolicyPropertiesPage.this.getDeletingMethodsPanel();
            }
            if (selectionChoice == EventsPolicyPropertiesPage.this.INSERTING_METHODS) {
                return EventsPolicyPropertiesPage.this.getInsertingMethodsPanel();
            }
            if (selectionChoice == EventsPolicyPropertiesPage.this.UPDATING_METHODS) {
                return EventsPolicyPropertiesPage.this.getUpdatingMethodsPanel();
            }
            if (selectionChoice == EventsPolicyPropertiesPage.this.WRITING_METHODS) {
                return EventsPolicyPropertiesPage.this.getWritingMethodsPanel();
            }
            return null;
        }
    }

    private class MethodTypesListDataListener
    implements ListSelectionListener {
        private JList list;
        private PropertyValueModel selectionModel;

        private MethodTypesListDataListener(JList list, PropertyValueModel selectionModel) {
            this.selectionModel = selectionModel;
            this.list = list;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                this.selectionModel.setValue(this.list.getSelectedValue());
            }
        }
    }
}

