/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWSequencingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ColumnCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectComponentFactory;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ExtendedListValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

final class RelationalProjectSequencingPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel sequencingPolicyHolder;
    private PseudoPreallocationSizeModel pseudoModel;
    private PropertyValueModel sequenceTableHolder;

    RelationalProjectSequencingPropertiesPage(PropertyValueModel projectNodeHolder, WorkbenchContextHolder contextHolder) {
        super(projectNodeHolder, contextHolder);
    }

    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.sequencingPolicyHolder = this.buildSequencingPolicyHolder();
        this.sequenceTableHolder = this.buildSequenceTableHolder(this.sequencingPolicyHolder);
        this.getSelectionHolder().addPropertyChangeListener("value", this.buildSelectionHolderListener());
        this.pseudoModel = new PseudoPreallocationSizeModel();
        this.pseudoModel.setParentNode((Node)((AbstractNodeModel)this.selection()));
    }

    private PropertyChangeListener buildSelectionHolderListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                RelationalProjectSequencingPropertiesPage.this.pseudoModel.setParentNode((Node)((AbstractNodeModel)e.getNewValue()));
            }
        };
    }

    private PropertyValueModel buildSequencingPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWRelationalProject)this.subject).getSequencingPolicy();
            }
        };
    }

    private PropertyValueModel buildSequenceTableHolder(ValueModel sequencingPolicyHolder) {
        return new PropertyAspectAdapter(sequencingPolicyHolder, "table"){

            protected Object getValueFromSubject() {
                return ((MWSequencingPolicy)this.subject).getTable();
            }

            protected void setValueOnSubject(Object value) {
                ((MWSequencingPolicy)this.subject).setTable((MWTable)value);
            }
        };
    }

    private String helpTopicId() {
        return "project.sequencing";
    }

    private ComponentEnabler buildNativeSequencingEnabler(JComponent component) {
        return new ComponentEnabler((ValueModel)this.buildNativeSequencingEnableStateHolder(), Collections.singleton(component));
    }

    private PropertyValueModel buildNativeSequencingEnableStateHolder() {
        PropertyAspectAdapter databaseHolder = new PropertyAspectAdapter(this.getSelectionHolder(), ""){

            protected Object getValueFromSubject() {
                MWRelationalProject project = (MWRelationalProject)this.subject;
                return project.getDatabase();
            }
        };
        PropertyAspectAdapter platformHolder = new PropertyAspectAdapter(databaseHolder, "databasePlatform"){

            protected Object getValueFromSubject() {
                MWDatabase database = (MWDatabase)this.subject;
                return database.getDatabasePlatform();
            }
        };
        return new TransformationPropertyValueModel(platformHolder){

            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                try {
                    DatabasePlatform platform = (DatabasePlatform)value;
                    return platform.supportsNativeSequencing();
                }
                catch (IllegalArgumentException e) {
                    return Boolean.FALSE;
                }
            }
        };
    }

    protected Component buildPage() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        JComponent preallocationSizeWidgets = this.buildLabeledSpinnerNumber("SEQUENCING_PREALLOCATION_SIZE_SPINNER_LABEL", this.buildSequencingPrealocationSizeSpinnerModel());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)preallocationSizeWidgets, constraints);
        this.addHelpTopicId(preallocationSizeWidgets, this.helpTopicId() + ".preallocation");
        this.buildPreallocationSizeEnabler(preallocationSizeWidgets);
        PropertyValueModel sequencingTypeHolder = this.buildSequencingTypeHolder(this.sequencingPolicyHolder);
        JRadioButton useDefaultSequencingRadioButton = this.buildDefaultSequencingRadioButton(sequencingTypeHolder);
        this.addHelpTopicId(useDefaultSequencingRadioButton, this.helpTopicId() + ".useDefault");
        JRadioButton useNativeSequencingRadioButton = this.buildNativeSequencingRadioButton(sequencingTypeHolder);
        this.addHelpTopicId(useNativeSequencingRadioButton, this.helpTopicId() + ".native");
        this.buildNativeSequencingEnabler(useNativeSequencingRadioButton);
        JRadioButton useSequenceTableRadioButton = this.buildSequenceTableRadioButton(sequencingTypeHolder);
        this.addHelpTopicId(useSequenceTableRadioButton, "session.login.database.sequencing.table");
        JComponent useSequenceTablePanel = this.buildSequenceTablePanel(sequencingTypeHolder);
        GroupBox useSequenceTableBox = new GroupBox((AbstractButton)useDefaultSequencingRadioButton, useNativeSequencingRadioButton, (AbstractButton)useSequenceTableRadioButton, useSequenceTablePanel);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)useSequenceTableBox, constraints);
        this.addHelpTopicId(useSequenceTableBox, "session.login.database.sequencing.table");
        this.addHelpTopicId(panel, this.helpTopicId());
        return panel;
    }

    protected JComponent buildSequenceTablePanel(PropertyValueModel sequencingTypeHolder) {
        JPanel sequenceTablePanel = new JPanel(new GridBagLayout());
        GridBagConstraints contraints = new GridBagConstraints();
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        JLabel nameLabel = SwingComponentFactory.buildLabel("SEQUENCING_TABLE_NAME_LIST_CHOOSER_LABEL", this.resourceRepository());
        components.add(nameLabel);
        contraints.gridx = 0;
        contraints.gridy = 0;
        contraints.gridwidth = 2;
        contraints.gridheight = 1;
        contraints.weightx = 0.0;
        contraints.weighty = 0.0;
        contraints.fill = 0;
        contraints.anchor = 21;
        contraints.insets = new Insets(0, 0, 0, 0);
        sequenceTablePanel.add((Component)nameLabel, contraints);
        ListChooser sequenceTableNameChooser = this.buildSequenceTableChooser();
        components.add(sequenceTableNameChooser);
        contraints.gridx = 1;
        contraints.gridy = 0;
        contraints.gridwidth = 1;
        contraints.gridheight = 1;
        contraints.weightx = 1.0;
        contraints.weighty = 0.0;
        contraints.fill = 2;
        contraints.anchor = 10;
        contraints.insets = new Insets(0, 5, 0, 0);
        sequenceTablePanel.add((Component)sequenceTableNameChooser, contraints);
        nameLabel.setLabelFor(sequenceTableNameChooser);
        JLabel nameFieldLabel = SwingComponentFactory.buildLabel("SEQUENCING_NAME_FIELD_COMBO_BOX_LABEL", this.resourceRepository());
        components.add(nameFieldLabel);
        contraints.gridx = 0;
        contraints.gridy = 1;
        contraints.gridwidth = 1;
        contraints.gridheight = 1;
        contraints.weightx = 0.0;
        contraints.weighty = 0.0;
        contraints.fill = 0;
        contraints.anchor = 21;
        contraints.insets = new Insets(5, 0, 0, 0);
        sequenceTablePanel.add((Component)nameFieldLabel, contraints);
        ListChooser sequenceTableNameFieldChooser = this.buildSequenceNameColumnChooser();
        components.add(sequenceTableNameFieldChooser);
        contraints.gridx = 1;
        contraints.gridy = 1;
        contraints.gridwidth = 1;
        contraints.gridheight = 1;
        contraints.weightx = 1.0;
        contraints.weighty = 0.0;
        contraints.fill = 2;
        contraints.anchor = 10;
        contraints.insets = new Insets(5, 5, 0, 0);
        sequenceTablePanel.add((Component)sequenceTableNameFieldChooser, contraints);
        nameFieldLabel.setLabelFor(sequenceTableNameFieldChooser);
        JLabel counterFieldLabel = SwingComponentFactory.buildLabel("SEQUENCING_COUNTER_FIELD_COMBO_BOX_LABEL", this.resourceRepository());
        components.add(counterFieldLabel);
        contraints.gridx = 0;
        contraints.gridy = 2;
        contraints.gridwidth = 1;
        contraints.gridheight = 1;
        contraints.weightx = 0.0;
        contraints.weighty = 0.0;
        contraints.fill = 0;
        contraints.anchor = 21;
        contraints.insets = new Insets(5, 0, 0, 0);
        sequenceTablePanel.add((Component)counterFieldLabel, contraints);
        ListChooser sequenceCounterFieldChooser = this.buildSequenceCounterColumnChooser();
        components.add(sequenceCounterFieldChooser);
        contraints.gridx = 1;
        contraints.gridy = 2;
        contraints.gridwidth = 1;
        contraints.gridheight = 1;
        contraints.weightx = 1.0;
        contraints.weighty = 0.0;
        contraints.fill = 2;
        contraints.anchor = 10;
        contraints.insets = new Insets(5, 5, 0, 0);
        sequenceTablePanel.add((Component)sequenceCounterFieldChooser, contraints);
        counterFieldLabel.setLabelFor(sequenceCounterFieldChooser);
        new ComponentEnabler(this.buildSequenceTypeBooleanHolder(sequencingTypeHolder), components);
        return sequenceTablePanel;
    }

    private ValueModel buildSequenceTypeBooleanHolder(PropertyValueModel sequencingTypeHolder) {
        return new TransformationPropertyValueModel(sequencingTypeHolder){

            protected Object transform(Object value) {
                return value == "Use sequencing table" ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    private PropertyValueModel buildPreallocationSizeEnableStateHolder() {
        return new PropertyAspectAdapter("enabled", (Model)this.pseudoModel){

            protected Object getValueFromSubject() {
                PseudoPreallocationSizeModel model = (PseudoPreallocationSizeModel)((Object)this.subject);
                return model.isEnabled();
            }
        };
    }

    private ComponentEnabler buildPreallocationSizeEnabler(JComponent widgets) {
        return new ComponentEnabler((ValueModel)this.buildPreallocationSizeEnableStateHolder(), Collections.singleton(widgets));
    }

    private SpinnerNumberModel buildSequencingPrealocationSizeSpinnerModel() {
        return new NumberSpinnerModelAdapter(this.buildSequencingPrealocationSizeHolder(), new Integer(0), null, new Integer(1), new Integer(0));
    }

    private PropertyValueModel buildSequencingPrealocationSizeHolder() {
        return new PropertyAspectAdapter(this.sequencingPolicyHolder, "preallocationSize"){

            protected Object getValueFromSubject() {
                return new Integer(((MWSequencingPolicy)this.subject).getPreallocationSize());
            }

            protected void setValueOnSubject(Object value) {
                ((MWSequencingPolicy)this.subject).setPreallocationSize(((Number)value).intValue());
            }
        };
    }

    private PropertyValueModel buildSequencingTypeHolder(ValueModel sequencingPolicyHolder) {
        return new PropertyAspectAdapter(sequencingPolicyHolder, "SequencingType"){

            protected Object getValueFromSubject() {
                return ((MWSequencingPolicy)this.subject).getSequencingType();
            }

            protected void setValueOnSubject(Object value) {
                ((MWSequencingPolicy)this.subject).setSequencingType((String)value);
            }
        };
    }

    private JRadioButton buildDefaultSequencingRadioButton(PropertyValueModel sequencingTypeHolder) {
        JRadioButton radioButton = SwingComponentFactory.buildRadioButton("DEFAULT_SEQUENCING_RADIO_BUTTON_TEXT", this.buildRadioButtonModelAdapter(sequencingTypeHolder, "Use default sequencing", true), this.resourceRepository());
        return radioButton;
    }

    private JRadioButton buildNativeSequencingRadioButton(PropertyValueModel sequencingTypeHolder) {
        JRadioButton radioButton = SwingComponentFactory.buildRadioButton("NATIVE_SEQUENCING_RADIO_BUTTON_TEXT", this.buildRadioButtonModelAdapter(sequencingTypeHolder, "Use native sequencing", false), this.resourceRepository());
        return radioButton;
    }

    private JRadioButton buildSequenceTableRadioButton(PropertyValueModel sequencingTypeHolder) {
        JRadioButton radioButton = SwingComponentFactory.buildRadioButton("CUSTOM_SEQUENCE_TABLE_RADIO_BUTTON_TEXT", this.buildRadioButtonModelAdapter(sequencingTypeHolder, "Use sequencing table", false), this.resourceRepository());
        return radioButton;
    }

    private ButtonModel buildRadioButtonModelAdapter(PropertyValueModel sequencingTypeHolder, String sequencingType, boolean defaultValue) {
        return new RadioButtonModelAdapter(sequencingTypeHolder, sequencingType, defaultValue);
    }

    private ListChooser buildSequenceTableChooser() {
        return RelationalProjectComponentFactory.buildTableChooser(this.getSelectionHolder(), this.sequenceTableHolder, this.buildSequenceTableChooserDialogBuilder(), this.getWorkbenchContextHolder());
    }

    private DefaultListChooserDialog.Builder buildSequenceTableChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SEQUENCE_TABLE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SEQUENCE_TABLE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildTableStringConverter());
        return builder;
    }

    private StringConverter buildTableStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWTable)o).getName();
            }
        };
    }

    private ListChooser buildSequenceNameColumnChooser() {
        PropertyValueModel sequenceNameFieldHolder = this.buildSequenceNameColumnAdapter(this.sequencingPolicyHolder);
        DefaultListChooser listChooser = new DefaultListChooser(RelationalProjectSequencingPropertiesPage.buildComboBoxModelAdapter(this.buildExtendedColumnsAdapter(this.sequenceTableHolder), sequenceNameFieldHolder), this.getWorkbenchContextHolder(), this.buildSequenceNameColumnChooserDialogBuilder());
        listChooser.setRenderer(this.buildColumnListCellRenderer());
        return listChooser;
    }

    private DefaultListChooserDialog.Builder buildSequenceNameColumnChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SEQUENCE_NAME_FIELD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SEQUENCE_NAME_FIELD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildColumnStringConverter());
        return builder;
    }

    private PropertyValueModel buildSequenceNameColumnAdapter(ValueModel sequencingPolicyHolder) {
        return new PropertyAspectAdapter(sequencingPolicyHolder, "nameColumn"){

            protected Object getValueFromSubject() {
                return ((MWSequencingPolicy)this.subject).getNameColumn();
            }

            protected void setValueOnSubject(Object value) {
                ((MWSequencingPolicy)this.subject).setNameColumn((MWColumn)value);
            }
        };
    }

    private static ComboBoxModel buildComboBoxModelAdapter(ListValueModel listHolder, PropertyValueModel selectionHolder) {
        return new ComboBoxModelAdapter(listHolder, selectionHolder);
    }

    private ListCellRenderer buildColumnListCellRenderer() {
        return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(this.resourceRepository()));
    }

    private StringConverter buildColumnStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWColumn)o).getName();
            }
        };
    }

    private ListChooser buildSequenceCounterColumnChooser() {
        PropertyValueModel sequenceNameFieldHolder = this.buildSequenceCounterColumnAdapter(this.sequencingPolicyHolder);
        DefaultListChooser listChooser = new DefaultListChooser(RelationalProjectSequencingPropertiesPage.buildComboBoxModelAdapter(this.buildExtendedColumnsAdapter(this.sequenceTableHolder), sequenceNameFieldHolder), this.getWorkbenchContextHolder(), this.buildSequenceCounterColumnChooserDialogBuilder());
        listChooser.setRenderer(this.buildColumnListCellRenderer());
        return listChooser;
    }

    private DefaultListChooserDialog.Builder buildSequenceCounterColumnChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SEQUENCE_COUNTER_FIELD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SEQUENCE_COUNTER_FIELD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildColumnStringConverter());
        return builder;
    }

    private PropertyValueModel buildSequenceCounterColumnAdapter(ValueModel sequencingPolicyHolder) {
        return new PropertyAspectAdapter(sequencingPolicyHolder, "counterColumn"){

            protected Object getValueFromSubject() {
                return ((MWSequencingPolicy)this.subject).getCounterColumn();
            }

            protected void setValueOnSubject(Object value) {
                ((MWSequencingPolicy)this.subject).setCounterColumn((MWColumn)value);
            }
        };
    }

    private ListValueModel buildExtendedColumnsAdapter(PropertyValueModel sequencingTableHolder) {
        return new ExtendedListValueModelWrapper(new CollectionListValueModelAdapter(this.buildColumnsAdapter(sequencingTableHolder)));
    }

    private CollectionValueModel buildColumnsAdapter(PropertyValueModel sequencingTableHolder) {
        return new CollectionAspectAdapter(sequencingTableHolder, "columns"){

            protected Iterator getValueFromSubject() {
                return ((MWTable)this.subject).columns();
            }

            protected int sizeFromSubject() {
                return ((MWTable)this.subject).columnsSize();
            }
        };
    }

    private class PseudoPreallocationSizeModel
    extends AbstractNodeModel {
        private boolean enabled;
        private PropertyChangeListener listener;

        private PseudoPreallocationSizeModel() {
        }

        private PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    PseudoPreallocationSizeModel.this.updateEnableState();
                }
            };
        }

        protected void checkParent(Node parent) {
        }

        private void disengageListeners() {
            MWRelationalProject project = (MWRelationalProject)this.getParent();
            if (project != null) {
                project.getSequencingPolicy().removePropertyChangeListener("SequencingType", this.listener);
                project.removePropertyChangeListener("databasePlatform", this.listener);
            }
        }

        public String displayString() {
            return null;
        }

        private void engageListeners() {
            MWRelationalProject project = (MWRelationalProject)this.getParent();
            if (project != null) {
                project.getSequencingPolicy().addPropertyChangeListener("SequencingType", this.listener);
                project.addPropertyChangeListener("databasePlatform", this.listener);
            }
        }

        protected void initialize() {
            super.initialize();
            this.listener = this.buildPropertyChangeListener();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            boolean oldEnabled = this.isEnabled();
            this.enabled = enabled;
            this.firePropertyChanged("enabled", oldEnabled, enabled);
        }

        public void setParentNode(Node parentNode) {
            this.disengageListeners();
            super.setParent(parentNode);
            this.engageListeners();
            if (parentNode != null) {
                this.updateEnableState();
            }
        }

        private void updateEnableState() {
            boolean oraclePlatform;
            MWRelationalProject project = (MWRelationalProject)this.getParent();
            DatabasePlatform platform = project.getDatabase().getDatabasePlatform();
            boolean bl = oraclePlatform = platform.getName().toLowerCase().indexOf("oracle") != -1;
            if (project.getSequencingPolicy().getSequencingType() == "Use native sequencing") {
                this.setEnabled(oraclePlatform);
            } else {
                this.setEnabled(true);
            }
        }
    }
}

