/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpressionQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.CompoundExpressionTreeNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionBuilderDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionTree;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionTreeNode;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

final class ExpressionQueryFormatSubPanel
extends AbstractSubjectPanel {
    private DefaultTreeModel expressionTreeModel;
    private TreeSelectionModel treeSelectionModel;
    private PropertyValueModel expressionQueryFormatHolder;

    ExpressionQueryFormatSubPanel(ValueModel queryFormatHolder, WorkbenchContextHolder contextHolder) {
        super(queryFormatHolder, contextHolder);
    }

    protected ActionListener buildEditExpressionAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ExpressionQueryFormatSubPanel.this.editExpresion();
            }
        };
    }

    private PropertyChangeListener buildQueryPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ExpressionQueryFormatSubPanel.this.populateTree();
            }
        };
    }

    protected void initializeLayout() {
        this.expressionQueryFormatHolder = this.buildExpressionQueryFormatHolder();
        this.expressionQueryFormatHolder.addPropertyChangeListener("value", this.buildQueryPropertyChangeListener());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel expressionLabel = this.buildLabel("EXPRESSION_PANEL_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)expressionLabel, constraints);
        this.expressionTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("RootNode"), true);
        ExpressionTree expressionTree = new ExpressionTree(this.expressionTreeModel);
        this.treeSelectionModel = expressionTree.getSelectionModel();
        this.treeSelectionModel.setSelectionMode(1);
        expressionLabel.setLabelFor(expressionTree);
        expressionTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    ExpressionQueryFormatSubPanel.this.editExpresion();
                }
            }
        });
        JScrollPane expressionTreePane = new JScrollPane(expressionTree);
        expressionTreePane.setPreferredSize(new Dimension(0, 0));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        this.add((Component)expressionTreePane, constraints);
        JButton editExpressionButton = this.buildButton("EDIT_EXPRESSION_BUTTON");
        editExpressionButton.addActionListener(this.buildEditExpressionAction());
        new ComponentEnabler(this.buildQueryBooleanHolder(), Collections.singleton(editExpressionButton));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)editExpressionButton, constraints);
    }

    private MWExpressionQueryFormat getExpressionQueryFormat() {
        return (MWExpressionQueryFormat)this.expressionQueryFormatHolder.getValue();
    }

    private PropertyValueModel buildExpressionQueryFormatHolder() {
        return new FilteringPropertyValueModel((PropertyValueModel)this.getSubjectHolder()){

            protected boolean accept(Object value) {
                return value instanceof MWExpressionQueryFormat;
            }
        };
    }

    private void populateTree() {
        if (this.getExpressionQueryFormat() == null) {
            this.expressionTreeModel.setRoot(new DefaultMutableTreeNode(""));
        } else {
            CompoundExpressionTreeNode node = new CompoundExpressionTreeNode(this.getExpressionQueryFormat().getExpression());
            this.expressionTreeModel.setRoot(node);
            node.setModel(this.expressionTreeModel);
            ((ExpressionTreeNode)node).initializeChildren();
        }
    }

    private void editExpresion() {
        int selectionRow = this.treeSelectionModel.getLeadSelectionRow();
        ExpressionBuilderDialog expressionBuilderDialog = new ExpressionBuilderDialog(this.getExpressionQueryFormat().getExpression(), selectionRow, this.getWorkbenchContext());
        expressionBuilderDialog.show();
        if (expressionBuilderDialog.wasCanceled()) {
            this.getExpressionQueryFormat().getExpression().restoreChanges();
        } else {
            this.getExpressionQueryFormat().getExpression().clearChanges();
        }
        expressionBuilderDialog = null;
        this.populateTree();
    }

    private ValueModel buildQueryBooleanHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder()){

            public Object buildValue() {
                return this.subject == null ? Boolean.FALSE : Boolean.TRUE;
            }
        };
    }
}

