/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaNamespacesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.XmlSchemaNode;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.LabelPanel;

final class SchemaDocumentInfoPanel
extends ScrollablePropertiesPage {
    public SchemaDocumentInfoPanel(PropertyValueModel schemaNodeHolder, WorkbenchContextHolder contextHolder) {
        super(schemaNodeHolder, contextHolder);
    }

    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel page = new JPanel(new GridBagLayout());
        page.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel schemaSourceWidgets = this.buildSchemaSourcePanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        page.add((Component)schemaSourceWidgets, constraints);
        this.addHelpTopicId(schemaSourceWidgets, "schema.docInfo.source");
        JCheckBox defaultNamespaceCheckBox = this.buildCheckBox("DEFAULT_NAMESPACE_CHECK_BOX", this.buildDefaultNamespaceCheckBoxAdapter());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 0, 0, 0);
        page.add((Component)defaultNamespaceCheckBox, constraints);
        this.addAlignLeft(defaultNamespaceCheckBox);
        JTextField defaultNamespaceUrlTextField = new JTextField();
        defaultNamespaceUrlTextField.setDocument(this.buildDefaultNamspaceUrlDocument(this.buildDefaultNamespaceUrlHolder()));
        defaultNamespaceUrlTextField.setEnabled(defaultNamespaceCheckBox.isSelected());
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 0, 0);
        page.add((Component)defaultNamespaceUrlTextField, constraints);
        this.addAlignRight(defaultNamespaceUrlTextField);
        defaultNamespaceCheckBox.addItemListener(this.buildDefaultNamspaceUrlEnabler(defaultNamespaceUrlTextField));
        JPanel schemaNamespacesWidgets = this.buildSchemaNamespacesPanel();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 0, 0, 0);
        page.add((Component)schemaNamespacesWidgets, constraints);
        this.addHelpTopicId(schemaNamespacesWidgets, "schema.docInfo.namespaces");
        this.addHelpTopicId(page, "schema.docInfo");
        return page;
    }

    private JPanel buildSchemaSourcePanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("SCHEMA_SOURCE_LABEL")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)this.buildSchemaSourceLabelPanel(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.buildEditSchemaSourceButton(), constraints);
        return panel;
    }

    private JPanel buildSchemaSourceLabelPanel() {
        LabelPanel panel = new LabelPanel(this.buildSchemaSourceLabelAdapter());
        Insets margin = UIManager.getInsets("TextField.margin");
        panel.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(margin.top, margin.left, margin.bottom, margin.right)));
        return panel;
    }

    private PropertyValueModel buildSchemaSourceLabelAdapter() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "schemaSource"){

            protected Object getValueFromSubject() {
                ResourceSpecification schemaSource = ((MWXmlSchema)this.subject).getSchemaSource();
                if (schemaSource == null) {
                    return null;
                }
                String key = schemaSource.getSourceKey() + "_LABEL";
                return SchemaDocumentInfoPanel.this.resourceRepository().getString(key, schemaSource.getLocation());
            }
        };
    }

    private JButton buildEditSchemaSourceButton() {
        JButton editSchemaSourceButton = new JButton(this.buildEditSchemaSourceAction());
        editSchemaSourceButton.setText(this.resourceRepository().getString("EDIT_SCHEMA_SOURCE_BUTTON_TEXT"));
        return editSchemaSourceButton;
    }

    private Action buildEditSchemaSourceAction() {
        return ((XmlSchemaNode)this.getNode()).getSchemaPropertiesAction(this.getWorkbenchContext());
    }

    private JPanel buildSchemaNamespacesPanel() {
        SchemaNamespacesPanel panel = new SchemaNamespacesPanel(this.getNodeHolder(), this.getWorkbenchContextHolder());
        panel.setBorder(this.buildTitledBorder("NAMESPACES_PANEL_TITLE"));
        return panel;
    }

    private ButtonModel buildDefaultNamespaceCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildDefaultNamespaceHolder());
    }

    private PropertyValueModel buildDefaultNamespaceHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "shouldUseDefaultNamespace"){

            protected Object getValueFromSubject() {
                return ((MWXmlSchema)this.subject).shouldUseDefaultNamespace();
            }

            protected void setValueOnSubject(Object value) {
                ((MWXmlSchema)this.subject).setShouldUseDefaultNamespace(((Boolean)value).booleanValue());
            }
        };
    }

    private ItemListener buildDefaultNamspaceUrlEnabler(final JTextField defaultNamespaceUrl) {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                defaultNamespaceUrl.setEnabled(e.getStateChange() == 1);
            }
        };
    }

    private Document buildDefaultNamspaceUrlDocument(PropertyValueModel defaultNamespaceUrlHolder) {
        return new DocumentAdapter(defaultNamespaceUrlHolder, new RegexpDocument());
    }

    private PropertyValueModel buildDefaultNamespaceUrlHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "defaultNamespaceUrl"){

            protected Object getValueFromSubject() {
                return ((MWXmlSchema)this.subject).getDefaultNamespaceUrl();
            }

            protected void setValueOnSubject(Object value) {
                ((MWXmlSchema)this.subject).setDefaultNamespaceUrl((String)value);
            }
        };
    }
}

