/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModelWrapper;
import org.eclipse.persistence.tools.workbench.utility.Counter;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;

public abstract class ItemAspectListValueModelAdapter
extends ListValueModelWrapper {
    protected IdentityHashMap counters;

    protected ItemAspectListValueModelAdapter(ListValueModel listHolder) {
        super(listHolder);
    }

    protected ItemAspectListValueModelAdapter(CollectionValueModel collectionHolder) {
        this(new CollectionListValueModelAdapter(collectionHolder));
    }

    protected void initialize() {
        super.initialize();
        this.counters = new IdentityHashMap();
    }

    public Object getValue() {
        return this.listHolder.getValue();
    }

    public void addItem(int index, Object item) {
        this.listHolder.addItem(index, item);
    }

    public void addItems(int index, List items) {
        this.listHolder.addItems(index, items);
    }

    public Object removeItem(int index) {
        return this.listHolder.removeItem(index);
    }

    public List removeItems(int index, int length) {
        return this.listHolder.removeItems(index, length);
    }

    public Object replaceItem(int index, Object item) {
        return this.listHolder.replaceItem(index, item);
    }

    public List replaceItems(int index, List items) {
        return this.listHolder.replaceItems(index, items);
    }

    public Object getItem(int index) {
        return this.listHolder.getItem(index);
    }

    public int size() {
        return this.listHolder.size();
    }

    protected void engageModel() {
        super.engageModel();
        this.engageAllItems();
    }

    protected void engageAllItems() {
        this.engageItems((ListIterator)this.listHolder.getValue());
    }

    protected void engageItems(Iterator stream) {
        while (stream.hasNext()) {
            this.engageItem(stream.next());
        }
    }

    protected void engageItem(Object item) {
        Counter counter = (Counter)this.counters.get(item);
        if (counter == null) {
            counter = new Counter();
            this.counters.put(item, counter);
            this.startListeningToItem((Model)item);
        }
        counter.increment();
    }

    protected abstract void startListeningToItem(Model var1);

    protected void disengageModel() {
        this.disengageAllItems();
        super.disengageModel();
    }

    protected void disengageAllItems() {
        this.disengageItems((ListIterator)this.listHolder.getValue());
    }

    protected void disengageItems(Iterator stream) {
        while (stream.hasNext()) {
            this.disengageItem(stream.next());
        }
    }

    protected void disengageItem(Object item) {
        Counter counter = (Counter)this.counters.get(item);
        if (counter == null) {
            throw new IllegalStateException("missing counter: " + item);
        }
        if (counter.decrement() == 0) {
            this.counters.remove(item);
            this.stopListeningToItem((Model)item);
        }
    }

    protected abstract void stopListeningToItem(Model var1);

    protected void itemsAdded(ListChangeEvent e) {
        this.fireItemsAdded(e.cloneWithSource((Object)this, "value"));
        this.engageItems(e.items());
    }

    protected void itemsRemoved(ListChangeEvent e) {
        this.disengageItems(e.items());
        this.fireItemsRemoved(e.cloneWithSource((Object)this, "value"));
    }

    protected void itemsReplaced(ListChangeEvent e) {
        this.disengageItems(e.replacedItems());
        this.fireItemsReplaced(e.cloneWithSource((Object)this, "value"));
        this.engageItems(e.items());
    }

    protected void listChanged(ListChangeEvent e) {
        ArrayList keys = new ArrayList(this.counters.keySet());
        this.disengageItems(keys.iterator());
        this.counters.clear();
        this.fireListChanged("value");
        this.engageAllItems();
    }

    protected void itemAspectChanged(EventObject e) {
        Object item = e.getSource();
        int index = this.lastIdentityIndexOf(item);
        while (index != -1) {
            this.itemAspectChanged(index, item);
            index = this.lastIdentityIndexOf(item, index);
        }
    }

    protected void itemAspectChanged(int index, Object item) {
        this.fireItemReplaced("value", index, item, item);
    }

    protected int lastIdentityIndexOf(Object o) {
        return this.lastIdentityIndexOf(o, this.listHolder.size());
    }

    protected int lastIdentityIndexOf(Object o, int end) {
        int i = end;
        while (i-- > 0) {
            if (this.listHolder.getItem(i) != o) continue;
            return i;
        }
        return -1;
    }
}

