/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyIterator;

public class SimpleCollectionValueModel
extends AbstractModel
implements CollectionValueModel {
    protected Collection value;

    public SimpleCollectionValueModel(Collection value) {
        this.setValue(value);
    }

    public SimpleCollectionValueModel() {
        this((Collection)new HashBag());
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    public Object getValue() {
        return new ReadOnlyIterator(this.value);
    }

    public void addItem(Object item) {
        this.addItemToCollection(item, this.value, "value");
    }

    public void addItems(Collection items) {
        this.addItemsToCollection(items, this.value, "value");
    }

    public void removeItem(Object item) {
        this.removeItemFromCollection(item, this.value, "value");
    }

    public void removeItems(Collection items) {
        this.removeItemsFromCollection(items, this.value, "value");
    }

    public int size() {
        return this.value.size();
    }

    public void setValue(Collection value) {
        this.value = value == null ? new HashBag() : value;
        this.fireCollectionChanged("value");
    }

    public void clear() {
        if (this.value.isEmpty()) {
            return;
        }
        ArrayList items = new ArrayList(this.value);
        this.value.clear();
        this.fireItemsRemoved("value", items);
    }

    public void toString(StringBuffer sb) {
        sb.append(this.value);
    }
}

