/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.tables.CollectionTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;

public abstract class DirectCollectionAccessor
extends DirectAccessor {
    private String m_joinFetch;
    private CollectionTableMetadata m_collectionTable;

    protected DirectCollectionAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected DirectCollectionAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        MetadataAnnotation joinFetch;
        if (annotation != null) {
            this.setFetch((String)annotation.getAttribute("fetch"));
        }
        if ((joinFetch = this.getAnnotation(JoinFetch.class)) != null) {
            this.m_joinFetch = (String)joinFetch.getAttribute("value");
        }
    }

    public CollectionTableMetadata getCollectionTable() {
        return this.m_collectionTable;
    }

    protected DatabaseField getDatabaseField(DatabaseTable defaultTable, String loggingCtx) {
        DatabaseField field = super.getDatabaseField(defaultTable, loggingCtx);
        if (this.getAccessibleObject().isGenericCollectionType()) {
            if (loggingCtx.equals("metadata_default_key_column")) {
                field.setType(this.getJavaClass(this.getMapKeyReferenceClass()));
            } else {
                field.setType(this.getJavaClass(this.getReferenceClass()));
            }
        }
        return field;
    }

    protected String getDefaultCollectionTableName() {
        return this.getDescriptor().getAlias() + "_" + this.getDefaultAttributeName();
    }

    public String getDefaultFetchType() {
        return FetchType.LAZY.name();
    }

    public String getJoinFetch() {
        return this.m_joinFetch;
    }

    public String getPrivateOwned() {
        return null;
    }

    public MetadataClass getReferenceClass() {
        MetadataClass cls = this.getReferenceClassFromGeneric();
        return cls == null ? this.getMetadataFactory().getMetadataClass(Void.TYPE.getName()) : cls;
    }

    protected DatabaseTable getReferenceDatabaseTable() {
        return this.m_collectionTable.getDatabaseTable();
    }

    public MetadataDescriptor getReferenceDescriptor() {
        return this.getDescriptor();
    }

    protected abstract String getKeyConverter();

    protected String getValueConverter() {
        return this.getConvert();
    }

    protected boolean hasMapKeyClass() {
        return false;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_collectionTable, accessibleObject);
    }

    public boolean isDirectCollection() {
        return true;
    }

    protected boolean isValidDirectCollectionType() {
        return this.getAccessibleObject().isSupportedCollectionClass(this.getDescriptor());
    }

    protected boolean isValidDirectMapType() {
        return this.getAccessibleObject().isSupportedMapClass(this.getDescriptor());
    }

    protected void process(CollectionMapping mapping) {
        this.setMapping(mapping);
        mapping.setReferenceClassName(this.getReferenceClassName());
        mapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods(mapping);
        mapping.setJoinFetch(this.getMappingJoinFetchType(this.m_joinFetch));
        this.processCollectionTable(mapping);
        this.processReturnInsertAndUpdate();
        mapping.setShouldExtendPessimisticLockScope(true);
    }

    protected void processCollectionTable(CollectionMapping mapping) {
        if (this.m_collectionTable == null) {
            this.m_collectionTable = new CollectionTableMetadata(this.getAccessibleObject());
        }
        this.processTable(this.m_collectionTable, this.getDefaultCollectionTableName());
        if (!this.isDirectEmbeddableCollection()) {
            ((DirectCollectionMapping)mapping).setReferenceTable(this.m_collectionTable.getDatabaseTable());
        }
    }

    protected void processDirectCollectionMapping() {
        DirectCollectionMapping mapping = new DirectCollectionMapping();
        this.process(mapping);
        this.processContainerPolicyAndIndirection(mapping, null);
        mapping.setDirectField(this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_value_column"));
        this.processMappingValueConverter(mapping, this.getValueConverter(), this.getReferenceClass());
    }

    protected void processDirectMapMapping() {
        DirectMapMapping mapping = new DirectMapMapping();
        this.process(mapping);
        this.processContainerPolicyAndIndirection(mapping, null);
        mapping.setDirectKeyField(this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_key_column"));
        if (this.isBasicMap()) {
            this.processMappingKeyConverter(mapping, this.getKeyConverter(), this.getMapKeyReferenceClass());
        }
        mapping.setDirectField(this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_value_column"));
        this.processMappingValueConverter(mapping, this.getValueConverter(), this.getReferenceClass());
    }

    public void setCollectionTable(CollectionTableMetadata collectionTable) {
        this.m_collectionTable = collectionTable;
    }

    public void setJoinFetch(String joinFetch) {
        this.m_joinFetch = joinFetch;
    }
}

