/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.platform.database.oracle.publisher.Util;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.AttributeField;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.CursorMethod;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.JavaArrayType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlMethod;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.RowtypeInfo;

public class PlsqlCursorMethod
extends PlsqlMethod
implements CursorMethod {
    protected SqlReflector m_reflector;
    protected String m_singleColName;
    protected TypeClass m_returnEleType;
    protected boolean m_returnBeans;
    protected int m_returnColCount;

    public PlsqlCursorMethod(String packageName, String methodName, String methodNo, int modifiers, int sequence, TypeClass[] parameterTypes, String[] parameterNames, int[] parameterModes, boolean[] parameterDefaults, int paramLen, boolean returnBeans, SqlReflector reflector) throws SQLException {
        super(methodName, null, modifiers, SqlReflector.REF_CURSOR_TYPE, parameterTypes, parameterNames, parameterModes, parameterDefaults, paramLen);
        this.m_returnBeans = returnBeans;
        this.m_reflector = reflector;
        if (!this.m_returnBeans) {
            return;
        }
        List<RowtypeInfo> rowtypeInfo = this.m_reflector.reflectRowtypeInfo(packageName, methodName, methodNo, sequence + 1);
        this.m_returnColCount = rowtypeInfo.size();
        TypeClass[] returnColTypes = new TypeClass[this.m_returnColCount];
        String[] returnColNames = new String[this.m_returnColCount];
        for (int j = 0; j < this.m_returnColCount; ++j) {
            RowtypeInfo rtinfo = rowtypeInfo.get(j);
            returnColNames[j] = rtinfo.argument_name;
            try {
                returnColTypes[j] = reflector.addPlsqlDBType(rtinfo.type_owner, rtinfo.type_name, rtinfo.type_subname, rtinfo.modifier, false, packageName, methodName, methodNo, rtinfo.sequence, null);
                continue;
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        }
        String returnEleTypeName = Util.uniqueResultTypeName(SqlName.sqlIdToJavaId(methodName, true), "Row");
        ArrayList<AttributeField> fields = null;
        this.m_returnEleType = null;
        if (returnColTypes != null && returnColTypes.length == 1) {
            this.m_singleColName = returnColNames[0];
            this.m_returnEleType = returnColTypes[0];
        } else if (returnColTypes != null) {
            fields = new ArrayList<AttributeField>(returnColTypes.length);
            for (int i = 0; i < returnColTypes.length; ++i) {
                String returnColName = returnColNames[i];
                if (returnColName.indexOf("(") > -1) {
                    returnColName = returnColName.substring(0, returnColName.indexOf("("));
                }
                fields.add(new AttributeField(returnColName, returnColTypes[i], 0, 0, 0, null, this.m_reflector));
            }
            this.m_returnEleType = this.m_reflector.addJavaType(returnEleTypeName, fields, null, true, null);
        } else {
            this.m_returnEleType = this.m_reflector.addJavaType(returnEleTypeName, null, null, true, null);
        }
        this.m_returnType = new JavaArrayType(this.m_returnEleType, this.m_reflector, SqlReflector.REF_CURSOR_TYPE);
    }

    @Override
    public TypeClass getReturnEleType() {
        return this.m_returnEleType;
    }

    public int getReturnColCount() {
        return this.m_returnColCount;
    }

    @Override
    public boolean isSingleCol() {
        return this.m_singleColName != null;
    }

    @Override
    public String singleColName() {
        return this.m_singleColName;
    }

    @Override
    public boolean returnBeans() {
        return this.m_returnBeans;
    }

    @Override
    public boolean returnResultSet() {
        return !this.m_returnBeans;
    }
}

