/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.Util;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.ProcedureMethod;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;

public abstract class SqlStmtMethod
extends ProcedureMethod {
    protected String[] m_sqlStmtParamNames;
    protected TypeClass[] m_sqlStmtParamTypes;
    protected int[] m_sqlStmtParamModes;
    protected String m_sqlStmt;
    protected String m_sqlStmtTmp;
    protected String m_sqlStmtQuoted;
    protected SqlReflector m_reflector;

    public SqlStmtMethod(String name, int modifiers, String sqlStmt, SqlReflector reflector) throws SQLException, PublisherException {
        super(name, null, modifiers, null, null, null, null, null, -1);
        int j;
        this.m_sqlStmt = sqlStmt;
        this.m_reflector = reflector;
        this.m_keepMethodName = true;
        this.m_sqlStmtTmp = this.m_sqlStmt;
        ArrayList<String> sqlStmtParamNamesV = new ArrayList<String>();
        ArrayList<SqlType> sqlStmtParamTypesV = new ArrayList<SqlType>();
        ArrayList<Integer> sqlStmtParamModesV = new ArrayList<Integer>();
        ArrayList<String> uniqueParamNamesV = new ArrayList<String>();
        ArrayList<SqlType> uniqueParamTypesV = new ArrayList<SqlType>();
        ArrayList<Integer> uniqueParamModesV = new ArrayList<Integer>();
        HashMap<String, String> uniqueHash = new HashMap<String, String>();
        int idx0 = this.m_sqlStmtTmp.lastIndexOf(":{");
        int idx1 = -1;
        int jdbcParamIdx = 0;
        if (idx0 >= 0) {
            idx1 = this.m_sqlStmtTmp.indexOf(125, idx0);
        }
        while (idx0 >= 0 && idx1 >= 0) {
            ++jdbcParamIdx;
            String sqlStmtTmpTerm = this.m_sqlStmtTmp.substring(idx0 + ":{".length(), idx1);
            StringTokenizer stnz = new StringTokenizer(sqlStmtTmpTerm);
            boolean unique = true;
            if (stnz.countTokens() > 1) {
                String paramName = SqlName.sqlIdToJavaId(stnz.nextToken(), false);
                if (paramName != null) {
                    unique = uniqueHash.get(paramName) == null;
                }
                uniqueHash.put(paramName, paramName);
                sqlStmtParamNamesV.add(paramName);
                if (unique) {
                    uniqueParamNamesV.add(paramName);
                }
                try {
                    String typeName = stnz.nextToken();
                    while (stnz.hasMoreTokens()) {
                        typeName = typeName + " " + stnz.nextToken();
                    }
                    String schema = null;
                    if ((typeName = typeName.toUpperCase()).indexOf(46) > -1 && typeName.indexOf(46) < typeName.length() - 1) {
                        schema = typeName.substring(0, typeName.indexOf(46));
                        typeName = typeName.substring(typeName.indexOf(46) + 1);
                    }
                    SqlType tmpType = this.m_reflector.addSqlUserType(schema, typeName, 7, false, 0, 0, null);
                    sqlStmtParamTypesV.add(tmpType);
                    if (unique) {
                        uniqueParamTypesV.add(tmpType);
                    }
                }
                catch (PublisherException e) {
                    throw new SQLException(e.getMessage());
                }
                sqlStmtParamModesV.add(new Integer(1));
                if (unique) {
                    uniqueParamModesV.add(new Integer(1));
                }
                this.m_sqlStmtTmp = this.m_sqlStmtTmp.substring(0, idx0) + "?" + this.m_sqlStmtTmp.substring(idx1 + 1);
                this.m_sqlStmt = this.m_sqlStmt.substring(0, idx0) + ":" + jdbcParamIdx + this.m_sqlStmt.substring(idx1 + 1);
            } else {
                System.err.println("needParamNameAndType " + sqlStmtTmpTerm);
            }
            if ((idx0 = this.m_sqlStmtTmp.lastIndexOf(":{")) < 0) continue;
            idx1 = this.m_sqlStmtTmp.indexOf(125, idx0);
        }
        this.m_sqlStmtParamNames = new String[sqlStmtParamNamesV.size()];
        this.m_sqlStmtParamTypes = new TypeClass[sqlStmtParamNamesV.size()];
        this.m_sqlStmtParamModes = new int[sqlStmtParamNamesV.size()];
        for (j = 0; j < sqlStmtParamNamesV.size(); ++j) {
            int jj = sqlStmtParamNamesV.size() - j - 1;
            this.m_sqlStmtParamNames[jj] = (String)sqlStmtParamNamesV.get(j);
            this.m_sqlStmtParamTypes[jj] = (TypeClass)sqlStmtParamTypesV.get(j);
            this.m_sqlStmtParamModes[jj] = (Integer)sqlStmtParamModesV.get(j);
        }
        this.m_paramNames = new String[uniqueParamNamesV.size()];
        this.m_paramTypes = new TypeClass[uniqueParamNamesV.size()];
        this.m_paramModes = new int[uniqueParamNamesV.size()];
        for (j = 0; j < uniqueParamNamesV.size(); ++j) {
            int jj = uniqueParamNamesV.size() - j - 1;
            this.m_paramNames[jj] = (String)uniqueParamNamesV.get(j);
            this.m_paramTypes[jj] = (TypeClass)uniqueParamTypesV.get(j);
            this.m_paramModes[jj] = (Integer)uniqueParamModesV.get(j);
        }
    }

    public String getSqlStmt() {
        return this.m_sqlStmt;
    }

    public String getSqlStmtQuoted() {
        if (this.m_sqlStmtQuoted == null) {
            this.m_sqlStmtQuoted = Util.quote(this.m_sqlStmt);
        }
        return this.m_sqlStmtQuoted;
    }

    public String[] getSqlStmtParamNames() {
        return this.m_sqlStmtParamNames;
    }

    public TypeClass[] getSqlStmtParamTypes() {
        return this.m_sqlStmtParamTypes;
    }
}

