/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.visit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherListener;

public class PublisherDefaultListener
implements PublisherListener {
    @Override
    public void beginPackage(String packageName) {
    }

    @Override
    public void endPackage() {
    }

    @Override
    public void beginPlsqlTable(String tableName, String targetTypeName) {
    }

    @Override
    public void endPlsqlTable(String tableName, String typeDDL, String typeDropDDL) {
    }

    @Override
    public void beginPlsqlRecord(String recordName, String targetTypeName, int numFields) {
    }

    @Override
    public void beginPlsqlRecordField(String fieldName, int idx) {
    }

    @Override
    public void endPlsqlRecordField(String fieldName, int idx) {
    }

    @Override
    public void endPlsqlRecord(String recordName, String typeDDL, String typeDropDDL) {
    }

    @Override
    public void beginMethod(String methodName, int numArgs) {
    }

    @Override
    public void handleMethodReturn(String returnTypeName) {
    }

    @Override
    public void beginMethodArg(String argName, String direction, int idx) {
    }

    @Override
    public void endMethodArg(String argName) {
    }

    @Override
    public void endMethod(String methodName) {
    }

    @Override
    public void handleObjectType(String objectTypeName, String targetTypeName, int numAttributes) {
    }

    @Override
    public void handleSqlType(String sqlTypeName, int typecode, String targetTypeName) {
    }

    @Override
    public void handleSqlArrayType(String name, String targetTypeName) {
    }

    @Override
    public void handleSqlTableType(String tableTypeName, String targetTypeName) {
    }

    @Override
    public void handleAttributeField(String attributeFieldName) {
    }

    public String trimDotPrefix(String prefix) {
        String trimmedPrefix = prefix;
        int dotIdx = trimmedPrefix.indexOf(46);
        if (dotIdx > -1) {
            trimmedPrefix = trimmedPrefix.substring(dotIdx + 1);
        }
        return trimmedPrefix;
    }

    public static class ReturnArgHelper
    extends MethodArgHelper {
        public ReturnArgHelper(String argName, String sqlTypeName) {
            super(argName, sqlTypeName);
        }

        @Override
        public boolean isMethodArg() {
            return false;
        }

        @Override
        public boolean isReturnArg() {
            return true;
        }
    }

    public static class MethodArgHelper
    extends SqltypeHelper {
        String argName;
        String direction = null;
        int typecode;
        String typeName;
        String nestedType = null;
        int nestedTypecode;
        String nestedTypeName;
        boolean isComplex = false;

        public MethodArgHelper(String argName, String sqlTypeName) {
            super(sqlTypeName);
            this.argName = argName;
        }

        public String argName() {
            return this.argName;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public String direction() {
            return this.direction;
        }

        public int typecode() {
            return this.typecode;
        }

        public void setTypecode(int typecode) {
            this.typecode = typecode;
        }

        public String typeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public void setNestedType(String nestedType) {
            this.nestedType = nestedType;
        }

        public String nestedType() {
            return this.nestedType;
        }

        public int nestedTypecode() {
            return this.nestedTypecode;
        }

        public void setNestedTypecode(int nestedTypecode) {
            this.nestedTypecode = nestedTypecode;
        }

        public String nestedTypeName() {
            return this.nestedTypeName;
        }

        public void setNestedTypeName(String nestedTypeName) {
            this.nestedTypeName = nestedTypeName;
        }

        @Override
        public boolean isComplex() {
            return this.isComplex;
        }

        public void setIsComplex(boolean isComplex) {
            this.isComplex = isComplex;
        }

        @Override
        public boolean isMethodArg() {
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.argName != null && this.argName.length() > 0) {
                sb.append(this.argName);
            }
            sb.append(" ");
            if (this.direction != null) {
                sb.append(this.direction);
                sb.append(" ");
            }
            sb.append(this.sqlTypeName);
            if (this.isComplex) {
                sb.append("{C}");
            }
            return sb.toString();
        }
    }

    public static class MethodHelper
    extends DefaultListenerHelper {
        int numArgs;
        boolean isFunc;
        List<MethodArgHelper> args;

        public MethodHelper(String methodName, int numArgs) {
            super(methodName);
            this.numArgs = numArgs;
            this.args = new ArrayList<MethodArgHelper>(numArgs + 1);
        }

        public String methodName() {
            return this.targetTypeName;
        }

        public int numArgs() {
            return this.numArgs;
        }

        public boolean isFunc() {
            return this.isFunc;
        }

        public void setFunc(boolean isFunc) {
            this.isFunc = isFunc;
        }

        public List<MethodArgHelper> args() {
            return this.args;
        }

        @Override
        public boolean isMethod() {
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int idx = 0;
            int len = this.args.size();
            if (this.isFunc) {
                if (len > 0) {
                    ++idx;
                }
                sb.append("function ");
            } else {
                sb.append("procedure ");
            }
            sb.append(this.targetTypeName);
            sb.append("(");
            for (int i = idx; i < len; ++i) {
                sb.append(this.args.get(i));
                if (i >= len - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            if (this.isFunc) {
                sb.append(" returns ");
                if (len > 0) {
                    MethodArgHelper returnArg = this.args.get(0);
                    sb.append(returnArg.sqlTypeName());
                    if (returnArg.isComplex) {
                        sb.append("{C}");
                    }
                }
            }
            return sb.toString();
        }
    }

    public static class AttributeFieldHelper
    extends SqltypeHelper {
        String attributeFieldName;

        public AttributeFieldHelper(String attributeFieldName, String sqlTypeName) {
            super(sqlTypeName);
            this.attributeFieldName = attributeFieldName;
        }

        public String attributeFieldName() {
            return this.attributeFieldName;
        }

        @Override
        public boolean isAttribute() {
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append(this.attributeFieldName);
            sb.append(":");
            sb.append(this.sqlTypeName);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class RecordHelper
    extends DefaultListenerHelper {
        protected String recordName;
        protected int numFields;

        public RecordHelper(String recordName, String targetTypeName, int numFields) {
            super(targetTypeName);
            this.recordName = recordName;
            this.numFields = numFields;
        }

        public String recordName() {
            return this.recordName;
        }

        public int numFields() {
            return this.numFields;
        }

        @Override
        public boolean isComplex() {
            return true;
        }

        @Override
        public boolean isRecord() {
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{[");
            sb.append(this.numFields);
            sb.append("]");
            sb.append(this.recordName);
            sb.append("/");
            sb.append(this.targetTypeName);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class TableHelper
    extends DefaultListenerHelper {
        protected String tableName;
        protected String tableAlias;
        protected boolean nestedIsComplex = false;

        public TableHelper(String tableName, String tableAlias, String targetTypeName) {
            super(targetTypeName);
            this.tableName = tableName;
            this.tableAlias = tableAlias;
        }

        public String tableName() {
            return this.tableName;
        }

        public String tableAlias() {
            return this.tableAlias;
        }

        @Override
        public boolean isComplex() {
            return true;
        }

        @Override
        public boolean isTable() {
            return true;
        }

        public void nestedIsComplex() {
            this.nestedIsComplex = true;
        }

        public boolean isNestedComplex() {
            return this.nestedIsComplex;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            if (this.nestedIsComplex) {
                sb.append("[nC]");
            }
            sb.append(this.tableAlias);
            sb.append("/");
            sb.append(this.targetTypeName);
            sb.append("}");
            return sb.toString();
        }
    }

    public static class ObjectTypeHelper
    extends DefaultListenerHelper {
        protected String objectTypename;
        protected int numAttributes;

        public ObjectTypeHelper(String objectTypename, String targetTypeName, int numAttributes) {
            super(targetTypeName);
            this.objectTypename = objectTypename;
            this.numAttributes = numAttributes;
        }

        public String objectTypename() {
            return this.objectTypename;
        }

        public int numAttributes() {
            return this.numAttributes;
        }

        @Override
        public boolean isObject() {
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append(this.objectTypename);
            sb.append("/");
            sb.append(this.targetTypeName);
            sb.append("}");
            return sb.toString();
        }

        public int decrNumAttributes() {
            return --this.numAttributes;
        }
    }

    public static class SqlArrayTypeHelper
    extends DefaultListenerHelper {
        protected String arrayTypename;

        public SqlArrayTypeHelper(String arrayTypename, String targetTypeName) {
            super(targetTypeName);
            this.arrayTypename = arrayTypename;
        }

        public String arrayTypename() {
            return this.arrayTypename;
        }

        public void setArrayTypename(String arrayTypename) {
            this.arrayTypename = arrayTypename;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        public String toString() {
            return "{" + this.arrayTypename + "}";
        }
    }

    public static class SqltypeHelper
    extends DefaultListenerHelper {
        protected String sqlTypeName;

        public SqltypeHelper(String sqlTypeName) {
            super(null);
            this.sqlTypeName = sqlTypeName;
        }

        public String sqlTypeName() {
            return this.sqlTypeName;
        }

        public void setSqlTypeName(String sqlTypeName) {
            this.sqlTypeName = sqlTypeName;
        }

        public String toString() {
            return "{" + this.sqlTypeName + "}";
        }
    }

    public static class DefaultListenerHelper
    implements ListenerHelper {
        protected String targetTypeName;

        public DefaultListenerHelper(String targetTypeName) {
            this.targetTypeName = targetTypeName;
        }

        @Override
        public String targetTypeName() {
            return this.targetTypeName;
        }

        @Override
        public boolean isComplex() {
            return false;
        }

        @Override
        public boolean isTable() {
            return false;
        }

        @Override
        public boolean isRecord() {
            return false;
        }

        @Override
        public boolean isObject() {
            return false;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public boolean isAttribute() {
            return false;
        }

        @Override
        public boolean isMethod() {
            return false;
        }

        @Override
        public boolean isMethodArg() {
            return false;
        }

        @Override
        public boolean isReturnArg() {
            return false;
        }
    }

    public static interface ListenerHelper {
        public String targetTypeName();

        public boolean isComplex();

        public boolean isTable();

        public boolean isRecord();

        public boolean isObject();

        public boolean isArray();

        public boolean isAttribute();

        public boolean isMethod();

        public boolean isMethodArg();

        public boolean isReturnArg();
    }
}

