/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherDefaultListener;
import org.eclipse.persistence.tools.dbws.NamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLOXDescriptorBuilder;

public class AdvancedJDBCOXDescriptorBuilder
extends PublisherDefaultListener {
    public static final String ITEMS_MAPPING_ATTRIBUTE_NAME = "items";
    public static final String ITEM_MAPPING_NAME = "item";
    protected String targetNamespace;
    protected NamingConventionTransformer nct;
    protected Stack<PublisherDefaultListener.ListenerHelper> stac = new Stack();
    protected Map<String, XMLDescriptor> descriptorMap = new HashMap<String, XMLDescriptor>();
    protected String packageName = null;

    public AdvancedJDBCOXDescriptorBuilder(String targetNamespace, NamingConventionTransformer nct) {
        this.targetNamespace = targetNamespace;
        this.nct = nct;
    }

    public AdvancedJDBCOXDescriptorBuilder(String targetNamespace, NamingConventionTransformer nct, String packageName) {
        this(targetNamespace, nct);
        this.packageName = packageName;
    }

    public List<XMLDescriptor> getDescriptors() {
        if (this.descriptorMap.isEmpty()) {
            return null;
        }
        ArrayList<XMLDescriptor> al = new ArrayList<XMLDescriptor>();
        al.addAll(this.descriptorMap.values());
        return al;
    }

    @Override
    public void beginPackage(String packageName) {
        if (this.packageName == null) {
            this.packageName = this.trimDotPrefix(packageName);
        }
    }

    @Override
    public void handleMethodReturn(String returnTypeName) {
        String returnType = this.trimDotPrefix(returnTypeName);
        this.stac.push(new PublisherDefaultListener.ReturnArgHelper("", returnType));
    }

    @Override
    public void handleSqlType(String sqlTypeName, int typecode, String targetTypeName) {
        if (!this.stac.isEmpty()) {
            PublisherDefaultListener.ListenerHelper listenerHelper = this.stac.pop();
            if (listenerHelper.isAttribute()) {
                PublisherDefaultListener.SqlArrayTypeHelper sqlArrayTypeHelper;
                XMLDescriptor xdesc;
                DatabaseMapping dm;
                PublisherDefaultListener.AttributeFieldHelper attributeFieldHelper = (PublisherDefaultListener.AttributeFieldHelper)listenerHelper;
                attributeFieldHelper.setSqlTypeName(sqlTypeName);
                String fieldName = attributeFieldHelper.attributeFieldName();
                String attributeName = fieldName.toLowerCase();
                PublisherDefaultListener.ListenerHelper listenerHelper2 = this.stac.peek();
                if (listenerHelper2.isObject()) {
                    int numAttributes;
                    PublisherDefaultListener.ObjectTypeHelper objectTypeHelper = (PublisherDefaultListener.ObjectTypeHelper)listenerHelper2;
                    XMLDescriptor xdesc2 = this.descriptorMap.get(objectTypeHelper.objectTypename());
                    DatabaseMapping dm2 = xdesc2.getMappingForAttributeName(attributeName);
                    if (dm2 == null) {
                        XMLDirectMapping fieldMapping = new XMLDirectMapping();
                        fieldMapping.setAttributeName(attributeName);
                        XMLField xField = new XMLField(attributeName + "/text()");
                        xField.setRequired(true);
                        QName qnameFromDatabaseType = PLSQLOXDescriptorBuilder.qnameFromDatabaseType(listenerHelper);
                        xField.setSchemaType(qnameFromDatabaseType);
                        if (qnameFromDatabaseType == XMLConstants.DATE_QNAME) {
                            fieldMapping.setAttributeClassification(Date.class);
                            xField.addXMLConversion(XMLConstants.DATE_QNAME, Date.class);
                            xField.addJavaConversion(Date.class, XMLConstants.DATE_QNAME);
                            xdesc2.getNamespaceResolver().put("xsd", "http://www.w3.org/2001/XMLSchema");
                        } else {
                            Class attributeClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(qnameFromDatabaseType);
                            if (attributeClass == null) {
                                attributeClass = ClassConstants.Object_Class;
                            }
                            fieldMapping.setAttributeClassification(attributeClass);
                        }
                        fieldMapping.setField((DatabaseField)xField);
                        AbstractNullPolicy nullPolicy = fieldMapping.getNullPolicy();
                        nullPolicy.setNullRepresentedByEmptyNode(false);
                        nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                        nullPolicy.setNullRepresentedByXsiNil(true);
                        fieldMapping.setNullPolicy(nullPolicy);
                        xdesc2.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                        xdesc2.addMapping((DatabaseMapping)fieldMapping);
                    }
                    if ((numAttributes = objectTypeHelper.decrNumAttributes()) == 0) {
                        this.stac.pop();
                    }
                } else if (listenerHelper2.isArray() && (dm = (xdesc = this.descriptorMap.get((sqlArrayTypeHelper = (PublisherDefaultListener.SqlArrayTypeHelper)listenerHelper2).arrayTypename())).getMappingForAttributeName(attributeName)) == null) {
                    XMLCompositeDirectCollectionMapping dirCollectMapping = new XMLCompositeDirectCollectionMapping();
                    PublisherDefaultListener.SqltypeHelper componentType = new PublisherDefaultListener.SqltypeHelper(sqlTypeName);
                    dirCollectMapping.setAttributeElementClass(PLSQLOXDescriptorBuilder.attributeClassFromDatabaseType(componentType));
                    dirCollectMapping.setAttributeName(attributeName);
                    dirCollectMapping.setUsesSingleNode(true);
                    dirCollectMapping.setXPath(attributeName + "/text()");
                    XMLField xField = (XMLField)dirCollectMapping.getField();
                    xField.setRequired(true);
                    xField.setSchemaType(PLSQLOXDescriptorBuilder.qnameFromDatabaseType(componentType));
                    dirCollectMapping.useCollectionClassName("java.util.ArrayList");
                    AbstractNullPolicy nullPolicy = dirCollectMapping.getNullPolicy();
                    nullPolicy.setNullRepresentedByEmptyNode(false);
                    nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                    nullPolicy.setNullRepresentedByXsiNil(true);
                    dirCollectMapping.setNullPolicy(nullPolicy);
                    xdesc.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    xdesc.addMapping((DatabaseMapping)dirCollectMapping);
                }
            } else if (listenerHelper.isArray()) {
                PublisherDefaultListener.ListenerHelper listenerHelper2;
                PublisherDefaultListener.SqlArrayTypeHelper sqlArrayTypeHelper2 = (PublisherDefaultListener.SqlArrayTypeHelper)listenerHelper;
                XMLDescriptor xdesc = this.descriptorMap.get(sqlArrayTypeHelper2.arrayTypename());
                DatabaseMapping dm = xdesc.getMappingForAttributeName(ITEMS_MAPPING_ATTRIBUTE_NAME);
                if (dm == null) {
                    XMLCompositeDirectCollectionMapping itemsMapping = new XMLCompositeDirectCollectionMapping();
                    PublisherDefaultListener.SqltypeHelper componentType = new PublisherDefaultListener.SqltypeHelper(sqlTypeName);
                    itemsMapping.setAttributeElementClass(PLSQLOXDescriptorBuilder.attributeClassFromDatabaseType(componentType));
                    itemsMapping.setAttributeName(ITEMS_MAPPING_ATTRIBUTE_NAME);
                    itemsMapping.setUsesSingleNode(true);
                    itemsMapping.setXPath("item/text()");
                    XMLField xField = (XMLField)itemsMapping.getField();
                    xField.setRequired(true);
                    xField.setSchemaType(PLSQLOXDescriptorBuilder.qnameFromDatabaseType(componentType));
                    itemsMapping.useCollectionClassName("java.util.ArrayList");
                    AbstractNullPolicy nullPolicy = itemsMapping.getNullPolicy();
                    nullPolicy.setNullRepresentedByEmptyNode(false);
                    nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                    nullPolicy.setNullRepresentedByXsiNil(true);
                    itemsMapping.setNullPolicy(nullPolicy);
                    xdesc.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    xdesc.addMapping((DatabaseMapping)itemsMapping);
                }
                if ((listenerHelper2 = this.stac.peek()).isAttribute()) {
                    this.stac.pop();
                    PublisherDefaultListener.AttributeFieldHelper fieldHelper = (PublisherDefaultListener.AttributeFieldHelper)listenerHelper2;
                    PublisherDefaultListener.ListenerHelper listenerHelper3 = this.stac.peek();
                    if (listenerHelper3.isObject()) {
                        int numAttributes;
                        String fieldName;
                        PublisherDefaultListener.ObjectTypeHelper objectTypeHelper = (PublisherDefaultListener.ObjectTypeHelper)listenerHelper3;
                        XMLDescriptor xdesc2 = this.descriptorMap.get(objectTypeHelper.objectTypename());
                        DatabaseMapping dm2 = xdesc2.getMappingForAttributeName((fieldName = fieldHelper.attributeFieldName()).toLowerCase());
                        if (dm2 == null) {
                            XMLCompositeDirectCollectionMapping fieldMapping = new XMLCompositeDirectCollectionMapping();
                            PublisherDefaultListener.SqltypeHelper componentType = new PublisherDefaultListener.SqltypeHelper(sqlTypeName);
                            fieldMapping.setAttributeElementClass(PLSQLOXDescriptorBuilder.attributeClassFromDatabaseType(componentType));
                            fieldMapping.setAttributeName(fieldName.toLowerCase());
                            XMLField field = new XMLField(fieldName.toLowerCase() + "/" + ITEM_MAPPING_NAME + "/text()");
                            field.setRequired(true);
                            fieldMapping.setField((DatabaseField)field);
                            field.setSchemaType(PLSQLOXDescriptorBuilder.qnameFromDatabaseType(componentType));
                            fieldMapping.useCollectionClassName("java.util.ArrayList");
                            AbstractNullPolicy nullPolicy = fieldMapping.getNullPolicy();
                            nullPolicy.setNullRepresentedByEmptyNode(false);
                            nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                            nullPolicy.setNullRepresentedByXsiNil(true);
                            fieldMapping.setNullPolicy(nullPolicy);
                            xdesc2.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                            xdesc2.addMapping((DatabaseMapping)fieldMapping);
                        }
                        if ((numAttributes = objectTypeHelper.decrNumAttributes()) == 0) {
                            this.stac.pop();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void handleObjectType(String objectTypeName, String targetTypeName, int numAttributes) {
        if (numAttributes > 0) {
            String objectTypeNameAlias = this.trimDotPrefix(objectTypeName).toLowerCase();
            XMLDescriptor xdesc = this.descriptorMap.get(objectTypeNameAlias);
            String userType = this.nct.generateSchemaAlias(objectTypeNameAlias);
            if (xdesc == null) {
                xdesc = new XMLDescriptor();
                xdesc.setAlias(objectTypeNameAlias);
                xdesc.setJavaClassName(this.packageName.toLowerCase() + "." + objectTypeNameAlias);
                xdesc.getQueryManager();
                XMLSchemaURLReference schemaReference = new XMLSchemaURLReference();
                schemaReference.setSchemaContext("/" + userType);
                schemaReference.setType(1);
                xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
                NamespaceResolver nr = new NamespaceResolver();
                nr.setDefaultNamespaceURI(this.targetNamespace);
                xdesc.setNamespaceResolver(nr);
                this.descriptorMap.put(objectTypeNameAlias, xdesc);
            }
            if (!this.stac.isEmpty()) {
                PublisherDefaultListener.ListenerHelper listenerHelper = this.stac.peek();
                if (listenerHelper.isAttribute()) {
                    PublisherDefaultListener.ObjectTypeHelper objectTypeHelper2;
                    String objectTypeNameAlias2;
                    XMLDescriptor xdesc2;
                    PublisherDefaultListener.AttributeFieldHelper fieldHelper = (PublisherDefaultListener.AttributeFieldHelper)this.stac.pop();
                    fieldHelper.setSqlTypeName(objectTypeNameAlias);
                    String fieldName = fieldHelper.attributeFieldName();
                    String attributeName = fieldName.toLowerCase();
                    PublisherDefaultListener.ListenerHelper listenerHelper2 = this.stac.peek();
                    if (listenerHelper2.isObject() && (xdesc2 = this.descriptorMap.get(objectTypeNameAlias2 = (objectTypeHelper2 = (PublisherDefaultListener.ObjectTypeHelper)listenerHelper2).objectTypename())) != null) {
                        int numAttributes2;
                        DatabaseMapping dm = xdesc2.getMappingForAttributeName(attributeName);
                        if (dm == null) {
                            XMLCompositeObjectMapping compMapping = new XMLCompositeObjectMapping();
                            compMapping.setAttributeName(attributeName);
                            compMapping.setReferenceClassName(xdesc.getJavaClassName());
                            compMapping.setXPath(attributeName);
                            XMLField xField = (XMLField)compMapping.getField();
                            xField.setRequired(true);
                            xdesc2.addMapping((DatabaseMapping)compMapping);
                        }
                        if ((numAttributes2 = objectTypeHelper2.decrNumAttributes()) == 0) {
                            this.stac.pop();
                        }
                    }
                } else if (listenerHelper.isArray()) {
                    PublisherDefaultListener.SqlArrayTypeHelper sqlArrayTypeHelper = (PublisherDefaultListener.SqlArrayTypeHelper)this.stac.pop();
                    String sqlArrayTypeAlias = sqlArrayTypeHelper.arrayTypename();
                    XMLDescriptor xdesc2 = this.descriptorMap.get(sqlArrayTypeAlias);
                    if (xdesc2 != null) {
                        boolean itemsMappingFound;
                        boolean bl = itemsMappingFound = xdesc2.getMappingForAttributeName(ITEMS_MAPPING_ATTRIBUTE_NAME) != null;
                        if (!itemsMappingFound) {
                            XMLCompositeCollectionMapping itemsMapping = new XMLCompositeCollectionMapping();
                            itemsMapping.setAttributeName(ITEMS_MAPPING_ATTRIBUTE_NAME);
                            itemsMapping.setXPath(ITEM_MAPPING_NAME);
                            itemsMapping.useCollectionClassName("java.util.ArrayList");
                            itemsMapping.setReferenceClassName(xdesc.getJavaClassName());
                            xdesc2.addMapping((DatabaseMapping)itemsMapping);
                        }
                    }
                } else if (listenerHelper.isReturnArg()) {
                    this.stac.pop();
                    xdesc.setDefaultRootElement(userType);
                }
            }
            this.stac.push(new PublisherDefaultListener.ObjectTypeHelper(objectTypeNameAlias, targetTypeName, numAttributes));
        }
    }

    @Override
    public void handleSqlArrayType(String arrayTypename, String targetTypeName) {
        PublisherDefaultListener.ListenerHelper listenerHelper;
        String arrayTypenameAlias = this.trimDotPrefix(arrayTypename).toLowerCase();
        String userType = this.nct.generateSchemaAlias(arrayTypenameAlias);
        XMLDescriptor xdesc = this.descriptorMap.get(arrayTypenameAlias);
        if (xdesc == null) {
            xdesc = new XMLDescriptor();
            xdesc.setAlias(arrayTypenameAlias);
            xdesc.setJavaClassName(this.packageName.toLowerCase() + "." + arrayTypenameAlias + "_CollectionWrapper");
            xdesc.getQueryManager();
            XMLSchemaURLReference schemaReference = new XMLSchemaURLReference();
            schemaReference.setSchemaContext("/" + userType);
            schemaReference.setType(1);
            xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
            NamespaceResolver nr = new NamespaceResolver();
            nr.setDefaultNamespaceURI(this.targetNamespace);
            xdesc.setNamespaceResolver(nr);
            this.descriptorMap.put(arrayTypenameAlias, xdesc);
        }
        if (!this.stac.isEmpty() && (listenerHelper = this.stac.peek()).isReturnArg()) {
            xdesc.setDefaultRootElement(userType);
        }
        this.stac.push(new PublisherDefaultListener.SqlArrayTypeHelper(arrayTypenameAlias, targetTypeName));
    }

    @Override
    public void handleSqlTableType(String tableTypeName, String targetTypeName) {
        PublisherDefaultListener.ListenerHelper listenerHelper;
        String tableTypeNameAlias = this.trimDotPrefix(tableTypeName).toLowerCase();
        String userType = this.nct.generateSchemaAlias(tableTypeNameAlias);
        XMLDescriptor xdesc = this.descriptorMap.get(tableTypeNameAlias);
        if (xdesc == null) {
            xdesc = new XMLDescriptor();
            xdesc.setAlias(tableTypeNameAlias);
            xdesc.setJavaClassName(this.packageName.toLowerCase() + "." + tableTypeNameAlias + "_CollectionWrapper");
            xdesc.getQueryManager();
            XMLSchemaURLReference schemaReference = new XMLSchemaURLReference();
            schemaReference.setSchemaContext("/" + userType);
            schemaReference.setType(1);
            xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
            NamespaceResolver nr = new NamespaceResolver();
            nr.setDefaultNamespaceURI(this.targetNamespace);
            xdesc.setNamespaceResolver(nr);
            this.descriptorMap.put(tableTypeNameAlias, xdesc);
        }
        if (!this.stac.isEmpty() && (listenerHelper = this.stac.peek()).isReturnArg()) {
            xdesc.setDefaultRootElement(userType);
        }
        this.stac.push(new PublisherDefaultListener.SqlArrayTypeHelper(tableTypeNameAlias, targetTypeName));
    }

    @Override
    public void handleAttributeField(String attributeFieldName) {
        this.stac.push(new PublisherDefaultListener.AttributeFieldHelper(attributeFieldName, null));
    }
}

