/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherDefaultListener;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.StoredFunctionCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;

public class AdvancedJDBCQueryBuilder
extends PublisherDefaultListener {
    protected Stack<PublisherDefaultListener.ListenerHelper> stac = new Stack();
    protected Map<String, DatabaseQuery> queryMap = new HashMap<String, DatabaseQuery>();
    protected List<DbStoredProcedure> storedProcedures;
    protected Map<DbStoredProcedure, DBWSBuilder.DbStoredProcedureNameAndModel> dbStoredProcedure2QueryName;
    protected String packageName = null;

    public AdvancedJDBCQueryBuilder(List<DbStoredProcedure> storedProcedures, Map<DbStoredProcedure, DBWSBuilder.DbStoredProcedureNameAndModel> dbStoredProcedure2QueryName) {
        this(storedProcedures, dbStoredProcedure2QueryName, null);
    }

    public AdvancedJDBCQueryBuilder(List<DbStoredProcedure> storedProcedures, Map<DbStoredProcedure, DBWSBuilder.DbStoredProcedureNameAndModel> dbStoredProcedure2QueryName, String packageName) {
        this.storedProcedures = storedProcedures;
        this.dbStoredProcedure2QueryName = dbStoredProcedure2QueryName;
        this.packageName = packageName;
    }

    public List<DatabaseQuery> getQueries() {
        if (this.queryMap.isEmpty()) {
            return null;
        }
        ArrayList<DatabaseQuery> al = new ArrayList<DatabaseQuery>();
        al.addAll(this.queryMap.values());
        return al;
    }

    @Override
    public void beginPackage(String packageName) {
        if (this.packageName == null) {
            int dotIdx = packageName.indexOf(46);
            this.packageName = dotIdx > -1 ? packageName.substring(dotIdx + 1) : packageName;
        }
    }

    @Override
    public void beginMethod(String methodName, int numArgs) {
        DatabaseQuery dq = this.queryMap.get(methodName);
        if (dq == null) {
            this.stac.push(new PublisherDefaultListener.MethodHelper(methodName, numArgs));
        }
    }

    @Override
    public void handleMethodReturn(String returnTypeName) {
        String returnType = returnTypeName;
        int dotIdx = returnTypeName.indexOf(46);
        if (dotIdx > -1) {
            returnType = returnTypeName.substring(dotIdx + 1);
        }
        this.stac.push(new PublisherDefaultListener.ReturnArgHelper("", returnType));
    }

    @Override
    public void beginMethodArg(String argName, String direction, int idx) {
        PublisherDefaultListener.ListenerHelper helper;
        if (!this.stac.isEmpty() && (helper = this.stac.peek()).isMethod()) {
            PublisherDefaultListener.MethodHelper methodHelper = (PublisherDefaultListener.MethodHelper)helper;
            PublisherDefaultListener.MethodArgHelper methodArgHelper = new PublisherDefaultListener.MethodArgHelper(argName, null);
            methodArgHelper.setDirection(direction);
            methodHelper.args().add(methodArgHelper);
        }
    }

    @Override
    public void endMethod(String methodName) {
        PublisherDefaultListener.ListenerHelper helper;
        if (!this.stac.isEmpty() && (helper = this.stac.peek()).isMethod()) {
            PublisherDefaultListener.MethodHelper methodHelper = (PublisherDefaultListener.MethodHelper)helper;
            DBWSBuilder.DbStoredProcedureNameAndModel nameAndModel = null;
            DbStoredProcedure targetProcedure = null;
            for (DbStoredProcedure storedProcedure : this.storedProcedures) {
                nameAndModel = this.dbStoredProcedure2QueryName.get(storedProcedure);
                if (!Util.sqlMatch(nameAndModel.procOpModel.getProcedurePattern(), methodHelper.methodName())) continue;
                targetProcedure = storedProcedure;
                break;
            }
            if (nameAndModel != null) {
                boolean hasResponse;
                Object dq = null;
                StoredProcedureCall spCall = null;
                List<PublisherDefaultListener.MethodArgHelper> args = methodHelper.args();
                int startIdx = 0;
                int len = args.size();
                if (methodHelper.isFunc()) {
                    startIdx = 1;
                    PublisherDefaultListener.MethodArgHelper returnArg = args.get(0);
                    if (returnArg.isComplex()) {
                        String javaClassName = returnArg.typeName();
                        if (returnArg.nestedType() != null) {
                            ObjectRelationalDatabaseField nestedField = new ObjectRelationalDatabaseField("");
                            nestedField.setSqlTypeName(returnArg.nestedType());
                            nestedField.setSqlType(returnArg.nestedTypecode());
                            nestedField.setTypeName(returnArg.nestedTypeName());
                            spCall = new StoredFunctionCall(returnArg.typecode(), returnArg.sqlTypeName(), javaClassName, (DatabaseField)nestedField);
                        } else {
                            spCall = new StoredFunctionCall(returnArg.typecode(), returnArg.sqlTypeName(), javaClassName);
                        }
                    } else {
                        spCall = new StoredFunctionCall();
                        ((StoredFunctionCall)spCall).setResult(null, ClassConstants.OBJECT);
                    }
                } else {
                    spCall = new StoredProcedureCall();
                }
                String returnType = nameAndModel.procOpModel.getReturnType();
                boolean bl = hasResponse = returnType != null;
                dq = hasResponse ? (nameAndModel.procOpModel.isCollection() ? new DataReadQuery() : new ValueReadQuery()) : new DataModifyQuery();
                dq.bindAllParameters();
                dq.setName(nameAndModel.name);
                for (int i = startIdx; i < len; ++i) {
                    PublisherDefaultListener.MethodArgHelper arg = args.get(i);
                    String argName = arg.argName();
                    String javaClassName = null;
                    if (arg.isComplex()) {
                        javaClassName = (this.packageName + "." + arg.sqlTypeName()).toLowerCase();
                    }
                    if (arg.direction().equalsIgnoreCase("IN")) {
                        dq.addArgument(argName);
                        if (arg.isComplex()) {
                            spCall.addNamedArgument(argName, argName, 2002, arg.sqlTypeName(), javaClassName);
                            continue;
                        }
                        spCall.addNamedArgument(argName, argName);
                        continue;
                    }
                    if (arg.direction().equalsIgnoreCase("OUT")) {
                        if (arg.isComplex()) {
                            spCall.addNamedOutputArgument(argName, argName, 2002, arg.sqlTypeName());
                            continue;
                        }
                        spCall.addNamedOutputArgument(argName, argName);
                        continue;
                    }
                    if (!arg.direction().equalsIgnoreCase("IN OUT")) continue;
                    dq.addArgument(argName);
                    spCall.addNamedInOutputArgument(argName);
                }
                String catalogPrefix = null;
                String cat = targetProcedure.getCatalog();
                catalogPrefix = cat == null | cat.length() == 0 ? "" : cat + ".";
                spCall.setProcedureName(catalogPrefix + targetProcedure.getName());
                dq.setCall((Call)spCall);
                this.queryMap.put(methodName, (DatabaseQuery)dq);
            }
            this.stac.pop();
        }
    }

    @Override
    public void handleObjectType(String objectTypeName, String targetTypeName, int numAttributes) {
        String objectType = this.trimDotPrefix(objectTypeName);
        if (!this.stac.isEmpty()) {
            PublisherDefaultListener.ListenerHelper helper = this.stac.peek();
            if (helper.isReturnArg() || helper.isArray()) {
                this.stac.pop();
                PublisherDefaultListener.ListenerHelper helper2 = this.stac.peek();
                if (helper2.isMethod()) {
                    int size;
                    PublisherDefaultListener.MethodHelper methodHelper2 = (PublisherDefaultListener.MethodHelper)helper2;
                    String javaClassName = null;
                    javaClassName = (this.packageName + "." + objectType).toLowerCase();
                    if (helper.isReturnArg()) {
                        methodHelper2.setFunc(true);
                    }
                    if ((size = methodHelper2.args().size()) > 0) {
                        PublisherDefaultListener.MethodArgHelper methodArgHelper = methodHelper2.args().get(size - 1);
                        methodArgHelper.setNestedType(objectType);
                        methodArgHelper.setNestedTypecode(2002);
                        methodArgHelper.setNestedTypeName(javaClassName);
                    } else {
                        PublisherDefaultListener.MethodArgHelper methodArgHelper = new PublisherDefaultListener.MethodArgHelper("", objectType);
                        methodArgHelper.setTypecode(2002);
                        methodArgHelper.setTypeName(javaClassName);
                        methodArgHelper.setIsComplex(true);
                        methodHelper2.args().add(methodArgHelper);
                    }
                }
            } else if (helper.isMethod()) {
                PublisherDefaultListener.MethodHelper methodHelper = (PublisherDefaultListener.MethodHelper)helper;
                int size = methodHelper.args().size();
                PublisherDefaultListener.MethodArgHelper methodArgHelper = methodHelper.args().get(size - 1);
                if (methodArgHelper.sqlTypeName() == null) {
                    methodArgHelper.setSqlTypeName(objectType);
                }
                methodArgHelper.setIsComplex(true);
            } else if (helper.isAttribute()) {
                this.stac.pop();
            }
        }
    }

    @Override
    public void handleSqlArrayType(String arrayTypename, String targetTypeName) {
        String arrayType = arrayTypename;
        int dotIdx = arrayTypename.indexOf(46);
        if (dotIdx > -1) {
            arrayType = arrayTypename.substring(dotIdx + 1);
        }
        if (!this.stac.isEmpty()) {
            PublisherDefaultListener.ListenerHelper helper = this.stac.peek();
            if (helper.isReturnArg()) {
                this.stac.pop();
                PublisherDefaultListener.MethodHelper methodHelper = (PublisherDefaultListener.MethodHelper)this.stac.peek();
                methodHelper.setFunc(true);
                PublisherDefaultListener.MethodArgHelper methodArgHelper = new PublisherDefaultListener.MethodArgHelper("", arrayType);
                methodArgHelper.setTypecode(2003);
                methodArgHelper.setTypeName((this.packageName + "." + arrayType).toLowerCase() + "_CollectionWrapper");
                methodArgHelper.setIsComplex(true);
                methodHelper.args().add(0, methodArgHelper);
            } else if (helper.isMethod()) {
                PublisherDefaultListener.MethodHelper methodHelper = (PublisherDefaultListener.MethodHelper)helper;
                int size = methodHelper.args().size();
                PublisherDefaultListener.MethodArgHelper methodArgHelper = methodHelper.args().get(size - 1);
                methodArgHelper.setSqlTypeName(arrayType);
                methodArgHelper.setIsComplex(true);
            } else if (helper.isAttribute()) {
                this.stac.pop();
            }
            this.stac.push(new PublisherDefaultListener.SqlArrayTypeHelper(arrayType, targetTypeName));
        }
    }

    @Override
    public void handleSqlTableType(String tableTypeName, String targetTypeName) {
        String tableType = this.trimDotPrefix(tableTypeName);
        if (!this.stac.isEmpty()) {
            PublisherDefaultListener.ListenerHelper helper = this.stac.peek();
            if (helper.isReturnArg()) {
                this.stac.pop();
                PublisherDefaultListener.MethodHelper methodHelper = (PublisherDefaultListener.MethodHelper)this.stac.peek();
                methodHelper.setFunc(true);
                PublisherDefaultListener.MethodArgHelper methodArgHelper = new PublisherDefaultListener.MethodArgHelper("", tableType);
                methodArgHelper.setTypecode(2003);
                methodArgHelper.setTypeName((this.packageName + "." + tableType).toLowerCase() + "_CollectionWrapper");
                methodArgHelper.setIsComplex(true);
                methodHelper.args().add(0, methodArgHelper);
            } else if (helper.isMethod()) {
                PublisherDefaultListener.MethodHelper methodHelper = (PublisherDefaultListener.MethodHelper)helper;
                int size = methodHelper.args().size();
                PublisherDefaultListener.MethodArgHelper methodArgHelper = methodHelper.args().get(size - 1);
                if (methodArgHelper.sqlTypeName() == null) {
                    methodArgHelper.setSqlTypeName(tableType);
                    methodArgHelper.setIsComplex(true);
                }
            } else if (helper.isAttribute()) {
                this.stac.pop();
            }
        }
    }

    @Override
    public void handleSqlType(String sqlTypeName, int typecode, String targetTypeName) {
        if (!this.stac.isEmpty()) {
            PublisherDefaultListener.ListenerHelper helper = this.stac.peek();
            if (helper.isMethod()) {
                PublisherDefaultListener.MethodHelper methodHelper = (PublisherDefaultListener.MethodHelper)helper;
                int size = methodHelper.args().size();
                PublisherDefaultListener.MethodArgHelper methodArgHelper = methodHelper.args().get(size - 1);
                if (methodArgHelper.sqlTypeName() == null) {
                    methodArgHelper.setSqlTypeName(sqlTypeName);
                }
            } else if (helper.isAttribute()) {
                this.stac.pop();
            }
        }
    }

    @Override
    public void handleAttributeField(String attributeFieldName) {
        this.stac.push(new PublisherDefaultListener.AttributeFieldHelper(attributeFieldName, null));
    }
}

