/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.io;

import java.io.Writer;

public class TokenWriter
extends Writer {
    private String delimiters;
    private char escapeCharacter;
    private StringBuffer buffer;
    private char maxDelimiter;
    private char[] delimiterBuffer;
    private final int delimiterBufferSize = 1024;
    public static final String DEFAULT_DELIMITERS = " \t\n\r\f";
    public static final char DEFAULT_ESCAPE_CHARACTER = '\\';

    private TokenWriter(String delimiters, char escapeCharacter, StringBuffer buffer) {
        this.delimiters = delimiters;
        this.escapeCharacter = escapeCharacter;
        this.buffer = buffer;
        this.lock = buffer;
        this.initialize();
    }

    public TokenWriter() {
        this(DEFAULT_DELIMITERS, '\\', new StringBuffer());
    }

    public TokenWriter(int initialSize) {
        this(DEFAULT_DELIMITERS, '\\', new StringBuffer(initialSize));
    }

    public TokenWriter(String delimiters) {
        this(delimiters, '\\', new StringBuffer());
    }

    public TokenWriter(String delimiters, char escapeCharacter) {
        this(delimiters, escapeCharacter, new StringBuffer());
    }

    public TokenWriter(String delimiters, char escapeCharacter, int initialSize) {
        this(delimiters, escapeCharacter, new StringBuffer(initialSize));
    }

    private void initialize() {
        this.calculateMaxDelimiter();
        if (this.charIsDelimiter(this.escapeCharacter)) {
            throw new IllegalArgumentException("The \"escape\" character may not belong to the list of delimiters.");
        }
    }

    private void calculateMaxDelimiter() {
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        this.maxDelimiter = '\u0000';
        for (int i = 0; i < this.delimiters.length(); ++i) {
            char c = this.delimiters.charAt(i);
            if (this.maxDelimiter >= c) continue;
            this.maxDelimiter = c;
        }
    }

    private boolean charIsDelimiter(int c) {
        return c <= this.maxDelimiter && this.delimiters.indexOf(c) >= 0;
    }

    private boolean charIsTheEscapeCharacter(int c) {
        return c == this.escapeCharacter;
    }

    private boolean charRequiresEscape(int c) {
        return this.charIsTheEscapeCharacter(c) || this.charIsDelimiter(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) {
        Object object = this.lock;
        synchronized (object) {
            if (this.charRequiresEscape(c)) {
                this.buffer.append(this.escapeCharacter);
            }
            this.buffer.append((char)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDelimiter(int c) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.charIsDelimiter(c)) {
                throw new IllegalArgumentException("Not a delimiter: " + c);
            }
            this.buffer.append((char)c);
        }
    }

    private void checkIndices(char[] cbuffer, int offset, int length) {
        if (offset < 0 || offset > cbuffer.length || length < 0 || offset + length > cbuffer.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuffer, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            this.checkIndices(cbuffer, offset, length);
            if (length == 0) {
                return;
            }
            int tooFar = offset + length;
            for (int i = offset; i < tooFar; ++i) {
                this.write(cbuffer[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDelimiter(char[] cbuffer, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            this.checkIndices(cbuffer, offset, length);
            if (length == 0) {
                return;
            }
            int tooFar = offset + length;
            for (int i = offset; i < tooFar; ++i) {
                this.writeDelimiter(cbuffer[i]);
            }
        }
    }

    public void writeDelimiter(String string) {
        this.writeDelimiter(string, 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDelimiter(String string, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            char[] cbuffer;
            if (length <= this.delimiterBufferSize) {
                if (this.delimiterBuffer == null) {
                    this.delimiterBuffer = new char[this.delimiterBufferSize];
                }
                cbuffer = this.delimiterBuffer;
            } else {
                cbuffer = new char[length];
            }
            string.getChars(offset, offset + length, cbuffer, 0);
            this.writeDelimiter(cbuffer, 0, length);
        }
    }

    public String toString() {
        return this.buffer.toString();
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void flush() {
    }

    public void close() {
    }
}

